/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.relauncherstub;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;

public class GraphicalConsole {
    static final long MAX_LOG_SIZE = 0x2000000L;
    final ConcurrentLinkedQueue<String> consoleBuffer = new ConcurrentLinkedQueue();
    final AtomicLong logSize = new AtomicLong(0L);
    final AtomicBoolean logSizeExceededMax = new AtomicBoolean(false);
    final InputStream stdout;
    final InputStream stderr;
    Thread stdoutAdapter;
    Thread stderrAdapter;
    final Process process;

    public GraphicalConsole(InputStream stdout, InputStream stderr, Process process) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.process = process;
        try {
            System.setProperty("awt.useSystemAAFontSettings", "on");
            if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux")) {
                UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            this.consoleBuffer.add("Could not initialize DarkLaf GUI theme");
        }
        this.invokeOnSwingThread(true, () -> {
            JFrame consoleWindow = new JFrame("Lwjgl3ify relaunch console");
            consoleWindow.setMinimumSize(new Dimension(640, 500));
            consoleWindow.setDefaultCloseOperation(2);
            JTextArea logArea = new JTextArea();
            logArea.setEditable(false);
            logArea.setFont(Font.decode("Monospaced").deriveFont(14.0f));
            try {
                logArea.getDocument().insertString(logArea.getDocument().getLength(), "Relaunching the process with new Java..." + System.lineSeparator(), null);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
            JScrollPane logScroll = new JScrollPane(logArea);
            consoleWindow.getContentPane().add((Component)logScroll, "Center");
            this.stdoutAdapter = new Thread((Runnable)new StreamToQueueAdapter(stdout, logArea), "stdout adapter");
            this.stdoutAdapter.setDaemon(true);
            this.stdoutAdapter.start();
            this.stderrAdapter = new Thread((Runnable)new StreamToQueueAdapter(stderr, logArea), "stderr adapter");
            this.stderrAdapter.setDaemon(true);
            this.stderrAdapter.start();
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            JButton closeMeButton = new JButton("Close console");
            closeMeButton.addActionListener(al -> consoleWindow.dispose());
            JButton killButton = new JButton("Kill process");
            killButton.addActionListener(al -> process.destroyForcibly());
            buttonPanel.add(closeMeButton);
            buttonPanel.add(killButton);
            consoleWindow.getContentPane().add((Component)buttonPanel, "South");
            Thread processDeathAwaiter = new Thread(() -> {
                try {
                    Process terminated = process.onExit().get();
                    int exitCode = terminated.exitValue();
                    this.invokeOnSwingThread(false, () -> {
                        killButton.setEnabled(false);
                        try {
                            logArea.getDocument().insertString(logArea.getDocument().getLength(), "Process exited with code " + exitCode, null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    });
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }, "death awaiter");
            processDeathAwaiter.start();
            consoleWindow.setVisible(true);
        });
    }

    private void invokeOnSwingThread(boolean wait, Runnable runnable) {
        try {
            if (wait) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            throw new RuntimeException(e);
        }
    }

    class StreamToQueueAdapter
    implements Runnable {
        final BufferedReader reader;
        final JTextArea guiLog;
        static final String LINE_SEPARATOR = System.lineSeparator();

        StreamToQueueAdapter(InputStream stream, JTextArea guiLog) {
            this.reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            this.guiLog = guiLog;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    GraphicalConsole.this.invokeOnSwingThread(false, () -> {
                        while (!GraphicalConsole.this.consoleBuffer.isEmpty()) {
                            String bufferedLine = (String)GraphicalConsole.this.consoleBuffer.remove();
                            try {
                                this.guiLog.getDocument().insertString(this.guiLog.getDocument().getLength(), bufferedLine + LINE_SEPARATOR, null);
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    });
                    long currLogSize = GraphicalConsole.this.logSize.addAndGet(line.length() + 1);
                    if (currLogSize > 0x2000000L) {
                        boolean prevExceeded = GraphicalConsole.this.logSizeExceededMax.getAndSet(true);
                        if (!prevExceeded) {
                            GraphicalConsole.this.consoleBuffer.add("Max console size exceeded, > 33554432 bytes!");
                        }
                        return;
                    }
                    GraphicalConsole.this.consoleBuffer.add(line);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

