/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.recipe;

import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PresentRecipe
extends ShapedRecipes {
    public PresentRecipe() {
        super(3, 3, PresentRecipe.createRecipeInput(), new ItemStack((Block)BetterStorageTiles.present));
    }

    private static ItemStack[] createRecipeInput() {
        ItemStack box = new ItemStack((Block)BetterStorageTiles.cardboardBox);
        ItemStack wool1 = new ItemStack(Blocks.field_150325_L, 1, 14);
        ItemStack wool2 = new ItemStack(Blocks.field_150325_L, 1, 0);
        return new ItemStack[]{wool1, wool2, wool1, wool1, box, wool1, wool1, wool2, wool1};
    }

    public boolean func_77569_a(InventoryCrafting crafting, World world) {
        ItemStack box = crafting.func_70301_a(4);
        if (box == null || box.func_77973_b() != Item.func_150898_a((Block)BetterStorageTiles.cardboardBox) || !StackUtils.has(box, "Items")) {
            return false;
        }
        int corners = PresentRecipe.checkWoolColor(crafting, 0, 2, 6, 8);
        if (corners >= 16) {
            return false;
        }
        int topBottom = PresentRecipe.checkWoolColor(crafting, 1, 7);
        int leftRight = PresentRecipe.checkWoolColor(crafting, 3, 5);
        return corners >= 0 && topBottom >= 0 && leftRight >= 0 && corners != topBottom && (leftRight == corners || leftRight == topBottom);
    }

    public ItemStack func_77572_b(InventoryCrafting crafting) {
        int colorInner = PresentRecipe.checkWoolColor(crafting, 0);
        int colorOuter = PresentRecipe.checkWoolColor(crafting, 1);
        int leftRight = PresentRecipe.checkWoolColor(crafting, 3);
        boolean skojanzaMode = leftRight == colorOuter;
        ItemStack box = crafting.func_70301_a(4);
        ItemStack present = new ItemStack((Block)BetterStorageTiles.present);
        NBTTagCompound compound = (NBTTagCompound)box.func_77978_p().func_74737_b();
        compound.func_74774_a("presentColorInner", (byte)colorInner);
        compound.func_74774_a("presentColorOuter", (byte)colorOuter);
        compound.func_74757_a("skojanzaMode", skojanzaMode);
        int color = StackUtils.get(box, -1, "display", "color");
        if (color >= 0) {
            compound.func_74768_a("color", color);
        }
        present.func_77982_d(compound);
        StackUtils.remove(present, "display", "color");
        return present;
    }

    private static int checkWoolColor(InventoryCrafting crafting, int ... slots) {
        int color = -1;
        for (int i = 0; i < slots.length; ++i) {
            int woolColor;
            int slot = slots[i];
            ItemStack stack = crafting.func_70301_a(slot);
            if (stack == null) {
                return -1;
            }
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L)) {
                woolColor = stack.func_77960_j();
            } else if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150340_R)) {
                woolColor = 16;
            } else {
                return -1;
            }
            if (i <= 0) {
                color = woolColor;
                continue;
            }
            if (woolColor == color) continue;
            return -1;
        }
        return color;
    }
}

