/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.misc.PropertiesBackpack;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MovingObjectPosition;

public class TileEntityBackpack
extends TileEntityContainer {
    private int despawnTime = -1;
    public ItemStack stack;
    public boolean equipped = false;

    public void equip(EntityLivingBase carrier) {
        this.equipped = true;
        ItemBackpack.setBackpack(carrier, this.stack, this.contents);
    }

    public void unequip(EntityLivingBase carrier, boolean despawn) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(carrier);
        if (backpackData.contents != null) {
            System.arraycopy(backpackData.contents, 0, this.contents, 0, Math.min(this.contents.length, backpackData.contents.length));
            backpackData.contents = null;
        }
        if (despawn) {
            this.despawnTime = 0;
        }
    }

    @Override
    public String getName() {
        return "container.betterstorage.backpack";
    }

    @Override
    public int getRows() {
        return BetterStorage.globalConfig.getInteger("general.backpackRows");
    }

    @Override
    protected boolean doesSyncPlayers() {
        return true;
    }

    @Override
    public boolean onBlockBreak(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && player.func_70093_af() && ItemBackpack.canEquipBackpack(player)) {
            this.equip((EntityLivingBase)player);
        }
        return super.onBlockBreak(player);
    }

    @Override
    public void dropContents() {
        if (this.equipped) {
            return;
        }
        if (!this.brokenInCreative) {
            WorldUtils.dropStackFromBlock(this, this.stack);
        }
        super.dropContents();
    }

    @Override
    public ItemStack onPickBlock(ItemStack block, MovingObjectPosition target) {
        return ItemStack.func_77944_b((ItemStack)this.stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onBlockRenderAsItem(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    protected float getLidSpeed() {
        return 0.2f;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        double x = (double)this.field_145851_c + 0.5;
        double y = (double)this.field_145848_d + 0.5;
        double z = (double)this.field_145849_e + 0.5;
        String sound = Block.field_149773_n.func_150498_e();
        if (this.lidAngle > 0.0f && this.prevLidAngle <= 0.0f) {
            this.field_145850_b.func_72908_a(x, y, z, sound, 1.0f, 0.6f);
        }
        if (this.lidAngle < 0.2f && this.prevLidAngle >= 0.2f) {
            this.field_145850_b.func_72908_a(x, y, z, sound, 0.8f, 0.4f);
        }
        if (this.despawnTime < 0) {
            return;
        }
        if (this.despawnTime++ > 6000) {
            this.equipped = true;
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (this.despawnTime % 40 == 0 && this.field_145850_b.func_72977_a(x, y, z, 24.0) != null) {
            this.despawnTime = -1;
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.stack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("stack"));
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("stack"));
        this.despawnTime = compound.func_74762_e("despawnTime");
        if (this.despawnTime == 0) {
            this.despawnTime = -1;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        compound.func_74768_a("despawnTime", this.despawnTime);
    }
}

