/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.gui.IBeefGuiControl;
import erogenousbeef.bigreactors.gui.IBeefListBoxEntry;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiListBox;
import erogenousbeef.bigreactors.gui.controls.grab.IBeefGuiGrabbable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class BeefGuiBase
extends GuiContainer {
    protected List<IBeefGuiControl> controls;
    protected List<IBeefTooltipControl> controlsWithTooltips;
    protected List<GuiTextField> textFields;
    protected IBeefGuiGrabbable grabbedItem = null;

    public BeefGuiBase(Container container) {
        super(container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.controls = new ArrayList<IBeefGuiControl>();
        this.controlsWithTooltips = new ArrayList<IBeefTooltipControl>();
        this.textFields = new ArrayList<GuiTextField>();
    }

    public void registerControl(GuiTextField newTextField) {
        this.textFields.add(newTextField);
    }

    public void registerControl(IBeefGuiControl newControl) {
        this.controls.add(newControl);
        if (newControl instanceof IBeefTooltipControl) {
            this.controlsWithTooltips.add((IBeefTooltipControl)((Object)newControl));
        }
    }

    public void registerControl(GuiButton newButton) {
        this.field_146292_n.add(newButton);
        if (newButton instanceof IBeefTooltipControl) {
            this.controlsWithTooltips.add((IBeefTooltipControl)newButton);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int relativeX = mouseX - this.field_147003_i;
        int relativeY = mouseY - this.field_147009_r;
        for (IBeefGuiControl c : this.controls) {
            c.drawBackground(this.field_146297_k.field_71446_o, relativeX, relativeY);
        }
        for (GuiTextField field : this.textFields) {
            field.func_146194_f();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int absoluteX = mouseX - this.field_147003_i;
        int absoluteY = mouseY - this.field_147009_r;
        for (IBeefGuiControl c : this.controls) {
            c.drawForeground(this.field_146297_k.field_71446_o, mouseX, mouseY);
        }
        for (IBeefTooltipControl tc : this.controlsWithTooltips) {
            String[] tooltip;
            if (!tc.isVisible() || !tc.isMouseOver(mouseX, mouseY) || (tooltip = tc.getTooltip()) == null) continue;
            GL11.glPushAttrib((int)1048575);
            this.drawHoveringText(Arrays.asList(tooltip), absoluteX, absoluteY, this.field_146289_q);
            GL11.glPopAttrib();
            break;
        }
        if (this.grabbedItem != null) {
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_94065_a(absoluteX + 1, absoluteY + 1, this.grabbedItem.getIcon(), 16, 16);
        }
    }

    protected void func_73864_a(int x, int y, int buttonIndex) {
        super.func_73864_a(x, y, buttonIndex);
        for (GuiTextField field : this.textFields) {
            field.func_146192_a(x, y, buttonIndex);
        }
        for (IBeefGuiControl c : this.controls) {
            c.onMouseClicked(x, y, buttonIndex);
        }
    }

    public abstract ResourceLocation getGuiBackground();

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public void onListBoxSelectionChanged(BeefGuiListBox listBox, IBeefListBoxEntry selectedEntry) {
    }

    public void onListBoxEntryClicked(BeefGuiListBox listBox, IBeefListBoxEntry clickedEntry) {
    }

    public void setGrabbedItem(IBeefGuiGrabbable grabbedSource) {
        this.grabbedItem = grabbedSource;
    }

    public IBeefGuiGrabbable getGrabbedItem() {
        return this.grabbedItem;
    }

    public void onControlClicked(IBeefGuiControl control) {
    }

    protected static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }
}

