/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.client.gui.GuiReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.gui.container.ContainerBasic;
import erogenousbeef.bigreactors.net.CommonPacketHandler;
import erogenousbeef.bigreactors.net.message.ControlRodUpdateMessage;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityReactorControlRod
extends TileEntityReactorPart {
    public static final short maxInsertion = 100;
    public static final short minInsertion = 0;
    protected short controlRodInsertion = 0;
    protected String name = "";

    public short getControlRodInsertion() {
        return this.controlRodInsertion;
    }

    public void setControlRodInsertion(short newInsertion) {
        if (newInsertion > 100 || newInsertion < 0 || newInsertion == this.controlRodInsertion) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        this.controlRodInsertion = (short)Math.max(Math.min(newInsertion, 100), 0);
        this.sendControlRodUpdate();
    }

    public void setName(String newName) {
        if (this.name.equals(newName)) {
            return;
        }
        this.name = newName;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void onClientControlRodChange(int amount) {
        this.setControlRodInsertion((short)(this.controlRodInsertion + amount));
    }

    protected void sendControlRodUpdate() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        CommonPacketHandler.INSTANCE.sendToAllAround((IMessage)new ControlRodUpdateMessage(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.controlRodInsertion), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
    }

    @SideOnly(value=Side.CLIENT)
    public void onControlRodUpdate(short controlRodInsertion) {
        this.controlRodInsertion = controlRodInsertion;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.readLocalDataFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.writeLocalDataToNBT(data);
    }

    @Override
    public Object getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerBasic();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiElement(InventoryPlayer inventoryPlayer) {
        return new GuiReactorControlRod(new ContainerBasic(), this);
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Control rods may only be placed on the top face", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Control rods may only be placed on the top face", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        TileEntity teBelow = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (!(teBelow instanceof TileEntityReactorFuelRod)) {
            throw new MultiblockValidationException(String.format("%d, %d, %d - Control rods may only be placed on the top face, atop a column of fuel rods", this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Control rods may only be placed on the top face", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Control rods may only be placed on the top face", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packet) {
        super.encodeDescriptionPacket(packet);
        NBTTagCompound localData = new NBTTagCompound();
        this.writeLocalDataToNBT(localData);
        packet.func_74782_a("reactorControlRod", (NBTBase)localData);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packet) {
        super.decodeDescriptionPacket(packet);
        if (packet.func_74764_b("reactorControlRod")) {
            NBTTagCompound localData = packet.func_74775_l("reactorControlRod");
            this.readLocalDataFromNBT(localData);
            if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    private void readLocalDataFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("controlRodInsertion")) {
            this.controlRodInsertion = data.func_74765_d("controlRodInsertion");
        }
        this.name = data.func_74764_b("name") ? data.func_74779_i("name") : "";
    }

    private void writeLocalDataToNBT(NBTTagCompound data) {
        data.func_74777_a("controlRodInsertion", this.controlRodInsertion);
        if (!this.name.isEmpty()) {
            data.func_74778_a("name", this.name);
        }
    }
}

