/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.world;

import cpw.mods.fml.common.IWorldGenerator;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.bigreactors.world.BRSimpleOreGenerator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class BRWorldGenerator
implements IWorldGenerator {
    protected static volatile Set<BRSimpleOreGenerator> oreGenerators = null;

    public static void addGenerator(BRSimpleOreGenerator newGenerator) {
        if (oreGenerators == null) {
            oreGenerators = new CopyOnWriteArraySet<BRSimpleOreGenerator>();
        }
        oreGenerators.add(newGenerator);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateChunk(random, chunkX, chunkZ, world);
    }

    public void generateChunk(Random random, int chunkX, int chunkZ, World world) {
        if (oreGenerators == null) {
            return;
        }
        if (!StaticUtils.WorldGen.shouldGenerateInDimension(world.field_73011_w.field_76574_g)) {
            return;
        }
        for (BRSimpleOreGenerator generator : oreGenerators) {
            if (!generator.shouldGenerateInWorld(world)) continue;
            generator.generateChunk(world, random, chunkX, chunkZ);
        }
    }
}

