/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Achievement;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelSword;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemExcaliber
extends ItemManasteelSword
implements IRelic,
ILensEffect {
    private static final String TAG_ATTACKER_USERNAME = "attackerUsername";
    private static final String TAG_HOME_ID = "homeID";
    public static Item.ToolMaterial toolMaterial = EnumHelper.addToolMaterial((String)"B_EXCALIBER", (int)3, (int)-1, (float)6.2f, (float)6.0f, (int)40);
    Achievement achievement;

    public ItemExcaliber() {
        super(toolMaterial, "excaliber");
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (par3Entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            ItemRelic.updateRelic(par1ItemStack, player);
            if (ItemRelic.isRightPlayer(player, par1ItemStack)) {
                float check;
                PotionEffect haste = player.func_70660_b(Potion.field_76422_e);
                float f = haste == null ? 0.16666667f : (check = haste.func_76458_c() == 1 ? 0.5f : 0.4f);
                if (player.func_71045_bC() == par1ItemStack && player.field_70733_aJ == check && !par2World.field_72995_K) {
                    EntityManaBurst burst = this.getBurst(player, par1ItemStack);
                    par2World.func_72838_d((Entity)burst);
                    par2World.func_72956_a((Entity)player, "botania:terraBlade", 0.4f, 1.4f);
                }
            }
        }
    }

    public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List p_77624_3_, boolean p_77624_4_) {
        ItemRelic.addBindInfo(p_77624_3_, p_77624_1_, p_77624_2_);
    }

    @Override
    public void bindToUsername(String playerName, ItemStack stack) {
        ItemRelic.bindToUsernameS(playerName, stack);
    }

    @Override
    public String getSoulbindUsername(ItemStack stack) {
        return ItemRelic.getSoulbindUsernameS(stack);
    }

    @Override
    public Achievement getBindAchievement() {
        return this.achievement;
    }

    @Override
    public void setBindAchievement(Achievement achievement) {
        this.achievement = achievement;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return false;
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public Multimap func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 10.0, 0));
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.3, 1));
        return multimap;
    }

    public EntityManaBurst getBurst(EntityPlayer player, ItemStack stack) {
        EntityManaBurst burst = new EntityManaBurst(player);
        float motionModifier = 7.0f;
        burst.setColor(0xFFFF20);
        burst.setMana(1);
        burst.setStartingMana(1);
        burst.setMinManaLoss(200);
        burst.setManaLossPerTick(1.0f);
        burst.setGravity(0.0f);
        burst.setMotion(burst.field_70159_w * (double)motionModifier, burst.field_70181_x * (double)motionModifier, burst.field_70179_y * (double)motionModifier);
        ItemStack lens = stack.func_77946_l();
        ItemNBTHelper.setString(lens, TAG_ATTACKER_USERNAME, player.func_70005_c_());
        burst.setSourceLens(lens);
        return burst;
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props) {
    }

    @Override
    public boolean collideBurst(IManaBurst burst, MovingObjectPosition pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        return dead;
    }

    @Override
    public void updateBurst(IManaBurst burst, ItemStack stack) {
        Entity home;
        EntityThrowable entity = (EntityThrowable)burst;
        AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)entity.field_70142_S, (double)entity.field_70137_T, (double)entity.field_70136_U).func_72314_b(1.0, 1.0, 1.0);
        String attacker = ItemNBTHelper.getString(burst.getSourceLens(), TAG_ATTACKER_USERNAME, "");
        int homeID = ItemNBTHelper.getInt(stack, TAG_HOME_ID, -1);
        if (homeID == -1) {
            AxisAlignedBB axis1 = AxisAlignedBB.func_72330_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)entity.field_70142_S, (double)entity.field_70137_T, (double)entity.field_70136_U).func_72314_b(5.0, 5.0, 5.0);
            List entities = entity.field_70170_p.func_72872_a(EntityLivingBase.class, axis1);
            for (EntityLivingBase living : entities) {
                if (living instanceof EntityPlayer || living instanceof IBossDisplayData || !(living instanceof IMob) || living.field_70737_aN != 0) continue;
                homeID = living.func_145782_y();
                ItemNBTHelper.setInt(stack, TAG_HOME_ID, homeID);
                break;
            }
        }
        List entities = entity.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
        if (homeID != -1 && (home = entity.field_70170_p.func_73045_a(homeID)) != null) {
            Vector3 vecEntity = Vector3.fromEntityCenter(home);
            Vector3 vecThis = Vector3.fromEntityCenter((Entity)entity);
            Vector3 vecMotion = vecEntity.sub(vecThis);
            Vector3 vecCurrentMotion = new Vector3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            vecMotion.normalize().multiply(vecCurrentMotion.mag());
            burst.setMotion(vecMotion.x, vecMotion.y, vecMotion.z);
        }
        for (EntityLivingBase living : entities) {
            if (living instanceof EntityPlayer && (((EntityPlayer)living).func_70005_c_().equals(attacker) || MinecraftServer.func_71276_C() != null && !MinecraftServer.func_71276_C().func_71219_W()) || living.field_70737_aN != 0) continue;
            int cost = 1;
            int mana = burst.getMana();
            if (mana < cost) continue;
            burst.setMana(mana - cost);
            float damage = 4.0f + toolMaterial.func_78000_c();
            if (burst.isFake() || entity.field_70170_p.field_72995_K) continue;
            EntityPlayer player = living.field_70170_p.func_72924_a(attacker);
            living.func_70097_a(player == null ? DamageSource.field_76376_m : DamageSource.func_76365_a((EntityPlayer)player), damage);
            entity.func_70106_y();
            break;
        }
    }

    @Override
    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        return true;
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return BotaniaAPI.rarityRelic;
    }
}

