/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import info.jbcs.minecraft.chisel.Chisel;
import info.jbcs.minecraft.chisel.ChiselBlocks;
import info.jbcs.minecraft.chisel.Configurations;
import info.jbcs.minecraft.chisel.api.ChiselMode;
import info.jbcs.minecraft.chisel.carving.CarvingVariation;
import info.jbcs.minecraft.chisel.client.GeneralChiselClient;
import info.jbcs.minecraft.chisel.item.ItemChisel;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ChiselLeftClick {
    HashMap<String, Long> chiselUseTime = new HashMap();
    HashMap<String, String> chiselUseLocation = new HashMap();
    Random random = new Random();

    @SubscribeEvent
    public void onPlayerClick(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (!Configurations.enableChiseling) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ItemStack stack = player.func_70694_bm();
        if (stack == null || stack.func_77973_b() != Chisel.chisel) {
            return;
        }
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        Block block = world.func_147439_a(x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        ItemStack chiselTarget = null;
        if (stack.field_77990_d != null) {
            chiselTarget = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("chiselTarget"));
        }
        boolean chiselHasBlockInside = true;
        if (chiselTarget == null) {
            CarvingVariation[] variations;
            chiselHasBlockInside = false;
            Long useTime = this.chiselUseTime.get(player.func_70005_c_());
            String loc = this.chiselUseLocation.get(player.func_70005_c_());
            if (useTime != null && this.chiselUseLocation != null && loc.equals(x + "|" + y + "|" + z)) {
                long cooldown = 20L;
                long time = world.func_72912_H().func_82573_f();
                if (time > useTime - cooldown && time < useTime + cooldown) {
                    return;
                }
            }
            if ((variations = ItemChisel.carving.getVariations(block, blockMeta)) == null || variations.length < 2) {
                return;
            }
            int index = blockMeta + 1;
            while (variations[index].block.equals(block) && variations[index].damage == blockMeta) {
                if (++index < variations.length) continue;
                index = 0;
            }
            CarvingVariation var = variations[index];
            chiselTarget = new ItemStack(var.block, 1, var.damage);
        }
        Item result = null;
        int targetMeta = 0;
        Item target = chiselTarget.func_77973_b();
        targetMeta = chiselTarget.func_77960_j();
        boolean match = ItemChisel.carving.isVariationOfSameClass(Block.func_149634_a((Item)target), targetMeta, block, blockMeta);
        result = target;
        if (Configurations.chiselStoneToCobbleBricks) {
            if (!match && block.equals(Blocks.field_150348_b) && Block.func_149634_a((Item)target).equals(ChiselBlocks.blockCobblestone)) {
                match = true;
            }
            if (!match && block.equals(Blocks.field_150348_b) && Block.func_149634_a((Item)target).equals(ChiselBlocks.stoneBrick)) {
                match = true;
            }
        }
        if (!match) {
            return;
        }
        int updateValue = 1;
        if (!world.field_72995_K || chiselHasBlockInside) {
            world.func_147465_d(x, y, z, Block.func_149634_a((Item)result), targetMeta, updateValue);
            world.func_147471_g(x, y, z);
        }
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case SERVER: {
                this.chiselUseTime.put(player.func_70005_c_(), world.func_72912_H().func_82573_f());
                this.chiselUseLocation.put(player.func_70005_c_(), x + "|" + y + "|" + z);
                break;
            }
            case CLIENT: {
                if (!chiselHasBlockInside) break;
                String sound = ItemChisel.carving.getVariationSound(result, chiselTarget.func_77960_j());
                GeneralChiselClient.spawnChiselEffect(x, y, z, sound);
                break;
            }
        }
        stack.func_77972_a(1, (EntityLivingBase)player);
        if (stack.field_77994_a == 0) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = chiselHasBlockInside ? chiselTarget : null;
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!Configurations.enableChiseling) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        ItemStack stack = player.func_70694_bm();
        if (stack == null || stack.func_77973_b() != Chisel.chisel) {
            return;
        }
        event.setCanceled(true);
    }

    public static void setBlock(World world, int x, int y, int z, ChiselMode chiselMode, Block previousBlock, int previousMetadata, Block newBlock, int newMetadata, ForgeDirection direction) {
        if (chiselMode == ChiselMode.SINGLE) {
            world.func_147465_d(x, y, z, newBlock, newMetadata, 2);
        } else if (chiselMode == ChiselMode.CIRCLETHREE) {
            int radius = 1;
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    if (world.func_147439_a(x + i, y, z + j) == null || world.func_147439_a(x + i, y, z + j) != previousBlock || world.func_72805_g(x + i, y, z + j) != previousMetadata) continue;
                    int shiftedX = x;
                    int shiftedY = y;
                    int shiftedZ = z;
                    world.func_147465_d(shiftedX, shiftedY, shiftedZ, newBlock, newMetadata, 2);
                }
            }
        }
    }
}

