/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui;

public class GuiColor
extends Number {
    private static final long serialVersionUID = 7024827242888861187L;
    private final int _color;

    public GuiColor(int n) {
        this._color = n;
    }

    public GuiColor(int n, Void void_) {
        this(n >>> 24, n >> 16, n >> 8, n);
    }

    public GuiColor(byte by, int n) {
        this(n >> 16, n >> 8, n, by);
    }

    public GuiColor(int n, byte by) {
        this(n >>> 24, n >> 16, n >> 8, by);
    }

    public GuiColor(int n, int n2, int n3) {
        this(n, n2, n3, 255);
    }

    public GuiColor(int n, int n2, int n3, int n4) {
        this._color = n3 & 0xFF | (n2 & 0xFF) << 8 | (n & 0xFF) << 16 | (n4 & 0xFF) << 24;
    }

    public int getColor() {
        return this._color;
    }

    public int getIntR() {
        return this._color >> 16 & 0xFF;
    }

    public int getIntG() {
        return this._color >> 8 & 0xFF;
    }

    public int getIntB() {
        return this._color >> 0 & 0xFF;
    }

    public int getIntA() {
        return this._color >> 24 & 0xFF;
    }

    public float getFloatR() {
        return (float)this.getIntR() / 255.0f;
    }

    public float getFloatG() {
        return (float)this.getIntG() / 255.0f;
    }

    public float getFloatB() {
        return (float)this.getIntB() / 255.0f;
    }

    public float getFloatA() {
        return (float)this.getIntA() / 255.0f;
    }

    public GuiColor multiply(float f) {
        return this.multiply(f, f, f, f);
    }

    public GuiColor multiply(float f, float f2) {
        return this.multiply(f, f, f, f2);
    }

    public GuiColor multiply(float f, float f2, float f3) {
        return this.multiply(f, f2, f3, 1.0f);
    }

    public GuiColor multiply(float f, float f2, float f3, float f4) {
        return new GuiColor(Math.min((int)((float)this.getIntR() * f), 255), Math.min((int)((float)this.getIntG() * f2), 255), Math.min((int)((float)this.getIntB() * f3), 255));
    }

    public GuiColor add(int n) {
        return new GuiColor(Math.max(Math.min(this.getIntR() + n, 255), 0), Math.max(Math.min(this.getIntG() + n, 255), 0), Math.max(Math.min(this.getIntB() + n, 255), 0), Math.max(Math.min(this.getIntA() + n, 255), 0));
    }

    public GuiColor add(GuiColor guiColor) {
        return new GuiColor(Math.max(Math.min(this.getIntR() + guiColor.getIntR(), 255), 0), Math.max(Math.min(this.getIntG() + guiColor.getIntG(), 255), 0), Math.max(Math.min(this.getIntB() + guiColor.getIntB(), 255), 0), Math.max(Math.min(this.getIntA() + guiColor.getIntA(), 255), 0));
    }

    @Override
    public int intValue() {
        return this.getColor();
    }

    @Override
    public long longValue() {
        return this.getColor();
    }

    @Override
    public float floatValue() {
        return this.getColor();
    }

    @Override
    public double doubleValue() {
        return this.getColor();
    }
}

