/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.render.CCRenderState;
import java.util.ArrayList;

public class CCRenderPipeline {
    private ArrayList<CCRenderState.VertexAttribute> attribs = new ArrayList();
    private ArrayList<CCRenderState.IVertexOperation> ops = new ArrayList();
    private ArrayList<PipelineNode> nodes = new ArrayList();
    private ArrayList<CCRenderState.IVertexOperation> sorted = new ArrayList();
    private PipelineNode loading;
    private PipelineBuilder builder = new PipelineBuilder();

    public void setPipeline(CCRenderState.IVertexOperation ... iVertexOperationArray) {
        this.ops.clear();
        for (int i = 0; i < iVertexOperationArray.length; ++i) {
            this.ops.add(iVertexOperationArray[i]);
        }
        this.rebuild();
    }

    public void reset() {
        this.ops.clear();
        this.unbuild();
    }

    private void unbuild() {
        for (int i = 0; i < this.attribs.size(); ++i) {
            this.attribs.get((int)i).active = false;
        }
        this.attribs.clear();
        this.sorted.clear();
    }

    public void rebuild() {
        int n;
        if (this.ops.isEmpty() || CCRenderState.model == null) {
            return;
        }
        while (this.nodes.size() < CCRenderState.operationCount()) {
            this.nodes.add(new PipelineNode());
        }
        this.unbuild();
        if (CCRenderState.useNormals) {
            this.addAttribute(CCRenderState.normalAttrib);
        }
        if (CCRenderState.useColour) {
            this.addAttribute(CCRenderState.colourAttrib);
        }
        if (CCRenderState.computeLighting) {
            this.addAttribute(CCRenderState.lightingAttrib);
        }
        for (n = 0; n < this.ops.size(); ++n) {
            CCRenderState.IVertexOperation iVertexOperation = this.ops.get(n);
            this.loading = this.nodes.get(iVertexOperation.operationID());
            boolean bl = iVertexOperation.load();
            if (bl) {
                this.loading.op = iVertexOperation;
            }
            if (!(iVertexOperation instanceof CCRenderState.VertexAttribute)) continue;
            if (bl) {
                this.attribs.add((CCRenderState.VertexAttribute)iVertexOperation);
                continue;
            }
            ((CCRenderState.VertexAttribute)iVertexOperation).active = false;
        }
        for (n = 0; n < this.nodes.size(); ++n) {
            this.nodes.get(n).add();
        }
    }

    public void addRequirement(int n) {
        this.loading.deps.add(this.nodes.get(n));
    }

    public void addDependency(CCRenderState.VertexAttribute vertexAttribute) {
        this.loading.deps.add(this.nodes.get(vertexAttribute.operationID()));
        this.addAttribute(vertexAttribute);
    }

    public void addAttribute(CCRenderState.VertexAttribute vertexAttribute) {
        if (!vertexAttribute.active) {
            this.ops.add(vertexAttribute);
            vertexAttribute.active = true;
        }
    }

    public void operate() {
        for (int i = 0; i < this.sorted.size(); ++i) {
            this.sorted.get(i).operate();
        }
    }

    public PipelineBuilder builder() {
        this.ops.clear();
        return this.builder;
    }

    private class PipelineNode {
        public ArrayList<PipelineNode> deps = new ArrayList();
        public CCRenderState.IVertexOperation op;

        private PipelineNode() {
        }

        public void add() {
            if (this.op == null) {
                return;
            }
            for (int i = 0; i < this.deps.size(); ++i) {
                this.deps.get(i).add();
            }
            this.deps.clear();
            CCRenderPipeline.this.sorted.add(this.op);
            this.op = null;
        }
    }

    public class PipelineBuilder {
        public PipelineBuilder add(CCRenderState.IVertexOperation iVertexOperation) {
            CCRenderPipeline.this.ops.add(iVertexOperation);
            return this;
        }

        public PipelineBuilder add(CCRenderState.IVertexOperation ... iVertexOperationArray) {
            for (int i = 0; i < iVertexOperationArray.length; ++i) {
                CCRenderPipeline.this.ops.add(iVertexOperationArray[i]);
            }
            return this;
        }

        public void build() {
            CCRenderPipeline.this.rebuild();
        }

        public void render() {
            CCRenderPipeline.this.rebuild();
            CCRenderState.render();
        }
    }
}

