/*
 * Decompiled with CFR 0.152.
 */
package foxz.commandhelper;

import foxz.commandhelper.CommandHelper;
import foxz.commandhelper.annotations.Command;
import foxz.commandhelper.annotations.SubCommand;
import foxz.commandhelper.permissions.AbstractPermission;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;

public abstract class AbstractCommandHelper
extends CommandHelper {
    public Object ctorParm;
    public ICommandSender pcParam;
    public Object xParam;
    public AbstractCommandHelper parentCmdHelper;
    public AbstractCommandHelper rootCmdHelper;
    public Map commands = new HashMap();
    public CommandHelper.Helper currentHelper;

    public AbstractCommandHelper(Object sender) {
        this.ctorParm = sender;
        this.ctor();
    }

    public void ctor() {
        this.commandHelper.name = this.getClass().getAnnotation(Command.class).name();
        this.commandHelper.usage = this.getClass().getAnnotation(Command.class).usage();
        this.commandHelper.desc = this.getClass().getAnnotation(Command.class).desc();
        for (Class m : this.getClass().getAnnotation(Command.class).sub()) {
            try {
                String sc = m.getAnnotation(Command.class).name().toUpperCase();
                Constructor name = m.getConstructor(Object.class);
                name.setAccessible(true);
                AbstractCommandHelper sc1 = (AbstractCommandHelper)name.newInstance(this.ctorParm);
                this.commands.put(sc, sc1);
            }
            catch (Exception var8) {
                Logger.getLogger(AbstractCommandHelper.class.getName()).log(Level.SEVERE, (String)null, var8);
            }
        }
        for (Method var10 : this.getClass().getDeclaredMethods()) {
            SubCommand var11 = var10.getAnnotation(SubCommand.class);
            if (var11 == null) continue;
            String var12 = var11.name();
            if (var12.equals("")) {
                var12 = var10.getName();
            }
            this.commands.put(var12.toUpperCase(), new MethodSubCmd(this, var10));
        }
    }

    public abstract void help(String var1, String var2, String var3);

    public abstract void cmdError(String var1);

    public abstract void error(String var1);

    public void allHelp() {
        for (CommandHelper cur : this.commands.values()) {
            this.help(cur.commandHelper.name, cur.commandHelper.desc, "");
        }
    }

    public Boolean processCommand(ICommandSender param, String[] args) {
        this.pcParam = param;
        if (this.parentCmdHelper == null) {
            this.rootCmdHelper = this;
        }
        if (args.length == 0) {
            this.allHelp();
            return true;
        }
        String cmd = args[0].toUpperCase();
        args = Arrays.copyOfRange(args, 1, args.length);
        if ((cmd.equals("HELP") || args.length == 0) && this.doHelp(param, args, cmd)) {
            return true;
        }
        CommandHelper ch = (CommandHelper)this.commands.get(cmd);
        if (ch == null) {
            this.cmdError(cmd);
            return false;
        }
        if (ch instanceof AbstractCommandHelper) {
            AbstractCommandHelper m1 = (AbstractCommandHelper)ch;
            m1.parentCmdHelper = this;
            m1.rootCmdHelper = this.rootCmdHelper;
            return m1.processCommand(param, args);
        }
        if (ch instanceof MethodSubCmd) {
            MethodSubCmd m = (MethodSubCmd)ch;
            m.method.setAccessible(true);
            this.currentHelper = ch.commandHelper;
            try {
                AbstractPermission p;
                Iterator ex = m.permissions.iterator();
                do {
                    if (ex.hasNext()) continue;
                    return (Boolean)m.method.invoke((Object)this, new Object[]{args});
                } while ((p = (AbstractPermission)ex.next()).delegate(this, args));
                this.error(p.errorMsg());
                return false;
            }
            catch (Exception var8) {
                Logger.getLogger(AbstractCommandHelper.class.getName()).log(Level.SEVERE, m.commandHelper.name, var8);
                return true;
            }
        }
        this.cmdError(cmd);
        return false;
    }

    private boolean doHelp(ICommandSender param, String[] args, String cmd) {
        CommandHelper ch;
        boolean isHelp = cmd.equals("HELP");
        if (args.length > 0) {
            cmd = args[0];
        }
        if ((ch = (CommandHelper)this.commands.get(cmd.toUpperCase())) != null) {
            if (ch.commandHelper.hasEmptyCall && !isHelp) {
                return false;
            }
            if (ch instanceof AbstractCommandHelper) {
                ((AbstractCommandHelper)ch).pcParam = param;
                ((AbstractCommandHelper)ch).allHelp();
            } else {
                if (ch instanceof MethodSubCmd && ((MethodSubCmd)ch).commandHelper.usage.isEmpty()) {
                    return false;
                }
                this.help(ch.commandHelper.name, ch.commandHelper.desc, ch.commandHelper.usage);
            }
        } else {
            this.allHelp();
        }
        return true;
    }

    @Override
    public List addTabCompletion(ICommandSender par1, String[] args) {
        if (args.length > 1) {
            CommandHelper ch1 = (CommandHelper)this.commands.get(args[0].toUpperCase());
            if (ch1 == null) {
                return null;
            }
            args = Arrays.copyOfRange(args, 1, args.length);
            this.currentHelper = ch1.commandHelper;
            return ch1.addTabCompletion(par1, args);
        }
        ArrayList<String> ch = new ArrayList<String>();
        for (String command : this.commands.keySet()) {
            ch.add(command.toLowerCase());
        }
        ch.add("help");
        return CommandBase.func_71530_a((String[])args, (String[])ch.toArray(new String[ch.size()]));
    }

    public List getPlayersData(String username) {
        ArrayList<PlayerData> list = new ArrayList<PlayerData>();
        EntityPlayerMP[] players = PlayerSelector.func_82380_c((ICommandSender)this.pcParam, (String)username);
        if (players != null && players.length != 0) {
            EntityPlayerMP[] var8 = players;
            int var5 = players.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                EntityPlayerMP player = var8[var6];
                list.add(PlayerDataController.instance.getPlayerData((EntityPlayer)player));
            }
        } else {
            PlayerData data = PlayerDataController.instance.getDataFromUsername(username);
            if (data != null) {
                list.add(data);
            }
        }
        return list;
    }

    protected class MethodSubCmd
    extends CommandHelper {
        public List permissions = new ArrayList();
        public Method method;

        public MethodSubCmd(AbstractCommandHelper ch, Method m) {
            SubCommand s = m.getAnnotation(SubCommand.class);
            this.commandHelper.name = s.name();
            if (this.commandHelper.name.equals("")) {
                this.commandHelper.name = m.getName();
            }
            this.commandHelper.usage = s.usage();
            this.commandHelper.desc = s.desc();
            this.commandHelper.hasEmptyCall = s.hasEmptyCall();
            this.method = m;
            for (Class c : s.permissions()) {
                try {
                    Constructor ex = c.getDeclaredConstructor(new Class[0]);
                    ex.setAccessible(true);
                    AbstractPermission i = (AbstractPermission)ex.newInstance(new Object[0]);
                    this.permissions.add(i);
                }
                catch (Exception var11) {
                    Logger.getLogger(AbstractCommandHelper.class.getName()).log(Level.SEVERE, (String)null, var11);
                }
            }
        }

        @Override
        public List addTabCompletion(ICommandSender par1, String[] args) {
            String[] np = AbstractCommandHelper.this.currentHelper.usage.split(" ");
            if (np.length < args.length) {
                return null;
            }
            String parameter = np[args.length - 1];
            return parameter.equals("<player>") ? CommandBase.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z()) : null;
        }
    }
}

