/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.oredict.OreDictionary;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomTeleporter;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.QuestLogData;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumOptionType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.containers.ContainerNPCFollower;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.BankData;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.Line;
import noppes.npcs.controllers.PlayerBankData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.PlayerTransportData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleFollower;

public class NoppesUtilPlayer {
    public static void changeFollowerState(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role == EnumRoleType.Follower) {
            RoleFollower role = (RoleFollower)npc.roleInterface;
            EntityPlayer owner = role.owner;
            if (owner != null && owner.func_70005_c_().equals(player.func_70005_c_())) {
                role.isFollowing = !role.isFollowing;
            }
        }
    }

    public static void hireFollower(EntityPlayerMP player, EntityNPCInterface npc) {
        Container con;
        if (npc.advanced.role == EnumRoleType.Follower && (con = player.field_71070_bA) != null && con instanceof ContainerNPCFollowerHire) {
            ContainerNPCFollowerHire container = (ContainerNPCFollowerHire)con;
            RoleFollower role = (RoleFollower)npc.roleInterface;
            NoppesUtilPlayer.followerBuy(role, (IInventory)container.currencyMatrix, player, npc);
        }
    }

    public static void extendFollower(EntityPlayerMP player, EntityNPCInterface npc) {
        Container con;
        if (npc.advanced.role == EnumRoleType.Follower && (con = player.field_71070_bA) != null && con instanceof ContainerNPCFollower) {
            ContainerNPCFollower container = (ContainerNPCFollower)con;
            RoleFollower role = (RoleFollower)npc.roleInterface;
            NoppesUtilPlayer.followerBuy(role, container.currencyMatrix, player, npc);
        }
    }

    public static void transport(EntityPlayerMP player, EntityNPCInterface npc, String location) {
        TransportLocation loc = TransportController.getInstance().getTransport(location);
        PlayerTransportData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).transportData;
        if (loc != null && (loc.isDefault() || playerdata.transports.contains(loc.id))) {
            NoppesUtilPlayer.teleportPlayer(player, loc.posX, loc.posY, loc.posZ, loc.dimension);
        }
    }

    public static void teleportPlayer(EntityPlayerMP player, double posX, double posY, double posZ, int dimension) {
        if (player.field_71093_bK != dimension) {
            int dim = player.field_71093_bK;
            MinecraftServer server = MinecraftServer.func_71276_C();
            WorldServer wor = server.func_71218_a(dimension);
            if (wor == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Broken transporter. Dimenion does not exist"));
                return;
            }
            player.func_70012_b(posX, posY, posZ, player.field_70177_z, player.field_70125_A);
            server.func_71203_ab().transferPlayerToDimension(player, dimension, (Teleporter)new CustomTeleporter(wor));
            player.field_71135_a.func_147364_a(posX, posY, posZ, player.field_70177_z, player.field_70125_A);
            if (!wor.field_73010_i.contains(player)) {
                wor.func_72838_d((Entity)player);
            }
        } else {
            player.field_71135_a.func_147364_a(posX, posY, posZ, player.field_70177_z, player.field_70125_A);
        }
        player.field_70170_p.func_72866_a((Entity)player, false);
    }

    private static void followerBuy(RoleFollower role, IInventory currencyInv, EntityPlayerMP player, EntityNPCInterface npc) {
        ItemStack currency = currencyInv.func_70301_a(0);
        if (currency != null) {
            int possibleSize;
            int days;
            HashMap<ItemStack, Integer> cd = new HashMap<ItemStack, Integer>();
            Iterator stackSize = role.inventory.items.keySet().iterator();
            while (stackSize.hasNext()) {
                days = (Integer)stackSize.next();
                ItemStack possibleDays = (ItemStack)role.inventory.items.get(days);
                if (possibleDays == null || possibleDays.func_77973_b() != currency.func_77973_b() || possibleDays.func_77981_g() && possibleDays.func_77960_j() != currency.func_77960_j()) continue;
                possibleSize = 1;
                if (role.rates.containsKey(days)) {
                    possibleSize = (Integer)role.rates.get(days);
                }
                cd.put(possibleDays, possibleSize);
            }
            if (cd.size() != 0) {
                int stackSize1 = currency.field_77994_a;
                days = 0;
                int possibleDays1 = 0;
                possibleSize = stackSize1;
                while (true) {
                    for (ItemStack item : cd.keySet()) {
                        int newStackSize;
                        int size;
                        int posDays;
                        int rDays = (Integer)cd.get(item);
                        int rValue = item.field_77994_a;
                        if (rValue > stackSize1 || possibleDays1 > (posDays = (size = stackSize1 - (newStackSize = stackSize1 % rValue)) / rValue * rDays)) continue;
                        possibleDays1 = posDays;
                        possibleSize = newStackSize;
                    }
                    if (stackSize1 == possibleSize) {
                        if (days == 0) {
                            return;
                        }
                        if (stackSize1 <= 0) {
                            currencyInv.func_70299_a(0, (ItemStack)null);
                        } else {
                            currency.func_77979_a(stackSize1);
                        }
                        npc.say((EntityPlayer)player, new Line(NoppesStringUtils.formatText(role.dialogHire.replace("{days}", days + ""), new Object[]{player, npc})));
                        role.setOwner((EntityPlayer)player);
                        role.addDays(days);
                        return;
                    }
                    stackSize1 = possibleSize;
                    days += possibleDays1;
                    possibleDays1 = 0;
                }
            }
        }
    }

    public static void bankUpgrade(EntityPlayerMP player, EntityNPCInterface npc) {
        Container con;
        if (npc.advanced.role == EnumRoleType.Bank && (con = player.field_71070_bA) != null && con instanceof ContainerNPCBankInterface) {
            ContainerNPCBankInterface container = (ContainerNPCBankInterface)con;
            Bank bank = BankController.getInstance().getBank(container.bankid);
            ItemStack item = bank.upgradeInventory.func_70301_a(container.slot);
            if (item != null) {
                int price = item.field_77994_a;
                ItemStack currency = container.currencyMatrix.func_70301_a(0);
                if (currency != null && price <= currency.field_77994_a) {
                    if (currency.field_77994_a - price == 0) {
                        container.currencyMatrix.func_70299_a(0, null);
                    } else {
                        currency.func_77979_a(price);
                    }
                    player.func_71128_l();
                    PlayerBankData data = PlayerDataController.instance.getBankData((EntityPlayer)player, bank.id);
                    BankData bankData = data.getBank(bank.id);
                    bankData.upgradedSlots.put(container.slot, true);
                    bankData.openBankGui((EntityPlayer)player, npc, bank.id, container.slot);
                }
            }
        }
    }

    public static void bankUnlock(EntityPlayerMP player, EntityNPCInterface npc) {
        Container con;
        if (npc.advanced.role == EnumRoleType.Bank && (con = player.field_71070_bA) != null && con instanceof ContainerNPCBankInterface) {
            ContainerNPCBankInterface container = (ContainerNPCBankInterface)con;
            Bank bank = BankController.getInstance().getBank(container.bankid);
            ItemStack item = bank.currencyInventory.func_70301_a(container.slot);
            if (item != null) {
                int price = item.field_77994_a;
                ItemStack currency = container.currencyMatrix.func_70301_a(0);
                if (currency != null && price <= currency.field_77994_a) {
                    if (currency.field_77994_a - price == 0) {
                        container.currencyMatrix.func_70299_a(0, null);
                    } else {
                        currency.func_77979_a(price);
                    }
                    player.func_71128_l();
                    PlayerBankData data = PlayerDataController.instance.getBankData((EntityPlayer)player, bank.id);
                    BankData bankData = data.getBank(bank.id);
                    if (bankData.unlockedSlots + 1 <= bank.maxSlots) {
                        ++bankData.unlockedSlots;
                    }
                    bankData.openBankGui((EntityPlayer)player, npc, bank.id, container.slot);
                }
            }
        }
    }

    public static void sendData(EnumPlayerPacket enu, Object ... obs) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (!Server.fillBuffer(buffer, enu, obs)) {
                return;
            }
            CustomNpcs.ChannelPlayer.sendToServer(new FMLProxyPacket(buffer, "CustomNPCsPlayer"));
        }
        catch (IOException var4) {
            var4.printStackTrace();
        }
    }

    public static void dialogSelected(int dialogId, int optionId, EntityPlayerMP player, EntityNPCInterface npc) {
        Dialog dialog = (Dialog)DialogController.instance.dialogs.get(dialogId);
        if (dialog != null) {
            DialogOption option;
            npc.script.callScript(EnumScriptType.DIALOG_OPTION, "player", player, "dialog", dialogId, "option", optionId + 1);
            if ((dialog.hasDialogs((EntityPlayer)player) || dialog.hasOtherOptions()) && (option = (DialogOption)dialog.options.get(optionId)) != null && (option.optionType != EnumOptionType.DialogOption || option.isAvailable((EntityPlayer)player) && option.hasDialog()) && option.optionType != EnumOptionType.Disabled && option.optionType != EnumOptionType.QuitOption) {
                if (option.optionType == EnumOptionType.RoleOption) {
                    if (npc.roleInterface != null) {
                        npc.roleInterface.interact((EntityPlayer)player);
                    } else {
                        Server.sendData(player, EnumPacketClient.GUI_CLOSE, new Object[0]);
                    }
                } else if (option.optionType == EnumOptionType.DialogOption) {
                    NoppesUtilServer.openDialog((EntityPlayer)player, npc, option.getDialog());
                } else if (option.optionType == EnumOptionType.CommandBlock) {
                    Server.sendData(player, EnumPacketClient.GUI_CLOSE, new Object[0]);
                    NoppesUtilServer.runCommand((EntityPlayer)player, npc.func_70005_c_(), option.command);
                } else {
                    Server.sendData(player, EnumPacketClient.GUI_CLOSE, new Object[0]);
                }
            }
        }
    }

    public static void sendQuestLogData(EntityPlayerMP player) {
        if (PlayerQuestController.hasActiveQuests((EntityPlayer)player)) {
            QuestLogData data = new QuestLogData();
            data.setData((EntityPlayer)player);
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.writeNBT());
        }
    }

    public static void questCompletion(EntityPlayerMP player, int questId) {
        PlayerQuestData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        QuestData data = (QuestData)playerdata.activeQuests.get(questId);
        if (data != null && data.quest.questInterface.isCompleted((EntityPlayer)player)) {
            data.quest.questInterface.handleComplete((EntityPlayer)player);
            if (data.quest.rewardExp > 0) {
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
                player.func_71023_q(data.quest.rewardExp);
            }
            data.quest.factionOptions.addPoints((EntityPlayer)player);
            if (data.quest.mail.isValid()) {
                PlayerDataController.instance.addPlayerMessage(player.func_70005_c_(), data.quest.mail);
            }
            if (!data.quest.randomReward) {
                for (ItemStack item : data.quest.rewardItems.items.values()) {
                    NoppesUtilServer.GivePlayerItem((Entity)player, (EntityPlayer)player, item);
                }
            } else {
                ArrayList<ItemStack> list1 = new ArrayList<ItemStack>();
                for (ItemStack item1 : data.quest.rewardItems.items.values()) {
                    if (item1 == null || item1.func_77973_b() == null) continue;
                    list1.add(item1);
                }
                if (!list1.isEmpty()) {
                    NoppesUtilServer.GivePlayerItem((Entity)player, (EntityPlayer)player, (ItemStack)list1.get(player.func_70681_au().nextInt(list1.size())));
                }
            }
            if (!data.quest.command.isEmpty()) {
                NoppesUtilServer.runCommand((EntityPlayer)player, "QuestCompletion", data.quest.command);
            }
            PlayerQuestController.setQuestFinished(data.quest, (EntityPlayer)player);
            if (data.quest.hasNewQuest()) {
                PlayerQuestController.addActiveQuest(data.quest.getNextQuest(), (EntityPlayer)player);
            }
        }
    }

    public static boolean compareItems(ItemStack item, ItemStack item2, boolean ignoreDamage, boolean ignoreNBT) {
        if (item2 != null && item != null) {
            boolean oreMatched = false;
            OreDictionary.itemMatches((ItemStack)item, (ItemStack)item2, (boolean)false);
            int[] ids = OreDictionary.getOreIDs((ItemStack)item);
            if (ids.length > 0) {
                int[] var6 = ids;
                int var7 = ids.length;
                for (int var8 = 0; var8 < var7; ++var8) {
                    int id = var6[var8];
                    boolean match1 = false;
                    boolean match2 = false;
                    for (ItemStack is : OreDictionary.getOres((Integer)id)) {
                        if (NoppesUtilPlayer.compareItemDetails(item, is, ignoreDamage, ignoreNBT)) {
                            match1 = true;
                        }
                        if (!NoppesUtilPlayer.compareItemDetails(item2, is, ignoreDamage, ignoreNBT)) continue;
                        match2 = true;
                    }
                    if (!match1 || !match2) continue;
                    return true;
                }
            }
            return NoppesUtilPlayer.compareItemDetails(item, item2, ignoreDamage, ignoreNBT);
        }
        return false;
    }

    private static boolean compareItemDetails(ItemStack item, ItemStack item2, boolean ignoreDamage, boolean ignoreNBT) {
        return item.func_77973_b() != item2.func_77973_b() ? false : (!ignoreDamage && item.func_77960_j() != -1 && item.func_77960_j() != item2.func_77960_j() ? false : (!ignoreNBT && item.field_77990_d != null && (item2.field_77990_d == null || !item.field_77990_d.equals((Object)item2.field_77990_d)) ? false : ignoreNBT || item2.field_77990_d == null || item.field_77990_d != null));
    }

    public static boolean compareItems(EntityPlayer player, ItemStack item, boolean ignoreDamage) {
        int size = 0;
        for (ItemStack is : player.field_71071_by.field_70462_a) {
            if (is == null || !NoppesUtilPlayer.compareItems(item, is, ignoreDamage, false)) continue;
            size += is.field_77994_a;
        }
        return size >= item.field_77994_a;
    }

    public static void consumeItem(EntityPlayer player, ItemStack item, boolean ignoreDamage) {
        if (item != null) {
            int size = item.field_77994_a;
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack is = player.field_71071_by.field_70462_a[i];
                if (is == null || !NoppesUtilPlayer.compareItems(item, is, ignoreDamage, false)) continue;
                if (size < is.field_77994_a) {
                    player.field_71071_by.field_70462_a[i].func_77979_a(size);
                    break;
                }
                size -= is.field_77994_a;
                player.field_71071_by.field_70462_a[i] = null;
            }
        }
    }
}

