/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NBTTags;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.containers.ContainerManageBanks;
import noppes.npcs.containers.ContainerManageRecipes;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogCategory;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.Faction;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PlayerBankData;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerDialogData;
import noppes.npcs.controllers.PlayerFactionData;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.PlayerTransportData;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestCategory;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.TransportCategory;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleTransporter;
import noppes.npcs.scripted.ScriptEventDialog;

public class NoppesUtilServer {
    private static HashMap editingQuests = new HashMap();

    public static void setEditingNpc(EntityPlayer player, EntityNPCInterface npc) {
        PlayerData data = PlayerDataController.instance.getPlayerData(player);
        data.editingNpc = npc;
        if (npc != null) {
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.EDIT_NPC, npc.func_145782_y());
        }
    }

    public static EntityNPCInterface getEditingNpc(EntityPlayer player) {
        PlayerData data = PlayerDataController.instance.getPlayerData(player);
        return data.editingNpc;
    }

    public static void setEditingQuest(EntityPlayer player, Quest quest) {
        editingQuests.put(player.func_70005_c_(), quest);
    }

    public static Quest getEditingQuest(EntityPlayer player) {
        return (Quest)editingQuests.get(player.func_70005_c_());
    }

    public static void sendRoleData(EntityPlayer player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.None) {
            NBTTagCompound comp = new NBTTagCompound();
            npc.roleInterface.writeToNBT(comp);
            comp.func_74768_a("EntityId", npc.func_145782_y());
            comp.func_74768_a("Role", npc.advanced.role.ordinal());
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.ROLE, comp);
        }
    }

    public static void sendFactionDataAll(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Faction faction : FactionController.getInstance().factions.values()) {
            map.put(faction.name, faction.id);
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    public static void sendBankDataAll(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Bank bank : BankController.getInstance().banks.values()) {
            map.put(bank.name, bank.id);
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    public static void openDialog(EntityPlayer player, EntityNPCInterface npc, Dialog dia) {
        Dialog dialog = dia.copy(player);
        Server.sendData((EntityPlayerMP)player, EnumPacketClient.DIALOG, npc.func_145782_y(), dialog.writeToNBT(new NBTTagCompound()));
        dia.factionOptions.addPoints(player);
        if (dialog.hasQuest()) {
            PlayerQuestController.addActiveQuest(dialog.getQuest(), player);
        }
        if (!dialog.command.isEmpty()) {
            NoppesUtilServer.runCommand(player, npc.func_70005_c_(), dialog.command);
        }
        if (dialog.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.func_70005_c_(), dialog.mail);
        }
        PlayerDialogData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).dialogData;
        if (!data.dialogsRead.contains(dialog.id)) {
            data.dialogsRead.add(dialog.id);
        }
        NoppesUtilServer.setEditingNpc(player, npc);
        npc.script.callScript(EnumScriptType.DIALOG, "event", new ScriptEventDialog(), "player", player, "dialog", dialog.id);
    }

    public static void runCommand(EntityPlayer player, String name, String command) {
        NoppesUtilServer.runCommand((EntityLivingBase)player, name, command, player);
    }

    public static void runCommand(EntityLivingBase executer, String name, String command, EntityPlayer player) {
        if (player != null) {
            command = command.replace("@dp", player.func_70005_c_());
        }
        TileEntityCommandBlock tile = new TileEntityCommandBlock();
        tile.func_145834_a(executer.field_70170_p);
        tile.field_145851_c = MathHelper.func_76128_c((double)executer.field_70165_t);
        tile.field_145848_d = MathHelper.func_76128_c((double)executer.field_70163_u);
        tile.field_145849_e = MathHelper.func_76128_c((double)executer.field_70161_v);
        CommandBlockLogic logic = tile.func_145993_a();
        logic.func_145752_a(command);
        logic.func_145754_b("@" + name);
        logic.func_145755_a(executer.field_70170_p);
    }

    public static void consumeItemStack(int i, EntityPlayer player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (!player.field_71075_bZ.field_75098_d && item != null) {
            --item.field_77994_a;
            if (item.field_77994_a <= 0) {
                player.func_71028_bD();
            }
        }
    }

    public static DataOutputStream getDataOutputStream(ByteArrayOutputStream stream) throws IOException {
        return new DataOutputStream(new GZIPOutputStream(stream));
    }

    public static void sendOpenGui(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc) {
        NoppesUtilServer.sendOpenGui(player, gui, npc, 0, 0, 0);
    }

    public static void sendOpenGui(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc, int i, int j, int k) {
        if (player instanceof EntityPlayerMP) {
            NoppesUtilServer.setEditingNpc(player, npc);
            NoppesUtilServer.sendExtraData(player, npc, gui, i, j, k);
            if (CustomNpcs.proxy.getServerGuiElement(gui.ordinal(), player, player.field_70170_p, i, j, k) != null) {
                player.openGui((Object)CustomNpcs.instance, gui.ordinal(), player.field_70170_p, i, j, k);
            } else {
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.GUI, gui.ordinal(), i, j, k);
                ArrayList list = NoppesUtilServer.getScrollData(player, gui, npc);
                if (list != null && !list.isEmpty()) {
                    Server.sendData((EntityPlayerMP)player, EnumPacketClient.SCROLL_LIST, list);
                }
            }
        }
    }

    private static void sendExtraData(EntityPlayer player, EntityNPCInterface npc, EnumGuiType gui, int i, int j, int k) {
        if (gui == EnumGuiType.PlayerFollower || gui == EnumGuiType.PlayerFollowerHire || gui == EnumGuiType.PlayerTrader || gui == EnumGuiType.PlayerTransporter) {
            NoppesUtilServer.sendRoleData(player, npc);
        }
    }

    private static ArrayList getScrollData(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc) {
        if (gui == EnumGuiType.PlayerTransporter) {
            RoleTransporter role = (RoleTransporter)npc.roleInterface;
            ArrayList<String> list = new ArrayList<String>();
            TransportLocation location = role.getLocation();
            String name = role.getLocation().name;
            for (TransportLocation loc : location.category.getDefaultLocations()) {
                if (list.contains(loc.name)) continue;
                list.add(loc.name);
            }
            PlayerTransportData playerdata1 = PlayerDataController.instance.getPlayerData((EntityPlayer)player).transportData;
            Iterator loc2 = playerdata1.transports.iterator();
            while (loc2.hasNext()) {
                int i = (Integer)loc2.next();
                TransportLocation loc1 = TransportController.getInstance().getTransport(i);
                if (loc1 == null || !location.category.locations.containsKey(loc1.id) || list.contains(loc1.name)) continue;
                list.add(loc1.name);
            }
            list.remove(name);
            return list;
        }
        return null;
    }

    public static void spawnParticle(Entity entity, String particle, int dimension) {
        Server.sendAssociatedData(entity, EnumPacketClient.PARTICLE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, Float.valueOf(entity.field_70131_O), Float.valueOf(entity.field_70130_N), Float.valueOf(entity.field_70129_M), particle);
    }

    public static void deleteNpc(EntityNPCInterface npc, EntityPlayer player) {
        Server.sendAssociatedData((Entity)npc, EnumPacketClient.DELETE_NPC, npc.func_145782_y());
    }

    public static void createMobSpawner(int x, int y, int z, NBTTagCompound comp, EntityPlayer player) {
        comp.func_82580_o("Pos");
        ServerCloneController.Instance.cleanTags(comp);
        if (comp.func_74779_i("id").equalsIgnoreCase("entityhorse")) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("Currently you cant create horse spawner, its a minecraft bug", new Object[0]));
        } else {
            player.field_70170_p.func_147449_b(x, y, z, Blocks.field_150474_ac);
            TileEntityMobSpawner tile = (TileEntityMobSpawner)player.field_70170_p.func_147438_o(x, y, z);
            MobSpawnerBaseLogic logic = tile.func_145881_a();
            logic.getClass();
            MobSpawnerBaseLogic mobSpawnerBaseLogic = logic;
            mobSpawnerBaseLogic.getClass();
            MobSpawnerBaseLogic.WeightedRandomMinecart var10001 = new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, comp, comp.func_74779_i("id"));
            logic.func_98277_a(var10001);
        }
    }

    public static void sendQuestCategoryData(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (QuestCategory category : QuestController.instance.categories.values()) {
            map.put(category.title, category.id);
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    public static void sendPlayerData(EnumPlayerData type, EntityPlayerMP player, String name) throws IOException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (type == EnumPlayerData.Players) {
            File playerdata = PlayerDataController.instance.getSaveDir();
            for (String username : PlayerDataController.instance.getUsernameData().keySet()) {
                map.put(username, 0);
            }
        } else {
            PlayerData playerdata1 = PlayerDataController.instance.getDataFromUsername(name);
            if (type == EnumPlayerData.Dialog) {
                PlayerDialogData data1 = playerdata1.dialogData;
                Iterator username1 = data1.dialogsRead.iterator();
                while (username1.hasNext()) {
                    int factionId = (Integer)username1.next();
                    Dialog faction = (Dialog)DialogController.instance.dialogs.get(factionId);
                    if (faction == null) continue;
                    map.put(faction.category.title + ": " + faction.title, factionId);
                }
            } else if (type == EnumPlayerData.Quest) {
                Quest faction1;
                int factionId;
                PlayerQuestData data2 = playerdata1.questData;
                Iterator username1 = data2.activeQuests.keySet().iterator();
                while (username1.hasNext()) {
                    factionId = (Integer)username1.next();
                    faction1 = (Quest)QuestController.instance.quests.get(factionId);
                    if (faction1 == null) continue;
                    map.put(faction1.category.title + ": " + faction1.title + "(Active quest)", factionId);
                }
                username1 = data2.finishedQuests.keySet().iterator();
                while (username1.hasNext()) {
                    factionId = (Integer)username1.next();
                    faction1 = (Quest)QuestController.instance.quests.get(factionId);
                    if (faction1 == null) continue;
                    map.put(faction1.category.title + ": " + faction1.title + "(Finished quest)", factionId);
                }
            } else if (type == EnumPlayerData.Transport) {
                PlayerTransportData data3 = playerdata1.transportData;
                Iterator username1 = data3.transports.iterator();
                while (username1.hasNext()) {
                    int factionId = (Integer)username1.next();
                    TransportLocation faction2 = TransportController.getInstance().getTransport(factionId);
                    if (faction2 == null) continue;
                    map.put(faction2.category.title + ": " + faction2.name, factionId);
                }
            } else if (type == EnumPlayerData.Bank) {
                PlayerBankData data4 = playerdata1.bankData;
                Iterator username1 = data4.banks.keySet().iterator();
                while (username1.hasNext()) {
                    int factionId = (Integer)username1.next();
                    Bank faction3 = (Bank)BankController.getInstance().banks.get(factionId);
                    if (faction3 == null) continue;
                    map.put(faction3.name, factionId);
                }
            } else if (type == EnumPlayerData.Factions) {
                PlayerFactionData data5 = playerdata1.factionData;
                Iterator username1 = data5.factionData.keySet().iterator();
                while (username1.hasNext()) {
                    int factionId = (Integer)username1.next();
                    Faction faction4 = (Faction)FactionController.getInstance().factions.get(factionId);
                    if (faction4 == null) continue;
                    map.put(faction4.name + "(" + data5.getFactionPoints(factionId) + ")", factionId);
                }
            }
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    public static void removePlayerData(ByteBuf buffer, EntityPlayerMP player) throws IOException {
        int id = buffer.readInt();
        if (EnumPlayerData.values().length > id) {
            String name = Server.readString(buffer);
            EnumPlayerData type = EnumPlayerData.values()[id];
            EntityPlayerMP pl = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(name);
            PlayerData playerdata = null;
            playerdata = pl == null ? PlayerDataController.instance.getDataFromUsername(name) : PlayerDataController.instance.getPlayerData((EntityPlayer)pl);
            if (type == EnumPlayerData.Players) {
                File data = new File(PlayerDataController.instance.getSaveDir(), playerdata.uuid + ".json");
                if (data.exists()) {
                    data.delete();
                }
                if (pl != null) {
                    playerdata.setNBT(new NBTTagCompound());
                    NoppesUtilServer.sendPlayerData(type, player, name);
                    playerdata.saveNBTData(null);
                    return;
                }
            }
            if (type == EnumPlayerData.Quest) {
                PlayerQuestData data1 = playerdata.questData;
                int questId = buffer.readInt();
                data1.activeQuests.remove(questId);
                data1.finishedQuests.remove(questId);
                playerdata.saveNBTData(null);
            }
            if (type == EnumPlayerData.Dialog) {
                PlayerDialogData data2 = playerdata.dialogData;
                data2.dialogsRead.remove(buffer.readInt());
                playerdata.saveNBTData(null);
            }
            if (type == EnumPlayerData.Transport) {
                PlayerTransportData data3 = playerdata.transportData;
                data3.transports.remove(buffer.readInt());
                playerdata.saveNBTData(null);
            }
            if (type == EnumPlayerData.Bank) {
                PlayerBankData data4 = playerdata.bankData;
                data4.banks.remove(buffer.readInt());
                playerdata.saveNBTData(null);
            }
            if (type == EnumPlayerData.Factions) {
                PlayerFactionData data5 = playerdata.factionData;
                data5.factionData.remove(buffer.readInt());
                playerdata.saveNBTData(null);
            }
            NoppesUtilServer.sendPlayerData(type, player, name);
        }
    }

    public static void sendRecipeData(EntityPlayerMP player, int size) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (size == 3) {
            for (RecipeCarpentry recipe : RecipeController.instance.globalRecipes.values()) {
                map.put(recipe.name, recipe.id);
            }
        } else {
            for (RecipeCarpentry recipe : RecipeController.instance.anvilRecipes.values()) {
                map.put(recipe.name, recipe.id);
            }
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    public static void sendScrollData(EntityPlayerMP player, Map map) {
        HashMap send = new HashMap();
        for (String key : map.keySet()) {
            send.put(key, map.get(key));
            if (send.size() != 100) continue;
            Server.sendData(player, EnumPacketClient.SCROLL_DATA_PART, send);
            send = new HashMap();
        }
        Server.sendData(player, EnumPacketClient.SCROLL_DATA, send);
    }

    public static void sendDialogData(EntityPlayerMP player, DialogCategory category) {
        if (category != null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Dialog dialog : category.dialogs.values()) {
                map.put(dialog.title, dialog.id);
            }
            NoppesUtilServer.sendScrollData(player, map);
        }
    }

    public static void sendQuestData(EntityPlayerMP player, QuestCategory category) {
        if (category != null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Quest quest : category.quests.values()) {
                map.put(quest.title, quest.id);
            }
            NoppesUtilServer.sendScrollData(player, map);
        }
    }

    public static void sendTransportCategoryData(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (TransportCategory category : TransportController.getInstance().categories.values()) {
            map.put(category.title, category.id);
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    public static void sendTransportData(EntityPlayerMP player, int categoryid) {
        TransportCategory category = (TransportCategory)TransportController.getInstance().categories.get(categoryid);
        if (category != null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (TransportLocation transport : category.locations.values()) {
                map.put(transport.name, transport.id);
            }
            NoppesUtilServer.sendScrollData(player, map);
        }
    }

    public static void sendNpcDialogs(EntityPlayer player) {
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc(player);
        if (npc != null) {
            Iterator var2 = npc.dialogs.keySet().iterator();
            while (var2.hasNext()) {
                int pos = (Integer)var2.next();
                DialogOption option = (DialogOption)npc.dialogs.get(pos);
                if (option == null || !option.hasDialog()) continue;
                NBTTagCompound compound = option.writeNBT();
                compound.func_74768_a("Position", pos);
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.GUI_DATA, compound);
            }
        }
    }

    public static DialogOption setNpcDialog(int slot, int dialogId, EntityPlayer player) throws IOException {
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc(player);
        if (npc == null) {
            return null;
        }
        if (!npc.dialogs.containsKey(slot)) {
            npc.dialogs.put(slot, new DialogOption());
        }
        DialogOption option = (DialogOption)npc.dialogs.get(slot);
        option.dialogId = dialogId;
        if (option.hasDialog()) {
            option.title = option.getDialog().title;
        }
        return option;
    }

    public static void saveTileEntity(EntityPlayerMP player, NBTTagCompound compound) {
        int z;
        int y;
        int x = compound.func_74762_e("x");
        TileEntity tile = player.field_70170_p.func_147438_o(x, y = compound.func_74762_e("y"), z = compound.func_74762_e("z"));
        if (tile != null) {
            tile.func_145839_a(compound);
        }
    }

    public static void setRecipeGui(EntityPlayerMP player, RecipeCarpentry recipe) {
        if (recipe != null && player.field_71070_bA instanceof ContainerManageRecipes) {
            ContainerManageRecipes container = (ContainerManageRecipes)player.field_71070_bA;
            container.setRecipe(recipe);
            Server.sendData(player, EnumPacketClient.GUI_DATA, recipe.writeNBT());
        }
    }

    public static void sendBank(EntityPlayerMP player, Bank bank) {
        NBTTagCompound compound = new NBTTagCompound();
        bank.writeEntityToNBT(compound);
        Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        if (player.field_71070_bA instanceof ContainerManageBanks) {
            ((ContainerManageBanks)player.field_71070_bA).setBank(bank);
        }
        player.func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
    }

    public static void sendNearbyNpcs(EntityPlayerMP player) {
        List npcs = player.field_70170_p.func_72872_a(EntityNPCInterface.class, player.field_70121_D.func_72314_b(120.0, 120.0, 120.0));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (EntityNPCInterface npc : npcs) {
            if (npc.field_70128_L) continue;
            float distance = player.func_70032_d((Entity)npc);
            DecimalFormat df = new DecimalFormat("#.#");
            String s = df.format(distance);
            if (distance < 10.0f) {
                s = "0" + s;
            }
            map.put(s + " : " + npc.display.name, npc.func_145782_y());
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    public static void sendGuiError(EntityPlayer player, int i) {
        Server.sendData((EntityPlayerMP)player, EnumPacketClient.GUI_ERROR, i, new NBTTagCompound());
    }

    public static void sendGuiClose(EntityPlayerMP player, int i, NBTTagCompound comp) {
        if (player.field_71070_bA != player.field_71069_bz) {
            player.field_71070_bA = player.field_71069_bz;
        }
        Server.sendData(player, EnumPacketClient.GUI_CLOSE, i, comp);
    }

    public static void updateNpc(EntityNPCInterface npc) {
        NBTTagCompound compound = npc.writeSpawnData();
        compound.func_74768_a("EntityId", npc.func_145782_y());
        Server.sendAssociatedData((Entity)npc, EnumPacketClient.UPDATE_NPC, compound);
    }

    public static Entity spawnClone(NBTTagCompound compound, int x, int y, int z, World worldObj) {
        ServerCloneController.Instance.cleanTags(compound);
        compound.func_74782_a("Pos", (NBTBase)NBTTags.nbtDoubleList((double)x + 0.5, y + 1, (double)z + 0.5));
        Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)worldObj);
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ai.startPos = new int[]{MathHelper.func_76128_c((double)npc.field_70165_t), MathHelper.func_76128_c((double)npc.field_70163_u), MathHelper.func_76128_c((double)npc.field_70161_v)};
        }
        worldObj.func_72838_d(entity);
        return entity;
    }

    public static boolean isOp(EntityPlayer player) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(player.func_146103_bH());
    }

    public static void GivePlayerItem(Entity entity, EntityPlayer player, ItemStack item) {
        if (!entity.field_70170_p.field_72995_K && item != null) {
            item = item.func_77946_l();
            float f = 0.7f;
            double d = (double)(entity.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
            double d1 = (double)(entity.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
            double d2 = (double)(entity.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
            EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t + d, entity.field_70163_u + d1, entity.field_70161_v + d2, item);
            entityitem.field_145804_b = 2;
            entity.field_70170_p.func_72838_d((Entity)entityitem);
            int i = item.field_77994_a;
            if (player.field_71071_by.func_70441_a(item)) {
                entity.field_70170_p.func_72956_a((Entity)entityitem, "random.pop", 0.2f, ((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.func_71001_a((Entity)entityitem, i);
                if (item.field_77994_a <= 0) {
                    entityitem.func_70106_y();
                }
            }
        }
    }
}

