/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEditableBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.blocks.tiles.TileBigSign;
import noppes.npcs.blocks.tiles.TileBook;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.BankData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerFactionData;
import noppes.npcs.controllers.PlayerMail;
import noppes.npcs.controllers.PlayerMailData;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;

public class PacketHandlerPlayer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        ByteBuf buffer = event.packet.payload();
        try {
            this.player(buffer, player, EnumPlayerPacket.values()[buffer.readInt()]);
        }
        catch (IOException var5) {
            LogWriter.except(var5);
        }
    }

    private void player(ByteBuf buffer, EntityPlayerMP player, EnumPlayerPacket type) throws IOException {
        if (type == EnumPlayerPacket.CompanionTalentExp) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null || x.advanced.role != EnumRoleType.Companion || player != x.getOwner()) {
                return;
            }
            int y = buffer.readInt();
            int z = buffer.readInt();
            RoleCompanion tileentity = (RoleCompanion)x.roleInterface;
            if (z <= 0 || !tileentity.canAddExp(-z) || y < 0 || y >= EnumCompanionTalent.values().length) {
                return;
            }
            EnumCompanionTalent tile = EnumCompanionTalent.values()[y];
            tileentity.addExp(-z);
            tileentity.addTalentExp(tile, z);
        } else if (type == EnumPlayerPacket.CompanionOpenInv) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null || x.advanced.role != EnumRoleType.Companion || player != x.getOwner()) {
                return;
            }
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.CompanionInv, x);
        } else if (type == EnumPlayerPacket.FollowerHire) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null || x.advanced.role != EnumRoleType.Follower) {
                return;
            }
            NoppesUtilPlayer.hireFollower(player, x);
        } else if (type == EnumPlayerPacket.FollowerExtend) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null || x.advanced.role != EnumRoleType.Follower) {
                return;
            }
            NoppesUtilPlayer.extendFollower(player, x);
            Server.sendData(player, EnumPacketClient.GUI_DATA, x.roleInterface.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.FollowerState) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null || x.advanced.role != EnumRoleType.Follower) {
                return;
            }
            NoppesUtilPlayer.changeFollowerState(player, x);
            Server.sendData(player, EnumPacketClient.GUI_DATA, x.roleInterface.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.RoleGet) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null || x.advanced.role == EnumRoleType.None) {
                return;
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, x.roleInterface.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.Transport) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null || x.advanced.role != EnumRoleType.Transporter) {
                return;
            }
            NoppesUtilPlayer.transport(player, x, Server.readString(buffer));
        } else if (type == EnumPlayerPacket.BankUpgrade) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null || x.advanced.role != EnumRoleType.Bank) {
                return;
            }
            NoppesUtilPlayer.bankUpgrade(player, x);
        } else if (type == EnumPlayerPacket.BankUnlock) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null || x.advanced.role != EnumRoleType.Bank) {
                return;
            }
            NoppesUtilPlayer.bankUnlock(player, x);
        } else if (type == EnumPlayerPacket.BankSlotOpen) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null || x.advanced.role != EnumRoleType.Bank) {
                return;
            }
            int y = buffer.readInt();
            int z = buffer.readInt();
            BankData tileentity1 = PlayerDataController.instance.getBankData((EntityPlayer)player, z).getBankOrDefault(z);
            tileentity1.openBankGui((EntityPlayer)player, x, z, y);
        } else if (type == EnumPlayerPacket.Dialog) {
            EntityNPCInterface x = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (x == null) {
                return;
            }
            NoppesUtilPlayer.dialogSelected(buffer.readInt(), buffer.readInt(), player, x);
        } else if (type == EnumPlayerPacket.CheckQuestCompletion) {
            PlayerQuestData x1 = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
            x1.checkQuestCompletion((EntityPlayer)player, null);
        } else if (type == EnumPlayerPacket.QuestLog) {
            NoppesUtilPlayer.sendQuestLogData(player);
        } else if (type == EnumPlayerPacket.QuestCompletion) {
            NoppesUtilPlayer.questCompletion(player, buffer.readInt());
        } else if (type == EnumPlayerPacket.FactionsGet) {
            PlayerFactionData x2 = PlayerDataController.instance.getPlayerData((EntityPlayer)player).factionData;
            Server.sendData(player, EnumPacketClient.GUI_DATA, x2.getPlayerGuiData());
        } else if (type == EnumPlayerPacket.MailGet) {
            PlayerMailData x3 = PlayerDataController.instance.getPlayerData((EntityPlayer)player).mailData;
            Server.sendData(player, EnumPacketClient.GUI_DATA, x3.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailDelete) {
            long x4 = buffer.readLong();
            String z1 = Server.readString(buffer);
            PlayerMailData tileentity2 = PlayerDataController.instance.getPlayerData((EntityPlayer)player).mailData;
            Iterator tile1 = tileentity2.playermail.iterator();
            while (tile1.hasNext()) {
                PlayerMail sign = (PlayerMail)tile1.next();
                if (sign.time != x4 || !sign.sender.equals(z1)) continue;
                tile1.remove();
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, tileentity2.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailSend) {
            if (!(player.field_71070_bA instanceof ContainerMail)) {
                return;
            }
            String x5 = PlayerDataController.instance.hasPlayer(Server.readString(buffer));
            if (x5.isEmpty()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 0);
                return;
            }
            PlayerMail y1 = new PlayerMail();
            String z1 = player.getDisplayName();
            if (!z1.equals(player.func_70005_c_())) {
                z1 = z1 + "(" + player.func_70005_c_() + ")";
            }
            y1.readNBT(Server.readNBT(buffer));
            y1.sender = z1;
            y1.items = ((ContainerMail)player.field_71070_bA).mail.items;
            if (y1.subject.isEmpty()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 1);
                return;
            }
            PlayerDataController.instance.addPlayerMessage(x5, y1);
            NBTTagCompound tileentity3 = new NBTTagCompound();
            tileentity3.func_74778_a("username", x5);
            NoppesUtilServer.sendGuiClose(player, 1, tileentity3);
        } else if (type == EnumPlayerPacket.MailboxOpenMail) {
            long x4 = buffer.readLong();
            String z1 = Server.readString(buffer);
            player.func_71128_l();
            PlayerMailData tileentity2 = PlayerDataController.instance.getPlayerData((EntityPlayer)player).mailData;
            for (PlayerMail sign : tileentity2.playermail) {
                if (sign.time != x4 || !sign.sender.equals(z1)) continue;
                ContainerMail.staticmail = sign;
                player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailman.ordinal(), player.field_70170_p, 0, 0, 0);
                break;
            }
        } else if (type == EnumPlayerPacket.MailRead) {
            long x4 = buffer.readLong();
            String z1 = Server.readString(buffer);
            PlayerMailData tileentity2 = PlayerDataController.instance.getPlayerData((EntityPlayer)player).mailData;
            for (PlayerMail sign : tileentity2.playermail) {
                if (sign.time != x4 || !sign.sender.equals(z1)) continue;
                sign.beenRead = true;
                if (!sign.hasQuest()) continue;
                PlayerQuestController.addActiveQuest(sign.getQuest(), (EntityPlayer)player);
            }
        } else if (type == EnumPlayerPacket.SignSave) {
            int z;
            int y;
            int x6 = buffer.readInt();
            TileEntity tileentity4 = player.field_70170_p.func_147438_o(x6, y = buffer.readInt(), z = buffer.readInt());
            if (tileentity4 == null || !(tileentity4 instanceof TileBigSign)) {
                return;
            }
            TileBigSign tile2 = (TileBigSign)tileentity4;
            if (tile2.canEdit) {
                tile2.setText(Server.readString(buffer));
                tile2.canEdit = false;
                player.field_70170_p.func_147471_g(x6, y, z);
            }
        } else if (type == EnumPlayerPacket.SaveBook) {
            int z;
            int y;
            int x6 = buffer.readInt();
            TileEntity tileentity4 = player.field_70170_p.func_147438_o(x6, y = buffer.readInt(), z = buffer.readInt());
            if (!(tileentity4 instanceof TileBook)) {
                return;
            }
            TileBook tile3 = (TileBook)tileentity4;
            if (tile3.book.func_77973_b() == Items.field_151164_bB) {
                return;
            }
            boolean sign1 = buffer.readBoolean();
            ItemStack book = ItemStack.func_77949_a((NBTTagCompound)Server.readNBT(buffer));
            if (book == null) {
                return;
            }
            if (book.func_77973_b() == Items.field_151099_bA && !sign1 && ItemWritableBook.func_150930_a((NBTTagCompound)book.func_77978_p())) {
                tile3.book.func_77983_a("pages", (NBTBase)book.func_77978_p().func_150295_c("pages", 8));
            }
            if (book.func_77973_b() == Items.field_151164_bB && sign1 && ItemEditableBook.func_77828_a((NBTTagCompound)book.func_77978_p())) {
                tile3.book.func_77983_a("author", (NBTBase)new NBTTagString(player.func_70005_c_()));
                tile3.book.func_77983_a("title", (NBTBase)new NBTTagString(book.func_77978_p().func_74779_i("title")));
                tile3.book.func_77983_a("pages", (NBTBase)book.func_77978_p().func_150295_c("pages", 8));
                tile3.book.func_150996_a(Items.field_151164_bB);
            }
        }
    }
}

