/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import foxz.utils.Market;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.constants.EnumCompanionStage;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumJobType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogCategory;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.Faction;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerMail;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestCategory;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.SpawnData;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.TransportLocation;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobSpawner;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.roles.RoleTransporter;

public class PacketHandlerServer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        if (CustomNpcs.OpsOnly && !NoppesUtilServer.isOp((EntityPlayer)player)) {
            this.warn((EntityPlayer)player, "tried to use custom npcs without being an op");
        } else {
            ByteBuf buffer = event.packet.payload();
            try {
                EnumPacketServer e = EnumPacketServer.values()[buffer.readInt()];
                ItemStack item = player.field_71071_by.func_70448_g();
                EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                if (!e.needsNpc || npc != null) {
                    if (e.hasPermission()) {
                        CustomNpcsPermissions var10000 = CustomNpcsPermissions.Instance;
                        if (!CustomNpcsPermissions.hasPermission((EntityPlayer)player, e.permission)) {
                            return;
                        }
                    }
                    if (item == null) {
                        this.warn((EntityPlayer)player, "tried to use custom npcs without a tool in hand, probably a hacker");
                    } else if (item.func_77973_b() == CustomItems.wand) {
                        this.wandPackets(e, buffer, player, npc);
                    } else if (item.func_77973_b() == CustomItems.moving) {
                        this.movingPackets(e, buffer, player, npc);
                    } else if (item.func_77973_b() == CustomItems.mount) {
                        this.mountPackets(e, buffer, player);
                    } else if (item.func_77973_b() == CustomItems.cloner) {
                        this.clonePackets(e, buffer, player);
                    } else if (item.func_77973_b() == CustomItems.teleporter) {
                        this.featherPackets(e, buffer, player);
                    } else if (item.func_77973_b() == CustomItems.scripter) {
                        this.scriptPackets(e, buffer, player, npc);
                    } else if (item.func_77973_b() == Item.func_150898_a((Block)CustomItems.waypoint) || item.func_77973_b() == Item.func_150898_a((Block)CustomItems.border) || item.func_77973_b() == Item.func_150898_a((Block)CustomItems.redstoneBlock)) {
                        this.blockPackets(e, buffer, player);
                    }
                }
            }
            catch (IOException var7) {
                var7.printStackTrace();
            }
        }
    }

    private void scriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws IOException {
        if (type == EnumPacketServer.ScriptDataSave) {
            npc.script.readFromNBT(Server.readNBT(buffer));
            npc.updateTasks();
            npc.script.hasInited = false;
        } else if (type == EnumPacketServer.ScriptDataGet) {
            NBTTagCompound compound = npc.script.writeToNBT(new NBTTagCompound());
            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        }
    }

    private void featherPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.DimensionsGet) {
            HashMap<String, Integer> dimension = new HashMap<String, Integer>();
            Integer[] world = DimensionManager.getStaticDimensionIDs();
            int coords = world.length;
            for (int var7 = 0; var7 < coords; ++var7) {
                int id = world[var7];
                WorldProvider provider = DimensionManager.createProviderFor((int)id);
                dimension.put(provider.func_80007_l(), id);
            }
            NoppesUtilServer.sendScrollData(player, dimension);
        } else if (type == EnumPacketServer.DimensionTeleport) {
            int var10 = buffer.readInt();
            WorldServer var11 = MinecraftServer.func_71276_C().func_71218_a(var10);
            ChunkCoordinates var12 = var11.func_73054_j();
            if (var12 == null) {
                var12 = var11.func_72861_E();
                if (!var11.func_147437_c(var12.field_71574_a, var12.field_71572_b, var12.field_71573_c)) {
                    var12.field_71572_b = var11.func_72825_h(var12.field_71574_a, var12.field_71573_c);
                } else {
                    while (var11.func_147437_c(var12.field_71574_a, var12.field_71572_b - 1, var12.field_71573_c) && var12.field_71572_b > 0) {
                        --var12.field_71572_b;
                    }
                    if (var12.field_71572_b == 0) {
                        var12.field_71572_b = var11.func_72825_h(var12.field_71574_a, var12.field_71573_c);
                    }
                }
            }
            NoppesUtilPlayer.teleportPlayer(player, var12.field_71574_a, var12.field_71572_b, var12.field_71573_c, var10);
        }
    }

    private void movingPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws IOException {
        if (type == EnumPacketServer.MovingPathGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.ai.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MovingPathSave) {
            npc.ai.setMovingPath(NBTTags.getIntegerArraySet(Server.readNBT(buffer).func_150295_c("MovingPathNew", 10)));
        }
    }

    private void blockPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SaveTileEntity) {
            NoppesUtilServer.saveTileEntity(player, Server.readNBT(buffer));
        } else if (type == EnumPacketServer.GetTileEntity) {
            TileEntity compound = player.field_70170_p.func_147438_o(buffer.readInt(), buffer.readInt(), buffer.readInt());
            NBTTagCompound faction = new NBTTagCompound();
            compound.func_145841_b(faction);
            Server.sendData(player, EnumPacketClient.GUI_DATA, faction);
        } else if (type == EnumPacketServer.DialogCategoriesGet) {
            NoppesUtilServer.sendScrollData(player, DialogController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogsGetFromDialog) {
            Dialog compound1 = (Dialog)DialogController.instance.dialogs.get(buffer.readInt());
            if (compound1 == null) {
                return;
            }
            NoppesUtilServer.sendDialogData(player, compound1.category);
        } else if (type == EnumPacketServer.DialogsGet) {
            NoppesUtilServer.sendDialogData(player, (DialogCategory)DialogController.instance.categories.get(buffer.readInt()));
        } else if (type == EnumPacketServer.QuestsGetFromQuest) {
            Quest compound2 = (Quest)QuestController.instance.quests.get(buffer.readInt());
            if (compound2 == null) {
                return;
            }
            NoppesUtilServer.sendQuestData(player, compound2.category);
        } else if (type == EnumPacketServer.QuestCategoriesGet) {
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestsGet) {
            QuestCategory compound3 = (QuestCategory)QuestController.instance.categories.get(buffer.readInt());
            NoppesUtilServer.sendQuestData(player, compound3);
        } else if (type == EnumPacketServer.FactionsGet) {
            NoppesUtilServer.sendFactionDataAll(player);
        } else if (type == EnumPacketServer.DialogGet) {
            Dialog compound1 = (Dialog)DialogController.instance.dialogs.get(buffer.readInt());
            if (compound1 != null) {
                NBTTagCompound faction = compound1.writeToNBT(new NBTTagCompound());
                Quest quest = (Quest)QuestController.instance.quests.get(compound1.quest);
                if (quest != null) {
                    faction.func_74778_a("DialogQuestName", quest.title);
                }
                Server.sendData(player, EnumPacketClient.GUI_DATA, faction);
            }
        } else if (type == EnumPacketServer.QuestGet) {
            Quest compound2 = (Quest)QuestController.instance.quests.get(buffer.readInt());
            if (compound2 != null) {
                NBTTagCompound faction = new NBTTagCompound();
                if (compound2.hasNewQuest()) {
                    faction.func_74778_a("NextQuestTitle", compound2.getNextQuest().title);
                }
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound2.writeToNBT(faction));
            }
        } else if (type == EnumPacketServer.FactionGet) {
            NBTTagCompound compound4 = new NBTTagCompound();
            Faction faction1 = FactionController.getInstance().getFaction(buffer.readInt());
            faction1.writeNBT(compound4);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound4);
        }
    }

    private void wandPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws IOException {
        if (type == EnumPacketServer.Delete) {
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
        } else if (type == EnumPacketServer.LinkedAdd) {
            LinkedNpcController.Instance.addData(Server.readString(buffer));
            ArrayList<String> market = new ArrayList<String>();
            for (LinkedNpcController.LinkedData names : LinkedNpcController.Instance.list) {
                market.add(names.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, market);
        } else if (type == EnumPacketServer.LinkedRemove) {
            LinkedNpcController.Instance.removeData(Server.readString(buffer));
            ArrayList<String> market = new ArrayList<String>();
            for (LinkedNpcController.LinkedData names : LinkedNpcController.Instance.list) {
                market.add(names.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, market);
        } else if (type == EnumPacketServer.LinkedGetAll) {
            ArrayList<String> market = new ArrayList<String>();
            for (LinkedNpcController.LinkedData names : LinkedNpcController.Instance.list) {
                market.add(names.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, market);
            if (npc != null) {
                Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, npc.linkedName);
            }
        } else if (type == EnumPacketServer.LinkedSet) {
            npc.linkedName = Server.readString(buffer);
            LinkedNpcController.Instance.loadNpcData(npc);
        } else if (type == EnumPacketServer.NpcMenuClose) {
            npc.reset();
            if (npc.linkedData != null) {
                LinkedNpcController.Instance.saveNpcData(npc);
            }
            NoppesUtilServer.setEditingNpc((EntityPlayer)player, null);
        } else if (type == EnumPacketServer.BanksGet) {
            NoppesUtilServer.sendBankDataAll(player);
        } else if (type == EnumPacketServer.BankGet) {
            Bank market1 = BankController.getInstance().getBank(buffer.readInt());
            NoppesUtilServer.sendBank(player, market1);
        } else if (type == EnumPacketServer.BankSave) {
            Bank market1 = new Bank();
            market1.readEntityFromNBT(Server.readNBT(buffer));
            BankController.getInstance().saveBank(market1);
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, market1);
        } else if (type == EnumPacketServer.BankRemove) {
            BankController.getInstance().removeBank(buffer.readInt());
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, new Bank());
        } else if (type == EnumPacketServer.RemoteMainMenu) {
            Entity market2 = player.field_70170_p.func_73045_a(buffer.readInt());
            if (market2 == null || !(market2 instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)market2);
        } else if (type == EnumPacketServer.RemoteDelete) {
            Entity market2 = player.field_70170_p.func_73045_a(buffer.readInt());
            if (market2 == null || !(market2 instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)market2;
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
            NoppesUtilServer.sendNearbyNpcs(player);
        } else if (type == EnumPacketServer.RemoteNpcsGet) {
            NoppesUtilServer.sendNearbyNpcs(player);
            Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, CustomNpcs.FreezeNPCs ? "Unfreeze Npcs" : "Freeze Npcs");
        } else if (type == EnumPacketServer.RemoteFreeze) {
            CustomNpcs.FreezeNPCs = !CustomNpcs.FreezeNPCs;
            Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, CustomNpcs.FreezeNPCs ? "Unfreeze Npcs" : "Freeze Npcs");
        } else if (type == EnumPacketServer.RemoteReset) {
            Entity market2 = player.field_70170_p.func_73045_a(buffer.readInt());
            if (market2 == null || !(market2 instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)market2;
            npc.reset();
        } else if (type == EnumPacketServer.RemoteTpToNpc) {
            Entity market2 = player.field_70170_p.func_73045_a(buffer.readInt());
            if (market2 == null || !(market2 instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)market2;
            player.field_71135_a.func_147364_a(npc.field_70165_t, npc.field_70163_u, npc.field_70161_v, 0.0f, 0.0f);
        } else if (type == EnumPacketServer.Gui) {
            EnumGuiType market3 = EnumGuiType.values()[buffer.readInt()];
            int bo1 = buffer.readInt();
            int names1 = buffer.readInt();
            int compound = buffer.readInt();
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, market3, npc, bo1, names1, compound);
        } else if (type == EnumPacketServer.RecipesGet) {
            NoppesUtilServer.sendRecipeData(player, buffer.readInt());
        } else if (type == EnumPacketServer.RecipeGet) {
            RecipeCarpentry market4 = RecipeController.instance.getRecipe(buffer.readInt());
            NoppesUtilServer.setRecipeGui(player, market4);
        } else if (type == EnumPacketServer.RecipeRemove) {
            RecipeCarpentry market4 = RecipeController.instance.removeRecipe(buffer.readInt());
            NoppesUtilServer.sendRecipeData(player, market4.isGlobal ? 3 : 4);
            NoppesUtilServer.setRecipeGui(player, new RecipeCarpentry(""));
        } else if (type == EnumPacketServer.RecipeSave) {
            RecipeCarpentry market4 = RecipeController.instance.saveRecipe(Server.readNBT(buffer));
            NoppesUtilServer.sendRecipeData(player, market4.isGlobal ? 3 : 4);
            NoppesUtilServer.setRecipeGui(player, market4);
        } else if (type == EnumPacketServer.NaturalSpawnGetAll) {
            NoppesUtilServer.sendScrollData(player, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.NaturalSpawnGet) {
            SpawnData market5 = SpawnController.instance.getSpawnData(buffer.readInt());
            if (market5 != null) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, market5.writeNBT(new NBTTagCompound()));
            }
        } else if (type == EnumPacketServer.NaturalSpawnSave) {
            SpawnData market5 = new SpawnData();
            market5.readNBT(Server.readNBT(buffer));
            SpawnController.instance.saveSpawnData(market5);
            NoppesUtilServer.sendScrollData(player, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.NaturalSpawnRemove) {
            SpawnController.instance.removeSpawnData(buffer.readInt());
            NoppesUtilServer.sendScrollData(player, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategorySave) {
            DialogCategory market6 = new DialogCategory();
            market6.readNBT(Server.readNBT(buffer));
            DialogController.instance.saveCategory(market6);
            NoppesUtilServer.sendScrollData(player, DialogController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategoryRemove) {
            DialogController.instance.removeCategory(buffer.readInt());
            NoppesUtilServer.sendScrollData(player, DialogController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategoryGet) {
            DialogCategory market6 = (DialogCategory)DialogController.instance.categories.get(buffer.readInt());
            if (market6 != null) {
                NBTTagCompound bo2 = market6.writeNBT(new NBTTagCompound());
                bo2.func_82580_o("Dialogs");
                Server.sendData(player, EnumPacketClient.GUI_DATA, bo2);
            }
        } else if (type == EnumPacketServer.DialogSave) {
            int market7 = buffer.readInt();
            Dialog bo3 = new Dialog();
            bo3.readNBT(Server.readNBT(buffer));
            DialogController.instance.saveDialog(market7, bo3);
            if (bo3.category != null) {
                NoppesUtilServer.sendDialogData(player, bo3.category);
            }
        } else if (type == EnumPacketServer.QuestOpenGui) {
            Quest market8 = new Quest();
            int bo1 = buffer.readInt();
            market8.readNBT(Server.readNBT(buffer));
            NoppesUtilServer.setEditingQuest((EntityPlayer)player, market8);
            player.openGui((Object)CustomNpcs.instance, bo1, player.field_70170_p, 0, 0, 0);
        } else if (type == EnumPacketServer.DialogRemove) {
            Dialog market9 = (Dialog)DialogController.instance.dialogs.get(buffer.readInt());
            if (market9 != null && market9.category != null) {
                DialogController.instance.removeDialog(market9);
                NoppesUtilServer.sendDialogData(player, market9.category);
            }
        } else if (type == EnumPacketServer.DialogNpcGet) {
            NoppesUtilServer.sendNpcDialogs((EntityPlayer)player);
        } else if (type == EnumPacketServer.DialogNpcSet) {
            int bo1;
            int market7 = buffer.readInt();
            DialogOption names2 = NoppesUtilServer.setNpcDialog(market7, bo1 = buffer.readInt(), (EntityPlayer)player);
            if (names2 != null && names2.hasDialog()) {
                NBTTagCompound compound1 = names2.writeNBT();
                compound1.func_74768_a("Position", market7);
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound1);
            }
        } else if (type == EnumPacketServer.DialogNpcRemove) {
            npc.dialogs.remove(buffer.readInt());
        } else if (type == EnumPacketServer.QuestCategoryGet) {
            QuestCategory market10 = (QuestCategory)QuestController.instance.categories.get(buffer.readInt());
            if (market10 != null) {
                NBTTagCompound bo2 = market10.writeNBT(new NBTTagCompound());
                bo2.func_82580_o("Dialogs");
                Server.sendData(player, EnumPacketClient.GUI_DATA, bo2);
            }
        } else if (type == EnumPacketServer.QuestCategorySave) {
            QuestCategory market10 = new QuestCategory();
            market10.readNBT(Server.readNBT(buffer));
            QuestController.instance.saveCategory(market10);
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestCategoryRemove) {
            QuestController.instance.removeCategory(buffer.readInt());
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestSave) {
            int market7 = buffer.readInt();
            Quest bo4 = new Quest();
            bo4.readNBT(Server.readNBT(buffer));
            QuestController.instance.saveQuest(market7, bo4);
            if (bo4.category != null) {
                NoppesUtilServer.sendQuestData(player, bo4.category);
            }
        } else if (type == EnumPacketServer.QuestDialogGetTitle) {
            Dialog market9 = (Dialog)DialogController.instance.dialogs.get(buffer.readInt());
            Dialog bo3 = (Dialog)DialogController.instance.dialogs.get(buffer.readInt());
            Dialog names3 = (Dialog)DialogController.instance.dialogs.get(buffer.readInt());
            NBTTagCompound compound1 = new NBTTagCompound();
            if (market9 != null) {
                compound1.func_74778_a("1", market9.title);
            }
            if (bo3 != null) {
                compound1.func_74778_a("2", bo3.title);
            }
            if (names3 != null) {
                compound1.func_74778_a("3", names3.title);
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound1);
        } else if (type == EnumPacketServer.QuestRemove) {
            Quest market8 = (Quest)QuestController.instance.quests.get(buffer.readInt());
            if (market8 != null) {
                QuestController.instance.removeQuest(market8);
                NoppesUtilServer.sendQuestData(player, market8.category);
            }
        } else if (type == EnumPacketServer.TransportCategoriesGet) {
            NoppesUtilServer.sendTransportCategoryData(player);
        } else if (type == EnumPacketServer.TransportCategorySave) {
            TransportController.getInstance().saveCategory(Server.readString(buffer), buffer.readInt());
        } else if (type == EnumPacketServer.TransportCategoryRemove) {
            TransportController.getInstance().removeCategory(buffer.readInt());
            NoppesUtilServer.sendTransportCategoryData(player);
        } else if (type == EnumPacketServer.TransportRemove) {
            int market7 = buffer.readInt();
            TransportLocation bo5 = TransportController.getInstance().removeLocation(market7);
            if (bo5 != null) {
                NoppesUtilServer.sendTransportData(player, bo5.category.id);
            }
        } else if (type == EnumPacketServer.TransportsGet) {
            NoppesUtilServer.sendTransportData(player, buffer.readInt());
        } else if (type == EnumPacketServer.TransportSave) {
            int market7 = buffer.readInt();
            TransportLocation bo5 = TransportController.getInstance().saveLocation(market7, Server.readNBT(buffer), player, npc);
            if (bo5 != null) {
                if (npc.advanced.role != EnumRoleType.Transporter) {
                    return;
                }
                RoleTransporter names4 = (RoleTransporter)npc.roleInterface;
                names4.setTransport(bo5);
            }
        } else if (type == EnumPacketServer.TransportGetLocation) {
            if (npc.advanced.role != EnumRoleType.Transporter) {
                return;
            }
            RoleTransporter market11 = (RoleTransporter)npc.roleInterface;
            if (market11.hasTransport()) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, market11.getLocation().writeNBT());
                Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, market11.getLocation().category.title);
            }
        } else if (type == EnumPacketServer.FactionSet) {
            npc.setFaction(buffer.readInt());
        } else if (type == EnumPacketServer.FactionSave) {
            Faction market12 = new Faction();
            market12.readNBT(Server.readNBT(buffer));
            FactionController.getInstance().saveFaction(market12);
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound bo2 = new NBTTagCompound();
            market12.writeNBT(bo2);
            Server.sendData(player, EnumPacketClient.GUI_DATA, bo2);
        } else if (type == EnumPacketServer.FactionRemove) {
            FactionController.getInstance().removeFaction(buffer.readInt());
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound market13 = new NBTTagCompound();
            new Faction().writeNBT(market13);
            Server.sendData(player, EnumPacketClient.GUI_DATA, market13);
        } else if (type == EnumPacketServer.PlayerDataGet) {
            int market7 = buffer.readInt();
            if (EnumPlayerData.values().length <= market7) {
                return;
            }
            String bo6 = null;
            EnumPlayerData names5 = EnumPlayerData.values()[market7];
            if (names5 != EnumPlayerData.Players) {
                bo6 = Server.readString(buffer);
            }
            NoppesUtilServer.sendPlayerData(names5, player, bo6);
        } else if (type == EnumPacketServer.PlayerDataRemove) {
            NoppesUtilServer.removePlayerData(buffer, player);
        } else if (type == EnumPacketServer.MainmenuDisplayGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.display.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuDisplaySave) {
            npc.display.readToNBT(Server.readNBT(buffer));
            NBTTagCompound market13 = npc.writeSpawnData();
            market13.func_74768_a("EntityId", npc.func_145782_y());
            Server.sendAssociatedData((Entity)npc, EnumPacketClient.UPDATE_NPC, market13);
        } else if (type == EnumPacketServer.MainmenuStatsGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.stats.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuStatsSave) {
            npc.stats.readToNBT(Server.readNBT(buffer));
            NBTTagCompound market13 = npc.writeSpawnData();
            market13.func_74768_a("EntityId", npc.func_145782_y());
            Server.sendAssociatedData((Entity)npc, EnumPacketClient.UPDATE_NPC, market13);
        } else if (type == EnumPacketServer.MainmenuInvGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.inventory.writeEntityToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuInvSave) {
            npc.inventory.readEntityFromNBT(Server.readNBT(buffer));
            npc.updateTasks();
            NoppesUtilServer.updateNpc(npc);
        } else if (type == EnumPacketServer.MainmenuAIGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.ai.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAISave) {
            npc.ai.readToNBT(Server.readNBT(buffer));
            npc.updateTasks();
            NBTTagCompound market13 = npc.writeSpawnData();
            market13.func_74768_a("EntityId", npc.func_145782_y());
            npc.func_70606_j(npc.func_110138_aP());
            Server.sendAssociatedData((Entity)npc, EnumPacketClient.UPDATE_NPC, market13);
        } else if (type == EnumPacketServer.MainmenuAdvancedGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.advanced.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAdvancedSave) {
            npc.advanced.readToNBT(Server.readNBT(buffer));
            npc.updateTasks();
            NoppesUtilServer.updateNpc(npc);
        } else if (type == EnumPacketServer.JobSave) {
            NBTTagCompound market13 = npc.jobInterface.writeToNBT(new NBTTagCompound());
            NBTTagCompound bo2 = Server.readNBT(buffer);
            Set names6 = bo2.func_150296_c();
            for (String name : names6) {
                market13.func_74782_a(name, bo2.func_74781_a(name));
            }
            npc.jobInterface.readFromNBT(market13);
            NoppesUtilServer.updateNpc(npc);
        } else if (type == EnumPacketServer.JobGet) {
            if (npc.jobInterface == null) {
                return;
            }
            NBTTagCompound market13 = new NBTTagCompound();
            market13.func_74757_a("JobData", true);
            npc.jobInterface.writeToNBT(market13);
            if (npc.advanced.job == EnumJobType.Spawner) {
                ((JobSpawner)npc.jobInterface).cleanCompound(market13);
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, market13);
            if (npc.advanced.job == EnumJobType.Spawner) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, ((JobSpawner)npc.jobInterface).getTitles());
            }
        } else if (type == EnumPacketServer.JobSpawnerAdd) {
            if (npc.advanced.job != EnumJobType.Spawner) {
                return;
            }
            JobSpawner market14 = (JobSpawner)npc.jobInterface;
            if (buffer.readBoolean()) {
                NBTTagCompound bo2 = ServerCloneController.Instance.getCloneData(null, Server.readString(buffer), buffer.readInt());
                market14.setJobCompound(buffer.readInt(), bo2);
            } else {
                market14.setJobCompound(buffer.readInt(), Server.readNBT(buffer));
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, market14.getTitles());
        } else if (type == EnumPacketServer.RoleCompanionUpdate) {
            if (npc.advanced.role != EnumRoleType.Companion) {
                return;
            }
            ((RoleCompanion)npc.roleInterface).matureTo(EnumCompanionStage.values()[buffer.readInt()]);
            NoppesUtilServer.updateNpc(npc);
        } else if (type == EnumPacketServer.JobSpawnerRemove) {
            if (npc.advanced.job != EnumJobType.Spawner) {
                return;
            }
        } else if (type == EnumPacketServer.RoleSave) {
            npc.roleInterface.readFromNBT(Server.readNBT(buffer));
            NoppesUtilServer.updateNpc(npc);
        } else if (type == EnumPacketServer.RoleGet) {
            if (npc.roleInterface == null) {
                return;
            }
            NBTTagCompound market13 = new NBTTagCompound();
            market13.func_74757_a("RoleData", true);
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(market13));
        } else if (type == EnumPacketServer.MerchantUpdate) {
            Entity market2 = player.field_70170_p.func_73045_a(buffer.readInt());
            if (market2 == null || !(market2 instanceof EntityVillager)) {
                return;
            }
            MerchantRecipeList bo7 = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buffer));
            ((EntityVillager)market2).func_70930_a(bo7);
        } else if (type == EnumPacketServer.ModelDataSave) {
            if (npc instanceof EntityCustomNpc) {
                ((EntityCustomNpc)npc).modelData.readFromNBT(Server.readNBT(buffer));
            }
        } else if (type == EnumPacketServer.MailOpenSetup) {
            PlayerMail market15 = new PlayerMail();
            market15.readNBT(Server.readNBT(buffer));
            ContainerMail.staticmail = market15;
            player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailman.ordinal(), player.field_70170_p, 1, 0, 0);
        } else if (type == EnumPacketServer.TransformSave) {
            boolean market16 = npc.transform.isValid();
            npc.transform.readOptions(Server.readNBT(buffer));
            if (market16 != npc.transform.isValid()) {
                npc.updateTasks();
            }
        } else if (type == EnumPacketServer.TransformGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.transform.writeOptions(new NBTTagCompound()));
        } else if (type == EnumPacketServer.TransformLoad) {
            if (npc.transform.isValid()) {
                npc.transform.transform(buffer.readBoolean());
            }
        } else if (type == EnumPacketServer.TraderMarketSave) {
            String market17 = Server.readString(buffer);
            boolean bo8 = buffer.readBoolean();
            if (npc.roleInterface instanceof RoleTrader) {
                if (bo8) {
                    Market.setMarket(npc, market17);
                } else {
                    Market.save((RoleTrader)npc.roleInterface, market17);
                }
            }
        } else {
            this.blockPackets(type, buffer, player);
        }
    }

    private void mountPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SpawnRider) {
            Entity list = EntityList.func_75615_a((NBTTagCompound)Server.readNBT(buffer), (World)player.field_70170_p);
            player.field_70170_p.func_72838_d(list);
            list.func_70078_a(ServerEventsHandler.mounted);
        } else if (type == EnumPacketServer.PlayerRider) {
            player.func_70078_a(ServerEventsHandler.mounted);
        } else if (type == EnumPacketServer.CloneList) {
            NBTTagList list1 = new NBTTagList();
            for (String name : ServerCloneController.Instance.getClones(buffer.readInt())) {
                list1.func_74742_a((NBTBase)new NBTTagString(name));
            }
            NBTTagCompound compound1 = new NBTTagCompound();
            compound1.func_74782_a("List", (NBTBase)list1);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound1);
        } else {
            this.warn((EntityPlayer)player, "tried todo something with the wrong tool, probably a hacker");
        }
    }

    private void clonePackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SpawnMob) {
            boolean list = buffer.readBoolean();
            int compound = buffer.readInt();
            int name = buffer.readInt();
            int name1 = buffer.readInt();
            NBTTagCompound compound1 = list ? ServerCloneController.Instance.getCloneData((ICommandSender)player, Server.readString(buffer), buffer.readInt()) : Server.readNBT(buffer);
            if (compound1 == null) {
                return;
            }
            Entity entity = NoppesUtilServer.spawnClone(compound1, compound, name, name1, player.field_70170_p);
            if (entity == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Failed to create an entity out of your clone"));
                return;
            }
        } else if (type == EnumPacketServer.MobSpawner) {
            boolean list = buffer.readBoolean();
            int compound = buffer.readInt();
            int name = buffer.readInt();
            int name1 = buffer.readInt();
            NBTTagCompound compound1 = list ? ServerCloneController.Instance.getCloneData((ICommandSender)player, Server.readString(buffer), buffer.readInt()) : Server.readNBT(buffer);
            if (compound1 != null) {
                NoppesUtilServer.createMobSpawner(compound, name, name1, compound1, (EntityPlayer)player);
            }
        } else if (type == EnumPacketServer.ClonePreSave) {
            boolean list = ServerCloneController.Instance.getCloneData(null, Server.readString(buffer), buffer.readInt()) != null;
            NBTTagCompound compound2 = new NBTTagCompound();
            compound2.func_74757_a("NameExists", list);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound2);
        } else if (type == EnumPacketServer.CloneSave) {
            PlayerData list1 = PlayerDataController.instance.getPlayerData((EntityPlayer)player);
            if (list1.cloned == null) {
                return;
            }
            ServerCloneController.Instance.addClone(list1.cloned, Server.readString(buffer), buffer.readInt());
        } else if (type == EnumPacketServer.CloneRemove) {
            int list2 = buffer.readInt();
            ServerCloneController.Instance.removeClone(Server.readString(buffer), list2);
            NBTTagList compound3 = new NBTTagList();
            for (String name5 : ServerCloneController.Instance.getClones(list2)) {
                compound3.func_74742_a((NBTBase)new NBTTagString(name5));
            }
            NBTTagCompound name3 = new NBTTagCompound();
            name3.func_74782_a("List", (NBTBase)compound3);
            Server.sendData(player, EnumPacketClient.GUI_DATA, name3);
        } else if (type == EnumPacketServer.CloneList) {
            NBTTagList list3 = new NBTTagList();
            for (String name4 : ServerCloneController.Instance.getClones(buffer.readInt())) {
                list3.func_74742_a((NBTBase)new NBTTagString(name4));
            }
            NBTTagCompound compound2 = new NBTTagCompound();
            compound2.func_74782_a("List", (NBTBase)list3);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound2);
        } else {
            this.warn((EntityPlayer)player, "tried todo something with the wrong tool, probably a hacker");
        }
    }

    private void warn(EntityPlayer player, String warning) {
        MinecraftServer.func_71276_C().func_71236_h(player.func_70005_c_() + ": " + warning);
    }
}

