/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player.companion;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiMenuTopIconButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.constants.EnumCompanionJobs;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;

public class GuiNpcCompanionStats
extends GuiNPCInterface
implements IGuiData {
    private RoleCompanion role;
    private boolean isEating = false;

    public GuiNpcCompanionStats(EntityNPCInterface npc) {
        super(npc);
        this.role = (RoleCompanion)npc.roleInterface;
        this.closeOnEsc = true;
        this.setBackground("companion.png");
        this.xSize = 171;
        this.ySize = 166;
        NoppesUtilPlayer.sendData(EnumPlayerPacket.RoleGet, new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int y = this.guiTop + 10;
        this.addLabel(new GuiNpcLabel(0, NoppesStringUtils.translate("gui.name", ": ", this.npc.display.name), this.guiLeft + 4, y));
        String var10004 = NoppesStringUtils.translate("companion.owner", ": ", this.role.ownerName);
        int var10005 = this.guiLeft + 4;
        GuiNpcLabel var10001 = new GuiNpcLabel(1, var10004, var10005, y += 12);
        this.addLabel(var10001);
        var10004 = NoppesStringUtils.translate("companion.age", ": ", this.role.ticksActive / 18000L + " (", this.role.stage.name, ")");
        var10005 = this.guiLeft + 4;
        var10001 = new GuiNpcLabel(2, var10004, var10005, y += 12);
        this.addLabel(var10001);
        var10004 = NoppesStringUtils.translate("companion.strength", ": ", this.npc.stats.getAttackStrength());
        var10005 = this.guiLeft + 4;
        var10001 = new GuiNpcLabel(3, var10004, var10005, y += 12);
        this.addLabel(var10001);
        var10004 = NoppesStringUtils.translate("companion.level", ": ", this.role.getTotalLevel());
        var10005 = this.guiLeft + 4;
        var10001 = new GuiNpcLabel(4, var10004, var10005, y += 12);
        this.addLabel(var10001);
        var10004 = NoppesStringUtils.translate("job.name", ": ", "gui.none");
        var10005 = this.guiLeft + 4;
        var10001 = new GuiNpcLabel(5, var10004, var10005, y += 12);
        this.addLabel(var10001);
        GuiNpcCompanionStats.addTopMenu(this.role, this, 1);
    }

    public static void addTopMenu(RoleCompanion role, GuiScreen screen, int active) {
        GuiMenuTopIconButton button;
        if (screen instanceof GuiNPCInterface) {
            GuiNPCInterface gui = (GuiNPCInterface)screen;
            button = new GuiMenuTopIconButton(1, gui.guiLeft + 4, gui.guiTop - 27, "menu.stats", new ItemStack(CustomItems.letter));
            gui.addTopButton(button);
            button = new GuiMenuTopIconButton(2, (GuiButton)button, "companion.talent", new ItemStack(CustomItems.spellHoly));
            gui.addTopButton(button);
            if (role.hasInv()) {
                button = new GuiMenuTopIconButton(3, (GuiButton)button, "inv.inventory", new ItemStack(CustomItems.bag));
                gui.addTopButton(button);
            }
            if (role.job != EnumCompanionJobs.NONE) {
                gui.addTopButton(new GuiMenuTopIconButton(4, (GuiButton)button, "job.name", new ItemStack(CustomItems.bag)));
            }
            gui.getTopButton((int)active).active = true;
        }
        if (screen instanceof GuiContainerNPCInterface) {
            GuiContainerNPCInterface gui1 = (GuiContainerNPCInterface)screen;
            button = new GuiMenuTopIconButton(1, gui1.field_147003_i + 4, gui1.field_147009_r - 27, "menu.stats", new ItemStack(CustomItems.letter));
            gui1.addTopButton(button);
            button = new GuiMenuTopIconButton(2, (GuiButton)button, "companion.talent", new ItemStack(CustomItems.spellHoly));
            gui1.addTopButton(button);
            if (role.hasInv()) {
                button = new GuiMenuTopIconButton(3, (GuiButton)button, "inv.inventory", new ItemStack(CustomItems.bag));
                gui1.addTopButton(button);
            }
            if (role.job != EnumCompanionJobs.NONE) {
                gui1.addTopButton(new GuiMenuTopIconButton(4, (GuiButton)button, "job.name", new ItemStack(CustomItems.bag)));
            }
            gui1.getTopButton((int)active).active = true;
        }
    }

    @Override
    public void func_146284_a(GuiButton guibutton) {
        super.func_146284_a(guibutton);
        int id = guibutton.field_146127_k;
        if (id == 2) {
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.CompanionTalent);
        }
        if (id == 3) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.CompanionOpenInv, new Object[0]);
        }
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        super.func_73863_a(i, j, f);
        if (this.isEating && !this.role.isEating()) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.RoleGet, new Object[0]);
        }
        this.isEating = this.role.isEating();
        super.drawNpc(34, 150);
        int y = this.drawHealth(this.guiTop + 88);
    }

    private int drawHealth(int y) {
        int x;
        int i;
        int k;
        this.field_146297_k.func_110434_K().func_110577_a(Gui.field_110324_m);
        int max = this.role.getTotalArmorValue();
        if (this.role.talents.containsKey((Object)EnumCompanionTalent.ARMOR) || max > 0) {
            for (k = 0; k < 10; ++k) {
                int scale = this.guiLeft + 66 + k * 10;
                if (k * 2 + 1 < max) {
                    this.func_73729_b(scale, y, 34, 9, 9, 9);
                }
                if (k * 2 + 1 == max) {
                    this.func_73729_b(scale, y, 25, 9, 9, 9);
                }
                if (k * 2 + 1 <= max) continue;
                this.func_73729_b(scale, y, 16, 9, 9, 9);
            }
            y += 10;
        }
        max = MathHelper.func_76123_f((float)this.npc.func_110138_aP());
        k = (int)this.npc.func_110143_aJ();
        float var8 = 1.0f;
        if (max > 40) {
            var8 = (float)max / 40.0f;
            k = (int)((float)k / var8);
            max = 40;
        }
        for (i = 0; i < max; ++i) {
            x = this.guiLeft + 66 + i % 20 * 5;
            int offset = i / 20 * 10;
            this.func_73729_b(x, y + offset, 52 + i % 2 * 5, 9, i % 2 == 1 ? 4 : 5, 9);
            if (k <= i) continue;
            this.func_73729_b(x, y + offset, 52 + i % 2 * 5, 0, i % 2 == 1 ? 4 : 5, 9);
        }
        k = this.role.foodstats.getFoodLevel();
        y += 10;
        if (max > 20) {
            y += 10;
        }
        for (i = 0; i < 20; ++i) {
            x = this.guiLeft + 66 + i % 20 * 5;
            this.func_73729_b(x, y, 16 + i % 2 * 5, 27, i % 2 == 1 ? 4 : 5, 9);
            if (k <= i) continue;
            this.func_73729_b(x, y, 52 + i % 2 * 5, 27, i % 2 == 1 ? 4 : 5, 9);
        }
        return y;
    }

    @Override
    public void save() {
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.role.readFromNBT(compound);
    }
}

