/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.constants.EnumJobType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobSpawner;
import org.apache.logging.log4j.LogManager;

public class PixelmonHelper {
    public static List getPixelmonList() {
        ArrayList<String> list = new ArrayList<String>();
        if (!CustomNpcs.PixelMonEnabled) {
            return list;
        }
        try {
            ?[] array;
            Class<?> e = Class.forName("com.pixelmonmod.pixelmon.enums.EnumPokemon");
            ?[] var3 = array = e.getEnumConstants();
            int var4 = array.length;
            for (int var5 = 0; var5 < var4; ++var5) {
                Object ob = var3[var5];
                list.add(ob.toString());
            }
        }
        catch (Exception var7) {
            LogManager.getLogger().error("getPixelmonList", (Throwable)var7);
        }
        return list;
    }

    public static boolean isPixelmon(EntityLivingBase entity) {
        return !CustomNpcs.PixelMonEnabled ? false : EntityList.func_75621_b((Entity)entity).equals("pixelmon.Pixelmon");
    }

    public static void setName(EntityLivingBase entity, String name) {
        if (CustomNpcs.PixelMonEnabled && PixelmonHelper.isPixelmon(entity)) {
            try {
                Method e = entity.getClass().getMethod("init", String.class);
                e.invoke((Object)entity, name);
                Class<?> c = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.Entity2HasModel");
                e = c.getDeclaredMethod("loadModel", new Class[0]);
                e.setAccessible(true);
                e.invoke((Object)entity, new Object[0]);
            }
            catch (Exception var4) {
                LogManager.getLogger().error("setName", (Throwable)var4);
            }
        }
    }

    public static String getName(EntityLivingBase entity) {
        if (CustomNpcs.PixelMonEnabled && PixelmonHelper.isPixelmon(entity)) {
            try {
                Method e = entity.getClass().getMethod("getName", new Class[0]);
                return e.invoke((Object)entity, new Object[0]).toString();
            }
            catch (Exception var2) {
                LogManager.getLogger().error("getName", (Throwable)var2);
                return "";
            }
        }
        return "";
    }

    public static void debug(EntityLivingBase entity) {
        if (CustomNpcs.PixelMonEnabled && PixelmonHelper.isPixelmon(entity)) {
            try {
                Method e = entity.getClass().getMethod("getModel", new Class[0]);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText((String)e.invoke((Object)entity, new Object[0])));
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
        }
    }

    public static boolean isTrainer(EntityLivingBase entity) {
        return !CustomNpcs.PixelMonEnabled ? false : EntityList.func_75621_b((Entity)entity).equals("pixelmon.Trainer");
    }

    public static boolean isBattling(EntityPlayerMP player) {
        if (!CustomNpcs.PixelMonEnabled) {
            return false;
        }
        try {
            Class<?> e = Class.forName("com.pixelmonmod.pixelmon.battles.BattleRegistry");
            Method m = e.getMethod("getBattle", EntityPlayer.class);
            return m.invoke((Object)null, player) == null;
        }
        catch (Exception var3) {
            LogManager.getLogger().error("canBattle", (Throwable)var3);
            return false;
        }
    }

    public static boolean isBattling(EntityLivingBase trainer) {
        if (CustomNpcs.PixelMonEnabled && PixelmonHelper.isTrainer(trainer)) {
            try {
                Field e = trainer.getClass().getField("battleController");
                return e.get(trainer) != null;
            }
            catch (Exception var2) {
                LogManager.getLogger().error("canBattle", (Throwable)var2);
                return false;
            }
        }
        return false;
    }

    public static boolean canBattle(EntityPlayerMP player, EntityNPCInterface npc) {
        if (CustomNpcs.PixelMonEnabled && npc.advanced.job == EnumJobType.Spawner && !PixelmonHelper.isBattling(player)) {
            try {
                JobSpawner e = (JobSpawner)npc.jobInterface;
                if (e.isOnCooldown(player.func_70005_c_())) {
                    return false;
                }
                Class<?> c = Class.forName("com.pixelmonmod.pixelmon.storage.PixelmonStorage");
                Field f = c.getField("PokeballManager");
                Object ob = f.get(null);
                c = Class.forName("com.pixelmonmod.pixelmon.storage.PokeballManager");
                Method m = c.getMethod("getPlayerStorage", EntityPlayerMP.class);
                ob = m.invoke(ob, player);
                c = Class.forName("com.pixelmonmod.pixelmon.storage.PlayerStorage");
                m = c.getMethod("countAblePokemon", new Class[0]);
                return (Integer)m.invoke(ob, new Object[0]) != 0;
            }
            catch (Exception var7) {
                LogManager.getLogger().error("canBattle", (Throwable)var7);
                return false;
            }
        }
        return false;
    }

    public static boolean startBattle(EntityPlayerMP player, EntityLivingBase trainer) {
        if (!CustomNpcs.PixelMonEnabled) {
            return false;
        }
        try {
            Class<?> e = Class.forName("com.pixelmonmod.pixelmon.storage.PixelmonStorage");
            Field f = e.getField("PokeballManager");
            Object ob = f.get(null);
            e = Class.forName("com.pixelmonmod.pixelmon.storage.PokeballManager");
            Method m = e.getMethod("getPlayerStorage", EntityPlayerMP.class);
            ob = m.invoke(ob, player);
            e = Class.forName("com.pixelmonmod.pixelmon.storage.PlayerStorage");
            m = e.getMethod("getFirstAblePokemon", World.class);
            Entity pixelmon = (Entity)m.invoke(ob, player.field_70170_p);
            Class<?> cEntity = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon");
            m = e.getMethod("EntityAlreadyExists", cEntity);
            if (!((Boolean)m.invoke(ob, pixelmon)).booleanValue()) {
                m = cEntity.getMethod("releaseFromPokeball", new Class[0]);
                pixelmon.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, 0.0f);
            }
            e = Class.forName("com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant");
            Object parTrainer = e.getConstructor(trainer.getClass(), EntityPlayer.class, Integer.TYPE).newInstance(trainer, player, 1);
            Object[] pixelmonArray = (Object[])Array.newInstance(cEntity, 1);
            pixelmonArray[0] = pixelmon;
            e = Class.forName("com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant");
            Object parPlayer = e.getConstructor(EntityPlayerMP.class, pixelmonArray.getClass()).newInstance(player, pixelmonArray);
            cEntity = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle");
            e = Class.forName("com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant");
            m = cEntity.getMethod("StartBattle", e, e);
            m.invoke((Object)pixelmon, parTrainer, parPlayer);
            return true;
        }
        catch (Exception var11) {
            LogManager.getLogger().error("startBattle", (Throwable)var11);
            return false;
        }
    }
}

