/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.PlayerBankData;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerMail;
import noppes.npcs.util.NBTJsonUtil;

public class PlayerDataController {
    public static PlayerDataController instance;

    public PlayerDataController() {
        instance = this;
    }

    public File getSaveDir() {
        try {
            File e = new File(CustomNpcs.getWorldSaveDirectory(), "playerdata");
            if (!e.exists()) {
                e.mkdir();
            }
            return e;
        }
        catch (Exception var2) {
            var2.printStackTrace();
            return null;
        }
    }

    public NBTTagCompound loadPlayerDataOld(String player) {
        File e;
        File saveDir = this.getSaveDir();
        String filename = player;
        if (player.isEmpty()) {
            filename = "noplayername";
        }
        filename = filename + ".dat";
        try {
            e = new File(saveDir, filename);
            if (e.exists()) {
                NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(e));
                e.delete();
                e = new File(saveDir, filename + "_old");
                if (e.exists()) {
                    e.delete();
                }
                return comp;
            }
        }
        catch (Exception var7) {
            LogWriter.except(var7);
        }
        try {
            e = new File(saveDir, filename + "_old");
            if (e.exists()) {
                return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(e));
            }
        }
        catch (Exception var6) {
            LogWriter.except(var6);
        }
        return new NBTTagCompound();
    }

    public NBTTagCompound loadPlayerData(String player) {
        File saveDir = this.getSaveDir();
        String filename = player;
        if (player.isEmpty()) {
            filename = "noplayername";
        }
        filename = filename + ".json";
        try {
            File e = new File(saveDir, filename);
            if (e.exists()) {
                return NBTJsonUtil.LoadFile(e);
            }
        }
        catch (Exception var5) {
            LogWriter.except(var5);
        }
        return new NBTTagCompound();
    }

    public void savePlayerData(PlayerData data) {
        NBTTagCompound compound = data.getNBT();
        String filename = data.uuid + ".json";
        try {
            File e = this.getSaveDir();
            File file = new File(e, filename + "_new");
            File file1 = new File(e, filename);
            NBTJsonUtil.SaveFile(file, compound);
            if (file1.exists()) {
                file1.delete();
            }
            file.renameTo(file1);
        }
        catch (Exception var7) {
            LogWriter.except(var7);
        }
    }

    public PlayerBankData getBankData(EntityPlayer player, int bankId) {
        Bank bank = BankController.getInstance().getBank(bankId);
        PlayerBankData data = this.getPlayerData((EntityPlayer)player).bankData;
        if (!data.hasBank(bank.id)) {
            data.loadNew(bank.id);
        }
        return data;
    }

    public PlayerData getPlayerData(EntityPlayer player) {
        PlayerData data = (PlayerData)player.getExtendedProperties("CustomNpcsData");
        if (data == null) {
            data = new PlayerData();
            player.registerExtendedProperties("CustomNpcsData", (IExtendedEntityProperties)data);
            data.player = player;
            data.loadNBTData(null);
        }
        return data;
    }

    public String hasPlayer(String username) {
        String name;
        Iterator var2 = this.getUsernameData().keySet().iterator();
        do {
            if (var2.hasNext()) continue;
            return "";
        } while (!(name = (String)var2.next()).equalsIgnoreCase(username));
        return name;
    }

    public PlayerData getDataFromUsername(String username) {
        EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(username);
        PlayerData data = null;
        if (player == null) {
            Map map = this.getUsernameData();
            for (String name : map.keySet()) {
                if (!name.equalsIgnoreCase(username)) continue;
                data = new PlayerData();
                data.setNBT((NBTTagCompound)map.get(name));
                break;
            }
        } else {
            data = this.getPlayerData((EntityPlayer)player);
        }
        return data;
    }

    public void addPlayerMessage(String username, PlayerMail mail) {
        mail.time = System.currentTimeMillis();
        EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(username);
        PlayerData data = this.getDataFromUsername(username);
        data.mailData.playermail.add(mail.copy());
        this.savePlayerData(data);
    }

    public Map getUsernameData() {
        HashMap<String, NBTTagCompound> map = new HashMap<String, NBTTagCompound>();
        for (File file : this.getSaveDir().listFiles()) {
            if (file.isDirectory() || !file.getName().endsWith(".json")) continue;
            try {
                NBTTagCompound e = NBTJsonUtil.LoadFile(file);
                if (!e.func_74764_b("PlayerName")) continue;
                map.put(e.func_74779_i("PlayerName"), e);
            }
            catch (Exception var7) {
                LogWriter.except(var7);
            }
        }
        return map;
    }

    public boolean hasMail(EntityPlayer player) {
        return this.getPlayerData((EntityPlayer)player).mailData.hasMail();
    }
}

