/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.quests.QuestInterface;

public class PlayerQuestData {
    public HashMap activeQuests = new HashMap();
    public HashMap finishedQuests = new HashMap();

    public void loadNBTData(NBTTagCompound mainCompound) {
        if (mainCompound != null) {
            NBTTagList var11;
            NBTTagCompound compound = mainCompound.func_74775_l("QuestData");
            NBTTagList list = compound.func_150295_c("CompletedQuests", 10);
            if (list != null) {
                HashMap<Integer, Long> list2 = new HashMap<Integer, Long>();
                for (int activeQuests = 0; activeQuests < list.func_74745_c(); ++activeQuests) {
                    NBTTagCompound i = list.func_150305_b(activeQuests);
                    list2.put(i.func_74762_e("Quest"), i.func_74763_f("Date"));
                }
                this.finishedQuests = list2;
            }
            if ((var11 = compound.func_150295_c("ActiveQuests", 10)) != null) {
                HashMap<Integer, QuestData> var12 = new HashMap<Integer, QuestData>();
                for (int var13 = 0; var13 < var11.func_74745_c(); ++var13) {
                    NBTTagCompound nbttagcompound = var11.func_150305_b(var13);
                    int id = nbttagcompound.func_74762_e("Quest");
                    Quest quest = (Quest)QuestController.instance.quests.get(id);
                    if (quest == null) continue;
                    QuestData data = new QuestData(quest);
                    data.readEntityFromNBT(nbttagcompound);
                    var12.put(id, data);
                }
                this.activeQuests = var12;
            }
        }
    }

    public void saveNBTData(NBTTagCompound maincompound) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        Iterator list2 = this.finishedQuests.keySet().iterator();
        while (list2.hasNext()) {
            int quest = (Integer)list2.next();
            NBTTagCompound quest1 = new NBTTagCompound();
            quest1.func_74768_a("Quest", quest);
            quest1.func_74772_a("Date", ((Long)this.finishedQuests.get(quest)).longValue());
            list.func_74742_a((NBTBase)quest1);
        }
        compound.func_74782_a("CompletedQuests", (NBTBase)list);
        NBTTagList list21 = new NBTTagList();
        Iterator quest2 = this.activeQuests.keySet().iterator();
        while (quest2.hasNext()) {
            int quest3 = (Integer)quest2.next();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Quest", quest3);
            ((QuestData)this.activeQuests.get(quest3)).writeEntityToNBT(nbttagcompound);
            list21.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("ActiveQuests", (NBTBase)list21);
        maincompound.func_74782_a("QuestData", (NBTBase)compound);
    }

    public QuestData getQuestCompletion(EntityPlayer player, EntityNPCInterface npc) {
        QuestData data;
        Quest quest;
        Iterator var3 = this.activeQuests.values().iterator();
        do {
            if (!var3.hasNext()) {
                return null;
            }
            data = (QuestData)var3.next();
        } while ((quest = data.quest) == null || quest.completion != EnumQuestCompletion.Npc || !quest.completerNpc.equals(npc.func_70005_c_()) || !quest.questInterface.isCompleted(player));
        return data;
    }

    public boolean checkQuestCompletion(EntityPlayer player, EnumQuestType type) {
        boolean bo = false;
        for (QuestData data : this.activeQuests.values()) {
            if (data.quest.type != type && type != null) continue;
            QuestInterface inter = data.quest.questInterface;
            if (inter.isCompleted(player)) {
                if (data.isCompleted) continue;
                if (!data.quest.complete(player, data)) {
                    Server.sendData((EntityPlayerMP)player, EnumPacketClient.MESSAGE, "quest.completed", data.quest.title);
                    Server.sendData((EntityPlayerMP)player, EnumPacketClient.CHAT, "quest.completed", ": ", data.quest.title);
                }
                data.isCompleted = true;
                bo = true;
                continue;
            }
            data.isCompleted = false;
        }
        return bo;
    }
}

