/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.controllers.TransportCategory;
import noppes.npcs.controllers.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleTransporter;

public class TransportController {
    private HashMap locations = new HashMap();
    public HashMap categories = new HashMap();
    private int lastUsedID = 0;
    private static TransportController instance;

    public TransportController() {
        instance = this;
        this.loadCategories();
        if (this.categories.isEmpty()) {
            TransportCategory cat = new TransportCategory();
            cat.id = 1;
            cat.title = "Default";
            this.categories.put(cat.id, cat);
        }
    }

    private void loadCategories() {
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        if (saveDir != null) {
            try {
                File e = new File(saveDir, "transport.dat");
                if (!e.exists()) {
                    return;
                }
                this.loadCategories(e);
            }
            catch (IOException var5) {
                try {
                    File ee = new File(saveDir, "transport.dat_old");
                    if (!ee.exists()) {
                        return;
                    }
                    this.loadCategories(ee);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void loadCategories(File file) throws IOException {
        HashMap<Integer, TransportLocation> locations = new HashMap<Integer, TransportLocation>();
        HashMap<Integer, TransportCategory> categories = new HashMap<Integer, TransportCategory>();
        NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        this.lastUsedID = nbttagcompound1.func_74762_e("lastID");
        NBTTagList list = nbttagcompound1.func_150295_c("NPCTransportCategories", 10);
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                TransportCategory category = new TransportCategory();
                NBTTagCompound compound = list.func_150305_b(i);
                category.readNBT(compound);
                for (TransportLocation location : category.locations.values()) {
                    locations.put(location.id, location);
                }
                categories.put(category.id, category);
            }
            this.locations = locations;
            this.categories = categories;
        }
    }

    public NBTTagCompound getNBT() {
        NBTTagList list = new NBTTagList();
        for (TransportCategory category : this.categories.values()) {
            NBTTagCompound compound = new NBTTagCompound();
            category.writeNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74768_a("lastID", this.lastUsedID);
        nbttagcompound1.func_74782_a("NPCTransportCategories", (NBTBase)list);
        return nbttagcompound1;
    }

    public void saveCategories() {
        try {
            File e = CustomNpcs.getWorldSaveDirectory();
            File file = new File(e, "transport.dat_new");
            File file1 = new File(e, "transport.dat_old");
            File file2 = new File(e, "transport.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception var5) {
            LogWriter.except(var5);
        }
    }

    public TransportLocation getTransport(int transportId) {
        return (TransportLocation)this.locations.get(transportId);
    }

    public TransportLocation getTransport(String name) {
        TransportLocation loc;
        Iterator var2 = this.locations.values().iterator();
        do {
            if (!var2.hasNext()) {
                return null;
            }
            loc = (TransportLocation)var2.next();
        } while (!loc.name.equals(name));
        return loc;
    }

    private int getUniqueIdLocation() {
        if (this.lastUsedID == 0) {
            Iterator var1 = this.locations.keySet().iterator();
            while (var1.hasNext()) {
                int catid = (Integer)var1.next();
                if (catid <= this.lastUsedID) continue;
                this.lastUsedID = catid;
            }
        }
        ++this.lastUsedID;
        return this.lastUsedID;
    }

    private int getUniqueIdCategory() {
        int id = 0;
        Iterator var2 = this.categories.keySet().iterator();
        while (var2.hasNext()) {
            int catid = (Integer)var2.next();
            if (catid <= id) continue;
            id = catid;
        }
        return ++id;
    }

    public void setLocation(TransportLocation location) {
        if (this.locations.containsKey(location.id)) {
            for (TransportCategory cat : this.categories.values()) {
                cat.locations.remove(location.id);
            }
        }
        this.locations.put(location.id, location);
        location.category.locations.put(location.id, location);
    }

    public TransportLocation removeLocation(int location) {
        TransportLocation loc = (TransportLocation)this.locations.get(location);
        if (loc == null) {
            return null;
        }
        loc.category.locations.remove(location);
        this.locations.remove(location);
        this.saveCategories();
        return loc;
    }

    private boolean containsCategoryName(String name) {
        TransportCategory cat;
        name = name.toLowerCase();
        Iterator var2 = this.categories.values().iterator();
        do {
            if (!var2.hasNext()) {
                return false;
            }
            cat = (TransportCategory)var2.next();
        } while (!cat.title.toLowerCase().equals(name));
        return true;
    }

    public void saveCategory(String name, int id) {
        if (id < 0) {
            id = this.getUniqueIdCategory();
        }
        if (this.categories.containsKey(id)) {
            TransportCategory category = (TransportCategory)this.categories.get(id);
            if (!category.title.equals(name)) {
                while (this.containsCategoryName(name)) {
                    name = name + "_";
                }
                ((TransportCategory)this.categories.get((Object)Integer.valueOf((int)id))).title = name;
            }
        } else {
            while (this.containsCategoryName(name)) {
                name = name + "_";
            }
            TransportCategory category = new TransportCategory();
            category.id = id;
            category.title = name;
            this.categories.put(id, category);
        }
        this.saveCategories();
    }

    public void removeCategory(int id) {
        TransportCategory cat;
        if (this.categories.size() != 1 && (cat = (TransportCategory)this.categories.get(id)) != null) {
            Iterator var3 = cat.locations.keySet().iterator();
            while (var3.hasNext()) {
                int i = (Integer)var3.next();
                this.locations.remove(i);
            }
            this.categories.remove(id);
            this.saveCategories();
        }
    }

    public boolean containsLocationName(String name) {
        TransportLocation loc;
        name = name.toLowerCase();
        Iterator var2 = this.locations.values().iterator();
        do {
            if (!var2.hasNext()) {
                return false;
            }
            loc = (TransportLocation)var2.next();
        } while (!loc.name.toLowerCase().equals(name));
        return true;
    }

    public static TransportController getInstance() {
        return instance;
    }

    public TransportLocation saveLocation(int categoryId, NBTTagCompound compound, EntityPlayerMP player, EntityNPCInterface npc) {
        TransportCategory category = (TransportCategory)this.categories.get(categoryId);
        if (category != null && npc.advanced.role == EnumRoleType.Transporter) {
            RoleTransporter role = (RoleTransporter)npc.roleInterface;
            TransportLocation location = new TransportLocation();
            location.readNBT(compound);
            location.category = category;
            if (role.hasTransport()) {
                location.id = role.transportId;
            }
            if (location.id < 0 || !((TransportLocation)this.locations.get((Object)Integer.valueOf((int)location.id))).name.equals(location.name)) {
                while (this.containsLocationName(location.name)) {
                    location.name = location.name + "_";
                }
            }
            if (location.id < 0) {
                location.id = this.getUniqueIdLocation();
            }
            category.locations.put(location.id, location);
            this.locations.put(location.id, location);
            this.saveCategories();
            return location;
        }
        return null;
    }
}

