/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.quests.QuestInterface;

public class QuestKill
extends QuestInterface {
    public HashMap targets = new HashMap();

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.targets = NBTTags.getStringIntegerMap(compound.func_150295_c("QuestDialogs", 10));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74782_a("QuestDialogs", (NBTBase)NBTTags.nbtStringIntegerMap(this.targets));
    }

    @Override
    public boolean isCompleted(EntityPlayer player) {
        String entity;
        PlayerQuestData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        QuestData data = (QuestData)playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return false;
        }
        HashMap killed = this.getKilled(data);
        if (killed.size() != this.targets.size()) {
            return false;
        }
        Iterator var5 = killed.keySet().iterator();
        do {
            if (var5.hasNext()) continue;
            return true;
        } while (this.targets.containsKey(entity = (String)var5.next()) && (Integer)this.targets.get(entity) <= (Integer)killed.get(entity));
        return false;
    }

    @Override
    public void handleComplete(EntityPlayer player) {
    }

    @Override
    public Vector getQuestLogStatus(EntityPlayer player) {
        Vector<String> vec = new Vector<String>();
        PlayerQuestData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        QuestData data = (QuestData)playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return vec;
        }
        HashMap killed = this.getKilled(data);
        for (String entityName : this.targets.keySet()) {
            int amount = 0;
            if (killed.containsKey(entityName)) {
                amount = (Integer)killed.get(entityName);
            }
            String state = amount + "/" + this.targets.get(entityName);
            vec.add(entityName + ": " + state);
        }
        return vec;
    }

    public HashMap getKilled(QuestData data) {
        return NBTTags.getStringIntegerMap(data.extraData.func_150295_c("Killed", 10));
    }

    public void setKilled(QuestData data, HashMap killed) {
        data.extraData.func_74782_a("Killed", (NBTBase)NBTTags.nbtStringIntegerMap(killed));
    }
}

