/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.scripted.ScriptEntity;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.ScriptPlayer;
import noppes.npcs.scripted.ScriptScoreboard;

public class ScriptWorld {
    private static Map tempData = new HashMap();
    protected WorldServer world;

    public ScriptWorld(WorldServer world) {
        this.world = world;
    }

    public long getTime() {
        return this.world.func_72820_D();
    }

    public long getTotalTime() {
        return this.world.func_82737_E();
    }

    public ScriptItemStack getBlock(int x, int y, int z) {
        Block block = this.world.func_147439_a(x, y, z);
        return block != null && !block.isAir((IBlockAccess)this.world, x, y, z) ? new ScriptItemStack(new ItemStack(block)) : null;
    }

    public void setBlock(int x, int y, int z, ScriptItemStack item) {
        if (item == null) {
            this.removeBlock(x, y, z);
        } else {
            Block block = Block.func_149634_a((Item)item.item.func_77973_b());
            if (block != null && block != Blocks.field_150350_a) {
                this.world.func_147449_b(x, y, z, block);
            }
        }
    }

    public void removeBlock(int x, int y, int z) {
        this.world.func_147449_b(x, y, z, Blocks.field_150350_a);
    }

    public ScriptPlayer getPlayer(String name) {
        EntityPlayer player = this.world.func_72924_a(name);
        return player == null ? null : (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)player);
    }

    public void setTime(long time) {
        this.world.func_72877_b(time);
    }

    public boolean isDay() {
        return this.world.func_72820_D() % 24000L < 12000L;
    }

    public boolean isRaining() {
        return this.world.func_72912_H().func_76059_o();
    }

    public void setRaining(boolean bo) {
        this.world.func_72912_H().func_76084_b(bo);
    }

    public void thunderStrike(double x, double y, double z) {
        this.world.func_72942_c((Entity)new EntityLightningBolt((World)this.world, x, y, z));
    }

    public void spawnParticle(String particle, double x, double y, double z, double dx, double dy, double dz, double speed, int count) {
        this.world.func_147487_a(particle, x, y, z, count, dx, dy, dz, speed);
    }

    public ScriptItemStack createItem(String id, int damage, int size) {
        Item item = (Item)Item.field_150901_e.func_82594_a(id);
        return item == null ? null : new ScriptItemStack(new ItemStack(item, size, damage));
    }

    public Object getTempData(String key) {
        return tempData.get(key);
    }

    public void setTempData(String key, Object value) {
        tempData.put(key, value);
    }

    public boolean hasTempData(String key) {
        return tempData.containsKey(key);
    }

    public void removeTempData(String key) {
        tempData.remove(key);
    }

    public void clearTempData() {
        tempData.clear();
    }

    public Object getStoredData(String key) {
        NBTTagCompound compound = ScriptController.Instance.compound;
        if (!compound.func_74764_b(key)) {
            return null;
        }
        NBTBase base = compound.func_74781_a(key);
        return base instanceof NBTBase.NBTPrimitive ? Double.valueOf(((NBTBase.NBTPrimitive)base).func_150286_g()) : ((NBTTagString)base).func_150285_a_();
    }

    public void setStoredData(String key, Object value) {
        NBTTagCompound compound = ScriptController.Instance.compound;
        if (value instanceof Number) {
            compound.func_74780_a(key, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            compound.func_74778_a(key, (String)value);
        }
        ScriptController.Instance.shouldSave = true;
    }

    public boolean hasStoredData(String key) {
        return ScriptController.Instance.compound.func_74764_b(key);
    }

    public void removeStoredData(String key) {
        ScriptController.Instance.compound.func_82580_o(key);
        ScriptController.Instance.shouldSave = true;
    }

    public void clearStoredData() {
        ScriptController.Instance.compound = new NBTTagCompound();
        ScriptController.Instance.shouldSave = true;
    }

    public void explode(double x, double y, double z, float range, boolean fire, boolean grief) {
        this.world.func_72885_a((Entity)null, x, y, z, range, fire, grief);
    }

    public ScriptPlayer[] getAllServerPlayers() {
        List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        ScriptPlayer[] arr = new ScriptPlayer[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (ScriptPlayer)ScriptController.Instance.getScriptForEntity((Entity)list.get(i));
        }
        return arr;
    }

    public String getBiomeName(int x, int z) {
        return this.world.func_72807_a((int)x, (int)z).field_76791_y;
    }

    public ScriptEntity spawnClone(int x, int y, int z, int tab, String name) {
        NBTTagCompound compound = ServerCloneController.Instance.getCloneData(null, name, tab);
        if (compound == null) {
            return null;
        }
        Entity entity = NoppesUtilServer.spawnClone(compound, x, y, z, (World)this.world);
        return entity == null ? null : ScriptController.Instance.getScriptForEntity(entity);
    }

    public ScriptScoreboard getScoreboard() {
        return new ScriptScoreboard();
    }

    public World getMCWorld() {
        return this.world;
    }
}

