/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import com.google.common.io.Files;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.util.JsonException;
import org.apache.commons.io.Charsets;

public class NBTJsonUtil {
    public static String Convert(NBTTagCompound compound) {
        ArrayList list = new ArrayList();
        JsonLine line = NBTJsonUtil.ReadTag("", (NBTBase)compound, list);
        line.removeComma();
        return NBTJsonUtil.ConvertList(list);
    }

    public static NBTTagCompound Convert(String json) throws JsonException {
        json = json.trim();
        JsonFile file = new JsonFile(json);
        if (json.startsWith("{") && json.endsWith("}")) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTJsonUtil.FillCompound(compound, file);
            return compound;
        }
        throw new JsonException("Not properly incapsulated between { }", file);
    }

    public static void FillCompound(NBTTagCompound compound, JsonFile json) throws JsonException {
        if (json.startsWith("{") || json.startsWith(",")) {
            json.cut(1);
        }
        if (!json.startsWith("}")) {
            int index = json.indexOf(":");
            if (index < 1) {
                throw new JsonException("Expected key after ,", json);
            }
            String key = json.substring(0, index);
            json.cut(index + 1);
            NBTBase base = NBTJsonUtil.ReadValue(json);
            if (base == null) {
                base = new NBTTagString();
            }
            compound.func_74782_a(key, base);
            if (json.startsWith(",")) {
                NBTJsonUtil.FillCompound(compound, json);
            }
        }
    }

    public static NBTBase ReadValue(JsonFile json) throws JsonException {
        if (json.startsWith("{")) {
            NBTTagCompound var7 = new NBTTagCompound();
            NBTJsonUtil.FillCompound(var7, json);
            if (!json.startsWith("}")) {
                throw new JsonException("Expected }", json);
            }
            json.cut(1);
            return var7;
        }
        if (json.startsWith("[")) {
            json.cut(1);
            NBTTagList var6 = new NBTTagList();
            NBTBase var8 = NBTJsonUtil.ReadValue(json);
            while (var8 != null) {
                var6.func_74742_a(var8);
                if (!json.startsWith(",")) break;
                json.cut(1);
                var8 = NBTJsonUtil.ReadValue(json);
            }
            if (!json.startsWith("]")) {
                throw new JsonException("Expected ]", json);
            }
            json.cut(1);
            if (var6.func_150303_d() == 3) {
                int[] var10 = new int[var6.func_74745_c()];
                int i = 0;
                while (var6.func_74745_c() > 0) {
                    var10[i] = ((NBTTagInt)var6.func_74744_a(0)).func_150287_d();
                    ++i;
                }
                return new NBTTagIntArray(var10);
            }
            if (var6.func_150303_d() != 1) {
                return var6;
            }
            byte[] var9 = new byte[var6.func_74745_c()];
            int i = 0;
            while (var6.func_74745_c() > 0) {
                var9[i] = ((NBTTagByte)var6.func_74744_a(0)).func_150290_f();
                ++i;
            }
            return new NBTTagByteArray(var9);
        }
        if (json.startsWith("\"")) {
            json.cut(1);
            String s = "";
            boolean ex = false;
            while (!json.startsWith("\"") || ex) {
                String cut = json.cutDirty(1);
                ex = cut.equals("\\");
                s = s + cut;
            }
            json.cut(1);
            return new NBTTagString(s.replace("\\\"", "\""));
        }
        String s = "";
        while (!json.startsWith(",", "]", "}")) {
            s = s + json.cut(1);
        }
        if ((s = s.trim().toLowerCase()).isEmpty()) {
            return null;
        }
        try {
            return s.endsWith("d") ? new NBTTagDouble(Double.parseDouble(s.substring(0, s.length() - 1))) : (s.endsWith("f") ? new NBTTagFloat(Float.parseFloat(s.substring(0, s.length() - 1))) : (s.endsWith("b") ? new NBTTagByte(Byte.parseByte(s.substring(0, s.length() - 1))) : (s.endsWith("s") ? new NBTTagShort(Short.parseShort(s.substring(0, s.length() - 1))) : (s.endsWith("l") ? new NBTTagLong(Long.parseLong(s.substring(0, s.length() - 1))) : (s.contains(".") ? new NBTTagDouble(Double.parseDouble(s)) : new NBTTagInt(Integer.parseInt(s)))))));
        }
        catch (NumberFormatException var5) {
            throw new JsonException("Unable to convert: " + s + " to a number", json);
        }
    }

    private static List getListData(NBTTagList list) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(NBTTagList.class, (Object)list, (int)0);
    }

    private static JsonLine ReadTag(String name, NBTBase base, List list) {
        JsonLine line1;
        if (!name.isEmpty()) {
            name = name + ": ";
        }
        if (base.func_74732_a() == 8) {
            String line = ((NBTTagString)base).func_150285_a_();
            line = line.replace("\"", "\\\"");
            list.add(new JsonLine(name + "\"" + line + "\""));
        } else if (base.func_74732_a() == 9) {
            list.add(new JsonLine(name + "["));
            NBTTagList line2 = (NBTTagList)base;
            line1 = null;
            List data = NBTJsonUtil.getListData(line2);
            for (NBTBase b : data) {
                line1 = NBTJsonUtil.ReadTag("", b, list);
            }
            if (line1 != null) {
                line1.removeComma();
            }
            list.add(new JsonLine("]"));
        } else if (base.func_74732_a() == 10) {
            list.add(new JsonLine(name + "{"));
            NBTTagCompound line3 = (NBTTagCompound)base;
            line1 = null;
            for (Object key1 : line3.func_150296_c()) {
                line1 = NBTJsonUtil.ReadTag(key1.toString(), line3.func_74781_a(key1.toString()), list);
            }
            if (line1 != null) {
                line1.removeComma();
            }
            list.add(new JsonLine("}"));
        } else if (base.func_74732_a() == 11) {
            list.add(new JsonLine(name + base.toString().replaceFirst(",]", "]")));
        } else {
            list.add(new JsonLine(name + base));
        }
        JsonLine line4 = (JsonLine)list.get(list.size() - 1);
        line4.line = line4.line + ",";
        return line4;
    }

    private static String ConvertList(List list) {
        String json = "";
        int tab = 0;
        for (JsonLine tag : list) {
            if (tag.reduceTab()) {
                --tab;
            }
            for (int i = 0; i < tab; ++i) {
                json = json + "    ";
            }
            json = json + tag + "\n";
            if (!tag.increaseTab()) continue;
            ++tab;
        }
        return json;
    }

    public static NBTTagCompound LoadFile(File file) throws JsonException, IOException {
        return NBTJsonUtil.Convert(Files.toString((File)file, (Charset)Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SaveFile(File file, NBTTagCompound compound) throws JsonException, IOException {
        String json = NBTJsonUtil.Convert(compound);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
            writer.write(json);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    static class JsonLine {
        private String line;

        public JsonLine(String line) {
            this.line = line;
        }

        public void removeComma() {
            if (this.line.endsWith(",")) {
                this.line = this.line.substring(0, this.line.length() - 1);
            }
        }

        public boolean reduceTab() {
            int length = this.line.length();
            return length == 1 && (this.line.endsWith("}") || this.line.endsWith("]")) || length == 2 && (this.line.endsWith("},") || this.line.endsWith("],"));
        }

        public boolean increaseTab() {
            return this.line.endsWith("{") || this.line.endsWith("[");
        }

        public String toString() {
            return this.line;
        }
    }

    static class JsonFile {
        private String original;
        private String text;

        public JsonFile(String text) {
            this.text = text;
            this.original = text;
        }

        public String cutDirty(int i) {
            String s = this.text.substring(0, i);
            this.text = this.text.substring(i);
            return s;
        }

        public String cut(int i) {
            String s = this.text.substring(0, i);
            this.text = this.text.substring(i).trim();
            return s;
        }

        public String substring(int beginIndex, int endIndex) {
            return this.text.substring(beginIndex, endIndex);
        }

        public int indexOf(String s) {
            return this.text.indexOf(s);
        }

        public String getCurrentPos() {
            int lengthOr = this.original.length();
            int lengthCur = this.text.length();
            int currentPos = lengthOr - lengthCur;
            String done = this.original.substring(0, currentPos);
            String[] lines = done.split("\r\n|\r|\n");
            int pos = 0;
            String line = "";
            if (lines.length > 0) {
                pos = lines[lines.length - 1].length();
                line = this.original.split("\r\n|\r|\n")[lines.length - 1].trim();
            }
            int nextNewLine = NoppesStringUtils.nextNewLine(this.text);
            return "Line: " + lines.length + ", Pos: " + pos + ", Text: " + line;
        }

        public boolean startsWith(String ... ss) {
            String[] var2 = ss;
            int var3 = ss.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String s = var2[var4];
                if (!this.text.startsWith(s)) continue;
                return true;
            }
            return false;
        }

        public boolean endsWith(String s) {
            return this.text.endsWith(s);
        }
    }
}

