/*
 * Decompiled with CFR 0.152.
 */
package extracells;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.MEMonitorHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.WorldCoord;
import cpw.mods.fml.common.Optional;
import extracells.Extracells;
import extracells.api.ExtraCellsApi;
import extracells.api.IExternalGasStorageHandler;
import extracells.api.IPortableFluidStorageCell;
import extracells.api.IPortableGasStorageCell;
import extracells.api.IWirelessFluidTermHandler;
import extracells.api.IWirelessGasFluidTermHandler;
import extracells.api.definitions.IBlockDefinition;
import extracells.api.definitions.IItemDefinition;
import extracells.api.definitions.IPartDefinition;
import extracells.definitions.BlockDefinition;
import extracells.definitions.ItemDefinition;
import extracells.definitions.PartDefinition;
import extracells.integration.Integration;
import extracells.integration.mekanism.gas.GasCellHandler;
import extracells.integration.mekanism.gas.MekanismGas;
import extracells.inventory.HandlerItemStorageFluid;
import extracells.inventory.HandlerItemStorageGas;
import extracells.network.GuiHandler;
import extracells.util.FluidCellHandler;
import extracells.util.FuelBurnTime;
import extracells.util.GasStorageRegistry;
import extracells.util.GasUtil;
import extracells.wireless.WirelessTermRegistry;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ExtraCellsApiInstance
implements ExtraCellsApi {
    public static final ExtraCellsApi instance = new ExtraCellsApiInstance();
    private final List<Class<? extends Fluid>> blacklistShowClass = new ArrayList<Class<? extends Fluid>>();
    private final List<Fluid> blacklistShowFluid = new ArrayList<Fluid>();
    private final List<Class<? extends Fluid>> blacklistStorageClass = new ArrayList<Class<? extends Fluid>>();
    private final List<Fluid> blacklistStorageFluid = new ArrayList<Fluid>();

    @Override
    public void addFluidToShowBlacklist(Class<? extends Fluid> clazz) {
        if (clazz == null || clazz == Fluid.class) {
            return;
        }
        this.blacklistShowClass.add(clazz);
    }

    @Override
    public void addFluidToShowBlacklist(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        this.blacklistShowFluid.add(fluid);
    }

    @Override
    public void addFluidToStorageBlacklist(Class<? extends Fluid> clazz) {
        if (clazz == null || clazz == Fluid.class) {
            return;
        }
        this.blacklistStorageClass.add(clazz);
    }

    @Override
    public void addFluidToStorageBlacklist(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        this.blacklistStorageFluid.add(fluid);
    }

    @Override
    public IBlockDefinition blocks() {
        return BlockDefinition.instance;
    }

    @Override
    public boolean canFluidSeeInTerminal(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        if (this.blacklistShowFluid.contains(fluid)) {
            return false;
        }
        for (Class<? extends Fluid> clazz : this.blacklistShowClass) {
            if (!clazz.isInstance(fluid)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canStoreFluid(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        if (this.blacklistStorageFluid.contains(fluid)) {
            return false;
        }
        for (Class<? extends Fluid> clazz : this.blacklistStorageClass) {
            if (!clazz.isInstance(fluid)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public String getVerion() {
        return Extracells.VERSION();
    }

    @Override
    public String getVersion() {
        return Extracells.VERSION();
    }

    @Override
    public IWirelessFluidTermHandler getWirelessFluidTermHandler(ItemStack is) {
        return (IWirelessFluidTermHandler)this.getWirelessTermHandler(is);
    }

    @Override
    public IWirelessGasFluidTermHandler getWirelessTermHandler(ItemStack is) {
        return WirelessTermRegistry.getWirelessTermHandler(is);
    }

    @Override
    public boolean isWirelessFluidTerminal(ItemStack is) {
        return WirelessTermRegistry.isWirelessItem(is);
    }

    @Override
    public IItemDefinition items() {
        return ItemDefinition.instance;
    }

    @Override
    public ItemStack openPortableCellGui(EntityPlayer player, ItemStack stack, World world) {
        return this.openPortableFluidCellGui(player, stack, world);
    }

    @Override
    public ItemStack openPortableFluidCellGui(EntityPlayer player, ItemStack stack, World world) {
        if (world.field_72995_K || stack == null || stack.func_77973_b() == null) {
            return stack;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof IPortableFluidStorageCell)) {
            return stack;
        }
        ICellHandler cellHandler = AEApi.instance().registries().cell().getHandler(stack);
        if (!(cellHandler instanceof FluidCellHandler)) {
            return stack;
        }
        IMEInventoryHandler handler = ((FluidCellHandler)cellHandler).getCellInventoryPlayer(stack, player);
        if (!(handler instanceof HandlerItemStorageFluid)) {
            return stack;
        }
        MEMonitorHandler fluidInventory = new MEMonitorHandler(handler, StorageChannel.FLUIDS);
        GuiHandler.launchGui(GuiHandler.getGuiId(3), player, new Object[]{fluidInventory, item});
        return stack;
    }

    @Override
    public ItemStack openPortableGasCellGui(EntityPlayer player, ItemStack stack, World world) {
        if (world.field_72995_K || stack == null || stack.func_77973_b() == null) {
            return stack;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof IPortableGasStorageCell)) {
            return stack;
        }
        ICellHandler cellHandler = AEApi.instance().registries().cell().getHandler(stack);
        if (!(cellHandler instanceof GasCellHandler)) {
            return stack;
        }
        IMEInventoryHandler handler = ((GasCellHandler)cellHandler).getCellInventoryPlayer(stack, player);
        if (!(handler instanceof HandlerItemStorageGas)) {
            return stack;
        }
        MEMonitorHandler fluidInventory = new MEMonitorHandler(handler, StorageChannel.FLUIDS);
        GuiHandler.launchGui(GuiHandler.getGuiId(6), player, new Object[]{fluidInventory, item});
        return stack;
    }

    @Override
    public ItemStack openWirelessTerminal(EntityPlayer player, ItemStack stack, World world) {
        return this.openWirelessFluidTerminal(player, stack, world);
    }

    @Override
    public ItemStack openWirelessFluidTerminal(EntityPlayer player, ItemStack stack, World world) {
        Long key;
        if (world.field_72995_K) {
            return stack;
        }
        if (!this.isWirelessFluidTerminal(stack)) {
            return stack;
        }
        IWirelessGasFluidTermHandler handler = this.getWirelessTermHandler(stack);
        if (!handler.hasPower(player, 1.0, stack)) {
            return stack;
        }
        try {
            key = Long.parseLong(handler.getEncryptionKey(stack));
        }
        catch (Throwable ignored) {
            return stack;
        }
        return this.openWirelessTerminal(player, stack, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, key);
    }

    @Override
    public ItemStack openWirelessGasTerminal(EntityPlayer player, ItemStack itemStack, World world) {
        Long key;
        if (world.field_72995_K) {
            return itemStack;
        }
        if (!this.isWirelessFluidTerminal(itemStack)) {
            return itemStack;
        }
        IWirelessGasFluidTermHandler handler = this.getWirelessTermHandler(itemStack);
        if (!handler.hasPower(player, 1.0, itemStack)) {
            return itemStack;
        }
        try {
            key = Long.parseLong(handler.getEncryptionKey(itemStack));
        }
        catch (Throwable ignored) {
            return itemStack;
        }
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        IGridHost securityTerminal = (IGridHost)AEApi.instance().registries().locatable().getLocatableBy(key.longValue());
        if (securityTerminal == null) {
            return itemStack;
        }
        IGridNode gridNode = securityTerminal.getGridNode(ForgeDirection.UNKNOWN);
        if (gridNode == null) {
            return itemStack;
        }
        IGrid grid = gridNode.getGrid();
        if (grid == null) {
            return itemStack;
        }
        for (IGridNode node : grid.getMachines((Class)AEApi.instance().definitions().blocks().wireless().maybeEntity().get())) {
            IMEMonitor fluidInventory;
            IStorageGrid gridCache;
            IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)node.getMachine();
            WorldCoord distance = accessPoint.getLocation().subtract(x, y, z);
            int squaredDistance = distance.x * distance.x + distance.y * distance.y + distance.z * distance.z;
            if (!((double)squaredDistance <= accessPoint.getRange() * accessPoint.getRange()) || (gridCache = (IStorageGrid)grid.getCache(IStorageGrid.class)) == null || (fluidInventory = gridCache.getFluidInventory()) == null) continue;
            GuiHandler.launchGui(GuiHandler.getGuiId(5), player, new Object[]{fluidInventory, this.getWirelessTermHandler(itemStack)});
        }
        return itemStack;
    }

    @Override
    @Deprecated
    public ItemStack openWirelessTerminal(EntityPlayer player, ItemStack itemStack, World world, int x, int y, int z, Long key) {
        if (world.field_72995_K) {
            return itemStack;
        }
        IGridHost securityTerminal = (IGridHost)AEApi.instance().registries().locatable().getLocatableBy(key.longValue());
        if (securityTerminal == null) {
            return itemStack;
        }
        IGridNode gridNode = securityTerminal.getGridNode(ForgeDirection.UNKNOWN);
        if (gridNode == null) {
            return itemStack;
        }
        IGrid grid = gridNode.getGrid();
        if (grid == null) {
            return itemStack;
        }
        for (IGridNode node : grid.getMachines((Class)AEApi.instance().definitions().blocks().wireless().maybeEntity().get())) {
            IMEMonitor fluidInventory;
            IStorageGrid gridCache;
            IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)node.getMachine();
            WorldCoord distance = accessPoint.getLocation().subtract(x, y, z);
            int squaredDistance = distance.x * distance.x + distance.y * distance.y + distance.z * distance.z;
            if (!((double)squaredDistance <= accessPoint.getRange() * accessPoint.getRange()) || (gridCache = (IStorageGrid)grid.getCache(IStorageGrid.class)) == null || (fluidInventory = gridCache.getFluidInventory()) == null) continue;
            GuiHandler.launchGui(GuiHandler.getGuiId(1), player, new Object[]{fluidInventory, this.getWirelessFluidTermHandler(itemStack)});
        }
        return itemStack;
    }

    @Override
    public IPartDefinition parts() {
        return PartDefinition.instance;
    }

    @Override
    public void registerWirelessTermHandler(IWirelessGasFluidTermHandler handler) {
        WirelessTermRegistry.registerWirelessTermHandler(handler);
    }

    @Override
    public void registerWirelessFluidTermHandler(IWirelessFluidTermHandler handler) {
        this.registerWirelessTermHandler(handler);
    }

    @Override
    @Deprecated
    public void registryWirelessFluidTermHandler(IWirelessFluidTermHandler handler) {
        this.registerWirelessFluidTermHandler(handler);
    }

    @Override
    public void registerFuelBurnTime(Fluid fuel, int burnTime) {
        FuelBurnTime.registerFuel(fuel, burnTime);
    }

    @Override
    public boolean isGasStack(IAEFluidStack stack) {
        return stack != null && this.isGasStack(stack.getFluidStack());
    }

    @Override
    public boolean isGasStack(FluidStack stack) {
        return stack != null && this.isGas(stack.getFluid());
    }

    @Override
    public boolean isGas(Fluid fluid) {
        return fluid != null && Integration.Mods.MEKANISMGAS.isEnabled() && this.checkGas(fluid);
    }

    @Override
    public Object createGasStack(IAEFluidStack stack) {
        return Integration.Mods.MEKANISMGAS.isEnabled() ? this.createGasFromFluidStack(stack) : null;
    }

    @Override
    public IAEFluidStack createFluidStackFromGas(Object gasStack) {
        return this.isMekEnabled() ? this.createFluidStackFromGasStack(gasStack) : null;
    }

    @Override
    public Fluid getGasFluid(Object gas) {
        return this.isMekEnabled() ? this.createFluidFromGas(gas) : null;
    }

    @Override
    public void addExternalStorageInterface(IExternalGasStorageHandler esh) {
        if (this.isMekEnabled()) {
            GasStorageRegistry.addExternalStorageInterface(esh);
        }
    }

    @Override
    public IExternalGasStorageHandler getHandler(TileEntity te, ForgeDirection opposite, BaseActionSource mySrc) {
        return this.isMekEnabled() ? GasStorageRegistry.getHandler(te, opposite, mySrc) : null;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private IAEFluidStack createFluidStackFromGasStack(Object gasStack) {
        return gasStack instanceof GasStack ? GasUtil.createAEFluidStack((GasStack)gasStack) : null;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private Fluid createFluidFromGas(Object gas) {
        return gas instanceof Gas ? (MekanismGas.getFluidGasMap().containsKey(gas) ? MekanismGas.getFluidGasMap().get(gas) : null) : null;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private Object createGasFromFluidStack(IAEFluidStack stack) {
        return stack == null ? null : GasUtil.getGasStack(stack.getFluidStack());
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private boolean checkGas(Fluid fluid) {
        return fluid instanceof MekanismGas.GasFluid;
    }

    private boolean isMekEnabled() {
        return Integration.Mods.MEKANISMGAS.isEnabled();
    }
}

