/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.FuzzyPriorityList;
import appeng.util.prioitylist.OreFilteredList;
import appeng.util.prioitylist.PrecisePriorityList;
import extracells.inventory.MEPassThrough;
import extracells.inventory.MEVoidInventoryHandler;
import extracells.inventory.VoidCellInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class VoidCellInventoryHandler
extends MEVoidInventoryHandler<IAEItemStack>
implements ICellInventoryHandler {
    VoidCellInventoryHandler(IMEInventory<IAEItemStack> c) {
        super(c, StorageChannel.ITEMS);
        ICellInventory ci = this.getCellInv();
        if (ci != null) {
            IInventory upgrades = ci.getUpgradesInventory();
            IInventory config = ci.getConfigInventory();
            FuzzyMode fzMode = ci.getFuzzyMode();
            String filter = ci.getOreFilter();
            boolean hasInverter = false;
            boolean hasFuzzy = false;
            boolean hasOreFilter = false;
            block5: for (int x = 0; x < upgrades.func_70302_i_(); ++x) {
                Upgrades u;
                ItemStack is = upgrades.func_70301_a(x);
                if (is == null || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
                switch (u) {
                    case FUZZY: {
                        hasFuzzy = true;
                        continue block5;
                    }
                    case INVERTER: {
                        hasInverter = true;
                        continue block5;
                    }
                    case ORE_FILTER: {
                        hasOreFilter = true;
                        continue block5;
                    }
                }
            }
            this.setWhitelist(hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
            if (hasOreFilter && !filter.isEmpty()) {
                this.setPartitionList(new OreFilteredList(filter));
            } else {
                IItemList priorityList = AEApi.instance().storage().createItemList();
                for (int x = 0; x < config.func_70302_i_(); ++x) {
                    ItemStack is = config.func_70301_a(x);
                    if (is == null) continue;
                    priorityList.add((IAEStack)AEItemStack.create((ItemStack)is));
                }
                if (!priorityList.isEmpty()) {
                    if (hasFuzzy) {
                        this.setPartitionList(new FuzzyPriorityList(priorityList, fzMode));
                    } else {
                        this.setPartitionList(new PrecisePriorityList(priorityList));
                    }
                }
            }
        }
    }

    public ICellInventory getCellInv() {
        IMEInventory o = this.getInternal();
        if (o instanceof MEPassThrough) {
            o = ((MEPassThrough)o).getInternal();
        }
        return (VoidCellInventory)(o instanceof VoidCellInventory ? o : null);
    }

    public boolean isPreformatted() {
        return !this.getPartitionList().isEmpty();
    }

    public boolean isFuzzy() {
        return this.getPartitionList() instanceof FuzzyPriorityList;
    }

    public IncludeExclude getIncludeExcludeMode() {
        return this.getWhitelist();
    }

    public int getStatusForCell() {
        ICellInventory c = this.getCellInv();
        int val = 0;
        if (c != null) {
            val = this.getCellInv().getStatusForCell();
        }
        if (val == 1 && this.isPreformatted()) {
            val = 2;
        }
        return val;
    }
}

