/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.util.InventoryAdaptor;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import extracells.api.IECTileEntity;
import extracells.api.IFluidInterface;
import extracells.api.crafting.IFluidCraftingPatternDetails;
import extracells.container.IContainerListener;
import extracells.crafting.CraftingPattern;
import extracells.crafting.CraftingPattern2;
import extracells.gridblock.ECFluidGridBlock;
import extracells.integration.waila.IWailaTile;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.registries.ItemEnum;
import extracells.tileentity.TileBase;
import extracells.util.EmptyMeItemMonitor;
import extracells.util.FluidUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityFluidInterface
extends TileBase
implements IActionHost,
IFluidHandler,
IECTileEntity,
IFluidInterface,
IFluidSlotPartOrBlock,
ITileStorageMonitorable,
IStorageMonitorable,
ICraftingProvider,
IWailaTile {
    List<IContainerListener> listeners = new ArrayList<IContainerListener>();
    private ECFluidGridBlock gridBlock;
    private IGridNode node = null;
    public FluidTank[] tanks = new FluidTank[6];
    public Integer[] fluidFilter = new Integer[this.tanks.length];
    public boolean doNextUpdate = false;
    private boolean wasIdle = false;
    private int tickCount = 0;
    private boolean update = false;
    private List<ICraftingPatternDetails> patternHandlers = new ArrayList<ICraftingPatternDetails>();
    private HashMap<ICraftingPatternDetails, IFluidCraftingPatternDetails> patternConvert = new HashMap();
    private final ICraftingPatternDetails[] originalPatternsCache = new ICraftingPatternDetails[9];
    private List<IAEItemStack> requestedItems = new ArrayList<IAEItemStack>();
    private List<IAEItemStack> removeList = new ArrayList<IAEItemStack>();
    public final FluidInterfaceInventory inventory;
    private IAEItemStack toExport = null;
    private final Item encodedPattern = (Item)AEApi.instance().definitions().items().encodedPattern().maybeItem().orNull();
    private List<IAEStack> export = new ArrayList<IAEStack>();
    private List<IAEStack> addToExport = new ArrayList<IAEStack>();
    private List<IAEItemStack> watcherList = new ArrayList<IAEItemStack>();
    private boolean isFirstGetGridNode = true;

    public TileEntityFluidInterface() {
        this.inventory = new FluidInterfaceInventory();
        this.gridBlock = new ECFluidGridBlock(this);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(10000){

                public FluidTank readFromNBT(NBTTagCompound nbt) {
                    if (!nbt.func_74764_b("Empty")) {
                        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                        this.setFluid(fluid);
                    } else {
                        this.setFluid(null);
                    }
                    return this;
                }
            };
            this.fluidFilter[i] = -1;
        }
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.UNKNOWN) {
            return false;
        }
        FluidStack tankFluid = this.tanks[from.ordinal()].getFluid();
        return tankFluid != null && tankFluid.getFluid() == fluid;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UNKNOWN && this.tanks[from.ordinal()].fill(new FluidStack(fluid, 1), false) > 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack tankFluid = this.tanks[from.ordinal()].getFluid();
        if (resource == null || tankFluid == null || tankFluid.getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.UNKNOWN) {
            return null;
        }
        FluidStack drained = this.tanks[from.ordinal()].drain(maxDrain, doDrain);
        if (drained != null && this.func_145831_w() != null) {
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.doNextUpdate = true;
        return drained;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from == ForgeDirection.UNKNOWN || resource == null) {
            return 0;
        }
        if ((this.tanks[from.ordinal()].getFluid() == null || this.tanks[from.ordinal()].getFluid().getFluid() == resource.getFluid()) && resource.getFluid() == FluidRegistry.getFluid((int)this.fluidFilter[from.ordinal()])) {
            int added = this.tanks[from.ordinal()].fill(resource.copy(), doFill);
            if (added == resource.amount) {
                this.doNextUpdate = true;
                return added;
            }
            added += this.fillToNetwork(new FluidStack(resource.getFluid(), resource.amount - added), doFill);
            this.doNextUpdate = true;
            return added;
        }
        int filled = 0;
        if ((filled += this.fillToNetwork(resource, doFill)) < resource.amount) {
            filled += this.tanks[from.ordinal()].fill(new FluidStack(resource.getFluid(), resource.amount - filled), doFill);
        }
        if (filled > 0 && this.func_145831_w() != null) {
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.doNextUpdate = true;
        return filled;
    }

    public int fillToNetwork(FluidStack resource, boolean doFill) {
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (node == null || resource == null) {
            return 0;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return 0;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return 0;
        }
        IAEFluidStack notRemoved = (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(resource), doFill ? Actionable.MODULATE : Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        if (notRemoved == null) {
            return resource.amount;
        }
        return (int)((long)resource.amount - notRemoved.getStackSize());
    }

    private void forceUpdate() {
        this.func_145831_w().func_147471_g(this.field_145848_d, this.field_145848_d, this.field_145849_e);
        for (IContainerListener listener : this.listeners) {
            if (listener == null) continue;
            listener.updateContainer();
        }
        this.doNextUpdate = false;
    }

    public IGridNode getActionableNode() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return null;
        }
        if (this.node == null) {
            this.node = AEApi.instance().createGridNode((IGridBlock)this.gridBlock);
        }
        return this.node;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBTWithoutExport(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    @Override
    public Fluid getFilter(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return FluidRegistry.getFluid((int)this.fluidFilter[side.ordinal()]);
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return this.getFluidInventory(ForgeDirection.UNKNOWN);
    }

    @Override
    public IFluidTank getFluidTank(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return this.tanks[side.ordinal()];
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        if (FMLCommonHandler.instance().getSide().isClient() && (this.func_145831_w() == null || this.func_145831_w().field_72995_K)) {
            return null;
        }
        if (this.isFirstGetGridNode) {
            this.isFirstGetGridNode = false;
            this.getActionableNode().updateState();
        }
        return this.node;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return new EmptyMeItemMonitor();
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src) {
        return this;
    }

    @Override
    public IInventory getPatternInventory() {
        return this.inventory;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == ForgeDirection.UNKNOWN) {
            return null;
        }
        return new FluidTankInfo[]{this.tanks[from.ordinal()].getInfo()};
    }

    @Override
    public List<String> getWailaBody(List<String> list, NBTTagCompound tag, ForgeDirection side) {
        int i;
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return list;
        }
        list.add(StatCollector.func_74838_a((String)("extracells.tooltip.direction." + side.ordinal())));
        FluidTank[] tanks = new FluidTank[6];
        for (i = 0; i < tanks.length; ++i) {
            tanks[i] = new FluidTank(10000){

                public FluidTank readFromNBT(NBTTagCompound nbt) {
                    if (!nbt.func_74764_b("Empty")) {
                        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                        this.setFluid(fluid);
                    } else {
                        this.setFluid(null);
                    }
                    return this;
                }
            };
        }
        for (i = 0; i < tanks.length; ++i) {
            if (!tag.func_74764_b("tank#" + i)) continue;
            tanks[i].readFromNBT(tag.func_74775_l("tank#" + i));
        }
        FluidTank tank = tanks[side.ordinal()];
        if (tank == null || tank.getFluid() == null || tank.getFluid().getFluid() == null) {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + StatCollector.func_74838_a((String)"extracells.tooltip.empty1"));
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": 0mB / 10000mB");
        } else {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + tank.getFluid().getLocalizedName());
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": " + tank.getFluidAmount() + "mB / 10000mB");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        for (int i = 0; i < this.tanks.length; ++i) {
            tag.func_74782_a("tank#" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public boolean isBusy() {
        return !this.export.isEmpty();
    }

    private ItemStack makeCraftingPatternItem(ICraftingPatternDetails details) {
        if (details == null) {
            return null;
        }
        NBTTagList in = new NBTTagList();
        NBTTagList out = new NBTTagList();
        for (IAEItemStack s : details.getInputs()) {
            if (s == null) {
                in.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            in.func_74742_a((NBTBase)s.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        for (IAEItemStack s : details.getOutputs()) {
            if (s == null) {
                out.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            out.func_74742_a((NBTBase)s.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        NBTTagCompound itemTag = new NBTTagCompound();
        itemTag.func_74782_a("in", (NBTBase)in);
        itemTag.func_74782_a("out", (NBTBase)out);
        itemTag.func_74757_a("crafting", details.isCraftable());
        ItemStack pattern = new ItemStack(this.encodedPattern);
        pattern.func_77982_d(itemTag);
        return pattern;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.patternHandlers = new ArrayList<ICraftingPatternDetails>();
        this.patternConvert.clear();
        ItemStack[] inv = this.inventory.inv;
        int invLength = inv.length;
        for (int i = 0; i < invLength; ++i) {
            ItemStack currentPatternStack = inv[i];
            if (currentPatternStack == null || currentPatternStack.func_77973_b() == null || !(currentPatternStack.func_77973_b() instanceof ICraftingPatternItem)) continue;
            ICraftingPatternItem currentPattern = (ICraftingPatternItem)currentPatternStack.func_77973_b();
            ICraftingPatternDetails originalPattern = this.originalPatternsCache[i];
            if (originalPattern == null) {
                this.originalPatternsCache[i] = originalPattern = currentPattern.getPatternForItem(currentPatternStack, this.func_145831_w());
            }
            if (originalPattern == null) continue;
            CraftingPattern2 pattern = new CraftingPattern2(originalPattern);
            this.patternHandlers.add(pattern);
            ItemStack is = this.makeCraftingPatternItem(pattern);
            if (is == null) continue;
            ICraftingPatternDetails p = ((ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.func_145831_w());
            this.patternConvert.put(p, pattern);
            craftingTracker.addCraftingOption((ICraftingMedium)this, p);
        }
    }

    private void pushItems() {
        ForgeDirection[] directions;
        this.export.addAll(this.addToExport);
        this.addToExport.clear();
        if (!this.func_145830_o() || this.export.isEmpty()) {
            return;
        }
        for (ForgeDirection dir : directions = ForgeDirection.VALID_DIRECTIONS) {
            int amount;
            TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (tile == null) continue;
            IAEStack stack0 = this.export.get(0);
            IAEStack stack = stack0.copy();
            if (stack instanceof IAEItemStack && tile instanceof IInventory) {
                ItemStack adding;
                InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor((Object)tile, (ForgeDirection)dir.getOpposite());
                if (adaptor == null) continue;
                int originalAddingAmount = adding.field_77994_a;
                adding = ((IAEItemStack)stack).getItemStack();
                ItemStack leftover = adaptor.addItems(adding);
                int leftoverAmount = leftover == null ? 0 : leftover.field_77994_a;
                int removedAmount = originalAddingAmount - leftoverAmount;
                if ((long)removedAmount == stack0.getStackSize()) {
                    this.export.remove(0);
                } else {
                    this.export.get(0).setStackSize(stack0.getStackSize() - (long)removedAmount);
                }
                return;
            }
            if (!(stack instanceof IAEFluidStack) || !(tile instanceof IFluidHandler)) continue;
            IFluidHandler handler = (IFluidHandler)tile;
            IAEFluidStack fluid = (IAEFluidStack)stack;
            if (!handler.canFill(dir.getOpposite(), fluid.copy().getFluid()) || (amount = handler.fill(dir.getOpposite(), fluid.getFluidStack().copy(), false)) == 0) continue;
            if ((long)amount == fluid.getStackSize()) {
                handler.fill(dir.getOpposite(), fluid.getFluidStack().copy(), true);
                this.export.remove(0);
                continue;
            }
            FluidStack fl = fluid.getFluidStack().copy();
            fl.amount = amount;
            this.export.get(0).setStackSize(fluid.getStackSize() - (long)handler.fill(dir.getOpposite(), fl, true));
            return;
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patDetails, InventoryCrafting table) {
        if (this.isBusy() || !this.patternConvert.containsKey(patDetails)) {
            return false;
        }
        ICraftingPatternDetails patternDetails = this.patternConvert.get(patDetails);
        if (patternDetails instanceof CraftingPattern) {
            IAEFluidStack extractFluid;
            Long amount;
            CraftingPattern patter = (CraftingPattern)patternDetails;
            HashMap<Fluid, Long> fluids = new HashMap<Fluid, Long>();
            for (IAEFluidStack stack : patter.getCondensedFluidInputs()) {
                if (fluids.containsKey(stack.getFluid())) {
                    amount = (Long)fluids.get(stack.getFluid()) + stack.getStackSize();
                    fluids.remove(stack.getFluid());
                    fluids.put(stack.getFluid(), amount);
                    continue;
                }
                fluids.put(stack.getFluid(), stack.getStackSize());
            }
            IGrid grid = this.node.getGrid();
            if (grid == null) {
                return false;
            }
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            if (storage == null) {
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(fluid, amount.intValue())), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (extractFluid != null && extractFluid.getStackSize() == amount.longValue()) continue;
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(fluid, amount.intValue())), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                this.export.add((IAEStack)extractFluid.copy());
            }
            for (IAEItemStack s : patter.getCondensedInputs()) {
                if (s == null) continue;
                if (s.getItem() == ItemEnum.FLUIDPATTERN.getItem()) {
                    this.toExport = s.copy();
                    continue;
                }
                this.export.add((IAEStack)s.copy());
            }
        }
        return true;
    }

    public void readFilter(NBTTagCompound tag) {
        for (int i = 0; i < this.fluidFilter.length; ++i) {
            if (!tag.func_74764_b("fluid#" + i)) continue;
            this.fluidFilter[i] = tag.func_74762_e("fluid#" + i);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < this.tanks.length; ++i) {
            if (tag.func_74764_b("tank#" + i)) {
                this.tanks[i].readFromNBT(tag.func_74775_l("tank#" + i));
            }
            if (!tag.func_74764_b("filter#" + i)) continue;
            this.fluidFilter[i] = tag.func_74762_e("filter#" + i);
        }
        if (this.func_145830_o()) {
            IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
            if (tag.func_74764_b("nodes") && node != null) {
                node.loadFromNBT("node0", tag.func_74775_l("nodes"));
                node.updateState();
            }
        }
        if (tag.func_74764_b("inventory")) {
            this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        }
        if (tag.func_74764_b("export")) {
            this.readOutputFromNBT(tag.func_74775_l("export"));
        }
    }

    private void readOutputFromNBT(NBTTagCompound tag) {
        IAEItemStack s;
        int j;
        this.addToExport.clear();
        this.export.clear();
        int i = tag.func_74762_e("add");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("add-" + j + "-isItem")) {
                s = AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("add-" + j)));
                s.setStackSize(tag.func_74763_f("add-" + j + "-amount"));
                this.addToExport.add((IAEStack)s);
                continue;
            }
            s = AEApi.instance().storage().createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("add-" + j)));
            s.setStackSize(tag.func_74763_f("add-" + j + "-amount"));
            this.addToExport.add((IAEStack)s);
        }
        i = tag.func_74762_e("export");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("export-" + j + "-isItem")) {
                s = AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("export-" + j)));
                s.setStackSize(tag.func_74763_f("export-" + j + "-amount"));
                this.export.add((IAEStack)s);
                continue;
            }
            s = AEApi.instance().storage().createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("export-" + j)));
            s.setStackSize(tag.func_74763_f("export-" + j + "-amount"));
            this.export.add((IAEStack)s);
        }
    }

    public void registerListener(IContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IContainerListener listener) {
        this.listeners.remove(listener);
    }

    public void securityBreak() {
    }

    @Override
    public void setFilter(ForgeDirection side, Fluid fluid) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return;
        }
        if (fluid == null) {
            this.fluidFilter[side.ordinal()] = -1;
            this.doNextUpdate = true;
            return;
        }
        this.fluidFilter[side.ordinal()] = fluid.getID();
        this.doNextUpdate = true;
    }

    @Override
    public void setFluid(int _index, Fluid _fluid, EntityPlayer _player) {
        this.setFilter(ForgeDirection.getOrientation((int)_index), _fluid);
    }

    @Override
    public void setFluidTank(ForgeDirection side, FluidStack fluid) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return;
        }
        this.tanks[side.ordinal()].setFluid(fluid);
        this.doNextUpdate = true;
    }

    private void tick() {
        if (this.tickCount < 40 && this.wasIdle) {
            ++this.tickCount;
            return;
        }
        this.tickCount = 0;
        this.wasIdle = true;
        if (this.node == null) {
            return;
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            return;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return;
        }
        if (this.toExport != null) {
            storage.getItemInventory().injectItems((IAEStack)this.toExport, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            this.toExport = null;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            int accepted;
            FluidStack s;
            FluidTank tank = this.tanks[i];
            if (tank.getFluid() != null && FluidRegistry.getFluid((int)this.fluidFilter[i]) != tank.getFluid().getFluid() && (s = tank.drain(1000, false)) != null) {
                int returned;
                IAEFluidStack notAdded = (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(s), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                int toAdd = s.amount - (notAdded != null ? (int)notAdded.getStackSize() : 0);
                IAEFluidStack actuallyNotInjected = (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(tank.drain(toAdd, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (actuallyNotInjected != null && (long)(returned = tank.fill(actuallyNotInjected.getFluidStack(), true)) != actuallyNotInjected.getStackSize()) {
                    FMLLog.severe((String)"[ExtraCells2] Interface tank import at %d:%d,%d,%d voided %d mL of %s", (Object[])new Object[]{this.func_145831_w().field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, actuallyNotInjected.getStackSize() - (long)returned, actuallyNotInjected.getFluid().getName()});
                }
                this.doNextUpdate = true;
            }
            if (tank.getFluid() != null && (tank.getFluid().getFluid() != FluidRegistry.getFluid((int)this.fluidFilter[i]) || tank.getFluidAmount() >= tank.getCapacity()) || FluidRegistry.getFluid((int)this.fluidFilter[i]) == null) continue;
            IAEFluidStack request = FluidUtil.createAEFluidStack(this.fluidFilter[i], 1000L);
            IAEFluidStack extracted = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)request, Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            if (extracted == null || (accepted = tank.fill(extracted.getFluidStack(), false)) == 0) continue;
            request.setStackSize(Long.min(accepted, extracted.getStackSize()));
            extracted = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)request, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            if (extracted == null || extracted.getStackSize() <= 0L) continue;
            accepted = tank.fill(extracted.getFluidStack(), true);
            if (extracted.getStackSize() != (long)accepted) {
                FMLLog.severe((String)"[ExtraCells2] Interface tank export at %d:%d,%d,%d voided %d mL of %s", (Object[])new Object[]{this.func_145831_w().field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, extracted.getStackSize() - (long)accepted, request.getFluid().getName()});
            }
            this.doNextUpdate = true;
        }
    }

    public void func_145845_h() {
        if (this.func_145831_w() == null || this.func_145831_w().field_73011_w == null || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.update) {
            this.update = false;
            if (this.getGridNode(ForgeDirection.UNKNOWN) != null && this.getGridNode(ForgeDirection.UNKNOWN).getGrid() != null) {
                this.getGridNode(ForgeDirection.UNKNOWN).getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getGridNode(ForgeDirection.UNKNOWN)));
            }
        }
        this.pushItems();
        if (this.doNextUpdate) {
            this.forceUpdate();
        }
        this.tick();
    }

    public NBTTagCompound writeFilter(NBTTagCompound tag) {
        for (int i = 0; i < this.fluidFilter.length; ++i) {
            tag.func_74768_a("fluid#" + i, this.fluidFilter[i].intValue());
        }
        return tag;
    }

    private NBTTagCompound writeOutputToNBT(NBTTagCompound tag) {
        NBTTagCompound data;
        int i = 0;
        i = 0;
        for (IAEStack s : this.addToExport) {
            if (s != null) {
                tag.func_74757_a("add-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).getItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("add-" + i, (NBTBase)data);
                tag.func_74772_a("add-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("add", this.addToExport.size());
        i = 0;
        for (IAEStack s : this.export) {
            if (s != null) {
                tag.func_74757_a("export-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).getItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("export-" + i, (NBTBase)data);
                tag.func_74772_a("export-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("export", this.export.size());
        return tag;
    }

    public void func_145841_b(NBTTagCompound data) {
        this.writeToNBTWithoutExport(data);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeOutputToNBT(tag);
        data.func_74782_a("export", (NBTBase)tag);
    }

    public void writeToNBTWithoutExport(NBTTagCompound tag) {
        super.func_145841_b(tag);
        for (int i = 0; i < this.tanks.length; ++i) {
            tag.func_74782_a("tank#" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
            tag.func_74768_a("filter#" + i, this.fluidFilter[i].intValue());
        }
        if (!this.func_145830_o()) {
            return;
        }
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (node != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            node.saveToNBT("node0", nodeTag);
            tag.func_74782_a("nodes", (NBTBase)nodeTag);
        }
        NBTTagCompound inventory = new NBTTagCompound();
        this.inventory.writeToNBT(inventory);
        tag.func_74782_a("inventory", (NBTBase)inventory);
    }

    private class FluidInterfaceInventory
    implements IInventory {
        private ItemStack[] inv = new ItemStack[9];

        private FluidInterfaceInventory() {
        }

        public void func_70305_f() {
        }

        public ItemStack func_70298_a(int slot, int amt) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null) {
                if (stack.field_77994_a <= amt) {
                    this.func_70299_a(slot, null);
                } else {
                    stack = stack.func_77979_a(amt);
                    if (stack.field_77994_a == 0) {
                        this.func_70299_a(slot, null);
                    }
                }
            }
            TileEntityFluidInterface.this.update = true;
            return stack;
        }

        public String func_145825_b() {
            return "inventory.fluidInterface";
        }

        public int func_70297_j_() {
            return 1;
        }

        public int func_70302_i_() {
            return this.inv.length;
        }

        public ItemStack func_70301_a(int slot) {
            return this.inv[slot];
        }

        public ItemStack func_70304_b(int slot) {
            return null;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            if (stack.func_77973_b() instanceof ICraftingPatternItem) {
                ICraftingPatternDetails details = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, TileEntityFluidInterface.this.func_145831_w());
                return details != null;
            }
            return false;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_70296_d() {
        }

        public void func_70295_k_() {
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.inv[slot] = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
            ((TileEntityFluidInterface)TileEntityFluidInterface.this).originalPatternsCache[slot] = null;
            TileEntityFluidInterface.this.update = true;
        }

        public void writeToNBT(NBTTagCompound tagCompound) {
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.inv.length; ++i) {
                ItemStack stack = this.inv[i];
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        }
    }
}

