/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryHelper {
    public static boolean match(ItemStack itemStack1, ItemStack itemStack2) {
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)itemStack1);
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)itemStack2);
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ItemStack> getPermutationsList(ItemStack itemStack) {
        ArrayList<ItemStack> permutations = new ArrayList<ItemStack>();
        for (int id : OreDictionary.getOreIDs((ItemStack)itemStack)) {
            permutations.addAll(OreDictionaryHelper.getPermutationsList(OreDictionary.getOreName((int)id)));
        }
        if (permutations.size() == 0) {
            permutations.add(itemStack);
        }
        return OreDictionaryHelper.stripWildcardDamage(permutations);
    }

    public static ItemStack[] getPermutations(ItemStack itemStack) {
        List<ItemStack> permutations = OreDictionaryHelper.getPermutationsList(itemStack);
        return permutations.toArray(new ItemStack[permutations.size()]);
    }

    public static List<ItemStack> getPermutationsList(String oreName) {
        return OreDictionaryHelper.stripWildcardDamage(OreDictionary.getOres((String)oreName));
    }

    public static ItemStack[] getPermutations(String oreName) {
        List<ItemStack> permutations = OreDictionaryHelper.getPermutationsList(oreName);
        return permutations.toArray(new ItemStack[permutations.size()]);
    }

    public static String[] getOreNames(ItemStack itemStack) {
        ArrayList<String> names = new ArrayList<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)itemStack)) {
            names.add(OreDictionary.getOreName((int)id));
        }
        return names.toArray(new String[names.size()]);
    }

    private static List<ItemStack> stripWildcardDamage(List<ItemStack> list) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(list.size());
        for (ItemStack itemStack : list) {
            result.add(new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, itemStack.func_77960_j() == Short.MAX_VALUE ? 0 : itemStack.func_77960_j()));
        }
        return result;
    }
}

