/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.Translator;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;

public final class SaveHelper {
    private static boolean isLarge = true;
    private static long saveTime;
    private static int total;
    private static ListElement[] list;
    private static List<ListElement> sortedList;
    private static final int START_X = 5;
    private static final int START_Y = 30;
    private static final int INDENT = 5;
    private static final int FONT_HEIGHT = 7;
    private static final int LISTED_TYPES = 7;
    private static final int X = 342;
    private static final int Y = 5;
    private static final int SRC_X = 0;
    private static final int SRC_Y = 123;
    private static final int WIDTH = 104;
    private static final int HEIGHT = 110;
    private static final int CHANGE_X = 4;
    private static final int CHANGE_Y = 4;
    private static final int CHANGE_SIZE = 7;
    private static final int CHANGE_SRC_X = 104;
    private static final int SMALL_SRC_X = 104;
    private static final int SMALL_SRC_Y = 137;
    private static final int SMALL_SIZE = 29;
    private static final int SAVE_X = 11;
    private static final int SAVE_Y = 11;
    private static final int SAVE_SRC_X = 118;
    private static final int SAVE_SIZE = 14;

    private static void createList() {
        list = new ListElement[EditType.values().length];
        for (int i = 0; i < list.length; ++i) {
            SaveHelper.list[i] = new ListElement(EditType.values()[i]);
        }
        sortedList = new ArrayList<ListElement>();
        Collections.addAll(sortedList, list);
        Collections.sort(sortedList);
        total = 0;
    }

    public static void add(EditType type, int count) {
        ListElement listElement = list[type.ordinal()];
        listElement.count = listElement.count + count;
        Collections.sort(sortedList);
        total += count;
    }

    public static void add(EditType type) {
        SaveHelper.add(type, 1);
    }

    public static void onSave() {
        saveTime = Minecraft.func_71386_F();
        SaveHelper.createList();
    }

    public static void onLoad() {
        SaveHelper.createList();
    }

    @SideOnly(value=Side.CLIENT)
    public static void render(GuiQuestBook gui, int mX, int mY) {
        if (isLarge) {
            gui.drawRect(342, 5, 0, 123, 104, 110);
        } else {
            gui.drawRect(342, 5, 104, 137, 29, 29);
        }
        int indexX = isLarge ? 0 : 1;
        int indexY = gui.inBounds(346, 9, 7, 7, mX, mY) ? 1 : 0;
        gui.drawRect(346, 9, 104 + indexX * 7, 123 + indexY * 7, 7, 7);
        if (isLarge) {
            if (total == 0) {
                gui.drawString(Translator.translate("hqm.editType.allSaved"), 347, 35, 0.7f, 0x404040);
            } else {
                ListElement element;
                if (saveTime == 0L) {
                    gui.drawString(Translator.translate("hqm.editType.neverSaved"), 347, 35, 0.7f, 0x404040);
                } else {
                    gui.drawString(SaveHelper.formatTime((int)((Minecraft.func_71386_F() - saveTime) / 60000L)), 347, 35, 0.7f, 0x404040);
                }
                gui.drawString(Translator.translate("hqm.editType.unsaved", total), 347, 49, 0.7f, 0x404040);
                int others = total;
                for (int i = 0; i < 7 && (element = sortedList.get(i)).count != 0; ++i) {
                    gui.drawString(element.type.translate(element.count), 352, 35 + (i + 3) * 7, 0.7f, 0x404040);
                    others -= element.count;
                }
                if (others > 0) {
                    gui.drawString(Translator.translate("hqm.editType.other", others), 352, 105, 0.7f, 0x404040);
                }
            }
        } else {
            int index = SaveHelper.inSaveBounds(gui, mX, mY) ? 1 : 0;
            gui.drawRect(353, 16, 118 + index * 14, 123, 14, 14);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void onClick(GuiQuestBook gui, int mX, int mY) {
        if (gui.inBounds(346, 9, 7, 7, mX, mY)) {
            isLarge = !isLarge;
        } else if (SaveHelper.inSaveBounds(gui, mX, mY)) {
            gui.save();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean inSaveBounds(GuiQuestBook gui, int mX, int mY) {
        return !isLarge && gui.inBounds(353, 16, 14, 14, mX, mY);
    }

    private static String formatTime(int minutes) {
        int hours = minutes / 60;
        minutes -= hours * 60;
        if (hours == 0) {
            if (minutes == 0) {
                return Translator.translate("hqm.editType.savedRecent");
            }
            return Translator.translate(minutes != 1, "hqm.editType.savedMinutes", minutes);
        }
        return Translator.translate(hours != 1, "hqm.editType.savedMinutes", hours);
    }

    public static boolean isLarge() {
        return isLarge;
    }

    private SaveHelper() {
    }

    static {
        SaveHelper.createList();
    }

    public static class ListElement
    implements Comparable<ListElement> {
        private EditType type;
        private int count;

        private ListElement(EditType type) {
            this.type = type;
            this.count = 0;
        }

        @Override
        public int compareTo(ListElement o) {
            return Integer.valueOf(o.count).compareTo(this.count);
        }
    }

    public static enum EditType {
        QUEST_CREATE(BaseEditType.ADD, Type.QUEST),
        QUEST_REMOVE(BaseEditType.REMOVE, Type.QUEST),
        TASK_CREATE(BaseEditType.ADD, Type.TASK),
        TASK_REMOVE(BaseEditType.REMOVE, Type.TASK),
        TASK_CHANGE_TYPE(BaseEditType.ADD, Type.TASK_TYPE),
        REQUIREMENT_CHANGE(BaseEditType.CHANGE, Type.REQUIREMENT),
        REQUIREMENT_REMOVE(BaseEditType.REMOVE, Type.REQUIREMENT),
        REPEATABILITY_CHANGED(BaseEditType.CHANGE, Type.REPEATABILITY),
        VISIBILITY_CHANGED(BaseEditType.CHANGE, Type.VISIBILITY),
        PARENT_REQUIREMENT_CHANGED(BaseEditType.CHANGE, Type.PARENT),
        OPTION_CHANGE(BaseEditType.ADD, Type.OPTION),
        OPTION_REMOVE(BaseEditType.REMOVE, Type.OPTION),
        NAME_CHANGE(BaseEditType.CHANGE, Type.NAME),
        DESCRIPTION_CHANGE(BaseEditType.CHANGE, Type.DESCRIPTION),
        ICON_CHANGE(BaseEditType.CHANGE, Type.ICON),
        QUEST_SIZE_CHANGE(BaseEditType.CHANGE, Type.QUEST_SIZE),
        QUEST_MOVE(BaseEditType.MOVE, Type.QUEST),
        QUEST_CHANGE_SET(BaseEditType.MOVE, Type.BETWEEN_SETS),
        SET_CREATE(BaseEditType.ADD, Type.SET),
        SET_REMOVE(BaseEditType.REMOVE, Type.SET),
        REWARD_CREATE(BaseEditType.ADD, Type.REWARD),
        REWARD_CHANGE(BaseEditType.CHANGE, Type.REWARD),
        REWARD_REMOVE(BaseEditType.REMOVE, Type.REWARD),
        MONSTER_CREATE(BaseEditType.ADD, Type.MONSTER),
        MONSTER_CHANGE(BaseEditType.CHANGE, Type.MONSTER),
        MONSTER_REMOVE(BaseEditType.REMOVE, Type.MONSTER),
        LOCATION_CREATE(BaseEditType.ADD, Type.LOCATION),
        LOCATION_CHANGE(BaseEditType.CHANGE, Type.LOCATION),
        LOCATION_REMOVE(BaseEditType.REMOVE, Type.LOCATION),
        TIER_CREATE(BaseEditType.ADD, Type.TIER),
        TIER_CHANGE(BaseEditType.CHANGE, Type.TIER),
        TIER_REMOVE(BaseEditType.REMOVE, Type.TIER),
        GROUP_CREATE(BaseEditType.ADD, Type.GROUP),
        GROUP_CHANGE(BaseEditType.CHANGE, Type.GROUP),
        GROUP_REMOVE(BaseEditType.REMOVE, Type.GROUP),
        GROUP_ITEM_CREATE(BaseEditType.ADD, Type.GROUP_ITEM),
        GROUP_ITEM_CHANGE(BaseEditType.REMOVE, Type.GROUP_ITEM),
        GROUP_ITEM_REMOVE(BaseEditType.REMOVE, Type.GROUP_ITEM),
        DEATH_CHANGE(BaseEditType.CHANGE, Type.DEATH),
        TASK_ITEM_CREATE(BaseEditType.ADD, Type.TASK_ITEM),
        TASK_ITEM_CHANGE(BaseEditType.CHANGE, Type.TASK_ITEM),
        TASK_ITEM_REMOVE(BaseEditType.REMOVE, Type.TASK_ITEM),
        REPUTATION_ADD(BaseEditType.ADD, Type.REPUTATION),
        REPUTATION_REMOVE(BaseEditType.REMOVE, Type.REPUTATION),
        REPUTATION_MARKER_CREATE(BaseEditType.ADD, Type.REPUTATION_MARKER),
        REPUTATION_MARKER_CHANGE(BaseEditType.CHANGE, Type.REPUTATION_MARKER),
        REPUTATION_MARKER_REMOVE(BaseEditType.REMOVE, Type.REPUTATION_MARKER),
        REPUTATION_TASK_CREATE(BaseEditType.ADD, Type.REPUTATION_TASK),
        REPUTATION_TASK_CHANGE(BaseEditType.CHANGE, Type.REPUTATION_TASK),
        REPUTATION_TASK_REMOVE(BaseEditType.REMOVE, Type.REPUTATION_TASK),
        REPUTATION_REWARD_CHANGE(BaseEditType.CHANGE, Type.REPUTATION_REWARD),
        KILLS_CHANGE(BaseEditType.CHANGE, Type.KILLS),
        REPUTATION_BAR_ADD(BaseEditType.ADD, Type.REPUTATION_BAR),
        REPUTATION_BAR_MOVE(BaseEditType.MOVE, Type.REPUTATION_BAR),
        REPUTATION_BAR_CHANGE(BaseEditType.CHANGE, Type.REPUTATION_BAR),
        REPUTATION_BAR_REMOVE(BaseEditType.REMOVE, Type.REPUTATION_BAR),
        COMMAND_ADD(BaseEditType.ADD, Type.COMMAND),
        COMMAND_CHANGE(BaseEditType.CHANGE, Type.COMMAND),
        COMMAND_REMOVE(BaseEditType.REMOVE, Type.COMMAND);

        private BaseEditType basType;
        private Type type;

        private EditType(BaseEditType basType, Type type) {
            this.basType = basType;
            this.type = type;
        }

        public String translate(int number) {
            return this.basType.translate() + " " + this.type.translate() + ": " + (Object)((Object)this.basType.colour) + number;
        }

        private static enum Type {
            QUEST("quest"),
            TASK("task"),
            TASK_TYPE("taskType"),
            REQUIREMENT("req"),
            REPEATABILITY("repeat"),
            VISIBILITY("vis"),
            PARENT("parent"),
            OPTION("option"),
            NAME("name"),
            DESCRIPTION("desc"),
            ICON("icon"),
            QUEST_SIZE("questSize"),
            SET("set"),
            REWARD("reward"),
            MONSTER("monster"),
            LOCATION("location"),
            TIER("tier"),
            GROUP("group"),
            GROUP_ITEM("groupItem"),
            DEATH("death"),
            TASK_ITEM("taskItem"),
            REPUTATION("rep"),
            REPUTATION_MARKER("repMark"),
            REPUTATION_TASK("repTask"),
            REPUTATION_REWARD("repReward"),
            KILLS("kills"),
            REPUTATION_BAR("repBar"),
            BETWEEN_SETS("betweenSets"),
            COMMAND("command");

            private String id;

            private Type(String id) {
                this.id = id;
            }

            private String translate() {
                return Translator.translate("hqm.editType." + this.id);
            }
        }

        private static enum BaseEditType {
            ADD("added", GuiColor.GREEN),
            CHANGE("changed", GuiColor.ORANGE),
            MOVE("moved", GuiColor.ORANGE),
            REMOVE("removed", GuiColor.RED);

            private String id;
            private GuiColor colour;

            private BaseEditType(String id, GuiColor colour) {
                this.id = id;
                this.colour = colour;
            }

            private String translate() {
                return Translator.translate("hqm.editType." + this.id);
            }
        }
    }
}

