/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import java.util.IllegalFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class Translator {
    private static Pattern pluralPattern = Pattern.compile("\\[\\[(.*)\\|\\|(.*)\\]\\]");

    public static String translate(String id) {
        return StatCollector.func_74838_a((String)id).replace("\\n", "\n");
    }

    public static String translate(String id, Object ... args) {
        return Translator.translate(false, id, args);
    }

    public static String translate(boolean plural, String id, Object ... args) {
        return Translator.format(Translator.translate(id), plural, args);
    }

    public static IChatComponent translateToIChatComponent(String id, Object ... args) {
        return Translator.translateToIChatComponent(EnumChatFormatting.WHITE, id, args);
    }

    public static IChatComponent translateToIChatComponent(EnumChatFormatting colour, String id, Object ... args) {
        return Translator.translateToIChatComponent(colour, false, id, args);
    }

    public static IChatComponent translateToIChatComponent(EnumChatFormatting colour, boolean plural, String id, Object ... args) {
        ChatComponentText iChatComponent = new ChatComponentText(Translator.translate(plural, id, args));
        iChatComponent.func_150256_b().func_150238_a(colour);
        return iChatComponent;
    }

    public static String format(String s, boolean plural, Object ... args) {
        if (s == null) {
            return s;
        }
        try {
            Matcher matcher = pluralPattern.matcher(s);
            while (matcher.find()) {
                s = matcher.replaceFirst(matcher.group(plural ? 2 : 1));
                matcher = pluralPattern.matcher(s);
            }
            return String.format(s, args);
        }
        catch (IllegalFormatException e) {
            return "Format Exception: " + s;
        }
    }
}

