/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.client.interfaces.GuiEditMenu;
import hardcorequesting.client.interfaces.RenderRotation;
import hardcorequesting.client.interfaces.ResourceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBase
extends GuiScreen {
    protected int left;
    protected int top;
    public static final ResourceLocation MAP_TEXTURE = ResourceHelper.getResource("questmap");
    protected static final ResourceLocation TERRAIN = new ResourceLocation("textures/atlas/blocks.png");
    protected static RenderItem itemRenderer = new RenderItem();
    protected static RenderBlocks blockRenderer = new RenderBlocks();
    protected static final int ITEM_SRC_Y = 235;
    public static final int ITEM_SIZE = 18;

    public void setEditMenu(GuiEditMenu menu) {
    }

    public void drawRect(int x, int y, int u, int v, int w, int h) {
        this.drawRect(x, y, u, v, w, h, RenderRotation.NORMAL);
    }

    public void drawRect(int x, int y, int u, int v, int w, int h, RenderRotation rotation) {
        double[] pt4;
        double[] pt3;
        double[] pt2;
        double[] pt1;
        boolean rotate = rotation == RenderRotation.ROTATE_90 || rotation == RenderRotation.ROTATE_270 || rotation == RenderRotation.ROTATE_90_FLIP || rotation == RenderRotation.ROTATE_270_FLIP;
        int targetW = rotate ? h : w;
        int targetH = rotate ? w : h;
        x += this.left;
        y += this.top;
        float fw = 0.00390625f;
        float fy = 0.00390625f;
        double a = (float)(u + 0) * fw;
        double b = (float)(u + w) * fw;
        double c = (float)(v + h) * fy;
        double d = (float)(v + 0) * fy;
        double[] ptA = new double[]{a, c};
        double[] ptB = new double[]{b, c};
        double[] ptC = new double[]{b, d};
        double[] ptD = new double[]{a, d};
        switch (rotation) {
            default: {
                pt1 = ptA;
                pt2 = ptB;
                pt3 = ptC;
                pt4 = ptD;
                break;
            }
            case ROTATE_90: {
                pt1 = ptB;
                pt2 = ptC;
                pt3 = ptD;
                pt4 = ptA;
                break;
            }
            case ROTATE_180: {
                pt1 = ptC;
                pt2 = ptD;
                pt3 = ptA;
                pt4 = ptB;
                break;
            }
            case ROTATE_270: {
                pt1 = ptD;
                pt2 = ptA;
                pt3 = ptB;
                pt4 = ptC;
                break;
            }
            case FLIP_HORIZONTAL: {
                pt1 = ptB;
                pt2 = ptA;
                pt3 = ptD;
                pt4 = ptC;
                break;
            }
            case ROTATE_90_FLIP: {
                pt1 = ptA;
                pt2 = ptD;
                pt3 = ptC;
                pt4 = ptB;
                break;
            }
            case FLIP_VERTICAL: {
                pt1 = ptD;
                pt2 = ptC;
                pt3 = ptB;
                pt4 = ptA;
                break;
            }
            case ROTATE_270_FLIP: {
                pt1 = ptC;
                pt2 = ptB;
                pt3 = ptA;
                pt4 = ptD;
            }
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + targetH), (double)this.field_73735_i, pt1[0], pt1[1]);
        tessellator.func_78374_a((double)(x + targetW), (double)(y + targetH), (double)this.field_73735_i, pt2[0], pt2[1]);
        tessellator.func_78374_a((double)(x + targetW), (double)(y + 0), (double)this.field_73735_i, pt3[0], pt3[1]);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, pt4[0], pt4[1]);
        tessellator.func_78381_a();
    }

    public void drawMouseOver(String str, int x, int y) {
        ArrayList<String> lst = new ArrayList<String>();
        Collections.addAll(lst, str.split("\n"));
        this.drawMouseOver(lst, x, y);
    }

    public void drawMouseOver(List<String> str, int x, int y) {
        GL11.glDisable((int)2929);
        int w = 0;
        for (String line : str) {
            int l = this.field_146289_q.func_78256_a(line);
            if (l <= w) continue;
            w = l;
        }
        x += 12;
        y -= 12;
        int h = 8;
        if (str.size() > 1) {
            h += 2 + (str.size() - 1) * 10;
        }
        if (x + w > this.field_146294_l) {
            x -= 28 + w;
        }
        if (y + h + 6 > this.field_146295_m) {
            y = this.field_146295_m - h - 6;
        }
        this.field_73735_i = 300.0f;
        int bg = -267386864;
        this.func_73733_a(x - 3, y - 4, x + w + 3, y - 3, bg, bg);
        this.func_73733_a(x - 3, y + h + 3, x + w + 3, y + h + 4, bg, bg);
        this.func_73733_a(x - 3, y - 3, x + w + 3, y + h + 3, bg, bg);
        this.func_73733_a(x - 4, y - 3, x - 3, y + h + 3, bg, bg);
        this.func_73733_a(x + w + 3, y - 3, x + w + 4, y + h + 3, bg, bg);
        int border1 = 0x505000FF;
        int border2 = (border1 & 0xFEFEFE) >> 1 | border1 & 0xFF000000;
        this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + h + 3 - 1, border1, border2);
        this.func_73733_a(x + w + 2, y - 3 + 1, x + w + 3, y + h + 3 - 1, border1, border2);
        this.func_73733_a(x - 3, y - 3, x + w + 3, y - 3 + 1, border1, border1);
        this.func_73733_a(x - 3, y + h + 2, x + w + 3, y + h + 3, border2, border2);
        for (int i = 0; i < str.size(); ++i) {
            String line = str.get(i);
            this.field_146289_q.func_78261_a(line, x, y, -1);
            if (i == 0) {
                y += 2;
            }
            y += 10;
        }
        this.field_73735_i = 0.0f;
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawLine(int x1, int y1, int x2, int y2, int thickness, int color) {
        GL11.glDisable((int)3553);
        this.applyColor(color);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)(1.0f + (float)(thickness * this.field_146294_l) / 500.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)x1, (float)y1, (float)0.0f);
        GL11.glVertex3f((float)x2, (float)y2, (float)0.0f);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public void applyColor(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public void drawIcon(IIcon icon, int x, int y) {
        this.func_94065_a(this.left + x, this.top + y, icon, 16, 16);
    }

    public void drawFluid(Fluid fluid, int x, int y, int mX, int mY) {
        this.drawItemBackground(x, y, mX, mY, false);
        if (fluid != null) {
            this.drawFluid(fluid, x + 1, y + 1);
        }
    }

    public void drawFluid(Fluid fluid, int x, int y) {
        IIcon icon = fluid.getIcon();
        if (icon == null) {
            if (FluidRegistry.WATER.equals(fluid)) {
                icon = Blocks.field_150355_j.func_149691_a(0, 0);
            } else if (FluidRegistry.LAVA.equals(fluid)) {
                icon = Blocks.field_150355_j.func_149691_a(0, 0);
            }
        }
        if (icon != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ResourceHelper.bindResource(MAP_TEXTURE);
            this.drawRect(x, y, 240, 240, 16, 16);
            ResourceHelper.bindResource(TERRAIN);
            this.setColor(fluid.getColor());
            this.drawIcon(icon, x, y);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void drawItemBackground(int x, int y, int mX, int mY, boolean selected) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        ResourceHelper.bindResource(MAP_TEXTURE);
        this.drawRect(x, y, this.inBounds(x, y, 18, 18, mX, mY) ? 18 : 0, 235, 18, 18);
        if (selected) {
            this.drawRect(x, y, 36, 235, 18, 18);
        }
    }

    public void drawItem(ItemStack item, int x, int y, int mX, int mY, boolean selected) {
        this.drawItemBackground(x, y, mX, mY, selected);
        if (item != null && item.func_77973_b() != null) {
            this.drawItem(item, x + 1, y + 1, true);
            itemRenderer.func_77021_b(this.field_146289_q, Minecraft.func_71410_x().func_110434_K(), item, x + this.left + 1, y + this.top + 1);
        }
        GL11.glDisable((int)2896);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void setColor(int color) {
        float[] colorComponents = new float[3];
        for (int i = 0; i < colorComponents.length; ++i) {
            colorComponents[i] = (float)((color & 255 << i * 8) >> i * 8) / 255.0f;
        }
        GL11.glColor4f((float)colorComponents[2], (float)colorComponents[1], (float)colorComponents[0], (float)1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawItem(ItemStack itemstack, int x, int y, boolean renderEffect) {
        if (itemstack == null || itemstack.func_77973_b() == null) {
            return;
        }
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        this.setZLevel(4.0f);
        try {
            if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)blockRenderer, (TextureManager)this.field_146297_k.func_110434_K(), (ItemStack)itemstack, (boolean)renderEffect, (float)this.field_73735_i, (float)(x + this.left), (float)(y + this.top))) {
                itemRenderer.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), itemstack, x + this.left, y + this.top);
            }
        }
        finally {
            this.setZLevel(0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3008);
        }
        GL11.glPopMatrix();
    }

    public float getZLevel() {
        return this.field_73735_i;
    }

    public void setZLevel(float zLevel) {
        this.field_73735_i = zLevel;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getStringWidth(String txt) {
        return this.field_146289_q.func_78256_a(txt);
    }

    public void drawString(String str, int x, int y, int color) {
        this.drawString(str, x, y, 1.0f, color);
    }

    public void drawString(String str, int x, int y, float mult, int color) {
        GL11.glPushMatrix();
        GL11.glScalef((float)mult, (float)mult, (float)1.0f);
        this.field_146289_q.func_78276_b(str, (int)((float)(x + this.left) / mult), (int)((float)(y + this.top) / mult), color);
        GL11.glPopMatrix();
    }

    public void drawStringWithShadow(String str, int x, int y, float mult, int color) {
        GL11.glPushMatrix();
        GL11.glScalef((float)mult, (float)mult, (float)1.0f);
        this.field_146289_q.func_78261_a(str, (int)((float)(x + this.left) / mult), (int)((float)(y + this.top) / mult), color);
        GL11.glPopMatrix();
    }

    public boolean inBounds(int x, int y, int w, int h, int mX, int mY) {
        return x <= mX && mX <= x + w && y <= mY && mY <= y + h;
    }

    public void drawCursor(int x, int y, int z, float size, int color) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)z);
        GL11.glTranslatef((float)(x += this.left), (float)(y += this.top), (float)0.0f);
        GL11.glScalef((float)size, (float)size, (float)0.0f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
        Gui.func_73734_a((int)x, (int)(y + 1), (int)(x + 1), (int)(y + 10), (int)color);
        GL11.glPopMatrix();
    }

    public void drawString(List<String> str, int x, int y, float mult, int color) {
        this.drawString(str, 0, str.size(), x, y, mult, color);
    }

    public void drawString(List<String> str, int start, int length, int x, int y, float mult, int color) {
        GL11.glPushMatrix();
        GL11.glScalef((float)mult, (float)mult, (float)1.0f);
        start = Math.max(start, 0);
        int end = Math.min(start + length, str.size());
        for (int i = start; i < end; ++i) {
            this.field_146289_q.func_78276_b(str.get(i), (int)((float)(x + this.left) / mult), (int)((float)(y + this.top) / mult), color);
            y += this.field_146289_q.field_78288_b;
        }
        GL11.glPopMatrix();
    }

    public void drawCenteredString(String str, int x, int y, float mult, int width, int height, int color) {
        this.drawString(str, x + (width - (int)((float)this.field_146289_q.func_78256_a(str) * mult)) / 2, y + (height - (int)((float)(this.field_146289_q.field_78288_b - 2) * mult)) / 2, mult, color);
    }

    public List<String> getLinesFromText(String str, float mult, int width) {
        String[] lines;
        ArrayList<String> lst = new ArrayList<String>();
        if (str == null) {
            str = "Missing info";
        }
        for (String line : lines = str.split("\n")) {
            ArrayList<String> words = new ArrayList<String>();
            Collections.addAll(words, line.split(" "));
            if (line.endsWith(" ")) {
                char c;
                String spaceTail = "";
                for (int i = line.length() - 1; i >= 0 && (c = line.charAt(i)) == ' '; --i) {
                    spaceTail = spaceTail + c;
                }
                words.add(spaceTail);
            }
            for (int i = 0; i < words.size(); ++i) {
                String word = (String)words.get(i);
                String other = "";
                while (true) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!((float)this.field_146289_q.func_78256_a(stringBuilder.append(word).append(" ").toString()) * mult >= (float)width)) break;
                    other = word.charAt(word.length() - 1) + other;
                    word = word.substring(0, word.length() - 1);
                }
                if (!other.isEmpty()) {
                    words.set(i, word);
                    words.add(i + 1, other);
                    continue;
                }
                words.set(i, word + " ");
            }
            String currentLine = null;
            for (String word : words) {
                String newLine = currentLine == null ? word : currentLine + word;
                if ((float)this.field_146289_q.func_78256_a(newLine) * mult < (float)width) {
                    currentLine = newLine;
                    continue;
                }
                lst.add(currentLine);
                currentLine = word;
            }
            lst.add(currentLine);
        }
        return lst;
    }
}

