/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.SaveHelper;
import hardcorequesting.Translator;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.quests.Quest;
import net.minecraft.entity.player.EntityPlayer;

public class GuiEditMenuCommandEditor
extends GuiEditMenuTextEditor {
    private Quest quest = GuiQuestBook.selectedQuest;
    private int id = -1;
    private String[] commands = this.quest.getCommandRewardsAsStrings();
    private boolean[] edited = new boolean[this.commands.length];
    private String added;

    protected GuiEditMenuCommandEditor(GuiQuestBook gui, EntityPlayer player) {
        super(gui, player, "", false);
        if (gui.getCurrentMode() == EditMode.COMMAND_CHANGE && this.commands.length > 0) {
            this.id = this.commands.length - 1;
            this.text.setTextAndCursor(gui, this.commands[this.id]);
        }
    }

    @Override
    protected void save(GuiBase gui) {
        if (this.id < 0) {
            this.added = this.text.getText();
        } else if (this.commands != null && !this.commands[this.id].equals(this.text.getText())) {
            this.edited[this.id] = true;
            this.commands[this.id] = this.text.getText();
        }
        if (this.added != null && !this.added.isEmpty()) {
            this.quest.addCommand(this.added);
            SaveHelper.add(SaveHelper.EditType.COMMAND_ADD);
        }
        if (this.commands != null) {
            for (int i = this.commands.length - 1; i >= 0; --i) {
                if (!this.edited[i]) continue;
                if (this.commands[i].isEmpty()) {
                    this.quest.removeCommand(i);
                    SaveHelper.add(SaveHelper.EditType.COMMAND_REMOVE);
                    continue;
                }
                this.quest.editCommand(i, this.commands[i]);
                SaveHelper.add(SaveHelper.EditType.COMMAND_CHANGE);
            }
        }
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        int i;
        super.draw(gui, mX, mY);
        if (this.commands != null && this.commands.length > 0) {
            for (i = 0; i < this.commands.length; ++i) {
                if (this.commands[i].isEmpty()) {
                    this.drawStringTrimmed(gui, Translator.translate("hqm.commandEdit.deleted"), 190, 65 + i * 10, 0xFF0000);
                    continue;
                }
                this.drawStringTrimmed(gui, this.commands[i], 190, 65 + i * 10, this.edited[i] ? 16729344 : 0);
            }
        }
        if (this.added != null && !this.added.isEmpty()) {
            this.drawStringTrimmed(gui, this.added, 190, 65 + i * 10, 0x447449);
        }
    }

    @Override
    public void drawMouseOver(GuiBase gui, int mX, int mY) {
        int i;
        super.drawMouseOver(gui, mX, mY);
        if (this.commands != null && this.commands.length > 0) {
            for (i = 0; i < this.commands.length; ++i) {
                if (mX <= 190 || mX >= 300 || mY <= 65 + i * 10 || mY >= 65 + (i + 1) * 10) continue;
                if (this.commands[i].isEmpty()) {
                    this.drawStringTrimmed(gui, Translator.translate("hqm.commandEdit.deleted"), 190, 65 + i * 10, 0xF76767);
                    continue;
                }
                this.drawStringTrimmed(gui, this.commands[i], 190, 65 + i * 10, this.edited[i] ? 16362362 : 0x969696);
            }
        }
        if (this.added != null && !this.added.isEmpty()) {
            this.drawStringTrimmed(gui, this.added, 190, 65 + i * 10, 5938016);
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        int i;
        super.onClick(gui, mX, mY, b);
        if (this.commands != null && this.commands.length > 0) {
            for (i = 0; i < this.commands.length; ++i) {
                if (mX <= 190 || mX >= 300 || mY <= 65 + i * 10 || mY >= 65 + (i + 1) * 10) continue;
                if (this.id == i) {
                    return;
                }
                if (this.id < 0) {
                    this.added = this.text.getText();
                } else if (!this.commands[this.id].equals(this.text.getText())) {
                    this.edited[this.id] = true;
                    this.commands[this.id] = this.text.getText();
                }
                this.id = i;
                this.text.setTextAndCursor(gui, this.commands[this.id]);
            }
        }
        if (mX > 190 && mX < 300 && mY > 65 + i * 10 && mY < 65 + (i + 1) * 10) {
            if (this.id == -1) {
                return;
            }
            if (this.commands != null) {
                this.commands[this.id] = this.text.getText();
            }
            this.id = -1;
            this.text.setTextAndCursor(gui, this.added);
        }
    }

    private void drawStringTrimmed(GuiBase gui, String s, int x, int y, int colour) {
        int maxLength = Math.min(25, s.length());
        gui.drawString(s.substring(0, maxLength) + (maxLength < s.length() ? "..." : ""), x, y, colour);
    }
}

