/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.Translator;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenuExtended;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.client.interfaces.TextBoxGroup;
import hardcorequesting.quests.QuestTaskLocation;
import net.minecraft.entity.player.EntityPlayer;

public class GuiEditMenuLocation
extends GuiEditMenuExtended {
    private int id;
    private QuestTaskLocation task;
    private QuestTaskLocation.Location location;
    private EntityPlayer player;

    public GuiEditMenuLocation(GuiQuestBook gui, QuestTaskLocation task, final QuestTaskLocation.Location location, int id, EntityPlayer player) {
        super(gui, player, true, 180, 30, 20, 30);
        this.id = id;
        this.task = task;
        this.location = location;
        this.player = player;
        this.textBoxes.add(new TextBoxNumberNegative(gui, 0, "hqm.locationMenu.xTarget"){

            @Override
            protected void setValue(int number) {
                location.setX(number);
            }

            @Override
            protected int getValue() {
                return location.getX();
            }
        });
        this.textBoxes.add(new TextBoxNumberNegative(gui, 1, "hqm.locationMenu.yTarget"){

            @Override
            protected void setValue(int number) {
                location.setY(number);
            }

            @Override
            protected int getValue() {
                return location.getY();
            }
        });
        this.textBoxes.add(new TextBoxNumberNegative(gui, 2, "hqm.locationMenu.zTarget"){

            @Override
            protected void setValue(int number) {
                location.setZ(number);
            }

            @Override
            protected int getValue() {
                return location.getZ();
            }
        });
        this.textBoxes.add(new TextBoxNumberNegative(gui, 3, "hqm.locationMenu.dim"){

            @Override
            protected void setValue(int number) {
                location.setDimension(number);
            }

            @Override
            protected int getValue() {
                return location.getDimension();
            }
        });
        this.textBoxes.add(new TextBoxNumberNegative(gui, 4, "hqm.locationMenu.radius"){

            @Override
            protected void setValue(int number) {
                location.setRadius(number);
            }

            @Override
            protected int getValue() {
                return location.getRadius();
            }

            @Override
            protected void draw(GuiBase gui, boolean selected) {
                super.draw(gui, selected);
                gui.drawString(gui.getLinesFromText(Translator.translate("hqm.locationMenu.negRadius"), 0.7f, 130), GuiEditMenuLocation.this.BOX_X, GuiEditMenuLocation.this.BOX_Y + 150 + -10, 0.7f, 0x404040);
            }
        });
        this.buttons.add(new LargeButton("hqm.locationMenu.location", 100, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                location.setX((int)player.field_70165_t);
                location.setY((int)player.field_70163_u);
                location.setZ((int)player.field_70161_v);
                location.setDimension(player.field_70170_p.field_73011_w.field_76574_g);
                for (TextBoxGroup.TextBox textBox : GuiEditMenuLocation.this.textBoxes.textBoxes) {
                    textBox.setTextAndCursor(gui, String.valueOf(((GuiEditMenuExtended.TextBoxNumber)textBox).getValue()));
                }
            }
        });
    }

    @Override
    protected void onArrowClick(boolean left) {
        if (left) {
            this.location.setVisible(QuestTaskLocation.Visibility.values()[(this.location.getVisible().ordinal() + QuestTaskLocation.Visibility.values().length - 1) % QuestTaskLocation.Visibility.values().length]);
        } else {
            this.location.setVisible(QuestTaskLocation.Visibility.values()[(this.location.getVisible().ordinal() + 1) % QuestTaskLocation.Visibility.values().length]);
        }
    }

    @Override
    protected String getArrowText() {
        return this.location.getVisible().getName();
    }

    @Override
    protected String getArrowDescription() {
        return this.location.getVisible().getDescription();
    }

    @Override
    protected void save(GuiBase gui) {
        this.task.setLocation(this.id, this.location, this.player);
    }

    private abstract class TextBoxNumberNegative
    extends GuiEditMenuExtended.TextBoxNumber {
        public TextBoxNumberNegative(GuiQuestBook gui, int id, String title) {
            super(gui, id, title);
        }

        @Override
        protected boolean isNegativeAllowed() {
            return true;
        }
    }
}

