/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.EventHandler;
import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.SaveHelper;
import hardcorequesting.Team;
import hardcorequesting.Translator;
import hardcorequesting.bag.Group;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiEditMenuDeathTask;
import hardcorequesting.client.interfaces.GuiEditMenuItem;
import hardcorequesting.client.interfaces.GuiEditMenuReputationKillTask;
import hardcorequesting.client.interfaces.GuiEditMenuReputationReward;
import hardcorequesting.client.interfaces.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.items.ModItems;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.FileHelper;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.QuestData;
import hardcorequesting.quests.QuestDataTask;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.quests.QuestTask;
import hardcorequesting.quests.QuestTaskDeath;
import hardcorequesting.quests.QuestTaskItems;
import hardcorequesting.quests.QuestTaskItemsConsume;
import hardcorequesting.quests.QuestTaskItemsConsumeQDS;
import hardcorequesting.quests.QuestTaskItemsCrafting;
import hardcorequesting.quests.QuestTaskItemsDetect;
import hardcorequesting.quests.QuestTaskLocation;
import hardcorequesting.quests.QuestTaskMob;
import hardcorequesting.quests.QuestTaskReputationKill;
import hardcorequesting.quests.QuestTaskReputationTarget;
import hardcorequesting.quests.QuestTicker;
import hardcorequesting.quests.RepeatInfo;
import hardcorequesting.quests.RepeatType;
import hardcorequesting.quests.TriggerType;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.reputation.ReputationBar;
import hardcorequesting.reward.CommandReward;
import hardcorequesting.reward.CommandRewardList;
import hardcorequesting.reward.ItemStackRewardList;
import hardcorequesting.reward.ReputationReward;
import java.awt.Polygon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class Quest {
    private static Map<Short, Quest> quests;
    public static boolean isEditing;
    public static int selectedQuestId;
    public static QuestTicker clientTicker;
    public static QuestTicker serverTicker;
    private short id;
    private String name;
    private String description;
    private List<Quest> requirement;
    private List<Integer> requirementIds;
    private List<Quest> reversedRequirement;
    private List<Quest> optionLinks;
    private List<Integer> optionLinkIds;
    private List<Quest> reversedOptionLinks;
    private List<QuestTask> tasks;
    private List<String> cachedDescription;
    private List<ReputationReward> reputationRewards;
    int nextTaskId;
    private QuestTask selectedTask;
    private ItemStackRewardList rewards;
    private ItemStackRewardList rewardChoices;
    private CommandRewardList commandRewardList;
    private RepeatInfo repeatInfo = new RepeatInfo(RepeatType.NONE, 0, 0);
    private TriggerType triggerType = TriggerType.NONE;
    private int triggerTasks = 1;
    private boolean useModifiedParentRequirement;
    private int parentRequirementCount;
    private int x;
    private int y;
    private boolean isBig;
    private ItemStack icon;
    private QuestSet set;
    private int selectedReward = -1;
    private final List<LargeButton> buttons = new ArrayList<LargeButton>();
    private Quest self;
    private final ScrollBar descriptionScroll;
    private final ScrollBar taskDescriptionScroll;
    private final ScrollBar taskScroll;
    private final List<ScrollBar> scrollBars;
    private static final int VISIBLE_DESCRIPTION_LINES = 7;
    private static final int VISIBLE_TASKS = 3;
    private ParentEvaluator enabledParentEvaluator;
    private ParentEvaluator linkParentEvaluator;
    private ParentEvaluator visibleParentEvaluator;
    private static final int START_X = 20;
    private static final int TEXT_HEIGHT = 9;
    private static final int TASK_LABEL_START_Y = 100;
    private static final int TASK_MARGIN = 2;
    private static final int TITLE_START_Y = 15;
    private static final int DESCRIPTION_START_Y = 30;
    private static final int TASK_DESCRIPTION_X = 180;
    private static final int TASK_DESCRIPTION_Y = 20;
    private static final int REWARD_STR_Y = 140;
    private static final int REWARD_Y = 150;
    private static final int REWARD_Y_OFFSET = 40;
    private static final int REWARD_OFFSET = 20;
    private static final int ITEM_SIZE = 18;
    private static final int REPUTATION_X = 142;
    private static final int REPUTATION_Y = 133;
    private static final int REPUTATION_Y_LOWER = 150;
    private static final int REPUTATION_SIZE = 16;
    private static final int REPUTATION_SRC_X = 30;
    private static final int REPUTATION_SRC_Y = 82;
    private static final int MAX_REWARD_SLOTS = 7;
    private static final int MAX_SELECT_REWARD_SLOTS = 4;
    public static FileHelper FILE_HELPER;

    public static Collection<Quest> getQuests() {
        return QuestLine.getActiveQuestLine().quests.values();
    }

    public static List<QuestSet> getQuestSets() {
        return QuestLine.getActiveQuestLine().questSets;
    }

    public static int size() {
        return QuestLine.getActiveQuestLine().questCount;
    }

    public Quest(int id, String name, String description, int x, int y, boolean isBig) {
        this.buttons.add(new LargeButton("hqm.quest.claim", 100, 190){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return Quest.this.canPlayerClaimReward(player);
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.hasReward(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                DataWriter dw = PacketHandler.getWriter(PacketId.CLAIM_REWARD);
                dw.writeData((int)Quest.this.getId(), DataBitHelper.QUESTS);
                if (!Quest.this.rewardChoices.isEmpty()) {
                    dw.writeData(Quest.this.selectedReward, DataBitHelper.REWARDS);
                }
                PacketHandler.sendToServer(dw);
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.manualSubmit", 185, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return ((QuestTaskItemsConsume)Quest.this.selectedTask).allowManual();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskItemsConsume && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                PacketHandler.sendToServer(Quest.this.selectedTask.getWriterForTask(PacketId.TASK_REQUEST));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.manualDetect", 185, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskItemsDetect && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                PacketHandler.sendToServer(Quest.this.selectedTask.getWriterForTask(PacketId.TASK_REQUEST));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.requirement", 185, 200){

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskDeath && isEditing;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onClick(GuiBase gui, EntityPlayer player) {
                gui.setEditMenu(new GuiEditMenuDeathTask(gui, player, (QuestTaskDeath)Quest.this.selectedTask));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.requirement", 250, 95){

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskReputationKill && isEditing;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onClick(GuiBase gui, EntityPlayer player) {
                gui.setEditMenu(new GuiEditMenuReputationKillTask(gui, player, (QuestTaskReputationKill)Quest.this.selectedTask));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.selectTask", 250, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return QuestingData.getQuestingData((EntityPlayer)player).selectedQuest != Quest.this.getId() || QuestingData.getQuestingData((EntityPlayer)player).selectedTask != Quest.this.selectedTask.getId();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskItemsConsume && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                QuestingData.getQuestingData((EntityPlayer)player).selectedQuest = Quest.this.getId();
                QuestingData.getQuestingData((EntityPlayer)player).selectedTask = Quest.this.selectedTask.getId();
                PacketHandler.sendToServer(Quest.this.selectedTask.getWriterForTask(PacketId.SELECT_TASK));
            }
        });
        int itemIds = 0;
        for (final TaskType taskType : TaskType.values()) {
            this.buttons.add(new LargeButton(taskType.getLangKeyName(), taskType.getLangKeyDescription(), 185 + taskType.ordinal() % 2 * 65, 50 + taskType.ordinal() / 2 * 35){

                @Override
                public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                    return Quest.this.tasks.size() < DataBitHelper.TASKS.getMaximum();
                }

                @Override
                public boolean isVisible(GuiBase gui, EntityPlayer player) {
                    return isEditing && Quest.this.selectedTask == null && ((GuiQuestBook)gui).getCurrentMode() == EditMode.TASK;
                }

                @Override
                public void onClick(GuiBase gui, EntityPlayer player) {
                    taskType.addTask(Quest.this);
                }
            });
            if (!QuestTaskItems.class.isAssignableFrom(taskType.clazz)) continue;
            this.buttons.add(new LargeButton(taskType.getLangKeyName(), taskType.getLangKeyDescription(), 185 + itemIds % 2 * 65, 50 + itemIds / 2 * 35){

                @Override
                public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                    return Quest.this.selectedTask instanceof QuestTaskItems;
                }

                @Override
                public boolean isVisible(GuiBase gui, EntityPlayer player) {
                    return isEditing && Quest.this.selectedTask != null && ((GuiQuestBook)gui).getCurrentMode() == EditMode.CHANGE_TASK;
                }

                @Override
                public void onClick(GuiBase gui, EntityPlayer player) {
                    TaskType oldTaskType = TaskType.getType(Quest.this.selectedTask.getClass());
                    if (oldTaskType == null) {
                        return;
                    }
                    --Quest.this.nextTaskId;
                    Class clazz = taskType.clazz;
                    try {
                        Constructor constructor = clazz.getConstructor(Quest.class, String.class, String.class);
                        QuestTask task = (QuestTask)constructor.newInstance(Quest.this.self, taskType.getLangKeyName(), taskType.getLangKeyDescription());
                        for (QuestTask questTask : Quest.this.selectedTask.getRequirements()) {
                            task.addRequirement(questTask);
                        }
                        for (QuestTask questTask : Quest.this.tasks) {
                            List<QuestTask> requirements = questTask.getRequirements();
                            for (int j = 0; j < requirements.size(); ++j) {
                                if (!requirements.get(j).equals(Quest.this.selectedTask)) continue;
                                requirements.set(j, task);
                            }
                        }
                        for (int j = 0; j < Quest.this.tasks.size(); ++j) {
                            if (!((QuestTask)Quest.this.tasks.get(j)).equals(Quest.this.selectedTask)) continue;
                            Quest.this.tasks.set(j, task);
                            break;
                        }
                        if (!Quest.this.selectedTask.getLangKeyDescription().equals(oldTaskType.getLangKeyName())) {
                            task.setDescription(Quest.this.selectedTask.getLangKeyDescription());
                        }
                        if (!Quest.this.selectedTask.getLangKeyLongDescription().equals(oldTaskType.getLangKeyDescription())) {
                            task.setLongDescription(Quest.this.selectedTask.getLangKeyLongDescription());
                        }
                        ((QuestTaskItems)task).setItems(((QuestTaskItems)Quest.this.selectedTask).getItems());
                        task.setId(Quest.this.selectedTask.getId());
                        Quest.this.selectedTask = task;
                        SaveHelper.add(SaveHelper.EditType.TASK_CHANGE_TYPE);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            ++itemIds;
        }
        this.self = this;
        this.scrollBars = new ArrayList<ScrollBar>();
        this.descriptionScroll = new ScrollBar(155, 28, 64, 249, 102, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return Quest.this.getCachedDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.descriptionScroll);
        this.taskDescriptionScroll = new ScrollBar(312, 18, 64, 249, 102, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask.getCachedLongDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.taskDescriptionScroll);
        this.taskScroll = new ScrollBar(155, 100, 29, 242, 102, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return Quest.this.tasks.size() > 3 && Quest.this.getVisibleTasks(gui) > 3;
            }
        };
        this.scrollBars.add(this.taskScroll);
        this.enabledParentEvaluator = new ParentEvaluator(){

            @Override
            protected boolean isValid(String playerName, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
                return parent.isCompleted(playerName);
            }
        };
        this.linkParentEvaluator = new ParentEvaluator(){

            @Override
            protected boolean isValid(String playerName, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
                return parent.isLinkFree(playerName, isLinkFreeCache);
            }
        };
        this.visibleParentEvaluator = new ParentEvaluator(){

            @Override
            protected boolean isValid(String playerName, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
                return parent.isVisible(playerName, isVisibleCache, isLinkFreeCache) || parent.isCompleted(playerName);
            }
        };
        this.id = (short)id;
        this.name = name;
        this.x = x;
        this.y = y;
        this.isBig = isBig;
        this.description = description;
        this.requirement = new ArrayList<Quest>();
        this.reversedRequirement = new ArrayList<Quest>();
        this.optionLinks = new ArrayList<Quest>();
        this.reversedOptionLinks = new ArrayList<Quest>();
        this.tasks = new ArrayList<QuestTask>();
        this.rewards = new ItemStackRewardList();
        this.rewardChoices = new ItemStackRewardList();
        this.commandRewardList = new CommandRewardList();
        QuestLine.getActiveQuestLine().quests.put(this.id, this);
        if (this.id >= QuestLine.getActiveQuestLine().questCount) {
            QuestLine.getActiveQuestLine().questCount = this.id + 1;
        }
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public ItemStack[] getReward() {
        return this.rewards.toArray();
    }

    public void setReward(ItemStack[] reward) {
        this.rewards.set(reward);
    }

    public ItemStack[] getRewardChoice() {
        return this.rewardChoices.toArray();
    }

    public void setRewardChoice(ItemStack[] rewardChoice) {
        this.rewardChoices.set(rewardChoice);
    }

    public String[] getCommandRewardsAsStrings() {
        return this.commandRewardList.asStrings();
    }

    public void setCommandRewards(String[] commands) {
        this.commandRewardList.set(commands);
    }

    public void addCommand(String command) {
        this.commandRewardList.add(command);
    }

    public void editCommand(int id, String command) {
        this.commandRewardList.set(id, command);
    }

    public void removeCommand(int id) {
        this.commandRewardList.remove(id);
    }

    public RepeatInfo getRepeatInfo() {
        return this.repeatInfo;
    }

    public void setRepeatInfo(RepeatInfo repeatInfo) {
        this.repeatInfo = repeatInfo;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getMainDescription(GuiBase gui) {
        if (QuestLine.getActiveQuestLine().cachedMainDescription == null) {
            QuestLine.getActiveQuestLine().cachedMainDescription = gui.getLinesFromText(QuestLine.getActiveQuestLine().mainDescription, 0.7f, 130);
        }
        return QuestLine.getActiveQuestLine().cachedMainDescription;
    }

    public static String getRawMainDescription() {
        return QuestLine.getActiveQuestLine().mainDescription;
    }

    public static void setMainDescription(String mainDescription) {
        QuestLine.getActiveQuestLine().mainDescription = mainDescription;
        QuestLine.getActiveQuestLine().cachedMainDescription = null;
    }

    public void addRequirement(int id) {
        if (this.lookForId(id, false) || this.lookForId(id, true)) {
            return;
        }
        Quest quest = QuestLine.getActiveQuestLine().quests.get((short)id);
        if (quest != null) {
            this.requirement.add(quest);
            quest.reversedRequirement.add(this);
            SaveHelper.add(SaveHelper.EditType.REQUIREMENT_CHANGE);
        }
    }

    private boolean lookForId(int id, boolean reversed) {
        List<Quest> quests = reversed ? this.reversedRequirement : this.requirement;
        for (Quest quest : quests) {
            if (quest.id != id && !quest.lookForId(id, reversed)) continue;
            return true;
        }
        return false;
    }

    public void clearRequirements() {
        SaveHelper.add(SaveHelper.EditType.REQUIREMENT_REMOVE, this.requirement.size());
        for (Quest quest : this.requirement) {
            quest.reversedRequirement.remove(this);
        }
        this.requirement.clear();
    }

    public void addOptionLink(int id) {
        for (Quest quest : this.optionLinks) {
            if (quest.id != id) continue;
            return;
        }
        for (Quest quest : this.reversedOptionLinks) {
            if (quest.id != id) continue;
            return;
        }
        Quest quest = QuestLine.getActiveQuestLine().quests.get((short)id);
        if (quest != null) {
            SaveHelper.add(SaveHelper.EditType.OPTION_CHANGE);
            this.optionLinks.add(quest);
            quest.reversedOptionLinks.add(this);
        }
    }

    public void clearOptionLinks() {
        SaveHelper.add(SaveHelper.EditType.OPTION_REMOVE, this.optionLinks.size());
        for (Quest quest : this.reversedOptionLinks) {
            quest.optionLinks.remove(this);
        }
        for (Quest quest : this.optionLinks) {
            quest.reversedOptionLinks.remove(this);
        }
        this.reversedRequirement.clear();
        this.optionLinks.clear();
    }

    public QuestData getQuestData(EntityPlayer player) {
        return QuestingData.getQuestingData(player).getQuestData(this.id);
    }

    public QuestData getQuestData(String playerName) {
        return QuestingData.getQuestingData(playerName).getQuestData(this.id);
    }

    public short getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible(EntityPlayer player) {
        return this.isVisible(QuestingData.getUserName(player));
    }

    boolean isVisible(EntityPlayer player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.isVisible(QuestingData.getUserName(player), isVisibleCache, isLinkFreeCache);
    }

    public boolean isVisible(String playerName) {
        return this.isVisible(playerName, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    boolean isVisible(String playerName, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        Boolean cachedResult = isVisibleCache.get(this);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = this.triggerType.isQuestVisible(this, playerName) && this.isLinkFree(playerName, isLinkFreeCache) && this.visibleParentEvaluator.isValid(playerName, isVisibleCache, isLinkFreeCache);
        isVisibleCache.put(this, result);
        return result;
    }

    public boolean isEnabled(EntityPlayer player) {
        return this.isEnabled(QuestingData.getUserName(player));
    }

    boolean isEnabled(EntityPlayer player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.isEnabled(QuestingData.getUserName(player), true, isVisibleCache, isLinkFreeCache);
    }

    public boolean isEnabled(String playerName) {
        return this.isEnabled(playerName, true);
    }

    public boolean isEnabled(String playerName, boolean requiresVisible) {
        return this.isEnabled(playerName, requiresVisible, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    boolean isEnabled(String playerName, boolean requiresVisible, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.set != null && this.isLinkFree(playerName, isLinkFreeCache) && (!requiresVisible || this.triggerType.doesWorkAsInvisible() || this.isVisible(playerName, isVisibleCache, isLinkFreeCache)) && this.enabledParentEvaluator.isValid(playerName, isVisibleCache, isLinkFreeCache);
    }

    public boolean isLinkFree(EntityPlayer player) {
        return this.isLinkFree(QuestingData.getUserName(player), new HashMap<Quest, Boolean>());
    }

    boolean isLinkFree(EntityPlayer player, Map<Quest, Boolean> cache) {
        return this.isLinkFree(QuestingData.getUserName(player), cache);
    }

    public boolean isLinkFree(String playerName) {
        return this.isLinkFree(playerName, new HashMap<Quest, Boolean>());
    }

    boolean isLinkFree(String playerName, Map<Quest, Boolean> cache) {
        Boolean cachedResult = cache.get(this);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = true;
        for (Quest optionLink : this.optionLinks) {
            if (!optionLink.isCompleted(playerName)) continue;
            result = false;
            break;
        }
        if (result) {
            for (Quest optionLink : this.reversedOptionLinks) {
                if (!optionLink.isCompleted(playerName)) continue;
                result = false;
                break;
            }
        }
        if (result) {
            result = this.linkParentEvaluator.isValid(playerName, null, cache);
        }
        cache.put(this, result);
        return result;
    }

    public void setReputationRewards(List<ReputationReward> reputationRewards) {
        this.reputationRewards = reputationRewards;
    }

    public List<ReputationReward> getReputationRewards() {
        return this.reputationRewards;
    }

    public boolean isAvailable(EntityPlayer player) {
        return this.isAvailable(QuestingData.getUserName(player));
    }

    public boolean isCompleted(EntityPlayer player) {
        return this.isCompleted(QuestingData.getUserName(player));
    }

    public boolean isAvailable(String playerName) {
        QuestData data = this.getQuestData(playerName);
        return data != null && data.available;
    }

    public boolean isCompleted(String playerName) {
        QuestData data = this.getQuestData(playerName);
        return data != null && data.completed;
    }

    public List<Quest> getRequirement() {
        return this.requirement;
    }

    public int getGuiX() {
        return this.x;
    }

    public int getGuiY() {
        return this.y;
    }

    public int getGuiU() {
        return this.isBig ? 195 : 170;
    }

    public int getGuiV(EntityPlayer player, int x, int y) {
        return this.isEnabled(player) && this.isMouseInObject(x, y) ? this.getGuiH() : 0;
    }

    public int getGuiW() {
        return this.isBig ? 31 : 25;
    }

    public int getGuiH() {
        return this.isBig ? 37 : 30;
    }

    public int getGuiCenterX() {
        return this.getGuiX() + this.getGuiW() / 2;
    }

    public int getGuiCenterY() {
        return this.getGuiY() + this.getGuiH() / 2;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public boolean useBigIcon() {
        return this.isBig;
    }

    public void setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setTriggerTasks(int triggerTasks) {
        this.triggerTasks = triggerTasks;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public int getTriggerTasks() {
        return this.triggerTasks;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFilter(EntityPlayer player, int tick) {
        if (isEditing && !this.isVisible(player)) {
            return 0x55FFFFFF;
        }
        if (!this.isEnabled(player)) {
            return -7829368;
        }
        if (!this.isAvailable(player) && !this.hasReward(player)) {
            return this.getRepeatInfo().getType() == RepeatType.NONE ? -1 : -52;
        }
        int componentBase = 187;
        int componentVariable = (int)(Math.abs(Math.sin((float)tick / 5.0f)) * 68.0);
        int component = componentBase + componentVariable;
        int red = this.hasReward(player) ? componentBase : component;
        int green = this.hasReward(player) ? component * 3 / 4 : component;
        int blue = component;
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isMouseInObject(int x, int y) {
        if (this.getGuiX() > x || x > this.getGuiX() + this.getGuiW() || this.getGuiY() > y || y > this.getGuiY() + this.getGuiH()) {
            return false;
        }
        Polygon poly = new Polygon();
        if (this.isBig) {
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 10);
            poly.addPoint(this.getGuiX() + 15, this.getGuiY() + 1);
            poly.addPoint(this.getGuiX() + 30, this.getGuiY() + 10);
            poly.addPoint(this.getGuiX() + 30, this.getGuiY() + 27);
            poly.addPoint(this.getGuiX() + 15, this.getGuiY() + 36);
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 27);
        } else {
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 12, this.getGuiY() + 2);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 21);
            poly.addPoint(this.getGuiX() + 12, this.getGuiY() + 27);
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 21);
        }
        return poly.contains(x, y);
    }

    public static Quest getQuest(int id) {
        return QuestLine.getActiveQuestLine().quests.get((short)id);
    }

    @SideOnly(value=Side.CLIENT)
    private List<String> getCachedDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(this.description, 0.7f, 130);
        }
        return this.cachedDescription;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMenu(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        if (!isEditing && this.selectedTask != null && !this.selectedTask.isVisible(player)) {
            this.selectedTask = this.tasks.size() > 0 ? this.tasks.get(0) : null;
        }
        gui.drawString(this.name, 20, 15, 0x404040);
        int startLine = this.descriptionScroll.isVisible(gui) ? Math.round((float)(this.getCachedDescription(gui).size() - 7) * this.descriptionScroll.getScroll()) : 0;
        gui.drawString(this.getCachedDescription(gui), startLine, 7, 20, 30, 0.7f, 0x404040);
        int id = 0;
        int start = this.taskScroll.isVisible(gui) ? Math.round((float)(this.getVisibleTasks(gui) - 3) * this.taskScroll.getScroll()) : 0;
        int end = Math.min(start + 3, this.tasks.size());
        for (int i = start; i < end; ++i) {
            QuestTask task = this.tasks.get(i);
            boolean isVisible = task.isVisible(player);
            if (!isVisible && !isEditing) continue;
            boolean completed = task.isCompleted(player);
            int yPos = this.getTaskY(gui, id);
            boolean inBounds = gui.inBounds(20, yPos, gui.getStringWidth(task.getDescription()), 9, mX, mY);
            boolean isSelected = task == this.selectedTask;
            gui.drawString(task.getDescription(), 20, yPos, completed ? (isSelected ? (inBounds ? 0x40BB40 : 0x40A040) : (inBounds ? 0x10A010 : 0x107010)) : (isSelected ? (inBounds ? 0xAAAAAA : 0x888888) : (inBounds ? 0x666666 : (isVisible ? 0x404040 : 0xDDDDDD))));
            ++id;
        }
        if (this.selectedReward != -1 && !this.hasReward(player)) {
            this.selectedReward = -1;
        }
        if (!this.rewards.isEmpty() || isEditing) {
            gui.drawString(Translator.translate("hqm.quest.rewards"), 20, 140, 0x404040);
            this.drawRewards(gui, this.rewards.toArray(), 150, -1, mX, mY, 4);
            if (!this.rewardChoices.isEmpty() || isEditing) {
                gui.drawString(Translator.translate("hqm.quest.pickOne"), 20, 180, 0x404040);
                this.drawRewards(gui, this.rewardChoices.toArray(), 190, this.selectedReward, mX, mY, 7);
            }
        } else if (!this.rewardChoices.isEmpty()) {
            gui.drawString(Translator.translate("hqm.quest.pickOneReward"), 20, 140, 0x404040);
            this.drawRewards(gui, this.rewardChoices.toArray(), 150, this.selectedReward, mX, mY, 7);
        }
        for (LargeButton button : this.buttons) {
            button.draw(gui, player, mX, mY);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        ResourceHelper.bindResource(GuiBase.MAP_TEXTURE);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.draw(gui);
        }
        boolean claimed = this.getQuestData((EntityPlayer)player).claimed;
        int y = this.rewards == null || this.rewards.size() <= 7 - (isEditing ? 2 : 1) ? 150 : 133;
        boolean hover = gui.inBounds(142, y, 16, 16, mX, mY);
        if (this.reputationRewards != null || isEditing) {
            int foregroundIndex;
            int backgroundIndex;
            if (this.reputationRewards == null) {
                claimed = true;
            }
            int n = claimed ? 2 : (backgroundIndex = hover ? 1 : 0);
            if (claimed) {
                foregroundIndex = 3;
            } else {
                boolean positive = false;
                boolean negative = false;
                for (ReputationReward reputationReward : this.reputationRewards) {
                    if (reputationReward.getValue() < 0) {
                        negative = true;
                        continue;
                    }
                    if (reputationReward.getValue() <= 0) continue;
                    positive = true;
                }
                foregroundIndex = negative == positive ? 2 : (positive ? 0 : 1);
            }
            gui.drawRect(142, y, 30 + backgroundIndex * 16, 82, 16, 16);
            gui.drawRect(142, y, 30 + (foregroundIndex += 3) * 16, 82, 16, 16);
        }
        if (this.selectedTask != null) {
            if (isEditing && gui.getCurrentMode() == EditMode.CHANGE_TASK) {
                if (this.selectedTask instanceof QuestTaskItems) {
                    gui.drawString(gui.getLinesFromText(Translator.translate("hqm.quest.itemTaskChangeTo"), 0.7f, 130), 180, 20, 0.7f, 0x404040);
                } else {
                    gui.drawString(gui.getLinesFromText(Translator.translate("hqm.quest.itemTaskTypeOnly"), 0.7f, 130), 180, 20, 0.7f, 0x404040);
                }
            } else {
                List<String> description = this.selectedTask.getCachedLongDescription(gui);
                int taskStartLine = this.taskDescriptionScroll.isVisible(gui) ? Math.round((float)(description.size() - 7) * this.taskDescriptionScroll.getScroll()) : 0;
                gui.drawString(description, taskStartLine, 7, 180, 20, 0.7f, 0x404040);
                this.selectedTask.draw(gui, player, mX, mY);
            }
        } else if (isEditing && gui.getCurrentMode() == EditMode.TASK) {
            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.quest.createTasks"), 0.7f, 130), 180, 20, 0.7f, 0x404040);
        } else if (isEditing && gui.getCurrentMode() == EditMode.CHANGE_TASK) {
            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.quest.itemTaskTypeChange"), 0.7f, 130), 180, 20, 0.7f, 0x404040);
        }
        if (!this.rewards.isEmpty() || isEditing) {
            this.drawRewardMouseOver(gui, this.rewards.toArray(), 150, -1, mX, mY);
            if (!this.rewardChoices.isEmpty() || isEditing) {
                this.drawRewardMouseOver(gui, this.rewardChoices.toArray(), 190, this.selectedReward, mX, mY);
            }
        } else if (!this.rewardChoices.isEmpty()) {
            this.drawRewardMouseOver(gui, this.rewardChoices.toArray(), 150, this.selectedReward, mX, mY);
        }
        for (LargeButton button : this.buttons) {
            button.drawMouseOver(gui, player, mX, mY);
        }
        if (this.reputationRewards != null && hover) {
            ArrayList<String> str = new ArrayList<String>();
            for (ReputationReward reputationReward : this.reputationRewards) {
                if (reputationReward.getValue() == 0 || reputationReward.getReward() == null || !((Reputation)reputationReward.getReward()).isValid()) continue;
                str.add(reputationReward.getLabel());
            }
            List<String> commentLines = gui.getLinesFromText(Translator.translate("hqm.quest.partyRepReward" + (claimed ? "Claimed" : "")), 1.0f, 200);
            if (commentLines != null) {
                str.add("");
                for (String commentLine : commentLines) {
                    str.add((Object)((Object)GuiColor.GRAY) + commentLine);
                }
            }
            gui.drawMouseOver(str, mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getVisibleTasks(GuiBase gui) {
        if (isEditing) {
            return this.tasks.size();
        }
        int count = 0;
        for (QuestTask task : this.tasks) {
            if (!task.isVisible(((GuiQuestBook)gui).getPlayer())) continue;
            ++count;
        }
        return count;
    }

    private boolean canPlayerClaimReward(EntityPlayer player) {
        return this.hasReward(player) && (this.rewardChoices.isEmpty() || this.selectedReward != -1) && this.isEnabled(player);
    }

    public boolean hasReward(EntityPlayer player) {
        return this.getQuestData(player).getReward(player) && (!this.rewards.isEmpty() || !this.rewardChoices.isEmpty()) || this.getQuestData(player).canClaim() && (this.reputationRewards != null || !this.commandRewardList.isEmpty());
    }

    @SideOnly(value=Side.CLIENT)
    private void drawRewards(GuiQuestBook gui, ItemStack[] rewards, int y, int selected, int mX, int mY, int max) {
        rewards = this.getEditFriendlyRewards(rewards, max);
        for (int i = 0; i < rewards.length; ++i) {
            gui.drawItem(rewards[i], 20 + i * 20, y, mX, mY, selected == i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawRewardMouseOver(GuiQuestBook gui, ItemStack[] rewards, int y, int selected, int mX, int mY) {
        if (rewards != null) {
            for (int i = 0; i < rewards.length; ++i) {
                if (!gui.inBounds(20 + i * 20, y, 18, 18, mX, mY)) continue;
                if (rewards[i] == null) break;
                GuiQuestBook.setSelected(rewards[i]);
                List<String> str = new ArrayList<String>();
                try {
                    if (isEditing && !GuiScreen.func_146271_m()) {
                        str = rewards[i].func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                        str.add("");
                        str.add((Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.quest.crtlNonEditor"));
                    } else {
                        str.add(rewards[i].func_82833_r());
                    }
                }
                catch (Throwable ignored) {
                    break;
                }
                if (selected == i) {
                    str.add((Object)((Object)GuiColor.GREEN) + Translator.translate("hqm.quest.selected"));
                }
                gui.drawMouseOver(str, gui.getLeft() + mX, gui.getTop() + mY);
                break;
            }
        }
    }

    private ItemStack[] getEditFriendlyRewards(ItemStack[] rewards, int max) {
        if (rewards == null) {
            return new ItemStack[1];
        }
        if (isEditing && rewards.length < max) {
            return Arrays.copyOf(rewards, rewards.length + 1);
        }
        return rewards;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleRewardClick(GuiQuestBook gui, EntityPlayer player, ItemStack[] rawRewards, int y, boolean canSelect, int mX, int mY) {
        ItemStack[] rewards = this.getEditFriendlyRewards(rawRewards, canSelect ? 4 : 7);
        for (int i = 0; i < rewards.length; ++i) {
            ItemStack[] newRewards;
            if (!gui.inBounds(20 + i * 20, y, 18, 18, mX, mY)) continue;
            if (canSelect && (!isEditing || gui.getCurrentMode() == EditMode.NORMAL)) {
                if (this.selectedReward == i) {
                    this.selectedReward = -1;
                    break;
                }
                if (rewards[i] == null) break;
                this.selectedReward = i;
                break;
            }
            if (isEditing && gui.getCurrentMode() == EditMode.ITEM) {
                gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, rewards[i], i, canSelect ? GuiEditMenuItem.Type.PICK_REWARD : GuiEditMenuItem.Type.REWARD, rewards[i] == null ? 1 : rewards[i].field_77994_a, ItemPrecision.PRECISE));
                break;
            }
            if (!isEditing || gui.getCurrentMode() != EditMode.DELETE || rewards[i] == null) break;
            if (rawRewards.length == 1) {
                newRewards = null;
                if (canSelect) {
                    this.selectedReward = -1;
                }
            } else {
                newRewards = new ItemStack[rawRewards.length - 1];
                int id = 0;
                for (int j = 0; j < rawRewards.length; ++j) {
                    if (j == i) continue;
                    newRewards[id] = rawRewards[j];
                    ++id;
                }
                if (canSelect && this.selectedReward != -1) {
                    if (this.selectedReward == i) {
                        this.selectedReward = -1;
                    } else if (this.selectedReward > i) {
                        --this.selectedReward;
                    }
                }
            }
            if (canSelect) {
                this.rewardChoices.set(newRewards);
            } else {
                this.rewards.set(newRewards);
            }
            SaveHelper.add(SaveHelper.EditType.REWARD_REMOVE);
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getTaskY(GuiQuestBook gui, int id) {
        return 100 + id * 11;
    }

    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        if (b == 1) {
            gui.loadMap();
        } else {
            int id = 0;
            int start = this.taskScroll.isVisible(gui) ? Math.round((float)(this.getVisibleTasks(gui) - 3) * this.taskScroll.getScroll()) : 0;
            int end = Math.min(start + 3, this.tasks.size());
            for (int i = start; i < end; ++i) {
                QuestTask task = this.tasks.get(i);
                if (!task.isVisible(player) && !isEditing) continue;
                if (gui.inBounds(20, this.getTaskY(gui, id), gui.getStringWidth(task.getDescription()), 9, mX, mY)) {
                    if (isEditing && gui.getCurrentMode() != EditMode.NORMAL) {
                        if (gui.getCurrentMode() == EditMode.RENAME) {
                            gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, task, true));
                            break;
                        }
                        if (gui.getCurrentMode() != EditMode.DELETE) break;
                        if (i + 1 < this.tasks.size()) {
                            this.tasks.get(i + 1).clearRequirements();
                            if (i > 0) {
                                this.tasks.get(i + 1).addRequirement(this.tasks.get(i - 1));
                            }
                        }
                        if (this.selectedTask == task) {
                            this.selectedTask = null;
                        }
                        task.onDelete();
                        this.tasks.remove(i);
                        this.nextTaskId = 0;
                        for (QuestTask questTask : this.tasks) {
                            questTask.updateId();
                        }
                        this.addTaskData(this.getQuestData(player));
                        SaveHelper.add(SaveHelper.EditType.TASK_REMOVE);
                        break;
                    }
                    if (task == this.selectedTask) {
                        this.selectedTask = null;
                        break;
                    }
                    this.selectedTask = task;
                    this.taskDescriptionScroll.resetScroll();
                    break;
                }
                ++id;
            }
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onClick(gui, mX, mY);
            }
            if (!this.rewards.isEmpty() || isEditing) {
                this.handleRewardClick(gui, player, this.rewards.toArray(), 150, false, mX, mY);
                if (!this.rewardChoices.isEmpty() || isEditing) {
                    this.handleRewardClick(gui, player, this.rewardChoices.toArray(), 190, true, mX, mY);
                }
            } else if (!this.rewardChoices.isEmpty()) {
                this.handleRewardClick(gui, player, this.rewardChoices.toArray(), 150, true, mX, mY);
            }
            if (this.selectedTask != null) {
                this.selectedTask.onClick(gui, player, mX, mY, b);
            }
            for (LargeButton button : this.buttons) {
                if (!button.inButtonBounds(gui, mX, mY) || !button.isVisible(gui, player) || !button.isEnabled(gui, player)) continue;
                button.onClick(gui, player);
                break;
            }
            if (gui.getCurrentMode() == EditMode.RENAME) {
                if (gui.inBounds(20, 15, 140, 9, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this, true));
                } else if (gui.inBounds(20, 30, 130, 44, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this, false));
                } else if (this.selectedTask != null && gui.inBounds(180, 20, 130, 44, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this.selectedTask, false));
                }
            }
            if (isEditing && this.selectedTask != null && gui.getCurrentMode() == EditMode.TASK) {
                this.selectedTask = null;
            }
            if (isEditing && gui.getCurrentMode() == EditMode.REPUTATION_REWARD) {
                int y;
                int n = this.rewards == null || this.rewards.size() <= 7 - (isEditing ? 2 : 1) ? 150 : (y = 133);
                if (gui.inBounds(142, y, 16, 16, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuReputationReward((GuiBase)gui, player, this.reputationRewards));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDrag(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onDrag(gui, mX, mY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRelease(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onRelease(gui, mX, mY);
        }
    }

    public QuestData createData(int players) {
        QuestData data = new QuestData(players);
        if (!this.addTaskData(data)) {
            return null;
        }
        return data;
    }

    public boolean addTaskData(QuestData data) {
        data.tasks = new QuestDataTask[this.tasks.size()];
        for (int i = 0; i < this.tasks.size(); ++i) {
            try {
                QuestDataTask obj;
                Constructor<? extends QuestDataTask> constructor = this.tasks.get(i).getDataType().getConstructor(QuestTask.class);
                data.tasks[i] = obj = constructor.newInstance(this.tasks.get(i));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void save(DataWriter dw, QuestData questData, boolean light) {
        dw.writeBoolean(questData.completed);
        dw.writeBoolean(questData.claimed);
        dw.writeBoolean(questData.available);
        dw.writeData(questData.time, DataBitHelper.HOURS);
        if (questData.completed) {
            for (boolean b : questData.reward) {
                dw.writeBoolean(b);
            }
        }
        if (light) {
            for (int i = 0; i < this.tasks.size(); ++i) {
                QuestTask task = this.tasks.get(i);
                questData.tasks[i] = task.validateData(questData.tasks[i]);
                task.write(dw, questData.tasks[i], true);
            }
        } else {
            dw.writeData(this.tasks.size(), DataBitHelper.TASKS);
            for (int i = 0; i < this.tasks.size(); ++i) {
                dw.writeData(TaskType.getType(this.tasks.get(i).getClass()).ordinal(), DataBitHelper.TASK_TYPE);
                QuestTask task = this.tasks.get(i);
                questData.tasks[i] = task.validateData(questData.tasks[i]);
                task.write(dw, questData.tasks[i], false);
            }
        }
    }

    public void preRead(int players, QuestData data) {
        data.reward = new boolean[players];
    }

    public void read(DataReader dr, QuestData questData, FileVersion version, boolean light) {
        int i;
        questData.completed = dr.readBoolean();
        boolean bl = questData.claimed = version.contains(FileVersion.REPUTATION) && dr.readBoolean();
        if (version.contains(FileVersion.REPEATABLE_QUESTS)) {
            questData.available = dr.readBoolean();
            questData.time = dr.readData(DataBitHelper.HOURS);
            if (questData.completed && this.repeatInfo.getType() == RepeatType.NONE) {
                questData.available = false;
            }
        } else if (this.repeatInfo.getType() != RepeatType.INSTANT) {
            boolean bl2 = questData.available = !questData.completed;
        }
        if (questData.completed) {
            for (i = 0; i < questData.reward.length; ++i) {
                questData.reward[i] = version.contains(FileVersion.REPEATABLE_QUESTS) ? dr.readBoolean() : !dr.readBoolean() && questData.completed;
            }
        }
        if (light) {
            for (i = 0; i < this.tasks.size(); ++i) {
                QuestTask task = this.tasks.get(i);
                questData.tasks[i] = task.validateData(questData.tasks[i]);
                task.read(dr, questData.tasks[i], version, true);
            }
        } else {
            int count = dr.readData(DataBitHelper.TASKS);
            for (int i2 = 0; i2 < count; ++i2) {
                int type = dr.readData(DataBitHelper.TASK_TYPE);
                if (i2 >= this.tasks.size()) {
                    try {
                        Class clazz = TaskType.values()[type].clazz;
                        Constructor constructor = clazz.getConstructor(Quest.class, String.class, String.class);
                        Object obj = constructor.newInstance(this, "Fake", "Fake");
                        QuestTask task = (QuestTask)obj;
                        --this.nextTaskId;
                        Constructor<? extends QuestDataTask> constructor2 = task.getDataType().getConstructor(QuestTask.class);
                        QuestDataTask obj2 = constructor2.newInstance(task);
                        task.read(dr, obj2, version, false);
                        task.onDelete();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                QuestTask task = this.tasks.get(i2);
                questData.tasks[i2] = task.validateData(questData.tasks[i2]);
                task.read(dr, questData.tasks[i2], version, false);
            }
        }
    }

    public void postRead(QuestingData questingData, QuestData questData, FileVersion version) {
        String name = questingData.getName();
        if (version.lacks(FileVersion.UNCOMPLETED_DISABLED)) {
            if (this.isCompleted(name) && !this.isEnabled(name)) {
                questData.completed = false;
            }
        } else {
            boolean update = false;
            for (QuestTask task : this.tasks) {
                if (task.isCompleted(name)) {
                    task.autoComplete(name);
                    continue;
                }
                if (!(task.getCompletedRatio(name) >= 1.0f)) continue;
                task.autoComplete(name);
                task.completeTask(name);
                update = true;
            }
            if (update) {
                QuestTask.completeQuest(this, name);
            }
        }
    }

    public List<QuestTask> getTasks() {
        return this.tasks;
    }

    public void sendUpdatedDataToTeam(EntityPlayer player) {
        this.sendUpdatedDataToTeam(QuestingData.getQuestingData(player).getTeam());
    }

    public void sendUpdatedDataToTeam(String playerName) {
        this.sendUpdatedDataToTeam(QuestingData.getQuestingData(playerName).getTeam());
    }

    public void sendUpdatedDataToTeam(Team team) {
        for (Team.PlayerEntry entry : team.getPlayers()) {
            if (!entry.shouldRefreshData()) continue;
            this.sendUpdatedData(entry.getName());
        }
    }

    private void sendUpdatedData(String playerName) {
        DataWriter dw = PacketHandler.getWriter(PacketId.QUEST_DATA);
        dw.writeData((int)this.id, DataBitHelper.QUESTS);
        dw.writeData(QuestingData.getQuestingData(playerName).getTeam().getPlayerCount(), DataBitHelper.PLAYERS);
        this.save(dw, this.getQuestData(playerName), true);
        PacketHandler.sendToPlayer(playerName, dw);
    }

    public void claimReward(EntityPlayer player, DataReader dr) {
        if (this.hasReward(player)) {
            boolean sentInfo = false;
            if (!(!this.getQuestData(player).getReward(player) || this.rewards.isEmpty() && this.rewardChoices.isEmpty())) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                if (!this.rewards.isEmpty()) {
                    for (ItemStack itemStack : this.rewards.toArray()) {
                        items.add(itemStack.func_77946_l());
                    }
                }
                if (!this.rewardChoices.isEmpty()) {
                    int id = dr.readData(DataBitHelper.REWARDS);
                    if (id >= 0 && id < this.rewardChoices.size()) {
                        items.add(((ItemStack)this.rewardChoices.getReward(id)).func_77946_l());
                    } else {
                        return;
                    }
                }
                ArrayList<ItemStack> itemsToAdd = new ArrayList<ItemStack>();
                for (ItemStack item : items) {
                    boolean added = false;
                    for (ItemStack itemStack : itemsToAdd) {
                        if (!item.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)itemStack)) continue;
                        itemStack.field_77994_a += item.field_77994_a;
                        added = true;
                        break;
                    }
                    if (added) continue;
                    itemsToAdd.add(item.func_77946_l());
                }
                ArrayList<ItemStack> itemsToCheck = new ArrayList<ItemStack>();
                for (ItemStack itemStack : itemsToAdd) {
                    itemsToCheck.add(itemStack.func_77946_l());
                }
                block4: for (ItemStack element : player.field_71071_by.field_70462_a) {
                    for (ItemStack itemStack : itemsToCheck) {
                        if (itemStack.field_77994_a <= 0) continue;
                        if (element == null) {
                            itemStack.field_77994_a -= itemStack.func_77976_d();
                            continue block4;
                        }
                        if (!element.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)element)) continue;
                        itemStack.field_77994_a -= itemStack.func_77976_d() - element.field_77994_a;
                        continue block4;
                    }
                }
                boolean valid = true;
                for (ItemStack itemStack : itemsToCheck) {
                    if (itemStack.field_77994_a <= 0) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    Quest.addItems(player, itemsToAdd);
                    player.field_71071_by.func_70296_d();
                    QuestData data = this.getQuestData(player);
                    Team team = QuestingData.getQuestingData(player).getTeam();
                    if (!team.isSingle() && team.getRewardSetting() == Team.RewardSetting.ANY) {
                        for (int i = 0; i < data.reward.length; ++i) {
                            data.reward[i] = false;
                        }
                        this.sendUpdatedDataToTeam(player);
                    } else {
                        data.claimReward(player);
                        this.sendUpdatedData(QuestingData.getUserName(player));
                    }
                    sentInfo = true;
                } else {
                    return;
                }
            }
            if (this.reputationRewards != null && this.getQuestData(player).canClaim()) {
                this.getQuestData((EntityPlayer)player).claimed = true;
                QuestingData.getQuestingData(player).getTeam().receiveAndSyncReputation(this, this.reputationRewards);
                EventHandler.instance().onEvent(new EventHandler.ReputationEvent(player));
                sentInfo = true;
            }
            if (this.commandRewardList != null && this.getQuestData(player).canClaim()) {
                this.getQuestData((EntityPlayer)player).claimed = true;
                this.commandRewardList.executeAll(player);
                sentInfo = true;
            }
            if (sentInfo) {
                SoundHandler.play(Sounds.COMPLETE, player);
            }
        }
    }

    public static void addItems(EntityPlayer player, List<ItemStack> itemsToAdd) {
        block0: for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Iterator<ItemStack> iterator = itemsToAdd.iterator();
            while (iterator.hasNext()) {
                int amount;
                ItemStack itemStack = iterator.next();
                if (player.field_71071_by.field_70462_a[i] == null) {
                    amount = Math.min(itemStack.func_77976_d(), itemStack.field_77994_a);
                    ItemStack copy = itemStack.func_77946_l();
                    copy.field_77994_a = amount;
                    player.field_71071_by.field_70462_a[i] = copy;
                    itemStack.field_77994_a -= amount;
                    if (itemStack.field_77994_a > 0) continue block0;
                    iterator.remove();
                    continue block0;
                }
                if (!player.field_71071_by.field_70462_a[i].func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)player.field_71071_by.field_70462_a[i])) continue;
                amount = Math.min(itemStack.func_77976_d() - player.field_71071_by.field_70462_a[i].field_77994_a, itemStack.field_77994_a);
                player.field_71071_by.field_70462_a[i].field_77994_a += amount;
                itemStack.field_77994_a -= amount;
                if (itemStack.field_77994_a > 0) continue block0;
                iterator.remove();
                continue block0;
            }
        }
    }

    public void setGuiCenterX(int x) {
        this.x = x - this.getGuiW() / 2;
    }

    public void setGuiCenterY(int y) {
        this.y = y - this.getGuiH() / 2;
    }

    public void setBigIcon(boolean b) {
        this.isBig = b;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
        this.cachedDescription = null;
    }

    public void setItem(GuiEditMenuItem.Element element, int id, GuiEditMenuItem.Type type, ItemPrecision precision, EntityPlayer player) {
        if (type == GuiEditMenuItem.Type.REWARD || type == GuiEditMenuItem.Type.PICK_REWARD) {
            ItemStack itemStack;
            if (element instanceof GuiEditMenuItem.ElementItem && (itemStack = (ItemStack)((GuiEditMenuItem.ElementItem)element).getItem()) != null) {
                itemStack.field_77994_a = Math.min(127, element.getAmount());
                this.setReward(itemStack, id, type == GuiEditMenuItem.Type.REWARD);
            }
        } else if (this.selectedTask != null && this.selectedTask instanceof QuestTaskItems) {
            ((QuestTaskItems)this.selectedTask).setItem(element, id, precision);
        } else if (this.selectedTask != null && this.selectedTask instanceof QuestTaskLocation && type == GuiEditMenuItem.Type.LOCATION) {
            ((QuestTaskLocation)this.selectedTask).setIcon(id, (ItemStack)element.getItem(), player);
        } else if (this.selectedTask != null && this.selectedTask instanceof QuestTaskMob && type == GuiEditMenuItem.Type.MOB) {
            ((QuestTaskMob)this.selectedTask).setIcon(id, (ItemStack)element.getItem(), player);
        }
    }

    private void setReward(ItemStack itemStack, int id, boolean isStandardReward) {
        ItemStackRewardList rewardList;
        ItemStackRewardList itemStackRewardList = rewardList = isStandardReward ? this.rewards : this.rewardChoices;
        if (id < rewardList.size()) {
            rewardList.set(id, itemStack);
            SaveHelper.add(SaveHelper.EditType.REWARD_CHANGE);
        } else {
            SaveHelper.add(SaveHelper.EditType.REWARD_CREATE);
            rewardList.add(itemStack);
        }
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
        if (icon != null) {
            icon.field_77994_a = 1;
        }
    }

    public boolean hasSameSetAs(Quest child) {
        return child.set.equals(this.set);
    }

    @SideOnly(value=Side.CLIENT)
    public void onScroll(GuiQuestBook gui, int x, int y, int scroll) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onScroll(gui, x, y, scroll);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onOpen(GuiQuestBook gui, EntityPlayer player) {
        if (this.selectedTask == null) {
            for (QuestTask task : this.tasks) {
                if (task.isCompleted(player)) continue;
                this.selectedTask = task;
                break;
            }
        }
        if (this.selectedTask == null && this.tasks.size() > 0) {
            this.selectedTask = this.tasks.get(0);
        }
    }

    public boolean hasSet(QuestSet selectedSet) {
        return this.set.equals(selectedSet);
    }

    public void mergeProgress(String playerName, QuestData own, QuestData other) {
        if (other.completed) {
            own.completed = true;
            if (other.available && !own.claimed) {
                own.available = true;
            }
        }
        for (int i = 0; i < own.tasks.length; ++i) {
            QuestTask task = this.tasks.get(i);
            own.tasks[i] = task.validateData(own.tasks[i]);
            task.mergeProgress(playerName, own.tasks[i], task.validateData(other.tasks[i]));
        }
    }

    public void copyProgress(QuestData own, QuestData other) {
        own.completed = other.completed;
        own.available = other.available;
        for (int i = 0; i < own.tasks.length; ++i) {
            QuestTask task = this.tasks.get(i);
            own.tasks[i] = task.validateData(own.tasks[i]);
            task.copyProgress(own.tasks[i], task.validateData(other.tasks[i]));
        }
    }

    public void completeQuest(EntityPlayer player) {
        for (QuestTask task : this.tasks) {
            task.autoComplete(QuestingData.getUserName(player));
            task.getData((EntityPlayer)player).completed = true;
        }
        QuestTask.completeQuest(this, QuestingData.getUserName(player));
    }

    public void reset(String playerName) {
        this.reset(this.getQuestData(playerName));
    }

    public void reset(QuestData data) {
        data.available = true;
        this.addTaskData(data);
    }

    public void resetAll() {
        for (Team team : QuestingData.getAllTeams()) {
            QuestData data = team.getQuestData(this.id);
            if (data == null || data.available) continue;
            this.reset(data);
            this.sendUpdatedDataToTeam(team);
        }
    }

    public void resetOnTime(int time) {
        for (Team team : QuestingData.getAllTeams()) {
            QuestData data = team.getQuestData(this.id);
            if (data == null || data.available || data.time > time) continue;
            this.reset(data);
            this.sendUpdatedDataToTeam(team);
        }
    }

    public float getProgress(Team team) {
        String name = team.getPlayers().get(0).getName();
        float data = 0.0f;
        for (QuestTask task : this.tasks) {
            data += task.getCompletedRatio(name);
        }
        return data / (float)this.tasks.size();
    }

    public List<Quest> getOptionLinks() {
        return this.optionLinks;
    }

    public List<Quest> getReversedOptionLinks() {
        return this.reversedOptionLinks;
    }

    public void setUseModifiedParentRequirement(boolean useModifiedParentRequirement) {
        this.useModifiedParentRequirement = useModifiedParentRequirement;
    }

    public boolean getUseModifiedParentRequirement() {
        return this.useModifiedParentRequirement;
    }

    public void setParentRequirementCount(int parentRequirementCount) {
        this.parentRequirementCount = parentRequirementCount;
    }

    public int getParentRequirementCount() {
        return this.parentRequirementCount;
    }

    public static void saveAll(DataWriter dw) {
        dw.writeString(QuestLine.getActiveQuestLine().mainDescription, DataBitHelper.QUEST_DESCRIPTION_LENGTH);
        dw.writeData(QuestLine.getActiveQuestLine().questSets.size(), DataBitHelper.QUEST_SETS);
        for (QuestSet questSet : QuestLine.getActiveQuestLine().questSets) {
            dw.writeString(questSet.getName(), DataBitHelper.QUEST_NAME_LENGTH);
            dw.writeString(questSet.getDescription(), DataBitHelper.QUEST_DESCRIPTION_LENGTH);
            dw.writeData(questSet.getReputationBars().size(), DataBitHelper.BYTE);
            for (ReputationBar reputationBar : questSet.getReputationBars()) {
                dw.writeData(reputationBar.save(), DataBitHelper.INT);
            }
        }
        Reputation.save(dw);
        dw.writeData(Quest.size(), DataBitHelper.QUESTS);
        for (int id = 0; id < Quest.size(); ++id) {
            Quest quest = Quest.getQuest(id);
            dw.writeBoolean(quest != null);
            if (quest == null) continue;
            dw.writeString(quest.getName(), DataBitHelper.QUEST_NAME_LENGTH);
            dw.writeString(quest.getDescription(), DataBitHelper.QUEST_DESCRIPTION_LENGTH);
            dw.writeData(quest.getGuiX(), DataBitHelper.QUEST_POS_X);
            dw.writeData(quest.getGuiY(), DataBitHelper.QUEST_POS_Y);
            dw.writeBoolean(quest.useBigIcon());
            dw.writeData(quest.set.getId(), DataBitHelper.QUEST_SETS);
            if (quest.getIcon() != null && quest.getIcon().func_77973_b() != null) {
                dw.writeBoolean(true);
                dw.writeItemStack(quest.getIcon(), false);
            } else {
                dw.writeBoolean(false);
            }
            dw.writeBoolean(!quest.requirement.isEmpty());
            if (!quest.requirement.isEmpty()) {
                dw.writeData(quest.requirement.size(), DataBitHelper.QUESTS);
                for (Quest required : quest.requirement) {
                    dw.writeData((int)required.getId(), DataBitHelper.QUESTS);
                }
            }
            dw.writeBoolean(!quest.optionLinks.isEmpty());
            if (!quest.optionLinks.isEmpty()) {
                dw.writeData(quest.optionLinks.size(), DataBitHelper.QUESTS);
                for (Quest optionLink : quest.optionLinks) {
                    dw.writeData((int)optionLink.getId(), DataBitHelper.QUESTS);
                }
            }
            quest.getRepeatInfo().save(dw);
            dw.writeData(quest.triggerType.ordinal(), DataBitHelper.TRIGGER_TYPE);
            if (quest.triggerType.isUseTaskCount()) {
                dw.writeData(quest.triggerTasks, DataBitHelper.TASKS);
            }
            if (quest.useModifiedParentRequirement) {
                dw.writeBoolean(true);
                dw.writeData(quest.parentRequirementCount, DataBitHelper.QUESTS);
            } else {
                dw.writeBoolean(false);
            }
            dw.writeData(quest.tasks.size(), DataBitHelper.TASKS);
            for (QuestTask task : quest.tasks) {
                int type = TaskType.getType(task.getClass()).ordinal();
                dw.writeData(type, DataBitHelper.TASK_TYPE);
                dw.writeString(task.getDescription(), DataBitHelper.QUEST_NAME_LENGTH);
                if (task.getLongDescription() != null) {
                    dw.writeString(task.getLongDescription(), DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                }
                task.save(dw);
            }
            Quest.writeRewardData(dw, quest.rewards.toArray(), quest);
            Quest.writeRewardData(dw, quest.rewardChoices.toArray(), quest);
            Quest.writeRewardData(dw, quest.commandRewardList);
            int count = quest.reputationRewards != null ? quest.reputationRewards.size() : 0;
            dw.writeData(count, DataBitHelper.REPUTATION_REWARD);
            if (quest.reputationRewards == null) continue;
            for (ReputationReward reputationReward : quest.reputationRewards) {
                dw.writeData(((Reputation)reputationReward.getReward()).getId(), DataBitHelper.REPUTATION);
                dw.writeData(reputationReward.getValue(), DataBitHelper.REPUTATION_VALUE);
            }
        }
        GroupTier.saveAll(dw);
        Group.saveAll(dw);
    }

    private static void writeRewardData(DataWriter dw, ItemStack[] reward, Quest quest) {
        dw.writeBoolean(reward != null);
        if (reward != null) {
            int count = 0;
            for (ItemStack itemStack : reward) {
                if (itemStack == null) continue;
                ++count;
            }
            dw.writeData(count, DataBitHelper.REWARDS);
            for (ItemStack itemStack : reward) {
                if (itemStack != null && itemStack.func_77973_b() != null) {
                    dw.writeItemStack(itemStack, true);
                    continue;
                }
                FMLLog.log((String)"HQM", (Level)Level.ERROR, (String)"The quest %s has an invalid item reference in it's rewards - substituting with HQM invalid item", (Object[])new Object[]{quest.getName()});
                dw.writeItemStack(new ItemStack(ModItems.invalidItem, 1), false);
            }
        }
    }

    private static void writeRewardData(DataWriter dw, CommandRewardList commands) {
        dw.writeBoolean(!commands.isEmpty());
        if (!commands.isEmpty()) {
            dw.writeData(commands.size(), DataBitHelper.REWARDS);
            for (String command : commands.asStrings()) {
                dw.writeString(command, DataBitHelper.QUEST_DESCRIPTION_LENGTH);
            }
        }
    }

    public static void loadAll(DataReader dr, FileVersion version) {
        if (isEditing) {
            FMLLog.log((String)"HQM-EDIT", (Level)Level.INFO, (String)"Loading quests", (Object[])new Object[0]);
        }
        if (dr != null) {
            EventHandler.instance().clear();
            try {
                String description;
                String name;
                QuestLine.getActiveQuestLine().mainDescription = version.lacks(FileVersion.LORE) ? "No description" : dr.readString(DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                if (version.lacks(FileVersion.SETS)) {
                    QuestLine.getActiveQuestLine().questSets.add(new QuestSet("Automatically generated", "This set was automatically generated. All your quests were put in this one."));
                } else {
                    int setCount = dr.readData(DataBitHelper.QUEST_SETS);
                    for (int i = 0; i < setCount; ++i) {
                        name = dr.readString(DataBitHelper.QUEST_NAME_LENGTH);
                        description = dr.readString(DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                        QuestSet questSet = new QuestSet(name, description);
                        if (version.contains(FileVersion.REPUTATION_BARS)) {
                            int barCount = dr.readData(DataBitHelper.BYTE);
                            for (int ii = 0; ii < barCount; ++ii) {
                                int data = dr.readData(DataBitHelper.INT);
                                questSet.addRepBar(new ReputationBar(version, data));
                            }
                        }
                        QuestLine.getActiveQuestLine().questSets.add(questSet);
                    }
                }
                Reputation.load(dr, version);
                int count = dr.readData(DataBitHelper.QUESTS);
                if (isEditing) {
                    FMLLog.log((String)"HQM-EDIT", (Level)Level.INFO, (String)"%d quests found", (Object[])new Object[]{count});
                }
                for (int id = 0; id < count; ++id) {
                    int i;
                    if (!dr.readBoolean()) continue;
                    name = dr.readString(DataBitHelper.QUEST_NAME_LENGTH);
                    description = dr.readString(DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                    int x = dr.readData(DataBitHelper.QUEST_POS_X);
                    int y = dr.readData(DataBitHelper.QUEST_POS_Y);
                    boolean big = dr.readBoolean();
                    Quest quest = new Quest(id, name, description, x, y, big);
                    if (isEditing) {
                        FMLLog.log((String)"HQM-EDIT", (Level)Level.INFO, (String)"Loading quest %s", (Object[])new Object[]{name});
                    }
                    if (version.lacks(FileVersion.SETS)) {
                        quest.setQuestSet(QuestLine.getActiveQuestLine().questSets.get(0));
                    } else {
                        int setId = dr.readData(DataBitHelper.QUEST_SETS);
                        quest.setQuestSet(QuestLine.getActiveQuestLine().questSets.get(setId));
                    }
                    if (version.contains(FileVersion.SETS) && dr.readBoolean()) {
                        ItemStack readItemStack = dr.readItemStack(false);
                        if (readItemStack.func_77973_b() == null) {
                            FMLLog.log((String)"HQM", (Level)Level.ERROR, (String)"Attempted to read invalid icon for quest", (Object[])new Object[0]);
                            readItemStack = null;
                        }
                        quest.setIcon(readItemStack);
                    } else {
                        quest.setIcon(null);
                    }
                    if (dr.readBoolean()) {
                        quest.requirementIds = new ArrayList<Integer>();
                        int requirementCount = dr.readData(DataBitHelper.QUESTS);
                        for (i = 0; i < requirementCount; ++i) {
                            quest.requirementIds.add(dr.readData(DataBitHelper.QUESTS));
                        }
                    }
                    if (version.contains(FileVersion.OPTION_LINKS) && dr.readBoolean()) {
                        quest.optionLinkIds = new ArrayList<Integer>();
                        int optionLinkCount = dr.readData(DataBitHelper.QUESTS);
                        for (i = 0; i < optionLinkCount; ++i) {
                            quest.optionLinkIds.add(dr.readData(DataBitHelper.QUESTS));
                        }
                    }
                    quest.getRepeatInfo().load(dr, version);
                    if (version.contains(FileVersion.TRIGGER_QUESTS)) {
                        quest.triggerType = TriggerType.values()[dr.readData(DataBitHelper.TRIGGER_TYPE)];
                        if (quest.triggerType.isUseTaskCount()) {
                            quest.triggerTasks = dr.readData(DataBitHelper.TASKS);
                        }
                    }
                    if (version.contains(FileVersion.PARENT_COUNT) && dr.readBoolean()) {
                        quest.useModifiedParentRequirement = true;
                        quest.parentRequirementCount = dr.readData(DataBitHelper.QUESTS);
                    } else {
                        quest.useModifiedParentRequirement = false;
                    }
                    int tasks = dr.readData(DataBitHelper.TASKS);
                    for (i = 0; i < tasks; ++i) {
                        int type = dr.readData(DataBitHelper.TASK_TYPE);
                        String taskName = dr.readString(DataBitHelper.QUEST_NAME_LENGTH);
                        String taskDescription = dr.readString(DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                        try {
                            Class clazz = TaskType.values()[type].clazz;
                            Constructor constructor = clazz.getConstructor(Quest.class, String.class, String.class);
                            Object obj = constructor.newInstance(quest, taskName, taskDescription);
                            QuestTask task = (QuestTask)obj;
                            task.load(dr, version);
                            if (quest.tasks.size() > 0) {
                                task.addRequirement(quest.tasks.get(quest.tasks.size() - 1));
                            }
                            quest.tasks.add(task);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (isEditing) {
                        FMLLog.log((String)"HQM-EDIT", (Level)Level.INFO, (String)"Loading quest rewards", (Object[])new Object[]{name});
                    }
                    quest.rewards.set(Quest.readRewardData(dr));
                    if (isEditing) {
                        FMLLog.log((String)"HQM-EDIT", (Level)Level.INFO, (String)"Loading quest reward choices", (Object[])new Object[]{name});
                    }
                    quest.rewardChoices.set(Quest.readRewardData(dr));
                    if (version.contains(FileVersion.COMMAND_REWARDS)) {
                        if (isEditing) {
                            FMLLog.log((String)"HQM-EDIT", (Level)Level.INFO, (String)"Loading quest reward choices", (Object[])new Object[]{name});
                        }
                        quest.commandRewardList.addAll(Quest.readCommandRewardData(dr));
                    }
                    if (version.contains(FileVersion.REPUTATION)) {
                        int reputationCount = dr.readData(DataBitHelper.REPUTATION_REWARD);
                        if (reputationCount == 0) {
                            quest.reputationRewards = null;
                            continue;
                        }
                        quest.reputationRewards = new ArrayList<ReputationReward>();
                        for (int i2 = 0; i2 < reputationCount; ++i2) {
                            quest.reputationRewards.add(new ReputationReward(Reputation.getReputation(dr.readData(DataBitHelper.REPUTATION)), dr.readData(DataBitHelper.REPUTATION_VALUE)));
                        }
                        continue;
                    }
                    quest.reputationRewards = null;
                }
                for (Quest quest : QuestLine.getActiveQuestLine().quests.values()) {
                    if (quest.requirementIds != null) {
                        for (Integer requirementId : quest.requirementIds) {
                            quest.addRequirement(requirementId);
                        }
                    }
                    if (quest.optionLinkIds == null) continue;
                    for (Integer optionLinkId : quest.optionLinkIds) {
                        quest.addOptionLink(optionLinkId);
                    }
                }
                if (isEditing) {
                    FMLLog.log((String)"HQM-EDIT", (Level)Level.INFO, (String)"Loading bags", (Object[])new Object[0]);
                }
                if (version.contains(FileVersion.BAGS)) {
                    GroupTier.readAll(dr, version);
                    Group.readAll(dr, version);
                }
                if (isEditing) {
                    FMLLog.log((String)"HQM-EDIT", (Level)Level.INFO, (String)"Loading complete", (Object[])new Object[0]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                FMLLog.log((String)"HQM", (Level)Level.ERROR, (Throwable)ex, (String)"Error occurred during quest loading", (Object[])new Object[0]);
            }
        }
        SaveHelper.onLoad();
    }

    private static ItemStack[] readRewardData(DataReader dr) {
        if (dr.readBoolean()) {
            int count = dr.readData(DataBitHelper.REWARDS);
            ItemStack[] reward = new ItemStack[count];
            for (int i = 0; i < reward.length; ++i) {
                ItemStack rewardItemStack = dr.readAndFixItemStack(true);
                if (rewardItemStack != null && rewardItemStack.func_77973_b() != null) {
                    reward[i] = rewardItemStack;
                    continue;
                }
                FMLLog.log((String)"HQM", (Level)Level.ERROR, (String)"Invalid reward item. Substituting with HQM invalid item.", (Object[])new Object[0]);
                reward[i] = new ItemStack(ModItems.invalidItem, 1);
            }
            return reward;
        }
        return null;
    }

    private static List<CommandReward> readCommandRewardData(DataReader dr) {
        ArrayList<CommandReward> rewards = new ArrayList<CommandReward>();
        if (dr.readBoolean()) {
            int count = dr.readData(DataBitHelper.REWARDS);
            for (int i = 0; i < count; ++i) {
                String commandString = dr.readString(DataBitHelper.QUEST_DESCRIPTION_LENGTH);
                rewards.add(new CommandReward(new CommandReward.Command(commandString)));
            }
        }
        return rewards;
    }

    public static void init(final String path) {
        FILE_HELPER = new FileHelper(){
            private boolean isUnLocked = true;
            private File file = new File(path + "quests.hqm");
            private File lock = new File(path + "lock.txt");

            @Override
            public boolean loadData(File file) {
                return super.loadData(this.file);
            }

            @Override
            public FileHelper.SaveResult saveData(File file) {
                return super.saveData(this.file);
            }

            @Override
            public void write(DataWriter dw) {
                String lockCode = this.readCode();
                dw.writeString(lockCode, DataBitHelper.PASS_CODE);
                Quest.saveAll(dw);
            }

            @Override
            public void read(DataReader dr, FileVersion version) {
                String code;
                this.isUnLocked = false;
                String string = code = version.lacks(FileVersion.LOCK) ? null : dr.readString(DataBitHelper.PASS_CODE);
                if (code == null || code.equals(this.readCode())) {
                    this.isUnLocked = true;
                }
                if (!isEditing || this.isUnLocked) {
                    Quest.loadAll(dr, version);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String readCode() {
                if (this.lock.exists()) {
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new FileReader(this.lock));
                        String str = br.readLine();
                        String string = str.substring(0, Math.min(DataBitHelper.PASS_CODE.getMaximum(), str.length()));
                        return string;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        String string = null;
                        return string;
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                return null;
            }
        };
        QuestLine.getActiveQuestLine().mainPath = path;
        QuestLine.getActiveQuestLine().quests = new HashMap<Short, Quest>();
        QuestLine.getActiveQuestLine().questSets = new ArrayList<QuestSet>();
        FILE_HELPER.loadData(null);
    }

    public static void removeQuest(Quest quest) {
        for (Quest requirement : quest.requirement) {
            requirement.reversedRequirement.remove(quest);
        }
        for (Quest optionLink : quest.optionLinks) {
            optionLink.reversedOptionLinks.remove(quest);
        }
        for (QuestTask task : quest.tasks) {
            task.onDelete();
        }
        quest.setQuestSet(null);
        QuestLine.getActiveQuestLine().quests.remove(quest.getId());
        for (Quest other : QuestLine.getActiveQuestLine().quests.values()) {
            Quest element;
            Iterator<Quest> iterator = other.requirement.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (element.getId() != quest.getId()) continue;
                iterator.remove();
            }
            iterator = other.optionLinks.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (element.getId() != quest.getId()) continue;
                iterator.remove();
            }
        }
    }

    public QuestSet getQuestSet() {
        return this.set;
    }

    public void setQuestSet(QuestSet set) {
        if (this.set != null) {
            this.set.removeQuest(this);
        }
        this.set = set;
        if (this.set != null) {
            this.set.addQuest(this);
        }
    }

    public List<Quest> getReversedRequirement() {
        return this.reversedRequirement;
    }

    static {
        isEditing = false;
    }

    public static enum TaskType {
        CONSUME(QuestTaskItemsConsume.class, "consume"),
        CRAFT(QuestTaskItemsCrafting.class, "craft"),
        LOCATION(QuestTaskLocation.class, "location"),
        CONSUME_QDS(QuestTaskItemsConsumeQDS.class, "consumeQDS"),
        DETECT(QuestTaskItemsDetect.class, "detect"),
        KILL(QuestTaskMob.class, "kill"),
        DEATH(QuestTaskDeath.class, "death"),
        REPUTATION(QuestTaskReputationTarget.class, "reputation"),
        REPUTATION_KILL(QuestTaskReputationKill.class, "reputationKill");

        private final Class<? extends QuestTask> clazz;
        private final String id;

        private TaskType(Class<? extends QuestTask> clazz, String id) {
            this.clazz = clazz;
            this.id = id;
        }

        public QuestTask addTask(Quest quest) {
            QuestTask prev = quest.getTasks().size() > 0 ? quest.getTasks().get(quest.getTasks().size() - 1) : null;
            try {
                Constructor<? extends QuestTask> ex = this.clazz.getConstructor(Quest.class, String.class, String.class);
                QuestTask task = ex.newInstance(quest, this.getName(), this.getDescription());
                if (prev != null) {
                    task.addRequirement(prev);
                }
                quest.getTasks().add(task);
                SaveHelper.add(SaveHelper.EditType.TASK_CREATE);
                return task;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static TaskType getType(Class<? extends QuestTask> clazz) {
            for (TaskType type : TaskType.values()) {
                if (type.clazz != clazz) continue;
                return type;
            }
            return CONSUME;
        }

        public String getLangKeyDescription() {
            return "hqm.taskType." + this.id + ".desc";
        }

        public String getLangKeyName() {
            return "hqm.taskType." + this.id + ".title";
        }

        public String getDescription() {
            return Translator.translate(this.getLangKeyDescription());
        }

        public String getName() {
            return Translator.translate(this.getLangKeyName());
        }
    }

    private abstract class ParentEvaluator {
        private ParentEvaluator() {
        }

        protected abstract boolean isValid(String var1, Quest var2, Map<Quest, Boolean> var3, Map<Quest, Boolean> var4);

        private boolean isValid(String playerName, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            int requiredAmount;
            int parents = Quest.this.getRequirement().size();
            int n = requiredAmount = Quest.this.useModifiedParentRequirement ? Quest.this.parentRequirementCount : parents;
            if (requiredAmount > parents) {
                return false;
            }
            int allowedUncompleted = parents - requiredAmount;
            int uncompleted = 0;
            for (Quest quest : Quest.this.getRequirement()) {
                if (this.isValid(playerName, quest, isVisibleCache, isLinkFreeCache) || ++uncompleted <= allowedUncompleted) continue;
                return false;
            }
            return true;
        }
    }
}

