/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.OPBookHelper;
import hardcorequesting.SaveHelper;
import hardcorequesting.Translator;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiEditMenuItem;
import hardcorequesting.client.interfaces.GuiEditMenuParentCount;
import hardcorequesting.client.interfaces.GuiEditMenuRepeat;
import hardcorequesting.client.interfaces.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.GuiEditMenuTrigger;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestTask;
import hardcorequesting.reputation.ReputationBar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class QuestSet {
    private String name;
    private String description;
    private List<String> cachedDescription;
    private final List<Quest> quests;
    private final List<ReputationBar> reputationBars;
    private int id;
    private static final int LINE_2_X = 10;
    private static final int LINE_2_Y = 12;
    private static final int INFO_Y = 100;

    public QuestSet(String name, String description) {
        this.name = name;
        this.description = description;
        this.quests = new ArrayList<Quest>();
        this.reputationBars = new ArrayList<ReputationBar>();
        this.id = Quest.getQuestSets().size();
    }

    public List<Quest> getQuests() {
        return this.quests;
    }

    public List<ReputationBar> getReputationBars() {
        this.validateBars();
        return this.reputationBars;
    }

    private void validateBars() {
        ArrayList<ReputationBar> toRemove = new ArrayList<ReputationBar>();
        for (ReputationBar reputationBar : this.reputationBars) {
            if (reputationBar.isValid()) continue;
            toRemove.add(reputationBar);
        }
        this.reputationBars.removeAll(toRemove);
    }

    public String getName() {
        return this.name;
    }

    public String getName(int i) {
        return i + 1 + ". " + this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(this.description, 0.7f, 130);
        }
        return this.cachedDescription;
    }

    public boolean isEnabled(EntityPlayer player) {
        return this.isEnabled(player, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    private boolean isEnabled(EntityPlayer player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        if (this.quests.isEmpty()) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (!quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleted(EntityPlayer player) {
        if (this.quests.isEmpty()) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (quest.isCompleted(player)) continue;
            return false;
        }
        return true;
    }

    public void removeQuest(Quest quest) {
        this.quests.remove(quest);
    }

    public void addQuest(Quest quest) {
        this.quests.add(quest);
    }

    public void removeRepBar(ReputationBar repBar) {
        this.reputationBars.remove(repBar);
    }

    public void addRepBar(ReputationBar repBar) {
        if (repBar == null) {
            return;
        }
        repBar.setQuestSet(this.id);
        this.reputationBars.add(repBar);
    }

    public int getCompletedCount(EntityPlayer player) {
        return this.getCompletedCount(player, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    private int getCompletedCount(EntityPlayer player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        int count = 0;
        for (Quest quest : this.quests) {
            if (!quest.isCompleted(player) || !quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            ++count;
        }
        return count;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.cachedDescription = null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void decreaseId() {
        --this.id;
        for (ReputationBar reputationBar : this.reputationBars) {
            reputationBar.setQuestSet(this.id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawOverview(GuiQuestBook gui, ScrollBar setScroll, ScrollBar descriptionScroll, int x, int y) {
        EntityPlayer player = gui.getPlayer();
        List<QuestSet> questSets = Quest.getQuestSets();
        int start = setScroll.isVisible(gui) ? Math.round((float)(Quest.getQuestSets().size() - 7) * setScroll.getScroll()) : 0;
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        for (int i = start; i < Math.min(start + 7, questSets.size()); ++i) {
            QuestSet questSet = questSets.get(i);
            int setY = 20 + (i - start) * 29;
            int total = questSet.getQuests().size();
            boolean enabled = questSet.isEnabled(player, isVisibleCache, isLinkFreeCache);
            int completedCount = enabled ? questSet.getCompletedCount(player, isVisibleCache, isLinkFreeCache) : 0;
            boolean completed = true;
            int unclaimed = 0;
            for (Quest quest : questSet.getQuests()) {
                if (completed && !quest.isCompleted(player) && quest.isLinkFree(player, isLinkFreeCache)) {
                    completed = false;
                }
                if (!quest.isCompleted(player) || !quest.hasReward(player)) continue;
                ++unclaimed;
            }
            boolean selected = questSet == GuiQuestBook.selectedSet;
            boolean inBounds = gui.inBounds(25, setY, gui.getStringWidth(questSet.getName(i)), 9, x, y);
            int color = gui.modifyingQuestSet == questSet ? 0x4040DD : (enabled ? (completed ? (selected ? (inBounds ? 0x40BB40 : 0x40A040) : (inBounds ? 0x10A010 : 0x107010)) : (selected ? (inBounds ? 0xAAAAAA : 0x888888) : (inBounds ? 0x666666 : 0x404040))) : 0xDDDDDD);
            gui.drawString(questSet.getName(i), 25, setY, color);
            String info = enabled ? (completed ? Translator.translate("hqm.questBook.allQuests") : Translator.translate("hqm.questBook.percentageQuests", completedCount * 100 / total)) : Translator.translate("hqm.questBook.locked");
            gui.drawString(info, 35, setY + 12, 0.7f, color);
            if (!enabled || unclaimed == 0) continue;
            String toClaim = GuiColor.PURPLE.toString() + Translator.translate(unclaimed != 1, "hqm.questBook.unclaimedRewards", unclaimed);
            gui.drawString(toClaim, 35, setY + 12 + 8, 0.7f, -1);
        }
        if (Quest.isEditing && gui.getCurrentMode() == EditMode.CREATE) {
            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.questBook.createNewSet"), 0.7f, 130), 180, 20, 0.7f, 0x404040);
        } else {
            if (GuiQuestBook.selectedSet != null) {
                int startLine = descriptionScroll.isVisible(gui) ? Math.round((float)(GuiQuestBook.selectedSet.getDescription(gui).size() - 7) * descriptionScroll.getScroll()) : 0;
                gui.drawString(GuiQuestBook.selectedSet.getDescription(gui), startLine, 7, 180, 20, 0.7f, 0x404040);
            }
            QuestSet.drawQuestInfo(gui, GuiQuestBook.selectedSet, 180, GuiQuestBook.selectedSet == null ? 20 : 100, isVisibleCache, isLinkFreeCache);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, int x0, int y0, int x, int y) {
        int color;
        if (gui.isOpBook) {
            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.questBook.shiftSetReset"), 0.7f, 130), 184, 192, 0.7f, 0x707070);
        }
        EntityPlayer player = gui.getPlayer();
        for (ReputationBar bar : this.getReputationBars()) {
            bar.draw(gui, x, y, player);
        }
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        for (Quest child : this.getQuests()) {
            if (!Quest.isEditing && !child.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            for (Quest parent : child.getRequirement()) {
                if (!Quest.isEditing && !parent.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.hasSameSetAs(child)) continue;
                color = Quest.isEditing && (!child.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.isVisible(player, isVisibleCache, isLinkFreeCache)) ? 0x55404040 : -12566464;
                gui.drawLine(gui.getLeft() + parent.getGuiCenterX(), gui.getTop() + parent.getGuiCenterY(), gui.getLeft() + child.getGuiCenterX(), gui.getTop() + child.getGuiCenterY(), 5, color);
            }
        }
        if (Quest.isEditing) {
            for (Quest child : this.getQuests()) {
                for (Quest parent : child.getOptionLinks()) {
                    if (!parent.hasSameSetAs(child)) continue;
                    color = !child.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.isVisible(player, isVisibleCache, isLinkFreeCache) ? 1430274269 : -12566307;
                    gui.drawLine(gui.getLeft() + parent.getGuiCenterX(), gui.getTop() + parent.getGuiCenterY(), gui.getLeft() + child.getGuiCenterX(), gui.getTop() + child.getGuiCenterY(), 5, color);
                }
            }
        }
        for (Quest quest : this.getQuests()) {
            if (!Quest.isEditing && !quest.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            gui.applyColor(quest == gui.modifyingQuest ? -4456517 : quest.getColorFilter(player, gui.getTick()));
            ResourceHelper.bindResource(GuiBase.MAP_TEXTURE);
            gui.drawRect(quest.getGuiX(), quest.getGuiY(), quest.getGuiU(), quest.getGuiV(player, x, y), quest.getGuiW(), quest.getGuiH());
            int iconX = quest.getGuiCenterX() - 8;
            int iconY = quest.getGuiCenterY() - 8;
            if (quest.useBigIcon()) {
                ++iconX;
                ++iconY;
            }
            gui.drawItem(quest.getIcon(), iconX, iconY, true);
            GL11.glPopMatrix();
        }
        for (Quest quest : this.getQuests()) {
            boolean editing;
            boolean bl = editing = Quest.isEditing && !GuiScreen.func_146271_m();
            if (!editing && !quest.isVisible(player, isVisibleCache, isLinkFreeCache) || !quest.isMouseInObject(x, y)) continue;
            boolean shouldDrawText = false;
            boolean enabled = quest.isEnabled(player, isVisibleCache, isLinkFreeCache);
            String txt = "";
            if (enabled || editing) {
                txt = txt + quest.getName();
            }
            if (!enabled) {
                if (editing) {
                    txt = txt + "\n";
                }
                txt = txt + (Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.questBook.lockedQuest");
            }
            if (!enabled || editing) {
                int allowedUncompleted;
                int totalParentCount = 0;
                int totalCompletedCount = 0;
                int parentCount = 0;
                int completed = 0;
                ArrayList<Quest> externalQuests = new ArrayList<Quest>();
                for (Quest quest2 : quest.getRequirement()) {
                    ++totalParentCount;
                    boolean isCompleted = quest2.isCompleted(player);
                    if (isCompleted) {
                        ++totalCompletedCount;
                    }
                    if (quest2.hasSameSetAs(quest)) continue;
                    externalQuests.add(quest2);
                    ++parentCount;
                    if (!isCompleted) continue;
                    ++completed;
                }
                if (editing && totalParentCount > 0) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.GRAY) + Translator.translate(totalParentCount != 1, "hqm.questBook.parentCount", totalParentCount - totalCompletedCount, totalParentCount);
                    if (Keyboard.isKeyDown((int)19)) {
                        txt = txt + " [" + Translator.translate("hqm.questBook.holding", "R") + "]";
                        for (Quest quest3 : quest.getRequirement()) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.GRAY) + quest3.getName();
                            if (!quest3.isCompleted(player)) continue;
                            txt = txt + " " + (Object)((Object)GuiColor.WHITE) + " [" + Translator.translate("hqm.questBook.completed") + "]";
                        }
                    } else {
                        txt = txt + " [" + Translator.translate("hqm.questBook.hold", "R") + "]";
                    }
                }
                int n = allowedUncompleted = quest.getUseModifiedParentRequirement() ? Math.max(0, quest.getRequirement().size() - quest.getParentRequirementCount()) : 0;
                if (parentCount - completed > allowedUncompleted || editing && parentCount > 0) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + Translator.translate(totalParentCount != 1, "hqm.questBook.parentCountElsewhere", totalParentCount - totalCompletedCount, totalParentCount);
                    shouldDrawText = true;
                    if (editing) {
                        if (Keyboard.isKeyDown((int)18)) {
                            txt = txt + " [" + Translator.translate("hqm.questBook.holding", "E") + "]";
                            for (Quest parent : externalQuests) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + parent.getName() + " (" + parent.getQuestSet().getName() + ")";
                                if (!parent.isCompleted(player)) continue;
                                txt = txt + " " + (Object)((Object)GuiColor.WHITE) + " [" + Translator.translate("hqm.questBook.completed") + "]";
                            }
                        } else {
                            txt = txt + " [" + Translator.translate("hqm.questBook.hold", "E") + "]";
                        }
                    }
                }
                if (editing && quest.getUseModifiedParentRequirement()) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.MAGENTA);
                    int iterator = quest.getParentRequirementCount();
                    txt = iterator < quest.getRequirement().size() ? txt + Translator.translate(iterator != 1, "hqm.questBook.reqOnly", iterator) : (iterator > quest.getRequirement().size() ? txt + Translator.translate(iterator != 1, "hqm.questBook.reqMore", iterator) : txt + Translator.translate(iterator != 1, "hqm.questBook.reqAll", iterator));
                }
            }
            if (enabled || editing) {
                String repeatMessage;
                if (quest.isCompleted(player)) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.GREEN) + Translator.translate("hqm.questBook.completed");
                }
                if (quest.hasReward(player)) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.PURPLE) + Translator.translate("hqm.questBook.unclaimedReward");
                }
                String string = repeatMessage = enabled ? quest.getRepeatInfo().getMessage(quest, player) : quest.getRepeatInfo().getShortMessage();
                if (repeatMessage != null) {
                    txt = txt + "\n" + repeatMessage;
                }
                if (editing) {
                    int totalTasks = 0;
                    int completedTasks = 0;
                    for (QuestTask task : quest.getTasks()) {
                        ++totalTasks;
                        if (!task.isCompleted(player)) continue;
                        ++completedTasks;
                    }
                    if (totalTasks == 0) {
                        txt = txt + "\n" + (Object)((Object)GuiColor.RED) + Translator.translate("hqm.questBook.noTasks");
                    } else {
                        txt = txt + "\n" + (Object)((Object)GuiColor.CYAN) + Translator.translate("hqm.questBook.completedTasks", completedTasks, totalTasks);
                        if (Keyboard.isKeyDown((int)20)) {
                            txt = txt + " [" + Translator.translate("hqm.questBook.holding", "T") + "]";
                            for (QuestTask task : quest.getTasks()) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.CYAN) + task.getDescription();
                                if (!task.isCompleted(player)) continue;
                                txt = txt + (Object)((Object)GuiColor.WHITE) + " [" + Translator.translate("hqm.questBook.completed") + "]";
                            }
                        } else {
                            txt = txt + " [" + Translator.translate("hqm.questBook.holding", "T") + "]";
                        }
                    }
                    String triggerMessage = quest.getTriggerType().getMessage(quest);
                    if (triggerMessage != null) {
                        txt = txt + "\n" + triggerMessage;
                    }
                    if (!quest.isVisible(player, isVisibleCache, isLinkFreeCache)) {
                        String invisibilityMessage;
                        if (quest.isLinkFree(player, isLinkFreeCache)) {
                            boolean parentInvisible = false;
                            for (Quest parent : quest.getRequirement()) {
                                if (parent.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
                                parentInvisible = true;
                                break;
                            }
                            switch (quest.getTriggerType()) {
                                case ANTI_TRIGGER: {
                                    invisibilityMessage = Translator.translate("hqm.questBook.invisLocked");
                                    break;
                                }
                                case QUEST_TRIGGER: {
                                    invisibilityMessage = Translator.translate("hqm.questBook.invisPerm");
                                    parentInvisible = false;
                                    break;
                                }
                                case TASK_TRIGGER: {
                                    invisibilityMessage = Translator.translate(quest.getTriggerTasks() != 1, "hqm.questBook.invisCount", quest.getTriggerTasks());
                                    break;
                                }
                                default: {
                                    invisibilityMessage = null;
                                }
                            }
                            if (parentInvisible) {
                                String string2 = Translator.translate("hqm.questBook.invisInherit");
                                invisibilityMessage = invisibilityMessage == null ? string2 : string2 + " " + Translator.translate("hqm.questBook.and") + " " + invisibilityMessage;
                            }
                        } else {
                            invisibilityMessage = Translator.translate("hqm.questBook.invisOption");
                        }
                        if (invisibilityMessage != null) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.LIGHT_BLUE) + invisibilityMessage;
                        }
                    }
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    for (Quest quest4 : quest.getOptionLinks()) {
                        ids.add(Integer.valueOf(quest4.getId()));
                    }
                    for (Quest quest5 : quest.getReversedOptionLinks()) {
                        short id = quest5.getId();
                        if (ids.contains(id)) continue;
                        ids.add(Integer.valueOf(id));
                    }
                    int optionLinks = ids.size();
                    if (optionLinks > 0) {
                        txt = txt + "\n" + (Object)((Object)GuiColor.BLUE) + Translator.translate(optionLinks != 1, "hqm.questBook.optionLinks", optionLinks);
                        if (Keyboard.isKeyDown((int)24)) {
                            txt = txt + " [" + Translator.translate("hqm.questBook.holding", "O") + "]";
                            Iterator iterator = ids.iterator();
                            while (iterator.hasNext()) {
                                int id = (Integer)iterator.next();
                                Quest option = Quest.getQuest(id);
                                txt = txt + "\n" + (Object)((Object)GuiColor.BLUE) + option.getName();
                                if (option.hasSameSetAs(quest)) continue;
                                txt = txt + " (" + option.getQuestSet().getName() + ")";
                            }
                        } else {
                            txt = txt + " [" + Translator.translate("hqm.questBook.hold", "O") + "]";
                        }
                    }
                }
                ArrayList<Quest> externalQuests = new ArrayList<Quest>();
                int childCount = 0;
                for (Quest child : quest.getReversedRequirement()) {
                    if (quest.hasSameSetAs(child)) continue;
                    ++childCount;
                    externalQuests.add(child);
                }
                if (childCount > 0) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + Translator.translate(childCount != 1, "hqm.questBook.childUnlocks", childCount);
                    if (editing) {
                        if (Keyboard.isKeyDown((int)22)) {
                            txt = txt + " [" + Translator.translate("hqm.questBook.holding", "U") + "]";
                            for (Quest child : externalQuests) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + child.getName() + " (" + child.getQuestSet().getName() + ")";
                            }
                        } else {
                            txt = txt + " [" + Translator.translate("hqm.questBook.hold", "U") + "]";
                        }
                    }
                }
                shouldDrawText = true;
            }
            if (editing) {
                txt = txt + "\n\n" + (Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.questBook.ctrlNonEditor");
            }
            if (gui.isOpBook && GuiScreen.func_146272_n()) {
                txt = quest.isCompleted(player) ? txt + "\n\n" + (Object)((Object)GuiColor.RED) + Translator.translate("hqm.questBook.resetQuest") : txt + "\n\n" + (Object)((Object)GuiColor.ORANGE) + Translator.translate("hqm.questBook.completeQuest");
            }
            if (!shouldDrawText) break;
            gui.drawMouseOver(txt, x0, y0);
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuestInfo(GuiQuestBook gui, QuestSet set, int x, int y) {
        QuestSet.drawQuestInfo(gui, set, x, y, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawQuestInfo(GuiQuestBook gui, QuestSet set, int x, int y, HashMap<Quest, Boolean> isVisibleCache, HashMap<Quest, Boolean> isLinkFreeCache) {
        int completed = 0;
        int reward = 0;
        int enabled = 0;
        int total = 0;
        int realTotal = 0;
        EntityPlayer player = gui.getPlayer();
        for (Quest quest : Quest.getQuests()) {
            if (set != null && !quest.hasSet(set)) continue;
            ++realTotal;
            if (!quest.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            ++total;
            if (!quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            ++enabled;
            if (!quest.isCompleted(player)) continue;
            ++completed;
            if (!quest.hasReward(player)) continue;
            ++reward;
        }
        ArrayList<String> info = new ArrayList<String>();
        info.add(GuiColor.GRAY.toString() + Translator.translate(total != 1, "hqm.questBook.totalQuests", total));
        info.add(GuiColor.CYAN.toString() + Translator.translate(enabled != 1, "hqm.questBook.unlockedQuests", enabled));
        info.add(GuiColor.GREEN.toString() + Translator.translate(completed != 1, "hqm.questBook.completedQuests", completed));
        info.add(GuiColor.LIGHT_BLUE.toString() + Translator.translate(enabled - completed != 1, "hqm.questBook.totalQuests", enabled - completed));
        if (reward > 0) {
            info.add(GuiColor.PURPLE.toString() + Translator.translate(reward != 1, "hqm.questBook.unclaimedQuests", reward));
        }
        if (Quest.isEditing && !GuiScreen.func_146271_m()) {
            info.add(GuiColor.LIGHT_GRAY.toString() + Translator.translate(realTotal != 1, "hqm.questBook.inclInvisiQuests", realTotal));
        }
        gui.drawString(info, x, y, 0.7f, 0x404040);
    }

    @SideOnly(value=Side.CLIENT)
    public static void mouseClickedOverview(GuiQuestBook gui, ScrollBar setScroll, int x, int y) {
        List<QuestSet> questSets = Quest.getQuestSets();
        int start = setScroll.isVisible(gui) ? Math.round((float)(Quest.getQuestSets().size() - 7) * setScroll.getScroll()) : 0;
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        block6: for (int i = start; i < Math.min(start + 7, questSets.size()); ++i) {
            int setY = 20 + (i - start) * 29;
            QuestSet questSet = questSets.get(i);
            if (!gui.inBounds(25, setY, gui.getStringWidth(questSet.getName(i)), 9, x, y)) continue;
            switch (gui.getCurrentMode()) {
                case DELETE: {
                    if (!questSet.getQuests().isEmpty()) break block6;
                    for (int j = questSet.getId() + 1; j < Quest.getQuestSets().size(); ++j) {
                        Quest.getQuestSets().get(j).decreaseId();
                    }
                    Quest.getQuestSets().remove(questSet);
                    SaveHelper.add(SaveHelper.EditType.SET_REMOVE);
                    break;
                }
                case SWAP_SELECT: {
                    gui.modifyingQuestSet = gui.modifyingQuestSet == questSet ? null : questSet;
                    break;
                }
                case RENAME: {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, gui.getPlayer(), questSet, true));
                    break;
                }
                default: {
                    if (Quest.isEditing) break block6;
                    if (!questSet.isEnabled(gui.getPlayer(), isVisibleCache, isLinkFreeCache)) break;
                }
                case NORMAL: {
                    GuiQuestBook.selectedSet = GuiQuestBook.selectedSet == questSet ? null : questSet;
                    break;
                }
            }
            break;
        }
        if (Quest.isEditing && gui.getCurrentMode() == EditMode.RENAME && gui.inBounds(180, 20, 130, 44, x, y)) {
            gui.setEditMenu(new GuiEditMenuTextEditor(gui, gui.getPlayer(), GuiQuestBook.selectedSet, false));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(GuiQuestBook gui, int x, int y) {
        block31: {
            EntityPlayer player;
            block30: {
                player = gui.getPlayer();
                if (!Quest.isEditing || gui.getCurrentMode() != EditMode.CREATE && gui.getCurrentMode() != EditMode.REP_BAR_CREATE) break block30;
                switch (gui.getCurrentMode()) {
                    case CREATE: {
                        if (x > 0 && Quest.size() < DataBitHelper.QUESTS.getMaximum()) {
                            int i = 0;
                            for (Quest quest : this.getQuests()) {
                                if (!quest.getName().startsWith("Unnamed")) continue;
                                ++i;
                            }
                            Quest newQuest = new Quest(Quest.size(), "Unnamed" + (i == 0 ? "" : Integer.valueOf(i)), "Unnamed quest", 0, 0, false);
                            newQuest.setGuiCenterX(x);
                            newQuest.setGuiCenterY(y);
                            newQuest.setQuestSet(this);
                            SaveHelper.add(SaveHelper.EditType.QUEST_CREATE);
                            break;
                        }
                        break block31;
                    }
                    case REP_BAR_CREATE: {
                        gui.setEditMenu(new ReputationBar.EditGui(gui, player, x, y, this.getId()));
                        break;
                    }
                }
                break block31;
            }
            HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
            HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
            block18: for (Quest quest : this.getQuests()) {
                if (!Quest.isEditing && !quest.isVisible(player, isVisibleCache, isLinkFreeCache) || !quest.isMouseInObject(x, y)) continue;
                if (Quest.isEditing && gui.getCurrentMode() != EditMode.NORMAL) {
                    switch (gui.getCurrentMode()) {
                        case MOVE: {
                            gui.modifyingQuest = quest;
                            SaveHelper.add(SaveHelper.EditType.QUEST_MOVE);
                            break;
                        }
                        case REQUIREMENT: {
                            if (gui.modifyingQuest == quest) {
                                if (GuiScreen.func_146272_n()) {
                                    gui.modifyingQuest.clearRequirements();
                                }
                                gui.modifyingQuest = null;
                                break;
                            }
                            if (gui.modifyingQuest == null) {
                                gui.modifyingQuest = quest;
                                break;
                            }
                            gui.modifyingQuest.addRequirement(quest.getId());
                            break;
                        }
                        case SIZE: {
                            int cX = quest.getGuiCenterX();
                            int cY = quest.getGuiCenterY();
                            quest.setBigIcon(!quest.useBigIcon());
                            quest.setGuiCenterX(cX);
                            quest.setGuiCenterY(cY);
                            SaveHelper.add(SaveHelper.EditType.QUEST_SIZE_CHANGE);
                            break;
                        }
                        case ITEM: {
                            gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, quest.getIcon(), (int)quest.getId(), GuiEditMenuItem.Type.QUEST_ICON, 1, ItemPrecision.PRECISE));
                            break;
                        }
                        case DELETE: {
                            Quest.removeQuest(quest);
                            SaveHelper.add(SaveHelper.EditType.QUEST_REMOVE);
                            break;
                        }
                        case SWAP: {
                            if (gui.modifyingQuestSet == null || gui.modifyingQuestSet == this) break block18;
                            quest.setQuestSet(gui.modifyingQuestSet);
                            SaveHelper.add(SaveHelper.EditType.QUEST_CHANGE_SET);
                            break;
                        }
                        case REPEATABLE: {
                            gui.setEditMenu(new GuiEditMenuRepeat(gui, player, quest));
                            break;
                        }
                        case REQUIRED_PARENTS: {
                            gui.setEditMenu(new GuiEditMenuParentCount((GuiBase)gui, player, quest));
                            break;
                        }
                        case QUEST_SELECTION: {
                            Quest.selectedQuestId = quest.getId();
                            break;
                        }
                        case QUEST_OPTION: {
                            if (gui.modifyingQuest == quest) {
                                if (GuiScreen.func_146272_n()) {
                                    gui.modifyingQuest.clearOptionLinks();
                                }
                                gui.modifyingQuest = null;
                                break;
                            }
                            if (gui.modifyingQuest == null) {
                                gui.modifyingQuest = quest;
                                break;
                            }
                            gui.modifyingQuest.addOptionLink(quest.getId());
                            break;
                        }
                        case TRIGGER: {
                            gui.setEditMenu(new GuiEditMenuTrigger(gui, player, quest));
                            break;
                        }
                    }
                    break;
                }
                if (gui.isOpBook && GuiScreen.func_146272_n()) {
                    OPBookHelper.reverseQuestCompletion(quest, player);
                    break;
                }
                GuiQuestBook.selectedQuest = quest;
                quest.onOpen(gui, player);
                break;
            }
        }
        if (Quest.isEditing) {
            for (ReputationBar reputationBar : new ArrayList<ReputationBar>(this.getReputationBars())) {
                reputationBar.mouseClicked(gui, x, y);
            }
        }
    }
}

