/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.eventhandler;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.IEventListener;
import java.util.ArrayList;
import java.util.Collection;

public class ListenerList {
    private static ImmutableList<ListenerList> allLists = ImmutableList.of();
    private static int maxSize = 0;
    private ListenerList parent;
    private ListenerListInst[] lists = new ListenerListInst[0];

    public ListenerList() {
        this(null);
    }

    public ListenerList(ListenerList parent) {
        this.parent = parent;
        ListenerList.extendMasterList(this);
        this.resizeLists(maxSize);
    }

    private static synchronized void extendMasterList(ListenerList inst) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(allLists);
        builder.add((Object)inst);
        allLists = builder.build();
    }

    public static void resize(int max) {
        if (max <= maxSize) {
            return;
        }
        for (ListenerList list : allLists) {
            list.resizeLists(max);
        }
        maxSize = max;
    }

    public void resizeLists(int max) {
        if (this.parent != null) {
            this.parent.resizeLists(max);
        }
        if (this.lists.length >= max) {
            return;
        }
        ListenerListInst[] newList = new ListenerListInst[max];
        int x = 0;
        while (x < this.lists.length) {
            newList[x] = this.lists[x];
            ++x;
        }
        while (x < max) {
            newList[x] = this.parent != null ? new ListenerListInst(this.parent.getInstance(x)) : new ListenerListInst(null, null, null);
            ++x;
        }
        this.lists = newList;
    }

    public static void clearBusID(int id) {
        for (ListenerList list : allLists) {
            list.lists[id].dispose();
        }
    }

    protected ListenerListInst getInstance(int id) {
        return this.lists[id];
    }

    public IEventListener[] getListeners(int id) {
        return this.lists[id].getListeners();
    }

    public void register(int id, EventPriority priority, IEventListener listener) {
        this.lists[id].register(priority, listener);
    }

    public void unregister(int id, IEventListener listener) {
        this.lists[id].unregister(listener);
    }

    public static void unregisterAll(int id, IEventListener listener) {
        for (ListenerList list : allLists) {
            list.unregister(id, listener);
        }
    }

    private class ListenerListInst {
        private boolean rebuild = true;
        private IEventListener[] listeners;
        private ArrayList<ArrayList<IEventListener>> priorities;
        private ListenerListInst parent;

        private ListenerListInst() {
            int count = EventPriority.values().length;
            this.priorities = new ArrayList(count);
            int x = 0;
            while (x < count) {
                this.priorities.add(new ArrayList());
                ++x;
            }
        }

        public void dispose() {
            for (ArrayList<IEventListener> listeners : this.priorities) {
                listeners.clear();
            }
            this.priorities.clear();
            this.parent = null;
            this.listeners = null;
        }

        private ListenerListInst(ListenerListInst parent) {
            this();
            this.parent = parent;
        }

        public ArrayList<IEventListener> getListeners(EventPriority priority) {
            ArrayList<IEventListener> ret = new ArrayList<IEventListener>((Collection)this.priorities.get(priority.ordinal()));
            if (this.parent != null) {
                ret.addAll(this.parent.getListeners(priority));
            }
            return ret;
        }

        public IEventListener[] getListeners() {
            if (this.shouldRebuild()) {
                this.buildCache();
            }
            return this.listeners;
        }

        protected boolean shouldRebuild() {
            return this.rebuild || this.parent != null && this.parent.shouldRebuild();
        }

        private void buildCache() {
            if (this.parent != null && this.parent.shouldRebuild()) {
                this.parent.buildCache();
            }
            ArrayList<IEventListener> ret = new ArrayList<IEventListener>();
            EventPriority[] eventPriorityArray = EventPriority.values();
            int n = eventPriorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventPriority value = eventPriorityArray[n2];
                ArrayList<IEventListener> listeners = this.getListeners(value);
                if (listeners.size() > 0) {
                    ret.add(value);
                    ret.addAll(listeners);
                }
                ++n2;
            }
            this.listeners = ret.toArray(new IEventListener[ret.size()]);
            this.rebuild = false;
        }

        public void register(EventPriority priority, IEventListener listener) {
            this.priorities.get(priority.ordinal()).add(listener);
            this.rebuild = true;
        }

        public void unregister(IEventListener listener) {
            for (ArrayList<IEventListener> list : this.priorities) {
                if (!list.remove(listener)) continue;
                this.rebuild = true;
            }
        }

        /* synthetic */ ListenerListInst(ListenerListInst listenerListInst, ListenerListInst listenerListInst2, ListenerListInst listenerListInst3) {
            this();
        }
    }
}

