/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.handlers;

import com.teammetallurgy.metallurgy.metals.ItemMoltenMetalBucket;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BucketsHandler {
    public static BucketsHandler instance = new BucketsHandler();
    private HashMap<ItemStack, Block> bucketBlocks = new HashMap();
    private HashMap<Block, ItemStack> blockBuckets = new HashMap();
    private static ItemMoltenMetalBucket bucket;

    public void fillBucket(FillBucketEvent event) {
        World world = event.world;
        MovingObjectPosition pos = event.target;
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        ItemStack bucketStack = this.blockBuckets.get(block);
        if (bucketStack == null) {
            return;
        }
        world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        event.result = bucketStack;
        event.setResult(Event.Result.ALLOW);
    }

    public Block getFilledBlock(ItemStack filledBucket) {
        Block block = Blocks.field_150350_a;
        for (Map.Entry<ItemStack, Block> entry : this.bucketBlocks.entrySet()) {
            if (!entry.getKey().func_77969_a(filledBucket)) continue;
            block = entry.getValue();
        }
        return block;
    }

    public void addMoltenMapping(ItemStack stack, Block fluidBlock) {
        this.bucketBlocks.put(stack, fluidBlock);
        this.blockBuckets.put(fluidBlock, stack);
    }

    public void addBucketMapping(int id, String unlocalizedName, String texture) {
        bucket.addMaping(id, "metallurgy.bucket.filled." + unlocalizedName, "Metallurgy".toLowerCase(Locale.US) + ":" + texture);
    }

    public void init() {
        bucket = new ItemMoltenMetalBucket();
        GameRegistry.registerItem((Item)bucket, (String)"molten.bucket");
        int bucketVol = 1000;
        ItemStack emptyBucketStack = new ItemStack(Items.field_151133_ar);
        TreeMap<String, String[]> materialSets = new TreeMap<String, String[]>();
        String[] baseMaterials = new String[]{"angmallen", "bronze", "copper", "damascus steel", "hepatizon", "manganese", "steel", "tin"};
        String[] enderMaterials = new String[]{"desichalkos", "eximite", "meutoite"};
        String[] fantasyMaterials = new String[]{"adamantine", "astral silver", "atlarus", "black steel", "carmot", "celenegil", "deep iron", "haderoth", "infuscolium", "mithril", "orichalcum", "oureclase", "prometheum", "quicksilver", "rubracium", "tartarite"};
        String[] netherMaterials = new String[]{"alduorite", "amordrine", "ceruclase", "ignatius", "inolashite", "kalendrite", "lemurite", "midasium", "sanguinite", "shadow iron", "shadow steel", "vulcanite", "vyroxeres"};
        String[] preciousMaterials = new String[]{"brass", "electrum", "platinum", "silver", "zinc"};
        materialSets.put("base", baseMaterials);
        materialSets.put("ender", enderMaterials);
        materialSets.put("fantasy", fantasyMaterials);
        materialSets.put("nether", netherMaterials);
        materialSets.put("precious", preciousMaterials);
        int bucketId = 0;
        for (Map.Entry entrySet : materialSets.entrySet()) {
            String set = (String)entrySet.getKey();
            String[] materials = (String[])entrySet.getValue();
            for (int i = 0; i < materials.length; ++i) {
                String unlocalizedName = materials[i].trim().replace(" ", ".").toLowerCase(Locale.US);
                unlocalizedName = unlocalizedName + ".molten";
                String texture = set.trim().replace(" ", "_").toLowerCase(Locale.US) + "/";
                texture = texture + materials[i].trim().replace(" ", "_").toLowerCase(Locale.US);
                texture = texture + "_bucket_fill";
                FluidStack fluidStack = FluidRegistry.getFluidStack((String)unlocalizedName, (int)bucketVol);
                if (fluidStack == null) continue;
                ++bucketId;
                ItemStack testBucket = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)emptyBucketStack);
                if (testBucket != null) continue;
                this.addBucketMapping(bucketId, unlocalizedName, texture);
                ItemStack bucketStack = new ItemStack((Item)bucket, 1, bucketId);
                this.addMoltenMapping(bucketStack, fluidStack.getFluid().getBlock());
                FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
            }
        }
    }
}

