/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.metals;

import com.teammetallurgy.metallurgy.handlers.ConfigHandler;
import com.teammetallurgy.metallurgy.handlers.LogHandler;
import com.teammetallurgy.metallurgy.recipes.AbstractorRecipes;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class MetalMaterials {
    public static MetalMaterials Instance = new MetalMaterials();

    public void addRecipes() {
        if (ConfigHandler.recipeEnabled("alternative_rails")) {
            this.addRailRecipes();
        }
        if (ConfigHandler.recipeEnabled("midasium_to_gold")) {
            this.addMidasiumRecipes();
        }
        if (ConfigHandler.recipeEnabled("alternative_iron_dust")) {
            this.addIronDustRecipes();
        }
        if (ConfigHandler.recipeEnabled("alternative_blaze_rod")) {
            this.addBlazeRodRecipe();
        }
        if (ConfigHandler.recipeEnabled("alternative_ender_perl")) {
            this.addEnderPerlRecipe();
        }
        if (ConfigHandler.recipeEnabled("alternative_gunpowder")) {
            this.addGunpowderRecipe();
        }
        this.addAbstractorCatalysts();
    }

    private void addRailRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150448_aq, 4), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotCopper", Character.valueOf('S'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150448_aq, 10), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotBronze", Character.valueOf('S'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150448_aq, 14), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotHepatizon", Character.valueOf('S'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150448_aq, 26), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotDamascusSteel", Character.valueOf('S'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150448_aq, 32), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotAngmallen", Character.valueOf('S'), "stickWood"}));
    }

    private void addMidasiumRecipes() {
        String[] ores;
        ArrayList goldDusts = OreDictionary.getOres((String)"dustGold");
        if (goldDusts.size() < 1) {
            LogHandler.log("Gold dust wasn't found in the ore dictionary, skipping adding Midasium recipes");
            return;
        }
        ItemStack dustGold = (ItemStack)goldDusts.get(0);
        if (dustGold == null) {
            LogHandler.log("Gold dust wasn't found in the ore dictionary, skipping adding Midasium recipes");
            return;
        }
        for (String name : ores = OreDictionary.getOreNames()) {
            if (!name.contains("dust") || name.toLowerCase(Locale.US).contains("tiny") || name.toLowerCase(Locale.US).contains("clay") || name.toLowerCase(Locale.US).contains("quartz") || name.toLowerCase(Locale.US).contentEquals("dustgold")) continue;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(dustGold.func_77946_l(), new Object[]{"dustMidasium", name}));
        }
    }

    private void addIronDustRecipes() {
        ArrayList ironDusts = OreDictionary.getOres((String)"dustIron");
        if (ironDusts.size() < 1) {
            LogHandler.log("Iron Dust wasn't found in the ore dictionary, skipping adding Iron dust coverting recipes");
            return;
        }
        ItemStack dustIron = (ItemStack)ironDusts.get(0);
        if (dustIron == null) {
            LogHandler.log("Iron Dust wasn't found in the ore dictionary, skipping adding Iron dust coverting recipes");
            return;
        }
        dustIron = dustIron.func_77946_l();
        dustIron.field_77994_a = 2;
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(dustIron.func_77946_l(), new Object[]{"dustShadowIron", "dustIgnatius"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(dustIron.func_77946_l(), new Object[]{"dustDeepIron", "dustPrometheum"}));
    }

    private void addBlazeRodRecipe() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151072_bj), new Object[]{"I", "I", Character.valueOf('I'), "ingotVulcanite"}));
    }

    private void addEnderPerlRecipe() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151079_bi, 4), new Object[]{" E ", "E E", " E ", Character.valueOf('E'), "ingotMeutoite"}));
    }

    private void addGunpowderRecipe() {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151016_H, 4), new Object[]{new ItemStack(Items.field_151044_h, 1, 1), "dustSulfur", "dustSaltpeter"}));
    }

    private void addAbstractorCatalysts() {
        ArrayList prometheumDusts = OreDictionary.getOres((String)"dustPrometheum");
        ArrayList astralSilverDusts = OreDictionary.getOres((String)"dustAstralSilver");
        ArrayList carmotDusts = OreDictionary.getOres((String)"dustCarmot");
        for (ItemStack dust : prometheumDusts) {
            AbstractorRecipes.getInstance().addCatalyst(dust.func_77946_l(), 1.0f);
        }
        for (ItemStack dust : astralSilverDusts) {
            AbstractorRecipes.getInstance().addCatalyst(dust.func_77946_l(), 2.0f);
        }
        for (ItemStack dust : carmotDusts) {
            AbstractorRecipes.getInstance().addCatalyst(dust.func_77946_l(), 3.0f);
        }
    }
}

