/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.teammetallurgy.metallurgy.machines.crusher.GUICrusher;
import com.teammetallurgy.metallurgy.recipes.CrusherRecipes;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class CrusherHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(77, 22, 12, 24), "metallurgy.crusher", new Object[0]));
    }

    public String getGuiTexture() {
        return "metallurgy:textures/gui/nei_crusher.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(77, 22, 176, 14, 12, 24, 48, 1);
    }

    public String getRecipeName() {
        return NEIClientUtils.translate((String)"recipe.metallurgy.crusher", (Object[])new Object[0]);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GUICrusher.class;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("metallurgy.crusher") && ((Object)((Object)this)).getClass() == CrusherHandler.class) {
            HashMap<ItemStack, ItemStack> recipes = CrusherRecipes.getInstance().getRecipes();
            for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
                this.arecipes.add(new NEICrusherRecipe(recipe.getKey(), recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        HashMap<ItemStack, ItemStack> recipes = CrusherRecipes.getInstance().getInput(result);
        if (recipes != null && !recipes.isEmpty()) {
            for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
                NEICrusherRecipe neiRecipe = new NEICrusherRecipe(recipe.getKey(), recipe.getValue());
                this.arecipes.add(neiRecipe);
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ItemStack result = CrusherRecipes.getInstance().getCrushingResult(ingredient);
        if (result != null) {
            NEICrusherRecipe neiRecipe = new NEICrusherRecipe(ingredient, result);
            this.arecipes.add(neiRecipe);
        }
    }

    public String getOverlayIdentifier() {
        return "metallurgy.crusher";
    }

    private class NEICrusherRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack ingredient;
        public PositionedStack result;

        public NEICrusherRecipe(ItemStack input, ItemStack craftingResult) {
            super((TemplateRecipeHandler)CrusherHandler.this);
            this.result = new PositionedStack((Object)craftingResult, 75, 48);
            this.ingredient = new PositionedStack((Object)input, 75, 3);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CrusherHandler.this.cycleticks / 48, Arrays.asList(this.ingredient));
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

