/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgycore.guiwidgets;

import com.teammetallurgy.metallurgycore.guiwidgets.FluidRender;
import com.teammetallurgy.metallurgycore.machines.GUIMetallurgy;
import com.teammetallurgy.metallurgycore.machines.GUIMetallurgyMachine;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidWidget {
    private final FluidTank tank;
    private final int x;
    private final int y;
    private final int u;
    private final int v;
    private final int w;
    private final int h;

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public FluidWidget(FluidTank tank, int x, int y, int u, int v, int w, int h) {
        this.tank = tank;
        this.x = x;
        this.y = y;
        this.u = u;
        this.v = v;
        this.w = w;
        this.h = h;
    }

    public void drawLiquid(GUIMetallurgy gui, int guiX, int guiY, ResourceLocation texture) {
        if (this.tank == null) {
            return;
        }
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack == null || fluidStack.amount <= 0 || fluidStack.getFluid() == null) {
            return;
        }
        IIcon liquidIcon = FluidRender.getFluidTexture(fluidStack, false);
        if (liquidIcon == null) {
            return;
        }
        double scale = (double)fluidStack.amount / (double)this.tank.getCapacity();
        GUIMetallurgyMachine.bindTexture(FluidRender.getFluidSheet(fluidStack));
        for (int col = 0; col < this.w / 16; ++col) {
            for (int row = 0; row <= this.h / 16; ++row) {
                gui.func_94065_a(guiX + this.x + col * 16, guiY + this.y + row * 16, liquidIcon, 16, 16);
            }
        }
        GUIMetallurgyMachine.bindTexture(texture);
        gui.func_73729_b(guiX + this.x, guiY + this.y - 1, this.x, this.y - 1, this.w, this.h - (int)Math.floor((double)this.h * scale));
        gui.func_73729_b(guiX + this.x, guiY + this.y + this.h - 1, 8, this.y + this.h - 1, this.w, 20);
    }
}

