/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.setup.recipe.handler;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.setup.Machine;

public abstract class ShapelessMachineTinker
extends ShapelessRecipes {
    protected List<List<ItemStack>> _tinkerItems;
    protected ItemStack _machine;

    private static ItemStack createMachineWithLore(Machine machine, String string) {
        ItemStack itemStack = machine.getItemStack();
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74782_a("display", (NBTBase)new NBTTagCompound());
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagCompound.func_74775_l("display").func_74782_a("Lore", (NBTBase)nBTTagList);
        nBTTagList.func_74742_a((NBTBase)new NBTTagString(string));
        itemStack.func_77982_d(nBTTagCompound);
        return itemStack;
    }

    private static List<ItemStack> createIngredientListforNEI(Machine machine, ItemStack ... itemStackArray) {
        LinkedList<ItemStack> linkedList = new LinkedList<ItemStack>();
        linkedList.addAll(Arrays.asList(itemStackArray));
        linkedList.add(machine.getItemStack());
        return linkedList;
    }

    public ShapelessMachineTinker(Machine machine, String string, String ... stringArray) {
        super(ShapelessMachineTinker.createMachineWithLore(machine, string), null);
        this._machine = machine.getItemStack();
        this._tinkerItems = new LinkedList<List<ItemStack>>();
        for (String string2 : stringArray) {
            this._tinkerItems.add(OreDictionary.getOres((String)string2));
        }
        RecipeSorter.register((String)"minefactoryreloaded:shapelessTinker", ((Object)((Object)this)).getClass(), (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    public ShapelessMachineTinker(Machine machine, String string, ItemStack ... itemStackArray) {
        super(ShapelessMachineTinker.createMachineWithLore(machine, string), ShapelessMachineTinker.createIngredientListforNEI(machine, itemStackArray));
        this._machine = machine.getItemStack();
        this._tinkerItems = new LinkedList<List<ItemStack>>();
        for (ItemStack itemStack : itemStackArray) {
            LinkedList<ItemStack> linkedList = new LinkedList<ItemStack>();
            linkedList.add(itemStack);
            this._tinkerItems.add(linkedList);
        }
        RecipeSorter.register((String)"minefactoryreloaded:shapelessTinker", ((Object)((Object)this)).getClass(), (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    protected abstract boolean isMachineTinkerable(ItemStack var1);

    protected abstract ItemStack getTinkeredMachine(ItemStack var1);

    public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
        int n = inventoryCrafting.func_70302_i_();
        boolean bl = false;
        LinkedList<List<ItemStack>> linkedList = new LinkedList<List<ItemStack>>();
        linkedList.addAll(this._tinkerItems);
        block0: while (n-- > 0) {
            ItemStack itemStack = inventoryCrafting.func_70301_a(n);
            if (itemStack == null) continue;
            if (UtilInventory.stacksEqual(this._machine, itemStack, false)) {
                if (bl || !this.isMachineTinkerable(itemStack)) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (bl && linkedList.isEmpty()) {
                return true;
            }
            for (List list : linkedList) {
                for (ItemStack itemStack2 : list) {
                    if (!UtilInventory.stacksEqual(itemStack, itemStack2)) continue;
                    linkedList.remove(list);
                    continue block0;
                }
            }
            return false;
        }
        return bl && linkedList.isEmpty();
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        int n = inventoryCrafting.func_70302_i_();
        while (n-- > 0) {
            ItemStack itemStack = inventoryCrafting.func_70301_a(n);
            if (!UtilInventory.stacksEqual(this._machine, itemStack, false) || !this.isMachineTinkerable(itemStack)) continue;
            return this.getTinkeredMachine(itemStack);
        }
        return null;
    }
}

