/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.CoreUtils;
import cofh.core.util.fluid.FluidTankAdv;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiBioReactor;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerBioReactor;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityBioReactor
extends TileEntityFactoryInventory
implements ITankContainerBucketable {
    private int _burnTime;
    private static final int _burnTimeMax = 8000;
    private static final int _bioFuelPerTick = 1;
    private static final int _burnTimeDecreasePerTick = 1;
    private static final int[] _outputValues = new int[]{0, 5, 25, 70, 150, 275, 455, 700, 1020, 1425};

    public TileEntityBioReactor() {
        super(Machine.BioReactor);
        this.setManageSolids(true);
    }

    public int getBurnTime() {
        return this._burnTime;
    }

    public void setBurnTime(int n) {
        this._burnTime = n;
    }

    public int getBurnTimeMax() {
        return 8000;
    }

    public int getOutputValue() {
        int n = 0;
        for (int i = 9; i < 18; ++i) {
            if (this._inventory[i] == null) continue;
            ++n;
        }
        return _outputValues[n];
    }

    public int getOutputValueMax() {
        return _outputValues[9];
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            int n;
            Map<Item, IFactoryPlantable> map = MFRRegistry.getPlantables();
            for (n = 0; n < 9; ++n) {
                int n2;
                ItemStack itemStack = this._inventory[n];
                if (itemStack == null || !map.containsKey(itemStack.func_77973_b()) || !map.get(itemStack.func_77973_b()).canBePlanted(itemStack, true) || (n2 = this.findMatchingSlot(this._inventory[n])) < 0) continue;
                if (this._inventory[n2] == null) {
                    this._inventory[n2] = this._inventory[n];
                    this._inventory[n] = null;
                    continue;
                }
                UtilInventory.mergeStacks(this._inventory[n2], this._inventory[n]);
                if (this._inventory[n].field_77994_a > 0) continue;
                this._inventory[n] = null;
            }
            if (this._rednetState != 0 || CoreUtils.isRedstonePowered((TileEntity)this)) {
                return;
            }
            n = this.getOutputValue();
            if (8000 - this._burnTime >= n) {
                this._burnTime += n;
                for (int i = 9; i < 18; ++i) {
                    if (this._inventory[i] == null) continue;
                    this.func_70298_a(i, 1);
                }
            }
            if (this._burnTime > 0 && this._tanks[0].getFluidAmount() <= this._tanks[0].getCapacity() - 1) {
                --this._burnTime;
                this._tanks[0].fill(FluidRegistry.getFluidStack((String)"biofuel", (int)1), true);
            }
        }
    }

    private int findMatchingSlot(ItemStack itemStack) {
        int n = -1;
        for (int i = 9; i < 18; ++i) {
            if (this._inventory[i] == null) {
                if (n != -1) continue;
                n = i;
                continue;
            }
            if (!this._inventory[i].func_77969_a(itemStack)) continue;
            return i;
        }
        return n;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiBioReactor(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerBioReactor getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerBioReactor(this, inventoryPlayer);
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    public int func_70302_i_() {
        return 18;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 9;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (itemStack != null && n < 9) {
            IFactoryPlantable iFactoryPlantable = MFRRegistry.getPlantables().get(itemStack.func_77973_b());
            return iFactoryPlantable != null && iFactoryPlantable.canBePlanted(itemStack, true);
        }
        return false;
    }

    @Override
    public boolean allowBucketDrain(ItemStack itemStack) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        if (this._burnTime != 0) {
            nBTTagCompound.func_74768_a("burnTime", this._burnTime);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._burnTime = nBTTagCompound.func_74762_e("burnTime");
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

