/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.core.IEntityCollidable;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityCollector
extends TileEntityFactoryInventory
implements IEntityCollidable {
    protected boolean canStuff;

    public TileEntityCollector() {
        super(Machine.ItemCollector);
        this.setManageSolids(true);
        this.canStuff = false;
    }

    @Override
    public void onEntityCollided(Entity entity) {
        if (this.failedDrops == null && entity instanceof EntityItem) {
            this.addToChests((EntityItem)entity);
        }
    }

    protected void addToChests(EntityItem entityItem) {
        if (entityItem.field_70128_L) {
            return;
        }
        ItemStack itemStack = this.addToChests(entityItem.func_92059_d());
        if (itemStack == null) {
            entityItem.func_70106_y();
            return;
        }
        entityItem.func_92058_a(itemStack);
    }

    protected ItemStack addToChests(ItemStack itemStack) {
        if (this.canStuff & this.failedDrops == null & (itemStack = UtilInventory.dropStack((TileEntity)this, itemStack, MFRUtil.directionsWithoutConveyors(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e), ForgeDirection.UNKNOWN)) != null) {
            this.doDrop(itemStack);
            itemStack = null;
        }
        return itemStack;
    }

    public boolean func_145830_o() {
        return this.field_145850_b != null & this.failedDrops != null;
    }

    @Override
    public int getComparatorOutput(int n) {
        return this.failedDrops != null ? 15 : 0;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public ForgeDirection[] getDropDirections() {
        return MFRUtil.directionsWithoutConveyors(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        if (this.canStuff) {
            nBTTagCompound.func_74757_a("hasTinkerStuff", true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.canStuff = nBTTagCompound.func_74767_n("hasTinkerStuff");
        this.setIsActive(this.canStuff);
    }
}

