/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.tank;

import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.position.BlockPosition;
import java.util.LinkedHashSet;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.core.IDelayedValidate;
import powercrystals.minefactoryreloaded.net.ConnectionHandler;
import powercrystals.minefactoryreloaded.tile.tank.FluidTankMulti;
import powercrystals.minefactoryreloaded.tile.tank.TileEntityTank;

public class TankNetwork
implements IDelayedValidate {
    private LinkedHashSet<TileEntityTank> nodeSet;
    private TileEntityTank master;
    private FluidTankMulti storage = new FluidTankMulti(this);

    public TankNetwork() {
    }

    public TankNetwork(TileEntityTank tileEntityTank) {
        this.nodeSet = new LinkedHashSet();
        this.addNode(tileEntityTank);
    }

    public boolean addNode(TileEntityTank tileEntityTank) {
        if (this.nodeSet.add(tileEntityTank)) {
            return this.nodeAdded(tileEntityTank);
        }
        return false;
    }

    public void removeNode(TileEntityTank tileEntityTank) {
        if (!this.nodeSet.isEmpty() && this.nodeSet.remove(tileEntityTank)) {
            this.nodeRemoved(tileEntityTank);
        }
    }

    @Override
    public boolean isNotValid() {
        return this.nodeSet.size() == 0;
    }

    @Override
    public void firstTick() {
        this.markSweep();
    }

    public synchronized void markSweep() {
        TankNetwork tankNetwork;
        this.destroyGrid();
        if (this.nodeSet.isEmpty()) {
            return;
        }
        TileEntityTank tileEntityTank = (TileEntityTank)this.nodeSet.iterator().next();
        LinkedHashSet<TileEntityTank> linkedHashSet = this.nodeSet;
        this.nodeSet = new LinkedHashSet(Math.min(linkedHashSet.size() / 6, 5));
        LinkedHashSet<TileEntityTank> linkedHashSet2 = new LinkedHashSet<TileEntityTank>();
        LinkedHashSet<TileEntityTank> linkedHashSet3 = new LinkedHashSet<TileEntityTank>();
        BlockPosition blockPosition = new BlockPosition(0, 0, 0);
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        linkedHashSet2.add(tileEntityTank);
        linkedHashSet3.add(tileEntityTank);
        while (!linkedHashSet2.isEmpty()) {
            tileEntityTank = (TileEntityTank)linkedHashSet2.iterator().next();
            this.addNode(tileEntityTank);
            tankNetwork = tileEntityTank.func_145831_w();
            int n = 6;
            while (n-- > 0) {
                TileEntityTank tileEntityTank2;
                blockPosition.x = tileEntityTank.field_145851_c;
                blockPosition.y = tileEntityTank.field_145848_d;
                blockPosition.z = tileEntityTank.field_145849_e;
                blockPosition.step(forgeDirectionArray[n]);
                if (!tankNetwork.func_72899_e(blockPosition.x, blockPosition.y, blockPosition.z) || (tileEntityTank2 = (TileEntityTank)blockPosition.getTileEntity((World)tankNetwork, TileEntityTank.class)) == null) continue;
                if (tileEntityTank.isInterfacing(forgeDirectionArray[n]) && !linkedHashSet3.contains(tileEntityTank2)) {
                    linkedHashSet2.add(tileEntityTank2);
                }
                linkedHashSet3.add(tileEntityTank2);
            }
            linkedHashSet2.remove(tileEntityTank);
            linkedHashSet.remove(tileEntityTank);
        }
        if (!linkedHashSet.isEmpty()) {
            tankNetwork = new TankNetwork();
            tankNetwork.nodeSet = linkedHashSet;
            tankNetwork.markSweep();
        }
        this.updateNodes();
    }

    public void destroyGrid() {
        this.master = null;
        for (TileEntityTank tileEntityTank : this.nodeSet) {
            tileEntityTank.grid = null;
        }
        this.storage.empty();
    }

    void updateNodes() {
        for (TileEntityTank tileEntityTank : this.nodeSet) {
            tileEntityTank.func_70296_d();
            tileEntityTank.func_145831_w().func_147471_g(tileEntityTank.field_145851_c, tileEntityTank.field_145848_d, tileEntityTank.field_145849_e);
        }
    }

    public boolean canMergeGrid(TankNetwork tankNetwork) {
        if (tankNetwork == null) {
            return false;
        }
        return FluidHelper.isFluidEqualOrNull((FluidStack)tankNetwork.storage.getFluid(), (FluidStack)this.storage.getFluid());
    }

    public synchronized void mergeGrid(TankNetwork tankNetwork) {
        if (tankNetwork == this) {
            return;
        }
        if (this.storage.getFluid() == null && tankNetwork.storage.getFluid() != null) {
            tankNetwork.mergeGrid(this);
            return;
        }
        tankNetwork.destroyGrid();
        for (TileEntityTank tileEntityTank : tankNetwork.nodeSet) {
            this.addNode(tileEntityTank);
        }
        tankNetwork.nodeSet.clear();
        this.updateNodes();
    }

    public void nodeRemoved(TileEntityTank tileEntityTank) {
        if (tileEntityTank == this.master) {
            this.master = this.nodeSet.isEmpty() ? null : (TileEntityTank)this.nodeSet.iterator().next();
        }
        this.storage.removeTank(tileEntityTank._tank);
        if (tileEntityTank.interfaceCount() > 1) {
            ConnectionHandler.update(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean nodeAdded(TileEntityTank tileEntityTank) {
        if (tileEntityTank.grid != null) {
            if (tileEntityTank.grid == this) return false;
            this.nodeSet.remove(tileEntityTank);
            if (!this.canMergeGrid(tileEntityTank.grid)) return false;
            this.mergeGrid(tileEntityTank.grid);
        } else if (tileEntityTank._tank.getFluid() != null) {
            if (!FluidHelper.isFluidEqualOrNull((FluidStack)tileEntityTank._tank.getFluid(), (FluidStack)this.storage.getFluid())) {
                this.nodeSet.remove(tileEntityTank);
                return false;
            }
            tileEntityTank.grid = this;
        } else {
            tileEntityTank.grid = this;
        }
        if (this.master == null) {
            this.master = tileEntityTank;
        }
        this.storage.addTank(tileEntityTank._tank);
        return true;
    }

    public synchronized FluidTankMulti getStorage() {
        return this.storage;
    }

    public int getSize() {
        return this.nodeSet.size();
    }

    public String toString() {
        return "TankNetwork@" + Integer.toString(this.hashCode()) + "; master:" + this.master;
    }
}

