/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.transport;

import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.ICustomHitBox;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.util.position.BlockPosition;
import cofh.repack.codechicken.lib.raytracer.IndexedCuboid6;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.minefactoryreloaded.block.transport.BlockRedNetCable;
import powercrystals.minefactoryreloaded.core.IGridController;
import powercrystals.minefactoryreloaded.core.INode;
import powercrystals.minefactoryreloaded.core.ITraceable;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.net.Packets;
import powercrystals.minefactoryreloaded.tile.base.TileEntityBase;
import powercrystals.minefactoryreloaded.tile.transport.FluidNetwork;

public class TileEntityPlasticPipe
extends TileEntityBase
implements INode,
ITraceable,
ICustomHitBox,
IFluidHandler {
    private byte[] sideMode = new byte[]{1, 1, 1, 1, 1, 1, 0};
    private IFluidHandler[] handlerCache = null;
    private byte upgradeItem = 0;
    private boolean deadCache = true;
    private boolean readFromNBT = false;
    private boolean isPowered = false;
    boolean isNode = false;
    FluidStack fluidForGrid = null;
    FluidNetwork _grid;

    @Override
    public boolean isNotValid() {
        return this.field_145846_f;
    }

    @Override
    public void func_145843_s() {
        if (this._grid != null) {
            this.removeFromGrid();
        }
        super.func_145843_s();
    }

    private void removeFromGrid() {
        this._grid.removeConduit(this);
        this.markForRegen();
        this.deadCache = true;
        this._grid = null;
    }

    private void markForRegen() {
        int n = 0;
        int n2 = 6;
        while (n2-- > 0) {
            if (this.sideMode[n2] != 9) continue;
            ++n;
        }
        if (n > 1) {
            this._grid.regenerate();
        }
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void onNeighborBlockChange() {
        boolean bl = this.isPowered;
        switch (this.upgradeItem) {
            case 0: {
                this.isPowered = CoreUtils.isRedstonePowered((TileEntity)this);
                break;
            }
            case 1: {
                this.isPowered = !CoreUtils.isRedstonePowered((TileEntity)this);
                break;
            }
            case 2: {
                this.isPowered = true;
            }
        }
        if (bl != this.isPowered) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void reCache() {
        if (this.deadCache) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                if (!BlockPosition.blockExists((TileEntity)this, (ForgeDirection)forgeDirection)) continue;
                this.addCache(BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)forgeDirection));
            }
            this.deadCache = false;
            FluidNetwork.HANDLER.addConduitForUpdate(this);
        }
    }

    public void onMerge() {
        this.markChunkDirty();
        this.notifyNeighborTileChange();
        this.deadCache = true;
        this.reCache();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void cofh_validate() {
        super.cofh_validate();
        this.deadCache = true;
        this.handlerCache = null;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this._grid == null) {
            this.incorporateTiles();
            if (this._grid == null) {
                this.setGrid(new FluidNetwork(this));
            }
        }
        this.readFromNBT = true;
        this.reCache();
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onNeighborTileChange(int n, int n2, int n3) {
        TileEntity tileEntity;
        if (this.field_145850_b.field_72995_K | this.deadCache) {
            return;
        }
        TileEntity tileEntity2 = tileEntity = this.field_145850_b.func_72899_e(n, n2, n3) ? this.field_145850_b.func_147438_o(n, n2, n3) : null;
        if (n < this.field_145851_c) {
            this.addCache(tileEntity, 5);
        } else if (n > this.field_145851_c) {
            this.addCache(tileEntity, 4);
        } else if (n3 < this.field_145849_e) {
            this.addCache(tileEntity, 3);
        } else if (n3 > this.field_145849_e) {
            this.addCache(tileEntity, 2);
        } else if (n2 < this.field_145848_d) {
            this.addCache(tileEntity, 1);
        } else if (n2 > this.field_145848_d) {
            this.addCache(tileEntity, 0);
        }
    }

    private void addCache(TileEntity tileEntity) {
        if (tileEntity == null) {
            return;
        }
        int n = tileEntity.field_145851_c;
        int n2 = tileEntity.field_145848_d;
        int n3 = tileEntity.field_145849_e;
        if (n < this.field_145851_c) {
            this.addCache(tileEntity, 5);
        } else if (n > this.field_145851_c) {
            this.addCache(tileEntity, 4);
        } else if (n3 < this.field_145849_e) {
            this.addCache(tileEntity, 3);
        } else if (n3 > this.field_145849_e) {
            this.addCache(tileEntity, 2);
        } else if (n2 < this.field_145848_d) {
            this.addCache(tileEntity, 1);
        } else if (n2 > this.field_145848_d) {
            this.addCache(tileEntity, 0);
        }
    }

    private void addCache(TileEntity tileEntity, int n) {
        if (this.handlerCache != null) {
            this.handlerCache[n] = null;
        }
        byte by = this.sideMode[n];
        int n2 = n;
        this.sideMode[n2] = (byte)(this.sideMode[n2] & 3);
        if (tileEntity instanceof TileEntityPlasticPipe) {
            TileEntityPlasticPipe tileEntityPlasticPipe = (TileEntityPlasticPipe)tileEntity;
            int n3 = n;
            this.sideMode[n3] = (byte)(this.sideMode[n3] & 0xFFFFFFFD);
            int n4 = n;
            this.sideMode[n4] = (byte)(this.sideMode[n4] | 8);
            if (tileEntityPlasticPipe.isInterfacing(ForgeDirection.getOrientation((int)n))) {
                if (this._grid == null && tileEntityPlasticPipe._grid != null) {
                    tileEntityPlasticPipe._grid.addConduit(this);
                }
                if (tileEntityPlasticPipe._grid == this._grid) {
                    int n5 = n;
                    this.sideMode[n5] = (byte)(this.sideMode[n5] | 1);
                }
            } else {
                int n6 = n;
                this.sideMode[n6] = (byte)(this.sideMode[n6] & 0xFFFFFFFC);
            }
        } else if (tileEntity instanceof IFluidHandler) {
            if (this.handlerCache == null) {
                this.handlerCache = new IFluidHandler[6];
            }
            this.handlerCache[n] = (IFluidHandler)tileEntity;
            int n7 = n;
            this.sideMode[n7] = (byte)(this.sideMode[n7] | 4);
        }
        if (!this.deadCache) {
            FluidNetwork.HANDLER.addConduitForUpdate(this);
            if (by != this.sideMode[n]) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    private void incorporateTiles() {
        if (this._grid == null) {
            boolean bl = false;
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                TileEntityPlasticPipe tileEntityPlasticPipe;
                if (this.readFromNBT && (this.sideMode[forgeDirection.getOpposite().ordinal()] & 1) == 0 || !BlockPosition.blockExists((TileEntity)this, (ForgeDirection)forgeDirection) || (tileEntityPlasticPipe = (TileEntityPlasticPipe)BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)forgeDirection, TileEntityPlasticPipe.class)) == null || tileEntityPlasticPipe._grid == null || !(this.readFromNBT ? tileEntityPlasticPipe.couldInterface(this) : tileEntityPlasticPipe.canInterface(this))) continue;
                if (bl) {
                    tileEntityPlasticPipe._grid.mergeGrid(this._grid);
                    continue;
                }
                if (!tileEntityPlasticPipe._grid.addConduit(this)) continue;
                bl = true;
                this.mergeWith(tileEntityPlasticPipe, forgeDirection.ordinal());
            }
        }
    }

    public boolean canInterface(TileEntityPlasticPipe tileEntityPlasticPipe, ForgeDirection forgeDirection) {
        if ((this.sideMode[forgeDirection.ordinal()] & 1) == 0) {
            return false;
        }
        return this.canInterface(tileEntityPlasticPipe);
    }

    public boolean canInterface(TileEntityPlasticPipe tileEntityPlasticPipe) {
        if (this._grid != null && tileEntityPlasticPipe._grid != null) {
            if (this._grid.storage.getFluid() == tileEntityPlasticPipe._grid.storage.getFluid()) {
                return true;
            }
            return FluidHelper.isFluidEqual((FluidStack)this._grid.storage.getFluid(), (FluidStack)tileEntityPlasticPipe._grid.storage.getFluid());
        }
        return this.fluidForGrid == tileEntityPlasticPipe.fluidForGrid || FluidHelper.isFluidEqual((FluidStack)this.fluidForGrid, (FluidStack)tileEntityPlasticPipe.fluidForGrid);
    }

    public boolean couldInterface(TileEntityPlasticPipe tileEntityPlasticPipe) {
        if (this._grid != null && tileEntityPlasticPipe._grid != null) {
            if (this._grid.storage.getFluid() == tileEntityPlasticPipe._grid.storage.getFluid()) {
                return true;
            }
            return FluidHelper.isFluidEqualOrNull((FluidStack)this._grid.storage.getFluid(), (FluidStack)tileEntityPlasticPipe._grid.storage.getFluid());
        }
        return this.fluidForGrid == tileEntityPlasticPipe.fluidForGrid || FluidHelper.isFluidEqualOrNull((FluidStack)this.fluidForGrid, (FluidStack)tileEntityPlasticPipe.fluidForGrid);
    }

    private void mergeWith(TileEntityPlasticPipe tileEntityPlasticPipe, int n) {
        if (this._grid != null && tileEntityPlasticPipe._grid != null && this.couldInterface(tileEntityPlasticPipe)) {
            tileEntityPlasticPipe._grid.mergeGrid(this._grid);
            this.setMode(n, (byte)1);
            tileEntityPlasticPipe.setMode(n ^ 1, (byte)1);
        }
    }

    public Packet func_145844_m() {
        if (this.deadCache) {
            return null;
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74768_a("mode[0]", this.sideMode[0] & 0xFF | (this.sideMode[1] & 0xFF) << 8 | (this.sideMode[2] & 0xFF) << 16 | (this.sideMode[3] & 0xFF) << 24);
        nBTTagCompound.func_74768_a("mode[1]", this.sideMode[4] & 0xFF | (this.sideMode[5] & 0xFF) << 8 | (this.sideMode[6] & 0xFF) << 16 | (this.isPowered ? 0x1000000 : 0));
        nBTTagCompound.func_74774_a("upgrade", this.upgradeItem);
        S35PacketUpdateTileEntity s35PacketUpdateTileEntity = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nBTTagCompound);
        return s35PacketUpdateTileEntity;
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity s35PacketUpdateTileEntity) {
        super.onDataPacket(networkManager, s35PacketUpdateTileEntity);
        NBTTagCompound nBTTagCompound = s35PacketUpdateTileEntity.func_148857_g();
        switch (s35PacketUpdateTileEntity.func_148853_f()) {
            case 0: {
                int n = nBTTagCompound.func_74762_e("mode[0]");
                this.sideMode[0] = (byte)(n >> 0 & 0xFF);
                this.sideMode[1] = (byte)(n >> 8 & 0xFF);
                this.sideMode[2] = (byte)(n >> 16 & 0xFF);
                this.sideMode[3] = (byte)(n >> 24 & 0xFF);
                n = nBTTagCompound.func_74762_e("mode[1]");
                this.sideMode[4] = (byte)(n >> 0 & 0xFF);
                this.sideMode[5] = (byte)(n >> 8 & 0xFF);
                this.sideMode[6] = (byte)(n >> 16 & 0xFF);
                this.isPowered = n >> 24 > 0;
                this.upgradeItem = nBTTagCompound.func_74771_c("upgrade");
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setUpgrade(int n) {
        this.upgradeItem = (byte)n;
    }

    public int getUpgrade() {
        return this.upgradeItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void setModes(byte[] byArray) {
        this.sideMode = byArray;
    }

    public byte getMode(int n) {
        return (byte)(this.sideMode[ForgeDirection.OPPOSITES[n]] & 3);
    }

    public void setMode(int n, byte by) {
        byte by2 = this.sideMode[n = ForgeDirection.OPPOSITES[n]];
        boolean bl = (by = (byte)(by & 3)) != (by2 & 3);
        this.sideMode[n] = (byte)(by2 & 0xFFFFFFFC | by);
        if (bl) {
            FluidNetwork.HANDLER.addConduitForUpdate(this);
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (this._grid == null | this.sideMode[6] == 1) {
            return 0;
        }
        byte by = this.sideMode[forgeDirection.getOpposite().ordinal()];
        if ((by & 1) != 0 & this.isPowered & (by & 2) == 2) {
            return this._grid.storage.fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (this._grid == null | this.sideMode[6] == 1) {
            return null;
        }
        byte by = this.sideMode[forgeDirection.getOpposite().ordinal()];
        if ((by & 1) != 0 & (by & 2) == 0) {
            return this._grid.storage.drain(fluidStack, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (this._grid == null | this.sideMode[6] == 1) {
            return null;
        }
        byte by = this.sideMode[forgeDirection.getOpposite().ordinal()];
        if ((by & 1) != 0 & (by & 2) == 0) {
            return this._grid.storage.drain(n, bl);
        }
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        if (this.sideMode[6] == 1) {
            return false;
        }
        byte by = this.sideMode[forgeDirection.getOpposite().ordinal()];
        return (by & 1) != 0 & (by & 2) == 2;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        if (this.sideMode[6] == 1) {
            return false;
        }
        byte by = this.sideMode[forgeDirection.getOpposite().ordinal()];
        return (by & 1) != 0 & (by & 2) == 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        if (this._grid == null) {
            return FluidHelper.NULL_TANK_INFO;
        }
        return new FluidTankInfo[]{this._grid.storage.getInfo()};
    }

    public boolean isInterfacing(ForgeDirection forgeDirection) {
        int n = forgeDirection.ordinal() ^ 1;
        int n2 = this.sideMode[n] >> 2;
        return (this.sideMode[n] & 1) != 0 & (this.sideMode[6] == 1 ? n2 == 2 : n2 != 0);
    }

    public int interfaceMode(ForgeDirection forgeDirection) {
        int n = forgeDirection.ordinal() ^ 1;
        int n2 = this.sideMode[n] >> 2;
        return (this.sideMode[n] & 1) != 0 ? n2 : 0;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.readFromNBT = true;
        this.upgradeItem = nBTTagCompound.func_74771_c("Upgrade");
        this.isPowered = nBTTagCompound.func_74767_n("Power");
        this.sideMode = nBTTagCompound.func_74770_j("SideMode");
        if (this.sideMode.length != 7) {
            this.sideMode = new byte[]{1, 1, 1, 1, 1, 1, 0};
        }
        if (nBTTagCompound.func_74764_b("Fluid")) {
            this.fluidForGrid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound.func_74775_l("Fluid"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Upgrade", this.upgradeItem);
        nBTTagCompound.func_74757_a("Power", this.isPowered);
        nBTTagCompound.func_74773_a("SideMode", this.sideMode);
        if (this._grid != null) {
            this.fluidForGrid = this.isNode ? this._grid.storage.drain(this._grid.getNodeShare(this), false) : this._grid.storage.drain(0, false);
            if (this.fluidForGrid != null) {
                nBTTagCompound.func_74782_a("Fluid", (NBTBase)this.fluidForGrid.writeToNBT(new NBTTagCompound()));
            }
        } else if (this.fluidForGrid != null) {
            nBTTagCompound.func_74782_a("Fluid", (NBTBase)this.fluidForGrid.writeToNBT(new NBTTagCompound()));
        }
    }

    void extract(ForgeDirection forgeDirection, IFluidTank iFluidTank) {
        if (this.deadCache) {
            return;
        }
        int n = forgeDirection.ordinal();
        byte by = this.sideMode[n];
        if (this.isPowered & (by & 1) != 0 & (by & 2) == 2) {
            switch (by >> 2) {
                case 1: {
                    FluidStack fluidStack;
                    IFluidHandler iFluidHandler;
                    if (this.handlerCache == null || (iFluidHandler = this.handlerCache[n]) == null || !iFluidHandler.canDrain(forgeDirection, null) || (fluidStack = iFluidHandler.drain(forgeDirection, 80, false)) == null || fluidStack.amount <= 0) break;
                    iFluidHandler.drain(forgeDirection, iFluidTank.fill(fluidStack, true), true);
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    int transfer(ForgeDirection forgeDirection, FluidStack fluidStack, Fluid fluid) {
        if (this.deadCache) {
            return 0;
        }
        int n = forgeDirection.ordinal();
        byte by = this.sideMode[n];
        if ((by & 1) != 0 & (by & 2) == 0) {
            switch (by >> 2) {
                case 1: {
                    IFluidHandler iFluidHandler;
                    if (this.handlerCache == null || (iFluidHandler = this.handlerCache[n]) == null || !iFluidHandler.canFill(forgeDirection, fluid)) break;
                    return iFluidHandler.fill(forgeDirection, fluidStack, true);
                }
            }
        }
        return 0;
    }

    public void setGrid(FluidNetwork fluidNetwork) {
        if (this.fluidForGrid == null) {
            this.fluidForGrid = fluidNetwork.storage.drain(0, false);
        }
        this._grid = fluidNetwork;
    }

    @Override
    public void updateInternalTypes(IGridController iGridController) {
        if (iGridController != FluidNetwork.HANDLER) {
            return;
        }
        if (this.deadCache) {
            this.reCache();
            return;
        }
        boolean bl = false;
        if (this.sideMode[6] != 1) {
            for (int i = 0; i < 6; ++i) {
                byte by = this.sideMode[i];
                int n = by >> 2;
                bl = (by & 1) != 0 & n != 0 & n != 2 | bl;
            }
        }
        this.isNode = bl;
        if (this._grid != null) {
            this._grid.addConduit(this);
        }
        Packets.sendToAllPlayersWatching(this);
    }

    public boolean shouldRenderCustomHitBox(int n, EntityPlayer entityPlayer) {
        return n < 2;
    }

    public CustomHitBox getCustomHitBox(int n, EntityPlayer entityPlayer) {
        int n2;
        ArrayList<IndexedCuboid6> arrayList = new ArrayList<IndexedCuboid6>(7);
        this.addTraceableCuboids(arrayList, true, MFRUtil.isHoldingUsableTool(entityPlayer, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        IndexedCuboid6 indexedCuboid6 = (IndexedCuboid6)arrayList.get(0);
        indexedCuboid6.expand(0.003);
        Vector3 vector3 = indexedCuboid6.min;
        Vector3 vector32 = indexedCuboid6.max.sub(vector3);
        CustomHitBox customHitBox = new CustomHitBox(vector32.x, vector32.y, vector32.z, vector3.x, vector3.y, vector3.z);
        int n3 = arrayList.size();
        for (n2 = 1; n2 < n3; ++n2) {
            indexedCuboid6 = (IndexedCuboid6)arrayList.get(n2);
            if (!this.shouldRenderCustomHitBox((Integer)indexedCuboid6.data, entityPlayer)) continue;
            indexedCuboid6.sub(vector3);
            if (indexedCuboid6.min.y < 0.0) {
                customHitBox.sideLength[0] = Math.max(customHitBox.sideLength[0], -indexedCuboid6.min.y);
            }
            if (indexedCuboid6.min.z < 0.0) {
                customHitBox.sideLength[2] = Math.max(customHitBox.sideLength[2], -indexedCuboid6.min.z);
            }
            if (indexedCuboid6.min.x < 0.0) {
                customHitBox.sideLength[4] = Math.max(customHitBox.sideLength[4], -indexedCuboid6.min.x);
            }
            indexedCuboid6.sub(vector32);
            if (indexedCuboid6.max.y > 0.0) {
                customHitBox.sideLength[1] = Math.max(customHitBox.sideLength[1], indexedCuboid6.max.y);
            }
            if (indexedCuboid6.max.z > 0.0) {
                customHitBox.sideLength[3] = Math.max(customHitBox.sideLength[3], indexedCuboid6.max.z);
            }
            if (!(indexedCuboid6.max.x > 0.0)) continue;
            customHitBox.sideLength[5] = Math.max(customHitBox.sideLength[5], indexedCuboid6.max.x);
        }
        n2 = customHitBox.sideLength.length;
        while (n2-- > 0) {
            customHitBox.drawSide[n2] = customHitBox.sideLength[n2] > 0.0;
        }
        return customHitBox;
    }

    @Override
    public boolean onPartHit(EntityPlayer entityPlayer, int n, int n2) {
        if (n2 >= 0 && n2 < 14 && MFRUtil.isHoldingUsableTool(entityPlayer, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (!this.field_145850_b.field_72995_K) {
                int n3 = this.sideMode[ForgeDirection.OPPOSITES[n]] >> 2;
                byte by = this.getMode(n);
                if ((by = (byte)(by + 1)) == 2) {
                    by = (byte)(by + 1);
                }
                if (n3 == 2) {
                    if (by > 1) {
                        by = 0;
                    }
                    ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)n);
                    TileEntityPlasticPipe tileEntityPlasticPipe = (TileEntityPlasticPipe)BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)forgeDirection, TileEntityPlasticPipe.class);
                    if (!this.isInterfacing(forgeDirection)) {
                        if (this.couldInterface(tileEntityPlasticPipe)) {
                            this.mergeWith(tileEntityPlasticPipe, n);
                            tileEntityPlasticPipe.onMerge();
                            this.onMerge();
                        }
                    } else {
                        this.removeFromGrid();
                        this.setMode(n, (byte)0);
                        tileEntityPlasticPipe.onMerge();
                        this.onMerge();
                        if (this._grid == null) {
                            this.setGrid(new FluidNetwork(this));
                        }
                    }
                    return true;
                }
                if (n == 6) {
                    if (by > 1) {
                        by = 0;
                    }
                    this.setMode(n, by);
                    this.func_70296_d();
                    switch (by) {
                        case 0: {
                            entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.tile.standard", new Object[0]));
                            break;
                        }
                        case 1: {
                            entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.tile.cableonly", new Object[0]));
                            break;
                        }
                    }
                    return true;
                }
                if (by > 3) {
                    by = 0;
                }
                this.setMode(n, by);
                this.func_70296_d();
                switch (by) {
                    case 0: {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.fluid.connection.disabled", new Object[0]));
                        break;
                    }
                    case 1: {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.fluid.connection.output", new Object[0]));
                        break;
                    }
                    case 3: {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.fluid.connection.extract", new Object[0]));
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> list, boolean bl, boolean bl2) {
        Vector3 vector3 = new Vector3((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        IndexedCuboid6 indexedCuboid6 = new IndexedCuboid6((Object)0, BlockRedNetCable.subSelection[0]);
        list.add(indexedCuboid6);
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        int[] nArray = ForgeDirection.OPPOSITES;
        boolean bl3 = this.sideMode[6] == 1;
        int n = forgeDirectionArray.length;
        while (n-- > 0) {
            int n2 = this.sideMode[nArray[n]] >> 2;
            boolean bl4 = n2 > 0 & n2 != 2;
            int n3 = 2 + n;
            if ((this.sideMode[nArray[n]] & 1) != 0 & n2 > 0) {
                if (n2 == 2) {
                    n3 = 20 + n;
                    list.add((IndexedCuboid6)new IndexedCuboid6((Object)(bl2 ? 2 + n : 1), BlockRedNetCable.subSelection[n3]).setSide(n, (double)(n & 1)).add(vector3));
                    continue;
                }
                if (bl3) continue;
                list.add((IndexedCuboid6)new IndexedCuboid6((Object)n3, BlockRedNetCable.subSelection[n3]).add(vector3));
                n3 = 20 + n;
                list.add((IndexedCuboid6)new IndexedCuboid6((Object)1, BlockRedNetCable.subSelection[n3]).add(vector3));
                continue;
            }
            if (!(bl & bl2)) continue;
            if (!bl3 & bl4) {
                list.add((IndexedCuboid6)new IndexedCuboid6((Object)n3, BlockRedNetCable.subSelection[n3]).add(vector3));
                continue;
            }
            if (n2 != 2) continue;
            n3 = 20 + n;
            list.add((IndexedCuboid6)new IndexedCuboid6((Object)(2 + n), BlockRedNetCable.subSelection[n3]).setSide(n, (double)(n & 1)).add(vector3));
        }
        indexedCuboid6.add(vector3);
    }

    @Override
    public void getTileInfo(List<IChatComponent> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        if (this._grid != null) {
            list.add(this.text("Powered: " + this.isPowered));
            if (!bl) {
                list.add(this.text("Contains: " + StringHelper.getFluidName((FluidStack)this._grid.storage.getFluid(), (String)"<Empty>")));
                list.add(this.text("Saturation: " + Math.ceil((float)this._grid.storage.getFluidAmount() / (float)this._grid.storage.getCapacity() * 1000.0f) / 10.0));
            }
        } else if (!bl) {
            list.add(this.text("Null Grid"));
        }
        if (bl) {
            if (this._grid != null) {
                list.add(this.text("Grid:" + this._grid));
                list.add(this.text("    Conduits: " + this._grid.getConduitCount() + ", Nodes: " + this._grid.getNodeCount()));
                list.add(this.text("    Grid Max: " + this._grid.storage.getCapacity() + ", Grid Cur: " + this._grid.storage.getFluidAmount()));
                list.add(this.text("    Contains: " + StringHelper.getFluidName((FluidStack)this._grid.storage.getFluid(), (String)"<Empty>")));
            } else {
                list.add(this.text("Grid: Null"));
            }
            list.add(this.text("Cache: (" + Arrays.toString(this.handlerCache) + ")"));
            list.add(this.text("FluidForGrid: " + this.fluidForGrid));
            list.add(this.text("SideType: " + Arrays.toString(this.sideMode)));
            list.add(this.text("Node: " + this.isNode));
            return;
        }
    }

    @Override
    public void firstTick(IGridController iGridController) {
    }
}

