/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeDouble;
import stanhebben.zenscript.type.ZenTypeFloat;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionFloat
extends Expression {
    private final double value;
    private final ZenType type;

    public ExpressionFloat(ZenPosition position, double value, ZenType type) {
        super(position);
        this.value = value;
        this.type = type;
    }

    @Override
    public ZenType getType() {
        return this.type;
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        if (!result) {
            return;
        }
        if (this.type == ZenTypeFloat.INSTANCE) {
            environment.getOutput().constant(Float.valueOf((float)this.value));
        } else if (this.type == ZenTypeDouble.INSTANCE) {
            environment.getOutput().constant(this.value);
        } else {
            throw new RuntimeException("Internal compiler error: source type is not a floating point type");
        }
    }
}

