/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.iterator;

import java.util.Iterator;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.MethodOutput;

public class IteratorList
implements IZenIterator {
    private final MethodOutput methodOutput;
    private final ZenType iteratorType;
    private int iterator;

    public IteratorList(MethodOutput methodOutput, ZenType iteratorType) {
        this.methodOutput = methodOutput;
        this.iteratorType = iteratorType;
    }

    @Override
    public void compileStart(int[] locals) {
        this.iterator = this.methodOutput.local(Type.getType(Iterator.class));
        this.methodOutput.invokeInterface(Iterable.class, "iterator", Iterator.class, new Class[0]);
        this.methodOutput.storeObject(this.iterator);
        this.methodOutput.iConst0();
        this.methodOutput.storeInt(locals[0]);
    }

    @Override
    public void compilePreIterate(int[] locals, Label exit) {
        this.methodOutput.dup();
        this.methodOutput.invokeInterface(Iterator.class, "hasNext", Boolean.TYPE, new Class[0]);
        this.methodOutput.ifEQ(exit);
        this.methodOutput.dup();
        this.methodOutput.invokeInterface(Iterator.class, "next", Object.class, new Class[0]);
        this.methodOutput.store(this.iteratorType.toASMType(), locals[1]);
    }

    @Override
    public void compilePostIterate(int[] locals, Label exit, Label repeat) {
        this.methodOutput.iinc(locals[0]);
        this.methodOutput.goTo(repeat);
    }

    @Override
    public void compileEnd() {
        this.methodOutput.pop();
    }

    @Override
    public ZenType getType(int i) {
        return i == 0 ? ZenType.INT : this.iteratorType;
    }
}

