/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.natives;

import java.util.ArrayList;
import java.util.List;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionCallVirtual;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.StringUtil;
import stanhebben.zenscript.util.ZenPosition;

public class ZenNativeMember {
    private IJavaMethod getter;
    private IJavaMethod setter;
    private final List<IJavaMethod> methods = new ArrayList<IJavaMethod>();

    public IJavaMethod getGetter() {
        return this.getter;
    }

    public IJavaMethod getSetter() {
        return this.setter;
    }

    public void setGetter(IJavaMethod getter) {
        if (this.getter != null) {
            throw new RuntimeException("already has a getter");
        }
        this.getter = getter;
    }

    public void setSetter(IJavaMethod setter) {
        if (this.setter != null) {
            throw new RuntimeException("already has a setter");
        }
        this.setter = setter;
    }

    public IPartialExpression instance(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value) {
        return new InstanceGetValue(position, value);
    }

    public IPartialExpression instance(ZenPosition position, IEnvironmentGlobal environment) {
        return new StaticGetValue(position);
    }

    public void addMethod(JavaMethod method) {
        this.methods.add(method);
    }

    private class StaticSymbol
    implements IZenSymbol {
        private StaticSymbol() {
        }

        @Override
        public IPartialExpression instance(ZenPosition position) {
            return new StaticGetValue(position);
        }
    }

    private class StaticGetValue
    implements IPartialExpression {
        private final ZenPosition position;

        public StaticGetValue(ZenPosition position) {
            this.position = position;
        }

        @Override
        public Expression eval(IEnvironmentGlobal environment) {
            return new ExpressionCallStatic(this.position, environment, ZenNativeMember.this.setter, new Expression[0]);
        }

        @Override
        public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
            return new ExpressionCallStatic(position, environment, ZenNativeMember.this.setter, new Expression[0]);
        }

        @Override
        public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
            return ZenNativeMember.this.getter.getReturnType().getMember(position, environment, this, name);
        }

        @Override
        public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
            IJavaMethod method = JavaMethod.select(true, ZenNativeMember.this.methods, environment, values);
            if (method == null) {
                environment.error(position, StringUtil.methodMatchingError(ZenNativeMember.this.methods, values));
                return new ExpressionInvalid(position);
            }
            return new ExpressionCallStatic(position, environment, method, values);
        }

        @Override
        public ZenType[] predictCallTypes(int numArguments) {
            return JavaMethod.predict(ZenNativeMember.this.methods, numArguments);
        }

        @Override
        public IZenSymbol toSymbol() {
            return new StaticSymbol();
        }

        @Override
        public ZenType getType() {
            return ZenNativeMember.this.getter.getReturnType();
        }

        @Override
        public ZenType toType(IEnvironmentGlobal environment) {
            environment.error(this.position, "not a valid type");
            return ZenType.ANY;
        }
    }

    private class InstanceGetValue
    implements IPartialExpression {
        private final ZenPosition position;
        private final IPartialExpression value;

        public InstanceGetValue(ZenPosition position, IPartialExpression value) {
            this.position = position;
            this.value = value;
        }

        @Override
        public Expression eval(IEnvironmentGlobal environment) {
            return new ExpressionCallVirtual(this.position, environment, ZenNativeMember.this.getter, this.value.eval(environment), new Expression[0]);
        }

        @Override
        public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
            return new ExpressionCallVirtual(position, environment, ZenNativeMember.this.setter, this.value.eval(environment), other);
        }

        @Override
        public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
            return ZenNativeMember.this.getter.getReturnType().getMember(position, environment, this, name);
        }

        @Override
        public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
            IJavaMethod method = JavaMethod.select(false, ZenNativeMember.this.methods, environment, values);
            if (method == null) {
                environment.error(position, StringUtil.methodMatchingError(ZenNativeMember.this.methods, values));
                return new ExpressionInvalid(position);
            }
            return new ExpressionCallVirtual(position, environment, method, this.value.eval(environment), values);
        }

        @Override
        public ZenType[] predictCallTypes(int numArguments) {
            return JavaMethod.predict(ZenNativeMember.this.methods, numArguments);
        }

        @Override
        public IZenSymbol toSymbol() {
            return null;
        }

        @Override
        public ZenType getType() {
            return ZenNativeMember.this.getter.getReturnType();
        }

        @Override
        public ZenType toType(IEnvironmentGlobal environment) {
            environment.error(this.position, "not a valid type");
            return ZenType.ANY;
        }
    }
}

