/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.chisel.commands;

import com.cricketcraft.chisel.api.carving.CarvingUtils;
import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.player.IPlayer;
import minetweaker.api.server.ICommandFunction;
import modtweaker2.mods.chisel.ChiselHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class ChiselVariationLogger
implements ICommandFunction {
    public void execute(String[] arguments, IPlayer player) {
        HashMap<ICarvingVariation, ICarvingGroup> variations = new HashMap<ICarvingVariation, ICarvingGroup>();
        List keys = CarvingUtils.getChiselRegistry().getSortedGroupNames();
        if (arguments.length > 0) {
            ICarvingGroup group = ChiselHelper.getGroup(arguments[0]);
            if (group == null) {
                MineTweakerAPI.getLogger().logError("Group not found (" + arguments[0] + ")");
                return;
            }
            keys.clear();
            keys.add(arguments[0]);
        }
        for (String string : keys) {
            ICarvingGroup group = CarvingUtils.getChiselRegistry().getGroup(string);
            for (ICarvingVariation variation : group.getVariations()) {
                variations.put(variation, group);
            }
        }
        System.out.println("Chisel Variations: " + variations.size());
        for (Map.Entry entry : variations.entrySet()) {
            String stringedVariation = "<" + Item.field_150901_e.func_148750_c((Object)Item.func_150898_a((Block)((ICarvingVariation)entry.getKey()).getBlock())) + ":" + ((ICarvingVariation)entry.getKey()).getBlockMeta() + ">";
            if (arguments.length == 0) {
                stringedVariation = stringedVariation + " " + ((ICarvingGroup)entry.getValue()).getName();
            }
            System.out.println("Chisel Variation " + stringedVariation);
            MineTweakerAPI.logCommand((String)stringedVariation);
        }
        if (player != null) {
            player.sendChat(MineTweakerImplementationAPI.platform.getMessage("List generated; see minetweaker.log in your minecraft dir"));
        }
    }
}

