/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import mcp.mobius.ram.common.Utils;
import mcp.mobius.ram.network.Packet0x04SetSign;
import mcp.mobius.ram.network.PacketManager;
import mcp.mobius.ram.server.CoordinateBlock;
import mcp.mobius.ram.server.WaypointManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Direction;
import org.lwjgl.input.Keyboard;

public class GuiScreenWaypointList
extends GuiScreen {
    protected int dim;
    protected int x;
    protected int y;
    protected int z;
    protected int sideHit;
    protected int metadata;
    protected boolean highHit;
    protected ArrayList<WaypointManager.Waypoint> waypoints;
    protected HashMap<WaypointManager.Waypoint, Double> distances = new HashMap();
    protected HashMap<WaypointManager.Waypoint, String> directions = new HashMap();
    protected FontRenderer fontRenderer;
    protected GuiTextField textField;
    protected GuiWaypointList waypointList;
    protected GuiButton btnAccept;
    protected GuiButton btnCancel;
    protected int selected;
    protected int textXSize;
    protected int textYSize;
    protected int textXPos;
    protected int textYPos;

    public GuiScreenWaypointList(int dim, int x, int y, int z, int sideHit, boolean highHit, int metadata, ArrayList<WaypointManager.Waypoint> waypoints) {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.textXSize = 100;
        this.textYSize = 12;
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.sideHit = sideHit;
        this.metadata = metadata;
        this.highHit = highHit;
        this.waypoints = waypoints;
        for (WaypointManager.Waypoint wp : waypoints) {
            if (wp.coord.x != x || wp.coord.z != z || wp.coord.dim != dim) continue;
            waypoints.remove(wp);
            break;
        }
        CoordinateBlock coord = new CoordinateBlock(dim, x, y, z);
        for (WaypointManager.Waypoint wp : waypoints) {
            this.distances.put(wp, Math.sqrt(wp.coord.distanceTo(coord)));
            this.directions.put(wp, Direction.field_82373_c[Utils.mcDirectionTo(x - wp.coord.x, z - wp.coord.z)]);
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.btnAccept = new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m - 30, 100, 20, "Accept");
        this.field_146292_n.add(this.btnAccept);
        this.btnCancel = new GuiButton(1, this.field_146294_l / 2, this.field_146295_m - 30, 100, 20, "Cancel");
        this.field_146292_n.add(this.btnCancel);
        this.waypointList = new GuiWaypointList();
        this.waypointList.func_148134_d(7, 8);
        this.textXPos = this.field_146294_l / 2;
        this.textYPos = this.field_146295_m - 50;
        this.textField = new GuiTextField(this.fontRenderer, this.textXPos, this.textYPos + 1, this.textXSize, this.textYSize);
        this.textField.func_146189_e(true);
        this.textField.func_146205_d(true);
        if (this.waypoints.size() == 0) {
            this.btnAccept.field_146124_l = false;
        }
    }

    public void func_146278_c(int par1) {
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, 0x40101010, 0x50101010);
        this.waypointList.func_148128_a(par1, par2, par3);
        this.fontRenderer.func_78276_b("Custom name", this.field_146294_l / 2 - 100 + 20, this.field_146295_m - 47, 0xFFFFFF);
        GuiScreenWaypointList.func_73734_a((int)(this.textXPos - 2), (int)(this.textYPos - 2), (int)(this.textXPos + this.textXSize + 2), (int)(this.textYPos + this.textYSize), (int)Integer.MIN_VALUE);
        this.textField.func_146194_f();
        super.func_73863_a(par1, par2, par3);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
        }
        if (this.textField.func_146206_l()) {
            this.textField.func_146201_a(par1, par2);
        }
    }

    public void func_73876_c() {
        this.textField.func_146178_a();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.sendWaypointToServer();
            } else if (button.field_146127_k == 1) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else {
                this.waypointList.func_148147_a(button);
            }
        }
    }

    public void sendWaypointToServer() {
        PacketManager.sendToServer(new Packet0x04SetSign(this.dim, this.x, this.y, this.z, this.waypoints.get((int)this.selected).coord.dim, this.waypoints.get((int)this.selected).coord.x, this.waypoints.get((int)this.selected).coord.y, this.waypoints.get((int)this.selected).coord.z, this.sideHit, this.highHit, this.metadata, this.textField.func_146179_b().trim()));
        Minecraft.func_71410_x().func_147108_a((GuiScreen)null);
    }

    protected void func_73864_a(int x, int y, int btn) {
        this.textField.func_146192_a(x, y, btn);
        super.func_73864_a(x, y, btn);
    }

    public class GuiWaypointList
    extends GuiSlot {
        public GuiWaypointList() {
            super(GuiScreenWaypointList.this.field_146297_k, GuiScreenWaypointList.this.field_146294_l, GuiScreenWaypointList.this.field_146295_m, 32, GuiScreenWaypointList.this.field_146295_m - 65 + 4, 18);
        }

        protected int func_148127_b() {
            return GuiScreenWaypointList.this.waypoints.size();
        }

        protected void func_148144_a(int index, boolean doubleClick, int var3, int var4) {
            GuiScreenWaypointList.this.selected = index;
            if (doubleClick) {
                GuiScreenWaypointList.this.sendWaypointToServer();
            }
        }

        public int func_148139_c() {
            return 240;
        }

        protected boolean func_148131_a(int var1) {
            return var1 == GuiScreenWaypointList.this.selected;
        }

        protected void func_148123_a() {
        }

        protected void drawContainerBackground(Tessellator tessellator) {
        }

        protected void func_148126_a(int index, int var2, int yoffset, int var4, Tessellator var5, int var6, int var7) {
            GuiScreenWaypointList.this.func_73731_b(GuiScreenWaypointList.this.field_146289_q, String.format("%s", GuiScreenWaypointList.this.waypoints.get((int)index).name), this.field_148155_a / 2 - 110, yoffset + 3, 0xFFFFFF);
            GuiScreenWaypointList.this.func_73731_b(GuiScreenWaypointList.this.field_146289_q, String.format("[ %.2f m ]", GuiScreenWaypointList.this.distances.get(GuiScreenWaypointList.this.waypoints.get(index))), this.field_148155_a / 2 + 15, yoffset + 3, 0xFFFFFF);
            GuiScreenWaypointList.this.func_73731_b(GuiScreenWaypointList.this.field_146289_q, GuiScreenWaypointList.this.directions.get(GuiScreenWaypointList.this.waypoints.get(index)), this.field_148155_a / 2 + 80, yoffset + 3, 0xFFFFFF);
        }
    }
}

