/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.server;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import mcp.mobius.ram.server.CoordinateBlock;
import mcp.mobius.ram.server.DataSaveManager;
import mcp.mobius.ram.server.ISaveable;
import mcp.mobius.ram.server.WaypointManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public enum BreadcrumbManager implements ISaveable
{
    INSTANCE;

    public static final int DECAYRATE = 3600000;
    public static final int DROPDIST = 100;
    public DataSaveManager save = new DataSaveManager(this);
    ArrayList<BreadCrumb> clientCrumbs = new ArrayList();
    HashMap<String, ArrayList<BreadCrumb>> serverCrumbs = new HashMap();
    HashBasedTable<WaypointManager.Waypoint, WaypointManager.Waypoint, ArrayList<BreadCrumb>> linkedCrumbs = HashBasedTable.create();
    WeakHashMap<EntityPlayerMP, CoordinateBlock> lastCrumb = new WeakHashMap();

    public void setClientCrumbs(ArrayList<BreadCrumb> crumbs) {
        this.clientCrumbs = crumbs;
    }

    public void setLinkedCrumbs(HashBasedTable<WaypointManager.Waypoint, WaypointManager.Waypoint, ArrayList<BreadCrumb>> crumbs) {
        this.linkedCrumbs = crumbs;
    }

    public ArrayList<BreadCrumb> getCrumbsForPlayer(EntityPlayerMP player) {
        return this.serverCrumbs.get(player.getDisplayName());
    }

    public HashMap<String, ArrayList<BreadCrumb>> getServerCrumbs() {
        return this.serverCrumbs;
    }

    public boolean shouldDropCrumb(EntityPlayerMP player, ItemStack stack, int slot) {
        if (slot > 8) {
            return false;
        }
        CoordinateBlock prevCoord = this.lastCrumb.get(player);
        CoordinateBlock currCoord = new CoordinateBlock(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (prevCoord == null) {
            this.lastCrumb.put(player, currCoord);
            return true;
        }
        if (currCoord.distanceTo(prevCoord) < 100.0) {
            return false;
        }
        this.lastCrumb.put(player, currCoord);
        return true;
    }

    public void addBreadcrumb(EntityPlayerMP player, CoordinateBlock coord) {
        if (!this.serverCrumbs.containsKey(player.getDisplayName())) {
            this.serverCrumbs.put(player.getDisplayName(), new ArrayList());
        }
        this.serverCrumbs.get(player.getDisplayName()).add(new BreadCrumb(coord));
        this.save.writeToFile();
    }

    @SideOnly(value=Side.CLIENT)
    public void addBreadcrumb(int dim, int x, int y, int z) {
        this.clientCrumbs.add(new BreadCrumb(new CoordinateBlock(dim, x, y, z)));
    }

    public void addLinkedBreadcrumb(WaypointManager.Waypoint start, WaypointManager.Waypoint stop, int dim, int x, int y, int z) {
        this.addLinkedBreadcrumb(start, stop, new CoordinateBlock(dim, x, y, z));
    }

    public void addLinkedBreadcrumb(WaypointManager.Waypoint start, WaypointManager.Waypoint stop, CoordinateBlock coord) {
        if (!this.linkedCrumbs.contains((Object)start, (Object)stop)) {
            this.linkedCrumbs.put((Object)start, (Object)stop, new ArrayList());
        }
        ((ArrayList)this.linkedCrumbs.get((Object)start, (Object)stop)).add(new BreadCrumb(coord));
        this.save.writeToFile();
    }

    public void clearLinkedBreadcrumbs(WaypointManager.Waypoint wpStart, WaypointManager.Waypoint wpStop) {
        this.linkedCrumbs.remove((Object)wpStart, (Object)wpStop);
        this.save.writeToFile();
    }

    @SideOnly(value=Side.CLIENT)
    public ArrayList<BreadCrumb> getCrumbs() {
        return this.clientCrumbs;
    }

    public HashBasedTable<WaypointManager.Waypoint, WaypointManager.Waypoint, ArrayList<BreadCrumb>> getLinkedCrumbs() {
        return this.linkedCrumbs;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList normalCrumbsTag = new NBTTagList();
        for (String player : this.serverCrumbs.keySet()) {
            NBTTagCompound thisPlayerTag = new NBTTagCompound();
            NBTTagList crumbsTag = new NBTTagList();
            for (BreadCrumb crumb : this.serverCrumbs.get(player)) {
                crumbsTag.func_74742_a((NBTBase)crumb.toNBT());
            }
            thisPlayerTag.func_74778_a("player", player);
            thisPlayerTag.func_74782_a("crumbs", (NBTBase)crumbsTag);
            normalCrumbsTag.func_74742_a((NBTBase)thisPlayerTag);
        }
        nbt.func_74782_a("crumbs", (NBTBase)normalCrumbsTag);
        NBTTagList linkedCrumbsList = new NBTTagList();
        for (Table.Cell crumbsCell : this.linkedCrumbs.cellSet()) {
            NBTTagCompound thisLinkedCrumbs = new NBTTagCompound();
            thisLinkedCrumbs.func_74782_a("wpStart", (NBTBase)((WaypointManager.Waypoint)crumbsCell.getRowKey()).toNBT());
            thisLinkedCrumbs.func_74782_a("wpEnd", (NBTBase)((WaypointManager.Waypoint)crumbsCell.getColumnKey()).toNBT());
            NBTTagList tagCoords = new NBTTagList();
            for (BreadCrumb crumb : (ArrayList)crumbsCell.getValue()) {
                tagCoords.func_74742_a((NBTBase)crumb.toNBT());
            }
            thisLinkedCrumbs.func_74782_a("crumbs", (NBTBase)tagCoords);
            linkedCrumbsList.func_74742_a((NBTBase)thisLinkedCrumbs);
        }
        nbt.func_74782_a("linked", (NBTBase)linkedCrumbsList);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.serverCrumbs.clear();
        NBTTagList normalCrumbsTag = nbt.func_150295_c("crumbs", 10);
        for (int i = 0; i < normalCrumbsTag.func_74745_c(); ++i) {
            NBTTagCompound thisPlayerTag = normalCrumbsTag.func_150305_b(i);
            String playerName = thisPlayerTag.func_74779_i("player");
            ArrayList<BreadCrumb> crumbs = new ArrayList<BreadCrumb>();
            NBTTagList crumbsTag = thisPlayerTag.func_150295_c("crumbs", 10);
            for (int j = 0; j < crumbsTag.func_74745_c(); ++j) {
                crumbs.add(new BreadCrumb(crumbsTag.func_150305_b(j)));
            }
            this.serverCrumbs.put(playerName, crumbs);
        }
        this.linkedCrumbs.clear();
        NBTTagList linkedCrumbsTag = nbt.func_150295_c("linked", 10);
        for (int i = 0; i < linkedCrumbsTag.func_74745_c(); ++i) {
            NBTTagCompound tagPath = linkedCrumbsTag.func_150305_b(i);
            WaypointManager waypointManager = WaypointManager.INSTANCE;
            waypointManager.getClass();
            WaypointManager.Waypoint wpStart = new WaypointManager.Waypoint(waypointManager, tagPath.func_74775_l("wpStart"));
            WaypointManager waypointManager2 = WaypointManager.INSTANCE;
            waypointManager2.getClass();
            WaypointManager.Waypoint wpEnd = new WaypointManager.Waypoint(waypointManager2, tagPath.func_74775_l("wpEnd"));
            NBTTagList tagCoords = tagPath.func_150295_c("crumbs", 10);
            ArrayList<BreadCrumb> crumbs = new ArrayList<BreadCrumb>();
            for (int j = 0; j < tagCoords.func_74745_c(); ++j) {
                crumbs.add(new BreadCrumb(tagCoords.func_150305_b(j)));
            }
            this.linkedCrumbs.put((Object)wpStart, (Object)wpEnd, crumbs);
        }
    }

    @Override
    public String[] getFilenames() {
        return new String[]{"crumbs1.dat", "crumbs2.dat", "crumbs.lck"};
    }

    public final class BreadCrumb {
        public final CoordinateBlock coord;
        public final long timing;

        public BreadCrumb(CoordinateBlock coord) {
            this.coord = coord;
            this.timing = System.currentTimeMillis();
        }

        public BreadCrumb(NBTTagCompound tag) {
            this.coord = new CoordinateBlock(tag.func_74775_l("coord"));
            this.timing = tag.func_74763_f("timing");
        }

        public boolean hasExpired(long time) {
            return time - this.timing > 3600000L;
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("coord", (NBTBase)this.coord.toNBT());
            tag.func_74772_a("timing", this.timing);
            return tag;
        }

        public boolean equals(Object o) {
            BreadCrumb c = (BreadCrumb)o;
            return this.coord.equals(c.coord);
        }

        public int hashCode() {
            return this.coord.hashCode();
        }
    }
}

